/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncBigInteger;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncNumber;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class VncDouble
extends VncNumber {
    public static final String TYPE = ":core/double";
    private static final long serialVersionUID = -1848883965231344442L;
    private final double value;

    public VncDouble(Double v) {
        super(null, Constants.Nil);
        this.value = v;
    }

    public VncDouble(Float v) {
        super(null, Constants.Nil);
        this.value = v.doubleValue();
    }

    public VncDouble(Long v) {
        super(null, Constants.Nil);
        this.value = v.doubleValue();
    }

    public VncDouble(Integer v) {
        super(null, Constants.Nil);
        this.value = v.doubleValue();
    }

    public VncDouble(Double v, VncVal meta) {
        super(null, meta);
        this.value = v;
    }

    public VncDouble(Double v, VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        super(wrappingTypeDef, meta);
        this.value = v;
    }

    public static VncDouble of(VncVal v) {
        if (Types.isVncNumber(v)) {
            return new VncDouble(((VncNumber)v).toJavaDouble());
        }
        throw new VncException(String.format("Cannot convert value of type %s to double", Types.getType(v)));
    }

    @Override
    public VncDouble withMeta(VncVal meta) {
        return new VncDouble(this.value, this.getWrappingTypeDef(), meta);
    }

    @Override
    public VncDouble wrap(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        return new VncDouble(this.value, wrappingTypeDef, meta);
    }

    @Override
    public VncKeyword getType() {
        return this.isWrapped() ? new VncKeyword(this.getWrappingTypeDef().getType().getQualifiedName(), MetaUtil.typeMeta(new VncKeyword(TYPE), new VncKeyword(":core/number"), new VncKeyword(":core/val"))) : new VncKeyword(TYPE, MetaUtil.typeMeta(new VncKeyword(":core/number"), new VncKeyword(":core/val")));
    }

    @Override
    public VncDouble inc() {
        return new VncDouble(this.value + 1.0);
    }

    @Override
    public VncDouble dec() {
        return new VncDouble(this.value - 1.0);
    }

    @Override
    public VncDouble negate() {
        return new VncDouble(this.value * -1.0);
    }

    @Override
    public VncNumber add(VncVal op) {
        if (op instanceof VncDouble) {
            return new VncDouble(this.value + ((VncDouble)op).value);
        }
        if (op instanceof VncLong) {
            return new VncDouble(this.value + ((VncLong)op).toJavaDouble());
        }
        if (op instanceof VncInteger) {
            return new VncDouble(this.value + ((VncInteger)op).toJavaDouble());
        }
        if (op instanceof VncBigDecimal) {
            return new VncBigDecimal(this.toJavaBigDecimal().add(((VncBigDecimal)op).toJavaBigDecimal()));
        }
        if (op instanceof VncBigInteger) {
            return new VncBigDecimal(this.toJavaBigDecimal().add(((VncBigInteger)op).toJavaBigDecimal()));
        }
        throw new VncException(String.format("Function + operand 2 (%s) is not a numeric type", Types.getType(op)));
    }

    @Override
    public VncNumber sub(VncVal op) {
        if (op instanceof VncDouble) {
            return new VncDouble(this.value - ((VncDouble)op).value);
        }
        if (op instanceof VncLong) {
            return new VncDouble(this.value - ((VncLong)op).toJavaDouble());
        }
        if (op instanceof VncInteger) {
            return new VncDouble(this.value - ((VncInteger)op).toJavaDouble());
        }
        if (op instanceof VncBigDecimal) {
            return new VncBigDecimal(this.toJavaBigDecimal().subtract(((VncBigDecimal)op).toJavaBigDecimal()));
        }
        if (op instanceof VncBigInteger) {
            return new VncBigDecimal(this.toJavaBigDecimal().subtract(((VncBigInteger)op).toJavaBigDecimal()));
        }
        throw new VncException(String.format("Function - operand 2 (%s) is not a numeric type", Types.getType(op)));
    }

    @Override
    public VncNumber mul(VncVal op) {
        if (op instanceof VncDouble) {
            return new VncDouble(this.value * ((VncDouble)op).value);
        }
        if (op instanceof VncLong) {
            return new VncDouble(this.value * ((VncLong)op).toJavaDouble());
        }
        if (op instanceof VncInteger) {
            return new VncDouble(this.value * ((VncInteger)op).toJavaDouble());
        }
        if (op instanceof VncBigDecimal) {
            return new VncBigDecimal(this.toJavaBigDecimal().multiply(((VncBigDecimal)op).toJavaBigDecimal()));
        }
        if (op instanceof VncBigInteger) {
            return new VncBigDecimal(this.toJavaBigDecimal().multiply(((VncBigInteger)op).toJavaBigDecimal()));
        }
        throw new VncException(String.format("Function * operand 2 (%s) is not a numeric type", Types.getType(op)));
    }

    @Override
    public VncNumber div(VncVal op) {
        try {
            if (op instanceof VncDouble) {
                return new VncDouble(this.value / ((VncDouble)op).value);
            }
            if (op instanceof VncLong) {
                return new VncDouble(this.value / ((VncLong)op).toJavaDouble());
            }
            if (op instanceof VncInteger) {
                return new VncDouble(this.value / ((VncInteger)op).toJavaDouble());
            }
            if (op instanceof VncBigDecimal) {
                return new VncBigDecimal(this.toJavaBigDecimal().divide(((VncBigDecimal)op).toJavaBigDecimal(), 16, RoundingMode.HALF_UP));
            }
            if (op instanceof VncBigInteger) {
                return new VncBigDecimal(this.toJavaBigDecimal().divide(((VncBigInteger)op).toJavaBigDecimal(), 16, RoundingMode.HALF_UP));
            }
            throw new VncException(String.format("Function / operand 2 (%s) is not a numeric type", Types.getType(op)));
        }
        catch (ArithmeticException ex) {
            throw new VncException(ex.getMessage());
        }
    }

    @Override
    public VncBoolean equ(VncVal other) {
        if (other instanceof VncDouble) {
            return VncBoolean.of(this.value == ((VncDouble)other).value);
        }
        if (other instanceof VncLong) {
            return VncBoolean.of(this.value == ((VncLong)other).toJavaDouble());
        }
        if (other instanceof VncInteger) {
            return VncBoolean.of(this.value == ((VncInteger)other).toJavaDouble());
        }
        if (other instanceof VncBigDecimal) {
            return VncBoolean.of(this.toJavaBigDecimal().compareTo(((VncBigDecimal)other).toJavaBigDecimal()) == 0);
        }
        if (other instanceof VncBigInteger) {
            return VncBoolean.of(this.toJavaBigInteger().compareTo(((VncBigInteger)other).toJavaBigInteger()) == 0);
        }
        throw new VncException(String.format("Function == operand 2 (%s) is not a numeric type", Types.getType(other)));
    }

    @Override
    public VncBoolean zeroQ() {
        return VncBoolean.of(this.value == 0.0);
    }

    @Override
    public VncBoolean posQ() {
        return VncBoolean.of(this.value > 0.0);
    }

    @Override
    public VncBoolean negQ() {
        return VncBoolean.of(this.value < 0.0);
    }

    @Override
    public VncNumber square() {
        return new VncDouble(this.value * this.value);
    }

    @Override
    public VncNumber sqrt() {
        return new VncDouble(Math.sqrt(this.value));
    }

    public Double getValue() {
        return this.value;
    }

    public Float getFloatValue() {
        return Float.valueOf((float)this.value);
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.DOUBLE;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int toJavaInteger() {
        return (int)this.value;
    }

    @Override
    public long toJavaLong() {
        return (long)this.value;
    }

    @Override
    public double toJavaDouble() {
        return this.value;
    }

    @Override
    public BigInteger toJavaBigInteger() {
        return BigInteger.valueOf((long)this.value);
    }

    @Override
    public BigDecimal toJavaBigDecimal() {
        return new BigDecimal(this.value);
    }

    @Override
    public BigDecimal toJavaBigDecimal(int scale) {
        return new BigDecimal(this.value).setScale(scale);
    }

    @Override
    public int compareTo(VncVal o) {
        if (Types.isVncDouble(o)) {
            double other = ((VncDouble)o).value;
            return this.value < other ? -1 : (this.value == other ? 0 : 1);
        }
        if (Types.isVncInteger(o)) {
            double other = ((VncInteger)o).toJavaDouble();
            return this.value < other ? -1 : (this.value == other ? 0 : 1);
        }
        if (Types.isVncLong(o)) {
            double other = ((VncLong)o).toJavaDouble();
            return this.value < other ? -1 : (this.value == other ? 0 : 1);
        }
        if (Types.isVncBigDecimal(o)) {
            double other = ((VncBigDecimal)o).toJavaDouble();
            return this.value < other ? -1 : (this.value == other ? 0 : 1);
        }
        if (Types.isVncBigInteger(o)) {
            double other = ((VncBigInteger)o).toJavaDouble();
            return this.value < other ? -1 : (this.value == other ? 0 : 1);
        }
        if (o == Constants.Nil) {
            return 1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return Double.hashCode(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.value == ((VncDouble)obj).value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

