/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.dag;

import com.github.jlangch.venice.impl.util.dag.DagCycleException;
import com.github.jlangch.venice.impl.util.dag.Edge;
import com.github.jlangch.venice.impl.util.dag.Node;
import com.github.jlangch.venice.impl.util.dag.TopologicalSort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class DAG<T> {
    private final Map<T, Node<T>> nodes = new LinkedHashMap<T, Node<T>>();
    private final List<Node<T>> roots = new ArrayList<Node<T>>();
    private final Set<Edge<Node<T>>> edges = new LinkedHashSet<Edge<Node<T>>>();

    public DAG() {
    }

    private DAG(Map<T, Node<T>> nodes, Set<Edge<Node<T>>> edges) {
        this.nodes.putAll(nodes);
        this.edges.addAll(edges);
        this.update();
    }

    public DAG<T> addNode(T value) {
        if (value == null) {
            throw new IllegalArgumentException("A node value must not be null");
        }
        this.getNodeOrCreate(value);
        return new DAG<T>(this.nodes, this.edges);
    }

    public DAG<T> addNodes(List<T> values) {
        if (values != null) {
            for (T v : values) {
                this.getNodeOrCreate(v);
            }
        }
        return new DAG<T>(this.nodes, this.edges);
    }

    public DAG<T> addEdge(T parent, T child) {
        this.addEdgeInternal(parent, child);
        return new DAG<T>(this.nodes, this.edges);
    }

    public DAG<T> addEdges(List<Edge<T>> edges) {
        if (edges != null) {
            for (Edge<T> e : edges) {
                this.addEdgeInternal(e.getParent(), e.getChild());
            }
        }
        return new DAG<T>(this.nodes, this.edges);
    }

    public Node<T> getNode(T value) {
        if (value == null) {
            throw new IllegalArgumentException("A node value must not be null");
        }
        return this.nodes.get(value);
    }

    public Collection<Node<T>> getNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    public List<Edge<Node<T>>> getEdges() {
        return Collections.unmodifiableList(new ArrayList<Edge<Node<T>>>(this.edges));
    }

    public Collection<T> getValues() {
        return Collections.unmodifiableCollection(this.nodes.values().stream().map(n -> n.getValue()).collect(Collectors.toList()));
    }

    public int size() {
        return this.nodes.size();
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public Node<T> node(T value) {
        if (value == null) {
            throw new IllegalArgumentException("A node value must not be null");
        }
        return this.nodes.get(value);
    }

    public List<T> children(T value) {
        if (value == null) {
            throw new IllegalArgumentException("A node value must not be null");
        }
        Node<T> node = this.nodes.get(value);
        if (node == null) {
            throw new NoSuchElementException("Node not found: " + value);
        }
        LinkedHashSet children = new LinkedHashSet();
        LinkedList<Node<T>> toVisit = new LinkedList<Node<T>>(node.getChildren());
        while (!toVisit.isEmpty()) {
            Node n = (Node)toVisit.remove(0);
            if (children.contains(n)) continue;
            children.add(n);
            toVisit.addAll(n.getChildren());
        }
        return Node.toValues(children);
    }

    public List<T> directChildren(T value) {
        if (value == null) {
            throw new IllegalArgumentException("A node value must not be null");
        }
        Node<T> node = this.nodes.get(value);
        if (node == null) {
            throw new NoSuchElementException("Node not found: " + value);
        }
        return Node.toValues(node.getChildren());
    }

    public List<T> parents(T value) {
        if (value == null) {
            throw new IllegalArgumentException("A node value must not be null");
        }
        Node<T> node = this.nodes.get(value);
        if (node == null) {
            throw new NoSuchElementException("Node not found: " + value);
        }
        LinkedHashSet parents = new LinkedHashSet();
        LinkedList<Node<T>> toVisit = new LinkedList<Node<T>>(node.getParents());
        while (!toVisit.isEmpty()) {
            Node n = (Node)toVisit.remove(0);
            if (parents.contains(n)) continue;
            parents.add(n);
            toVisit.addAll(n.getParents());
        }
        return Node.toValues(parents);
    }

    public List<T> directParents(T value) {
        if (value == null) {
            throw new IllegalArgumentException("A node value must not be null");
        }
        Node<T> node = this.nodes.get(value);
        if (node == null) {
            throw new NoSuchElementException("Node not found: " + value);
        }
        return Node.toValues(node.getParents());
    }

    public List<T> roots() {
        return Node.toValues(this.roots);
    }

    public List<T> topologicalSort() throws DagCycleException {
        return new TopologicalSort<T>(this.edges, this.getIsolatedNodes()).sort();
    }

    public boolean isParentOf(T parent, T value) {
        return this.parents(value).contains(parent);
    }

    public boolean isChildOf(T child, T value) {
        return this.children(value).contains(child);
    }

    public boolean isNode(T value) {
        return this.nodes.containsKey(value);
    }

    public String toString() {
        return String.format("DAG{nodes=%d}", this.nodes.size());
    }

    public List<Node<T>> getIsolatedNodes() {
        return this.nodes.values().stream().filter(n -> n.isWithoutRelations()).collect(Collectors.toList());
    }

    public Comparator<T> comparator() {
        AtomicInteger idx = new AtomicInteger();
        final ConcurrentHashMap map = new ConcurrentHashMap();
        this.topologicalSort().forEach(e -> map.put(e, idx.getAndIncrement()));
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return map.getOrDefault(o1, Integer.MAX_VALUE).compareTo(map.getOrDefault(o2, Integer.MAX_VALUE));
            }
        };
    }

    private Node<T> getNodeOrCreate(T value) {
        return this.nodes.computeIfAbsent(value, v -> new Node<Object>(v));
    }

    private void update() throws DagCycleException {
        this.roots.clear();
        this.findRoots();
        this.checkForCycles();
    }

    private void addEdgeInternal(T parent, T child) {
        Node<T> childNode;
        if (parent == null) {
            throw new IllegalArgumentException("A parent must not be null");
        }
        if (child == null) {
            throw new IllegalArgumentException("A child must not be null");
        }
        Node<T> parentNode = this.getNodeOrCreate(parent);
        Edge<Node<Node<T>>> edge = new Edge<Node<Node<T>>>(parentNode, childNode = this.getNodeOrCreate(child));
        if (!this.edges.contains(edge)) {
            parentNode.addChild(childNode);
            this.edges.add(edge);
        }
    }

    private void findRoots() {
        for (Node<T> n : this.nodes.values()) {
            if (!n.getParents().isEmpty()) continue;
            this.roots.add(n);
        }
    }

    private void checkForCycles() throws DagCycleException {
        if (this.roots.isEmpty() && this.nodes.size() > 1) {
            throw new DagCycleException("No childless node found to be selected as root!");
        }
        ArrayList<Node<T>> cycleCrawlerPath = new ArrayList<Node<T>>();
        for (Node<T> n : this.roots) {
            this.checkForCycles(n, cycleCrawlerPath);
        }
    }

    private void checkForCycles(Node<T> n, List<Node<T>> path) {
        if (path.contains(n)) {
            path.add(n);
            throw new DagCycleException(this.getPath(path.subList(path.indexOf(n), path.size())));
        }
        path.add(n);
        n.getParents().forEach(node -> this.checkForCycles((Node<T>)node, path));
        path.remove(path.size() - 1);
    }

    private String getPath(List<Node<T>> path) {
        return path.stream().map(n -> String.valueOf(n.getValue())).collect(Collectors.joining(" -> "));
    }
}

