/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.markdown.block;

import com.github.jlangch.venice.impl.util.markdown.block.Block;
import com.github.jlangch.venice.impl.util.markdown.chunk.ChunkParser;
import com.github.jlangch.venice.impl.util.markdown.chunk.Chunks;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class TableBlock
implements Block {
    private List<Alignment> format = new ArrayList<Alignment>();
    private List<Chunks> headerRow = new ArrayList<Chunks>();
    private List<List<Chunks>> bodyRows = new ArrayList<List<Chunks>>();

    public TableBlock() {
    }

    public TableBlock(int cols, List<List<Chunks>> bodyRows) {
        this.addFormat(cols, new ArrayList<Alignment>());
        this.addHeaderRow(cols, new ArrayList<Chunks>());
        this.addBodyRows(cols, bodyRows);
    }

    public TableBlock(int cols, List<Alignment> format, List<List<Chunks>> bodyRows) {
        this.addFormat(cols, format);
        this.addHeaderRow(cols, new ArrayList<Chunks>());
        this.addBodyRows(cols, bodyRows);
    }

    public TableBlock(int cols, List<Alignment> format, List<Chunks> headerRow, List<List<Chunks>> bodyRows) {
        this.addFormat(cols, format);
        this.addHeaderRow(cols, headerRow);
        this.addBodyRows(cols, bodyRows);
    }

    public int cols() {
        return this.format.size();
    }

    public int bodyRows() {
        return this.bodyRows.size();
    }

    public boolean hasHeader() {
        return !this.headerRow.isEmpty();
    }

    public Alignment format(int col) {
        return col >= this.format.size() ? Alignment.LEFT : this.format.get(col);
    }

    public Chunks headerCell(int col) {
        return col >= this.headerRow.size() ? new Chunks() : this.headerRow.get(col);
    }

    public Chunks bodyCell(int row, int col) {
        if (row >= this.bodyRows.size()) {
            return new Chunks();
        }
        List<Chunks> bodyRow = this.bodyRows.get(row);
        return col >= bodyRow.size() ? new Chunks() : bodyRow.get(col);
    }

    @Override
    public boolean isEmpty() {
        return this.headerRow.isEmpty() && this.bodyRows.isEmpty();
    }

    @Override
    public void parseChunks() {
        this.headerRow = this.parseChunks(this.headerRow);
        for (int ii = 0; ii < this.bodyRows.size(); ++ii) {
            this.bodyRows.set(ii, this.parseChunks(this.bodyRows.get(ii)));
        }
    }

    private void addFormat(int cols, List<Alignment> formats) {
        for (int ii = 0; ii < cols; ++ii) {
            this.format.add(formats != null && ii < formats.size() ? formats.get(ii) : Alignment.LEFT);
        }
    }

    private void addHeaderRow(int cols, List<Chunks> row) {
        if (row == null || row.isEmpty()) {
            return;
        }
        for (int ii = 0; ii < cols; ++ii) {
            this.headerRow.add(ii < row.size() ? row.get(ii) : new Chunks());
        }
    }

    private void addBodyRows(int cols, List<List<Chunks>> rows) {
        if (rows == null || rows.isEmpty()) {
            return;
        }
        for (List<Chunks> row : rows) {
            ArrayList<Chunks> bodyRow = new ArrayList<Chunks>();
            this.bodyRows.add(bodyRow);
            for (int ii = 0; ii < cols; ++ii) {
                bodyRow.add(row != null && ii < row.size() ? row.get(ii) : new Chunks());
            }
        }
    }

    private List<Chunks> parseChunks(List<Chunks> chunks) {
        return chunks.stream().map(c -> new ChunkParser((Chunks)c).parse()).collect(Collectors.toList());
    }

    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

