/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.markdown.chunk;

import com.github.jlangch.venice.impl.reader.CharacterReader;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.markdown.chunk.Chunk;
import com.github.jlangch.venice.impl.util.markdown.chunk.Chunks;
import com.github.jlangch.venice.impl.util.markdown.chunk.InlineCodeChunk;
import com.github.jlangch.venice.impl.util.markdown.chunk.RawChunk;
import com.github.jlangch.venice.impl.util.markdown.chunk.TextChunk;
import com.github.jlangch.venice.impl.util.markdown.chunk.UrlChunk;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChunkParser {
    private static final int EOF = -1;
    private final Chunks chunksRaw;
    private final Chunks chunks = new Chunks();

    public ChunkParser(Chunks chunks) {
        this.chunksRaw = chunks;
    }

    public Chunks parse() {
        for (Chunk ch : this.chunksRaw.getChunks()) {
            if (ch instanceof RawChunk) {
                this.chunks.add(this.parse(((RawChunk)ch).getText()));
                continue;
            }
            this.chunks.add(ch);
        }
        return this.chunks;
    }

    private Chunks parse(String s) {
        Chunks chunks = new Chunks();
        CharacterReader reader = new CharacterReader(s);
        StringBuilder sb = new StringBuilder();
        block0: while (true) {
            int ch;
            if ((ch = reader.peek()) == -1) break;
            if (ch == 92) {
                reader.consume();
                ch = reader.peek();
                if (ch == -1) continue;
                reader.consume();
                sb.append((char)ch);
                continue;
            }
            if (ch == 42) {
                chunks.add(this.parseTextChunk(sb.toString()));
                sb = new StringBuilder();
                reader.consume();
                ch = reader.peek();
                if (ch != 42) {
                    chunks.add(this.parseEmphasizeSingle(reader));
                    continue;
                }
                reader.consume();
                ch = reader.peek();
                if (ch != 42) {
                    chunks.add(this.parseEmphasizeDouble(reader));
                    continue;
                }
                reader.consume();
                ch = reader.peek();
                if (ch != 42) {
                    chunks.add(this.parseEmphasizeTriple(reader));
                    continue;
                }
                sb.append("***");
                while (true) {
                    if (reader.peek() != 42) continue block0;
                    reader.consume();
                    ch = reader.peek();
                    sb.append("*");
                }
            }
            if (ch == 96) {
                chunks.add(this.parseTextChunk(sb.toString()));
                sb = new StringBuilder();
                reader.consume();
                chunks.add(this.parseInlineCode(reader));
                continue;
            }
            reader.consume();
            sb.append((char)ch);
        }
        chunks.add(this.parseTextChunk(sb.toString()));
        return chunks;
    }

    private Chunk parseEmphasizeSingle(CharacterReader reader) {
        StringBuilder sb = new StringBuilder();
        int last2Ch = -1;
        int last1Ch = -1;
        int ch = reader.peek();
        while (true) {
            if (ch == -1) {
                if (last2Ch != 42 && last1Ch == 42) {
                    String chunk = this.collapseWhitespaces(StringUtil.removeEnd(sb.toString(), "*"));
                    return new TextChunk(chunk, TextChunk.Format.ITALIC);
                }
                return new TextChunk("*" + sb.toString());
            }
            if (last2Ch != 42 && last1Ch == 42 && ch != 42) {
                String chunk = this.collapseWhitespaces(StringUtil.removeEnd(sb.toString(), "*"));
                return new TextChunk(chunk, TextChunk.Format.ITALIC);
            }
            reader.consume();
            last2Ch = last1Ch;
            last1Ch = ch;
            sb.append((char)ch);
            ch = reader.peek();
        }
    }

    private Chunk parseEmphasizeDouble(CharacterReader reader) {
        StringBuilder sb = new StringBuilder();
        int last3Ch = -1;
        int last2Ch = -1;
        int last1Ch = -1;
        int ch = reader.peek();
        while (true) {
            if (ch == -1) {
                if (last3Ch != 42 && last2Ch == 42 && last1Ch == 42) {
                    String chunk = this.collapseWhitespaces(StringUtil.removeEnd(sb.toString(), "**"));
                    return new TextChunk(chunk, TextChunk.Format.BOLD);
                }
                return new TextChunk("**" + sb.toString());
            }
            if (last3Ch != 42 && last2Ch == 42 && last1Ch == 42 && ch != 42) {
                String chunk = this.collapseWhitespaces(StringUtil.removeEnd(sb.toString(), "**"));
                return new TextChunk(chunk, TextChunk.Format.BOLD);
            }
            reader.consume();
            last3Ch = last2Ch;
            last2Ch = last1Ch;
            last1Ch = ch;
            sb.append((char)ch);
            ch = reader.peek();
        }
    }

    private Chunk parseEmphasizeTriple(CharacterReader reader) {
        StringBuilder sb = new StringBuilder();
        int last4Ch = -1;
        int last3Ch = -1;
        int last2Ch = -1;
        int last1Ch = -1;
        int ch = reader.peek();
        while (true) {
            if (ch == -1) {
                if (last4Ch != 42 && last3Ch == 42 && last2Ch == 42 && last1Ch == 42) {
                    String chunk = this.collapseWhitespaces(StringUtil.removeEnd(sb.toString(), "***"));
                    return new TextChunk(chunk, TextChunk.Format.BOLD_ITALIC);
                }
                return new TextChunk("***" + sb.toString());
            }
            if (last4Ch != 42 && last3Ch == 42 && last2Ch == 42 && last1Ch == 42 && ch != 42) {
                String chunk = this.collapseWhitespaces(StringUtil.removeEnd(sb.toString(), "***"));
                return new TextChunk(chunk, TextChunk.Format.BOLD_ITALIC);
            }
            reader.consume();
            last4Ch = last3Ch;
            last3Ch = last2Ch;
            last2Ch = last1Ch;
            last1Ch = ch;
            sb.append((char)ch);
            ch = reader.peek();
        }
    }

    private Chunks parseTextChunk(String text) {
        Chunks chunks = new Chunks();
        Pattern p = Pattern.compile("\\[.*?\\]\\(http[s]?://.*?\\)");
        Matcher m = p.matcher(text);
        int lastEndPos = 0;
        while (m.find()) {
            int startPos = m.start();
            int endPos = m.end();
            String urlRef = m.group();
            String caption = urlRef.substring(urlRef.indexOf("[") + 1, urlRef.indexOf("]"));
            String url = urlRef.substring(urlRef.indexOf("(") + 1, urlRef.indexOf(")"));
            if (startPos > lastEndPos) {
                chunks.add(new TextChunk(this.collapseWhitespaces(text.substring(lastEndPos, startPos))));
            }
            chunks.add(new UrlChunk(caption, url));
            lastEndPos = endPos;
        }
        if (lastEndPos < text.length()) {
            chunks.add(new TextChunk(this.collapseWhitespaces(text.substring(lastEndPos, text.length()))));
        }
        return chunks;
    }

    private Chunk parseInlineCode(CharacterReader reader) {
        StringBuilder sb = new StringBuilder();
        int ch = reader.peek();
        while (true) {
            reader.consume();
            if (ch == -1) {
                String chunk = this.collapseWhitespaces("`" + sb.toString());
                return new TextChunk(chunk);
            }
            if (ch == 96) {
                return new InlineCodeChunk(sb.toString());
            }
            sb.append((char)ch);
            ch = reader.peek();
        }
    }

    private String collapseWhitespaces(String str) {
        return str.replaceAll("\t", " ").replaceAll(" +", " ");
    }
}

