/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.markdown.renderer.text;

import com.github.jlangch.venice.impl.reader.LineReader;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.markdown.Markdown;
import com.github.jlangch.venice.impl.util.markdown.block.Block;
import com.github.jlangch.venice.impl.util.markdown.block.CodeBlock;
import com.github.jlangch.venice.impl.util.markdown.block.ListBlock;
import com.github.jlangch.venice.impl.util.markdown.block.TableBlock;
import com.github.jlangch.venice.impl.util.markdown.block.TextBlock;
import com.github.jlangch.venice.impl.util.markdown.chunk.Chunk;
import com.github.jlangch.venice.impl.util.markdown.chunk.Chunks;
import com.github.jlangch.venice.impl.util.markdown.chunk.InlineCodeChunk;
import com.github.jlangch.venice.impl.util.markdown.chunk.LineBreakChunk;
import com.github.jlangch.venice.impl.util.markdown.chunk.TextChunk;
import com.github.jlangch.venice.impl.util.markdown.chunk.UrlChunk;
import com.github.jlangch.venice.impl.util.markdown.renderer.text.LineWrap;
import com.github.jlangch.venice.impl.util.markdown.renderer.text.TextTableRendrer;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class TextRenderer {
    private static final char BULLET = 'o';
    private static final String CODE_INDENT = "\u00a0\u00a0\u00a0";
    private static final String LIST_INDENT = "\u00a0\u00a0";
    private int width = -1;
    private boolean softWrap = true;

    private TextRenderer(int width, boolean softWrap) {
        this.width = width;
        this.softWrap = softWrap;
    }

    public TextRenderer() {
    }

    public TextRenderer hardWrap(int width) {
        if (width < 1) {
            throw new IllegalArgumentException("A wrap width must be positive");
        }
        this.width = width;
        this.softWrap = false;
        return this;
    }

    public TextRenderer softWrap(int width) {
        if (width < 1) {
            throw new IllegalArgumentException("A wrap width must be positive");
        }
        this.width = width;
        this.softWrap = true;
        return this;
    }

    public TextRenderer nowrap() {
        this.width = -1;
        this.softWrap = false;
        return this;
    }

    public String render(Markdown md) {
        StringBuilder sb = new StringBuilder();
        for (Block b : md.blocks().getBlocks()) {
            if (sb.length() > 0) {
                sb.append("\n\n");
            }
            sb.append(this.render(b));
        }
        return sb.toString().replace("\u00a0", " ");
    }

    public String render(Block b) {
        if (b.isEmpty()) {
            return "";
        }
        if (b instanceof TextBlock) {
            return this.render((TextBlock)b);
        }
        if (b instanceof CodeBlock) {
            return this.render((CodeBlock)b);
        }
        if (b instanceof ListBlock) {
            return this.render((ListBlock)b);
        }
        if (b instanceof TableBlock) {
            return this.render((TableBlock)b);
        }
        return "";
    }

    public String render(Chunks chunks) {
        StringBuilder sb = new StringBuilder();
        for (Chunk c : chunks.getChunks()) {
            if (c.isEmpty()) continue;
            if (c instanceof TextChunk) {
                sb.append(this.render((TextChunk)c));
                continue;
            }
            if (c instanceof LineBreakChunk) {
                sb.append(this.render((LineBreakChunk)c));
                continue;
            }
            if (c instanceof InlineCodeChunk) {
                sb.append(this.render((InlineCodeChunk)c));
                continue;
            }
            if (!(c instanceof UrlChunk)) continue;
            sb.append(this.render((UrlChunk)c));
        }
        String s = sb.toString();
        s = this.isWrap() ? this.wrap(s, this.width) : s;
        s = s.replace("\u00a0", " ");
        return s;
    }

    private String render(TextBlock block) {
        return this.render(block.getChunks());
    }

    private String render(CodeBlock block) {
        return block.getLines().stream().map(l -> CODE_INDENT + l).collect(Collectors.joining("\n"));
    }

    private String render(ListBlock block) {
        StringBuilder sb = new StringBuilder();
        int itemNrDigits = this.digits(block.size());
        for (int ii = 0; ii < block.size(); ++ii) {
            Block b = block.get(ii);
            if (sb.length() > 0) {
                sb.append("\n");
            }
            String prefix = block.isOrdered() ? LIST_INDENT + this.formatListItemNr(ii + 1, itemNrDigits) + " " : "\u00a0\u00a0o ";
            int blockWidth = this.width - prefix.length();
            if (this.isWrap()) {
                sb.append(this.indent(new TextRenderer(blockWidth, this.softWrap).render(b), prefix, StringUtil.repeat(' ', prefix.length())));
                continue;
            }
            sb.append(prefix + this.render(b));
        }
        return sb.toString();
    }

    private String render(TableBlock block) {
        return new TextTableRendrer(block, this.width).render();
    }

    private String render(TextChunk chunk) {
        String s = chunk.getText();
        s = StringUtil.replace(s, "\t", "\u00a0\u00a0\u00a0\u00a0", -1, false);
        s = StringUtil.replace(s, "&nbsp;", "\u00a0", -1, false);
        s = StringUtil.replace(s, "&ensp;", LIST_INDENT, -1, false);
        s = StringUtil.replace(s, "&emsp;", "\u00a0\u00a0\u00a0\u00a0", -1, false);
        return s;
    }

    private String render(LineBreakChunk chunk) {
        return "\n";
    }

    private String render(InlineCodeChunk chunk) {
        return chunk.getText();
    }

    private String render(UrlChunk chunk) {
        if (chunk.isEmpty()) {
            return "";
        }
        return chunk.getCaption().isEmpty() ? chunk.getUrl() : chunk.getCaption() + " (" + chunk.getUrl() + ")";
    }

    private String wrap(String text, int maxWidth) {
        return String.join((CharSequence)"\n", this.softWrap ? LineWrap.softWrap(text, maxWidth) : LineWrap.hardWrap(text, maxWidth));
    }

    private String indent(String text, String firstLineIndent, String indent) {
        ArrayList<String> lines = new ArrayList<String>();
        LineReader reader = new LineReader(text);
        if (!reader.eof()) {
            lines.add(firstLineIndent + reader.peek().trim());
            reader.consume();
            while (!reader.eof()) {
                lines.add(indent + reader.peek().trim());
                reader.consume();
            }
        }
        return String.join((CharSequence)"\n", lines);
    }

    private boolean isWrap() {
        return this.width > 0;
    }

    private String formatListItemNr(int itemNr, int digits) {
        String s = String.format("%d", itemNr);
        return s + '.' + StringUtil.repeat(' ', Math.max(0, digits - s.length()));
    }

    private int digits(int x) {
        return (int)Math.log10(x);
    }
}

