/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.reflect;

import com.github.jlangch.venice.JavaMethodInvocationException;
import com.github.jlangch.venice.impl.util.reflect.ReflectionTypes;
import com.github.jlangch.venice.impl.util.reflect.ScopedEnumValue;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;

public class Boxing {
    public static Object[] boxArgs(Class<?>[] params, Object[] args) {
        if (params.length == 0) {
            return null;
        }
        Object[] ret = new Object[params.length];
        for (int ii = 0; ii < params.length; ++ii) {
            ret[ii] = Boxing.boxArg(params[ii], args[ii]);
        }
        return ret;
    }

    public static Object boxArg(Class<?> paramType, Object arg) {
        Object boxed;
        if (!paramType.isPrimitive()) {
            if (ReflectionTypes.isArrayType(paramType)) {
                return Boxing.boxArrayArg(paramType, arg);
            }
            if (arg instanceof Number) {
                Object boxed2 = Boxing.boxNumberArg(paramType, (Number)arg);
                if (boxed2 != null) {
                    return boxed2;
                }
            } else if (ReflectionTypes.isEnumType(paramType)) {
                return Boxing.boxEnumArg(paramType, arg);
            }
            return paramType.cast(arg);
        }
        if (paramType == Boolean.TYPE) {
            return Boolean.class.cast(arg);
        }
        if (paramType == Character.TYPE) {
            return Character.class.cast(arg);
        }
        if (arg instanceof Number && (boxed = Boxing.boxNumberArg(paramType, (Number)arg)) != null) {
            return boxed;
        }
        throw new JavaMethodInvocationException(String.format("Unexpected param type, expected: %s, given: %s", paramType.getName(), arg.getClass().getName()));
    }

    private static Object boxNumberArg(Class<?> paramType, Number arg) {
        if (paramType == Byte.TYPE || paramType == Byte.class) {
            return arg.byteValue();
        }
        if (paramType == Short.TYPE || paramType == Short.class) {
            return arg.shortValue();
        }
        if (paramType == Integer.TYPE || paramType == Integer.class) {
            return arg.intValue();
        }
        if (paramType == Long.TYPE || paramType == Long.class) {
            return arg.longValue();
        }
        if (paramType == Float.TYPE || paramType == Float.class) {
            return Float.valueOf(arg.floatValue());
        }
        if (paramType == Double.TYPE || paramType == Double.class) {
            return arg.doubleValue();
        }
        return null;
    }

    private static Enum<?> boxEnumArg(Class<? extends Enum<?>> enumType, Object arg) {
        if (arg instanceof String) {
            ScopedEnumValue scopedEnum = new ScopedEnumValue((String)arg);
            if (scopedEnum.isScoped()) {
                if (scopedEnum.isCompatible(enumType)) {
                    Enum<?> e = scopedEnum.getEnum(enumType);
                    if (e != null) {
                        return e;
                    }
                    throw new JavaMethodInvocationException(String.format("Enum %s does not define value %s", enumType.getName(), scopedEnum.getEnumValue()));
                }
                throw new JavaMethodInvocationException(String.format("Enum %s is not compatible with %s", scopedEnum.getScopedEnumValue(), enumType.getName()));
            }
            Enum<?> e = scopedEnum.getEnum(enumType);
            if (e != null) {
                return e;
            }
            throw new JavaMethodInvocationException(String.format("Enum %s does not define value %s", enumType.getName(), scopedEnum.getEnumValue()));
        }
        throw new JavaMethodInvocationException(String.format("Cannot convert type %s to enum %s", arg.getClass().getName(), enumType.getName()));
    }

    private static Object boxArrayArg(Class<?> type, Object arg) {
        Class<?> argComponentType;
        if (arg == null) {
            return null;
        }
        Class<?> componentType = type.getComponentType();
        if (componentType == Byte.TYPE) {
            if (arg.getClass() == String.class) {
                return Boxing.boxStringToByteArray((String)arg);
            }
            if (arg.getClass() == byte[].class) {
                return (byte[])arg;
            }
            if (arg instanceof ByteBuffer) {
                return ((ByteBuffer)arg).array();
            }
        } else if (componentType == Character.TYPE) {
            if (arg.getClass() == String.class) {
                return ((String)arg).toCharArray();
            }
        } else if (ReflectionTypes.isArrayType(arg.getClass()) && componentType == (argComponentType = arg.getClass().getComponentType())) {
            return arg;
        }
        if (ReflectionTypes.isListOrSet(arg.getClass())) {
            int size = ((Collection)arg).size();
            Object arr = Array.newInstance(componentType, size);
            AtomicInteger idx = new AtomicInteger(0);
            ((Collection)arg).forEach(v -> Array.set(arr, idx.getAndIncrement(), Boxing.boxArg(componentType, v)));
            return arr;
        }
        if (ReflectionTypes.isMap(arg.getClass())) {
            throw new JavaMethodInvocationException("Cannot box map to array");
        }
        Object arr = Array.newInstance(componentType, 1);
        Array.set(arr, 0, Boxing.boxArg(componentType, arg));
        return arr;
    }

    private static byte[] boxStringToByteArray(String str) {
        try {
            return str == null ? null : str.getBytes("UTF-8");
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException("Failed to box arg of type String to byte[]", ex);
        }
    }
}

