/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.util.IXMLHandler;
import com.github.jlangch.venice.util.XmlAttributesWrapper;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLHandler
extends DefaultHandler {
    private final IXMLHandler handler;

    public XMLHandler(IXMLHandler handler) {
        this.handler = handler;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.handler.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.handler.startDocument();
        }
        catch (VncException ex) {
            throw new SAXException(ex.printVeniceStackTraceToString(), ex);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.handler.endDocument();
        }
        catch (VncException ex) {
            throw new SAXException(ex.printVeniceStackTraceToString(), ex);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        try {
            this.handler.startPrefixMapping(prefix, uri);
        }
        catch (VncException ex) {
            throw new SAXException(ex.printVeniceStackTraceToString(), ex);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        try {
            this.handler.endPrefixMapping(prefix);
        }
        catch (VncException ex) {
            throw new SAXException(ex.printVeniceStackTraceToString(), ex);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        try {
            this.handler.startElement(uri, localName, qName, new XmlAttributesWrapper(attrs));
        }
        catch (VncException ex) {
            throw new SAXException(ex.printVeniceStackTraceToString(), ex);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.handler.endElement(uri, localName, qName);
        }
        catch (VncException ex) {
            throw new SAXException(ex.printVeniceStackTraceToString(), ex);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.handler.characters(new String(ch).substring(start, start + length));
        }
        catch (VncException ex) {
            throw new SAXException(ex.printVeniceStackTraceToString(), ex);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.handler.ignorableWhitespace(new String(ch).substring(start, start + length));
        }
        catch (VncException ex) {
            throw new SAXException(ex.printVeniceStackTraceToString(), ex);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.handler.processingInstruction(target, data);
        }
        catch (VncException ex) {
            throw new SAXException(ex.printVeniceStackTraceToString(), ex);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        try {
            this.handler.skippedEntity(name);
        }
        catch (VncException ex) {
            throw new SAXException(ex.printVeniceStackTraceToString(), ex);
        }
    }
}

