/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.pdf;

import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.Tuple2;
import com.github.jlangch.venice.util.pdf.ClasspathUserAgent;
import com.github.jlangch.venice.util.pdf.PdfMetaDataCreationListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.pdf.ITextRenderer;
import org.xhtmlrenderer.pdf.PDFCreationListener;
import org.xml.sax.SAXParseException;

public class PdfRenderer {
    public static final int DOTS_PER_PIXEL = 20;
    public static final float DOTS_PER_POINT = 26.666666f;

    public static ByteBuffer render(String xhtml) {
        return PdfRenderer.render(xhtml, "classpath:/", null);
    }

    public static ByteBuffer render(String xhtml, Map<String, ByteBuffer> resources) {
        return PdfRenderer.render(xhtml, "classpath:/", resources);
    }

    public static ByteBuffer render(String xhtml, String baseUrl) {
        return PdfRenderer.render(xhtml, baseUrl, null);
    }

    public static ByteBuffer render(String xhtml, String baseUrl, Map<String, ByteBuffer> resources) {
        return PdfRenderer.render(xhtml, baseUrl, null, 20, 26.666666f);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ByteBuffer render(String xhtml, String baseUrl, Map<String, ByteBuffer> resources, int dotsPerPixel, float dotsPerPoint) {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            ITextRenderer renderer = new ITextRenderer(dotsPerPoint, dotsPerPixel);
            ClasspathUserAgent userAgent = new ClasspathUserAgent(renderer.getOutputDevice());
            if (resources != null) {
                for (Map.Entry<String, ByteBuffer> entry : resources.entrySet()) {
                    userAgent.addResource(entry.getKey(), entry.getValue());
                }
            }
            userAgent.setSharedContext(renderer.getSharedContext());
            renderer.getSharedContext().setUserAgentCallback((UserAgentCallback)userAgent);
            PdfMetaDataCreationListener mcl = new PdfMetaDataCreationListener().parseMetaTags(PdfRenderer.parseXHTML(xhtml));
            renderer.setListener((PDFCreationListener)mcl);
            renderer.setDocumentFromString(xhtml, baseUrl);
            renderer.layout();
            renderer.createPDF((OutputStream)os);
            renderer.finishPDF();
            os.flush();
            ByteBuffer byteBuffer = ByteBuffer.wrap(os.toByteArray());
            return byteBuffer;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to render PDF.", ex);
        }
    }

    private static Document parseXHTML(String xhtml) throws Exception {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            ByteArrayInputStream is = new ByteArrayInputStream(xhtml.getBytes("UTF-8"));
            return builder.parse(is);
        }
        catch (SAXParseException ex) {
            int lineNr = ex.getLineNumber();
            String excerpt = lineNr == -1 ? null : PdfRenderer.extractLines(xhtml, Math.max(0, lineNr - 10), lineNr + 10);
            throw new RuntimeException(String.format("Invalid XHTML template regarding XML validation.\nXML parser error: %s %s", ex.getMessage(), excerpt == null ? "" : "\n" + excerpt), ex);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to parse XHTML template", ex);
        }
    }

    private static String extractLines(String text, int startLine, int endLine) {
        if (text == null || startLine > endLine) {
            return null;
        }
        AtomicInteger lineNr = new AtomicInteger(0);
        return StringUtil.splitIntoLines(text).stream().map(line -> new Tuple2<Integer, String>(lineNr.incrementAndGet(), (String)line)).filter(line -> (Integer)line.getFirst() >= startLine && (Integer)line.getFirst() <= endLine).map(line -> String.format("%d: %s", line.getFirst(), line.getSecond())).collect(Collectors.joining("\n"));
    }
}

