/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncDAG;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import java.util.Map;

public class DagFunctions {
    public static VncFunction dag = new VncFunction("dag/dag", (VncVal)VncFunction.meta().arglists("(dag)", "(dag edges*)").doc("Creates a new DAG (directed acyclic graph)\n\nAn edge is a vector of two nodes forming a parent/child relationship.").examples("(dag/dag)", "(dag/dag [\"A\" \"B\"] [\"B\" \"C\"])", "(dag/dag [\"A\", \"B\"]  ;    A  E   \n         [\"B\", \"C\"]  ;    |  |   \n         [\"C\", \"D\"]  ;    B  F   \n         [\"E\", \"F\"]  ;    | / \\ \n         [\"F\", \"C\"]  ;    C    G \n         [\"F\", \"G\"]  ;     \\  / \n         [\"G\", \"D\"]) ;      D      ").seeAlso("dag/dag?", "dag/add-edges", "dag/add-nodes", "dag/topological-sort", "dag/edges", "dag/nodes", "empty?", "count").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            VncDAG dag = new VncDAG(Constants.Nil);
            return dag.addEdges(args);
        }
    };
    public static VncFunction dag_Q = new VncFunction("dag/dag?", (VncVal)VncFunction.meta().arglists("(dag? coll)").doc("Returns true if coll is a DAG").examples("(dag/dag? (dag/dag))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncDAG(args.first()));
        }
    };
    public static VncFunction add_edges = new VncFunction("dag/add-edges", (VncVal)VncFunction.meta().arglists("(add-edges edges*)").doc("Add edges to a DAG. Returns a new DAG with added edges.\n\nAn edge is a vector of two nodes forming a parent/child relationship. Any *Venice* value can be used for a node.\n\nNote: The graph is reconstructed after adding edges. To have best performance pass the edges with a single `add-edges` call to the DAG.").examples("(dag/add-edges (dag/dag) [\"A\" \"B\"] [\"B\" \"C\"])").seeAlso("dag/dag", "dag/topological-sort").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            VncDAG dag = Coerce.toVncDAG(args.first());
            return dag.addEdges(args.rest());
        }
    };
    public static VncFunction add_nodes = new VncFunction("dag/add-nodes", (VncVal)VncFunction.meta().arglists("(add-nodes nodes*)").doc("Add nodes to a DAG. Returns a new DAG with added nodes.\n\nAny *Venice* value can be used for a node.\n\nNote: The graph is reconstructed after adding nodes. To have best performance pass the nodes with a single `add-nodes` call to the DAG.").examples("(dag/add-nodes (dag/dag) \"A\")", "(-> (dag/dag)                      \n    (dag/add-nodes \"A\")          \n    (dag/add-edges [\"A\" \"B\"]))   ", "(-> (dag/dag)                      \n    (dag/add-nodes \"A\")          \n    (dag/add-edges [\"B\" \"C\"]))   ").seeAlso("dag/dag", "dag/topological-sort").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            VncDAG dag = Coerce.toVncDAG(args.first());
            return dag.addNodes(args.rest());
        }
    };
    public static VncFunction topological_sort = new VncFunction("dag/topological-sort", (VncVal)VncFunction.meta().arglists("(topological-sort dag)").doc("Topological sort of a DAG using [Kahn's algorithm](https://en.wikipedia.org/wiki/Topological_sorting)").examples("(dag/topological-sort (dag/dag [\"A\" \"B\"] [\"B\" \"C\"]))", "(-> (dag/dag [\"A\", \"B\"]  ;    A  E   \n             [\"B\", \"C\"]  ;    |  |   \n             [\"C\", \"D\"]  ;    B  F   \n             [\"E\", \"F\"]  ;    | / \\ \n             [\"F\", \"C\"]  ;    C    G \n             [\"F\", \"G\"]  ;     \\  / \n             [\"G\", \"D\"]) ;      D    \n    (dag/topological-sort))                ").seeAlso("dag/dag", "dag/compare-fn", "dag/add-edges").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncDAG dag = Coerce.toVncDAG(args.first());
            return dag.topologicalSort();
        }
    };
    public static VncFunction compare_fn = new VncFunction("dag/compare-fn", (VncVal)VncFunction.meta().arglists("(compare-fn dag)").doc("Returns a comparator fn which produces a topological sort based on the dependencies in the graph. Nodes not present in the graph will sort after nodes in the graph.").examples("(let [g (dag/dag [\"A\", \"B\"]   ;    A  E   \n                 [\"B\", \"C\"]   ;    |  |   \n                 [\"C\", \"D\"]   ;    B  F   \n                 [\"E\", \"F\"]   ;    | / \\ \n                 [\"F\", \"C\"]   ;    C    G \n                 [\"F\", \"G\"]   ;     \\  / \n                 [\"G\", \"D\"])] ;      D    \n  (sort (dag/compare-fn g) [\"D\" \"F\" \"A\" \"Z\"])) ").seeAlso("dag/dag", "dag/topological-sort").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncDAG dag = Coerce.toVncDAG(args.first());
            return dag.compareFn();
        }
    };
    public static VncFunction edges = new VncFunction("dag/edges", (VncVal)VncFunction.meta().arglists("(edges dag)").doc("Returns the edges of a DAG").examples("(dag/edges (dag/dag [\"A\" \"B\"] [\"B\" \"C\"]))").seeAlso("dag/dag", "dag/add-edges", "dag/nodes").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncDAG dag = Coerce.toVncDAG(args.first());
            return dag.edges();
        }
    };
    public static VncFunction nodes = new VncFunction("dag/nodes", (VncVal)VncFunction.meta().arglists("(nodes dag)").doc("Returns the nodes of a DAG").examples("(dag/nodes (dag/dag [\"A\" \"B\"] [\"B\" \"C\"]))").seeAlso("dag/dag", "dag/node?", "dag/add-edges", "dag/edges").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncDAG dag = Coerce.toVncDAG(args.first());
            return dag.nodes();
        }
    };
    public static VncFunction children = new VncFunction("dag/children", (VncVal)VncFunction.meta().arglists("(children dag node)").doc("Returns the transitive child nodes").examples("(dag/children (dag/dag [\"A\" \"B\"] [\"B\" \"C\"]) \"A\")", "(-> (dag/dag [\"A\", \"B\"]  ;    A  E   \n             [\"B\", \"C\"]  ;    |  |   \n             [\"C\", \"D\"]  ;    B  F   \n             [\"E\", \"F\"]  ;    | / \\ \n             [\"F\", \"C\"]  ;    C    G \n             [\"F\", \"G\"]  ;     \\  / \n             [\"G\", \"D\"]) ;      D    \n    (dag/children \"F\"))                  ").seeAlso("dag/dag", "dag/direct-children", "dag/parents", "dag/direct-parents", "dag/roots").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncDAG dag = Coerce.toVncDAG(args.first());
            return dag.children(args.second());
        }
    };
    public static VncFunction direct_children = new VncFunction("dag/direct-children", (VncVal)VncFunction.meta().arglists("(direct-children dag node)").doc("Returns the direct child nodes").examples("(-> (dag/dag [\"A\", \"B\"]  ;    A  E   \n             [\"B\", \"C\"]  ;    |  |   \n             [\"C\", \"D\"]  ;    B  F   \n             [\"E\", \"F\"]  ;    | / \\ \n             [\"F\", \"C\"]  ;    C    G \n             [\"F\", \"G\"]  ;     \\  / \n             [\"G\", \"D\"]) ;      D    \n    (dag/direct-children \"F\"))        ").seeAlso("dag/dag", "dag/children", "dag/parents", "dag/direct-parents", "dag/roots").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncDAG dag = Coerce.toVncDAG(args.first());
            return dag.directChildren(args.second());
        }
    };
    public static VncFunction parents = new VncFunction("dag/parents", (VncVal)VncFunction.meta().arglists("(parents dag node)").doc("Returns the transitive parent nodes").examples("(dag/parents (dag/dag [\"A\" \"B\"] [\"B\" \"C\"]) \"C\")", "(-> (dag/dag [\"A\", \"B\"]  ;    A  E   \n             [\"B\", \"C\"]  ;    |  |   \n             [\"C\", \"D\"]  ;    B  F   \n             [\"E\", \"F\"]  ;    | / \\ \n             [\"F\", \"C\"]  ;    C    G \n             [\"F\", \"G\"]  ;     \\  / \n             [\"G\", \"D\"]) ;      D    \n    (dag/parents \"C\"))                   ").seeAlso("dag/dag", "dag/direct-parents", "dag/children", "dag/direct-children", "dag/roots").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncDAG dag = Coerce.toVncDAG(args.first());
            return dag.parents(args.second());
        }
    };
    public static VncFunction direct_parents = new VncFunction("dag/direct-parents", (VncVal)VncFunction.meta().arglists("(direct-parents dag node)").doc("Returns the direct parent nodes").examples("(dag/parents (dag/dag [\"A\" \"B\"] [\"B\" \"C\"]) \"C\")", "(-> (dag/dag [\"A\", \"B\"]  ;    A  E   \n             [\"B\", \"C\"]  ;    |  |   \n             [\"C\", \"D\"]  ;    B  F   \n             [\"E\", \"F\"]  ;    | / \\ \n             [\"F\", \"C\"]  ;    C    G \n             [\"F\", \"G\"]  ;     \\  / \n             [\"G\", \"D\"]) ;      D    \n    (dag/direct-parents \"C\"))         ").seeAlso("dag/dag", "dag/parents", "dag/children", "dag/direct-children", "dag/roots").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncDAG dag = Coerce.toVncDAG(args.first());
            return dag.directParents(args.second());
        }
    };
    public static VncFunction roots = new VncFunction("dag/roots", (VncVal)VncFunction.meta().arglists("(roots dag)").doc("Returns the root nodes of a DAG").examples("(dag/roots (dag/dag [\"A\" \"B\"] [\"B\" \"C\"]))", "(-> (dag/dag [\"A\", \"B\"]  ;    A  E   \n             [\"B\", \"C\"]  ;    |  |   \n             [\"C\", \"D\"]  ;    B  F   \n             [\"E\", \"F\"]  ;    | / \\ \n             [\"F\", \"C\"]  ;    C    G \n             [\"F\", \"G\"]  ;     \\  / \n             [\"G\", \"D\"]) ;      D    \n    (dag/roots))                           ").seeAlso("dag/dag", "dag/parents", "dag/children").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncDAG dag = Coerce.toVncDAG(args.first());
            return dag.roots();
        }
    };
    public static VncFunction parent_of_Q = new VncFunction("dag/parent-of?", (VncVal)VncFunction.meta().arglists("(parent-of? dag p v)").doc("Returns `true` if p is a transitive parent of v").examples("(-> (dag/dag [\"A\", \"B\"]  ;    A  E   \n             [\"B\", \"C\"]  ;    |  |   \n             [\"C\", \"D\"]  ;    B  F   \n             [\"E\", \"F\"]  ;    | / \\ \n             [\"F\", \"C\"]  ;    C    G \n             [\"F\", \"G\"]  ;     \\  / \n             [\"G\", \"D\"]) ;      D    \n    (dag/parent-of? \"E\" \"G\"))         ").seeAlso("dag/dag", "dag/parents", "dag/child-of?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3);
            VncDAG dag = Coerce.toVncDAG(args.first());
            return dag.isParentOf(args.second(), args.third());
        }
    };
    public static VncFunction child_of_Q = new VncFunction("dag/child-of?", (VncVal)VncFunction.meta().arglists("(child-of? dag c v)").doc("Returns `true` if c is a transitive child of v").examples("(-> (dag/dag [\"A\", \"B\"]  ;    A  E   \n             [\"B\", \"C\"]  ;    |  |   \n             [\"C\", \"D\"]  ;    B  F   \n             [\"E\", \"F\"]  ;    | / \\ \n             [\"F\", \"C\"]  ;    C    G \n             [\"F\", \"G\"]  ;     \\  / \n             [\"G\", \"D\"]) ;      D    \n    (dag/child-of? \"G\" \"E\"))         ").seeAlso("dag/dag", "dag/children", "dag/parent-of?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3);
            VncDAG dag = Coerce.toVncDAG(args.first());
            return dag.isChildOf(args.second(), args.third());
        }
    };
    public static VncFunction node_Q = new VncFunction("dag/node?", (VncVal)VncFunction.meta().arglists("(node? dag v)").doc("Returns `true` if v is a node in the DAG").examples("(-> (dag/dag [\"A\", \"B\"]  ;    A  E   \n             [\"B\", \"C\"]  ;    |  |   \n             [\"C\", \"D\"]  ;    B  F   \n             [\"E\", \"F\"]  ;    | / \\ \n             [\"F\", \"C\"]  ;    C    G \n             [\"F\", \"G\"]  ;     \\  / \n             [\"G\", \"D\"]) ;      D    \n    (dag/node? \"G\"))                     ").seeAlso("dag/dag", "dag/nodes").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncDAG dag = Coerce.toVncDAG(args.first());
            return dag.isNode(args.second());
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().add(dag).add(dag_Q).add(topological_sort).add(compare_fn).add(add_edges).add(add_nodes).add(edges).add(nodes).add(children).add(direct_children).add(parents).add(direct_parents).add(roots).add(parent_of_Q).add(child_of_Q).add(node_Q).toMap();
}

