/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.thread;

import com.github.jlangch.venice.impl.Namespace;
import com.github.jlangch.venice.impl.debug.agent.DebugAgent;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.util.MeterRegistry;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.util.Map;

public class ThreadContextSnapshot {
    private final Long threadID;
    private final Namespace ns;
    private final Map<VncKeyword, VncVal> values;
    private final DebugAgent agent;
    private final IInterceptor interceptor;
    private final MeterRegistry meterRegistry;

    public ThreadContextSnapshot(Long threadID, Namespace ns, Map<VncKeyword, VncVal> values, DebugAgent agent, IInterceptor interceptor, MeterRegistry meterRegistry) {
        this.threadID = threadID;
        this.ns = ns;
        this.values = values;
        this.agent = agent;
        this.interceptor = interceptor;
        this.meterRegistry = meterRegistry;
    }

    public long getThreadID() {
        return this.threadID;
    }

    public Namespace getNamespace() {
        return this.ns;
    }

    public Map<VncKeyword, VncVal> getValues() {
        return this.values;
    }

    public DebugAgent getAgent() {
        return this.agent;
    }

    public IInterceptor getInterceptor() {
        return this.interceptor;
    }

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public boolean isDifferentFromCurrentThread() {
        return this.threadID.longValue() != Thread.currentThread().getId();
    }

    public boolean isSameAsCurrentThread() {
        return this.threadID.longValue() == Thread.currentThread().getId();
    }
}

