/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.markdown.block;

import com.github.jlangch.venice.impl.reader.LineReader;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.markdown.block.Block;
import com.github.jlangch.venice.impl.util.markdown.block.Blocks;
import com.github.jlangch.venice.impl.util.markdown.block.CodeBlock;
import com.github.jlangch.venice.impl.util.markdown.block.CodeBlockParser;
import com.github.jlangch.venice.impl.util.markdown.block.ListBlock;
import com.github.jlangch.venice.impl.util.markdown.block.ListBlockParser;
import com.github.jlangch.venice.impl.util.markdown.block.TableBlock;
import com.github.jlangch.venice.impl.util.markdown.block.TableBlockParser;
import com.github.jlangch.venice.impl.util.markdown.block.TextBlock;
import com.github.jlangch.venice.impl.util.markdown.block.TextBlockParser;

public class BlockParser {
    private final LineReader reader;
    private final Blocks blocks = new Blocks();

    public BlockParser(String text) {
        this.reader = new LineReader(text);
    }

    public Blocks parse() {
        while (!this.reader.eof()) {
            Block block;
            Object p;
            String line = this.reader.peek();
            if (StringUtil.isBlank(line)) {
                this.reader.consume();
                continue;
            }
            if (CodeBlockParser.isBlockStart(line)) {
                p = new CodeBlockParser(this.reader);
                block = ((CodeBlockParser)p).parse();
                if (((CodeBlock)block).isEmpty()) continue;
                this.blocks.add(block);
                continue;
            }
            if (ListBlockParser.isBlockStart(line)) {
                p = new ListBlockParser(this.reader);
                block = ((ListBlockParser)p).parse();
                if (((ListBlock)block).isEmpty()) continue;
                this.blocks.add(block);
                continue;
            }
            if (TableBlockParser.isBlockStart(line)) {
                p = new TableBlockParser(this.reader);
                block = ((TableBlockParser)p).parse();
                if (((TableBlock)block).isEmpty()) continue;
                this.blocks.add(block);
                continue;
            }
            p = new TextBlockParser(this.reader);
            block = ((TextBlockParser)p).parse();
            if (((TextBlock)block).isEmpty()) continue;
            this.blocks.add(block);
        }
        return this.blocks;
    }
}

