/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.markdown.block;

import com.github.jlangch.venice.impl.reader.CharacterReader;
import com.github.jlangch.venice.impl.reader.LineReader;
import com.github.jlangch.venice.impl.util.markdown.block.TableBlock;
import com.github.jlangch.venice.impl.util.markdown.chunk.Chunks;
import com.github.jlangch.venice.impl.util.markdown.chunk.LineBreakChunk;
import com.github.jlangch.venice.impl.util.markdown.chunk.RawChunk;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class TableBlockParser {
    private static final int EOF = -1;
    private final LineReader reader;

    public TableBlockParser(LineReader reader) {
        this.reader = reader;
    }

    public TableBlock parse() {
        if (this.reader.eof()) {
            return new TableBlock();
        }
        List<String> rawRows = this.parseRawRows();
        if (rawRows.isEmpty()) {
            return new TableBlock();
        }
        List<List<String>> cells = rawRows.stream().map(r -> this.split((String)r)).collect(Collectors.toList());
        int cols = ((List)cells.get(0)).size();
        if (this.isFormatRow((List)cells.get(0))) {
            List formatRow = (List)cells.get(0);
            List<List<String>> body = cells.subList(1, cells.size());
            TableBlock block = new TableBlock(cols, this.parseAlignments(formatRow), this.toChunks2(body));
            block.parseChunks();
            return block;
        }
        if (cells.size() > 1 && this.isFormatRow((List)cells.get(1))) {
            List<String> headerRow = cells.get(0);
            List<String> formatRow = cells.get(1);
            List<List<String>> body = cells.subList(2, cells.size());
            TableBlock block = new TableBlock(cols, this.parseAlignments(formatRow), this.toChunks(headerRow), this.toChunks2(body));
            block.parseChunks();
            return block;
        }
        List<List<String>> body = cells;
        TableBlock block = new TableBlock(cols, this.toChunks2(body));
        block.parseChunks();
        return block;
    }

    public static boolean isBlockStart(String line) {
        return TableBlockParser.isRow(line);
    }

    private static boolean isRow(String line) {
        return line.matches(" *[|].*[|] *");
    }

    private List<String> parseRawRows() {
        ArrayList<String> rows = new ArrayList<String>();
        String line = this.reader.peek();
        while (line != null && TableBlockParser.isRow(line)) {
            this.reader.consume();
            rows.add(line.trim());
            line = this.reader.peek();
        }
        return rows;
    }

    private List<String> split(String line) {
        CharacterReader reader = new CharacterReader(line);
        ArrayList<String> cols = new ArrayList<String>();
        StringBuilder col = new StringBuilder();
        int ch = reader.peek();
        if (ch == 124) {
            reader.consume();
        }
        while (true) {
            ch = reader.peek();
            reader.consume();
            if (ch == -1) break;
            if (ch == 92) {
                ch = reader.peek();
                if (ch == -1) continue;
                reader.consume();
                col.append((char)ch);
                continue;
            }
            if (ch == 124) {
                cols.add(col.toString().trim());
                col = new StringBuilder();
                continue;
            }
            col.append((char)ch);
        }
        return cols;
    }

    private List<TableBlock.Alignment> parseAlignments(List<String> row) {
        ArrayList<TableBlock.Alignment> align = new ArrayList<TableBlock.Alignment>();
        for (String s : row) {
            if (this.isCenterAlign(s)) {
                align.add(TableBlock.Alignment.CENTER);
                continue;
            }
            if (this.isLeftAlign(s)) {
                align.add(TableBlock.Alignment.LEFT);
                continue;
            }
            if (this.isRightAlign(s)) {
                align.add(TableBlock.Alignment.RIGHT);
                continue;
            }
            align.add(TableBlock.Alignment.LEFT);
        }
        return align;
    }

    private boolean isFormatRow(List<String> row) {
        for (String col : row) {
            if (!this.isCenterAlign(col) && !this.isLeftAlign(col) && !this.isRightAlign(col)) continue;
            return true;
        }
        return false;
    }

    private boolean isCenterAlign(String s) {
        return s.matches("---+") || s.matches("[:]-+[:]");
    }

    private boolean isLeftAlign(String s) {
        return s.matches("[:]-+");
    }

    private boolean isRightAlign(String s) {
        return s.matches("-+[:]");
    }

    private List<Chunks> toChunks(List<String> list) {
        return list.stream().map(s -> this.parseLine((String)s)).collect(Collectors.toList());
    }

    private List<List<Chunks>> toChunks2(List<List<String>> list) {
        return list.stream().map(l -> this.toChunks((List<String>)l)).collect(Collectors.toList());
    }

    private Chunks parseLine(String line) {
        Chunks chunks = new Chunks();
        if (line.contains("\u00b6")) {
            String[] elments = line.split("\u00b6");
            for (int ii = 0; ii < elments.length; ++ii) {
                if (ii > 0) {
                    chunks.add(new LineBreakChunk());
                }
                chunks.add(new RawChunk(elments[ii].trim()));
            }
            if (line.endsWith("\u00b6")) {
                chunks.add(new LineBreakChunk());
            }
        } else {
            return chunks.add(new RawChunk(line));
        }
        return chunks;
    }
}

