/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.markdown.renderer.text;

import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.markdown.block.TableBlock;
import com.github.jlangch.venice.impl.util.markdown.renderer.text.LineFormatter;
import com.github.jlangch.venice.impl.util.markdown.renderer.text.LineWrap;
import com.github.jlangch.venice.impl.util.markdown.renderer.text.TextTableLayouter;
import com.github.jlangch.venice.impl.util.markdown.renderer.text.TextTableUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class TextTableRendrer {
    private final TableBlock block;
    private final int maxTableWidth;
    private final String colSpacing;
    private final char fillChar;

    public TextTableRendrer(TableBlock block, int maxTableWidth) {
        this(block, maxTableWidth, ' ', "  ");
    }

    public TextTableRendrer(TableBlock block, int maxTableWidth, char fillChar, String colSpacing) {
        this.block = block;
        this.maxTableWidth = maxTableWidth;
        this.fillChar = fillChar;
        this.colSpacing = colSpacing;
    }

    public String render() {
        int cols = this.block.cols();
        List<String> headerCells = TextTableUtil.toHeaderCellTextLines(this.block);
        List<List<String>> bodyCells = TextTableUtil.toBodyCellTextLines(this.block);
        int[] maxColWidths = TextTableUtil.maxColWidths(this.block, headerCells, bodyCells);
        int[] effColWidth = new TextTableLayouter().layoutColWidths(this.maxTableWidth, this.colSpacing.length(), maxColWidths);
        ArrayList<String> lines = new ArrayList<String>();
        if (this.block.hasHeader()) {
            lines.add(this.renderHeader(cols, effColWidth, headerCells));
            lines.add(this.renderHeaderSeparator(cols, effColWidth));
        }
        for (int row = 0; row < bodyCells.size(); ++row) {
            lines.addAll(this.renderBodyRow(cols, effColWidth, bodyCells.get(row)));
        }
        return lines.stream().map(l -> StringUtil.trimRight(l)).collect(Collectors.joining("\n"));
    }

    private String renderHeader(int cols, int[] colWidth, List<String> headerCells) {
        StringBuilder sb = new StringBuilder();
        for (int col = 0; col < cols; ++col) {
            if (col > 0) {
                sb.append(this.colSpacing);
            }
            int width = colWidth[col];
            String s = headerCells.get(col);
            sb.append(this.align(s.length() <= width ? s : s.substring(0, width), this.block.format(col), width));
        }
        return sb.toString();
    }

    private String renderHeaderSeparator(int cols, int[] colWidth) {
        StringBuilder sb = new StringBuilder();
        for (int col = 0; col < cols; ++col) {
            if (col > 0) {
                sb.append(this.colSpacing);
            }
            sb.append(StringUtil.repeat("-", colWidth[col]));
        }
        return sb.toString();
    }

    private List<String> renderBodyRow(int cols, int[] colWidth, List<String> cells) {
        int col;
        ArrayList<List<String>> cellLines = new ArrayList<List<String>>();
        for (int col2 = 0; col2 < cols; ++col2) {
            cellLines.add(LineWrap.softWrap(cells.get(col2), colWidth[col2]));
        }
        int height = (int)cellLines.stream().mapToLong(l -> l.size()).max().orElse(0L);
        for (col = 0; col < cols; ++col) {
            for (int ii = ((List)cellLines.get(col)).size(); ii < height; ++ii) {
                ((List)cellLines.get(col)).add("");
            }
        }
        for (col = 0; col < cols; ++col) {
            List lines = (List)cellLines.get(col);
            for (int ii = 0; ii < lines.size(); ++ii) {
                String s = (String)lines.get(ii);
                lines.set(ii, this.align(s, this.block.format(col), colWidth[col]));
            }
        }
        ArrayList<String> lines = new ArrayList<String>();
        for (int ii = 0; ii < height; ++ii) {
            StringBuilder sb = new StringBuilder();
            for (int col3 = 0; col3 < cols; ++col3) {
                if (col3 > 0) {
                    sb.append(this.colSpacing);
                }
                String chunk = (String)((List)cellLines.get(col3)).get(ii);
                sb.append(chunk);
            }
            lines.add(sb.toString());
        }
        return lines;
    }

    private String align(String str, TableBlock.Alignment align, int width) {
        switch (align) {
            case LEFT: {
                return LineFormatter.leftAlign(str, width, this.fillChar);
            }
            case CENTER: {
                return LineFormatter.centerAlign(str, width, this.fillChar);
            }
            case RIGHT: {
                return LineFormatter.rightAlign(str, width, this.fillChar);
            }
        }
        return LineFormatter.leftAlign(str, width, this.fillChar);
    }
}

