/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.javainterop;

import com.github.jlangch.venice.SecurityException;
import com.github.jlangch.venice.javainterop.IInvoker;
import com.github.jlangch.venice.javainterop.ILoadPaths;
import com.github.jlangch.venice.javainterop.Interceptor;
import com.github.jlangch.venice.javainterop.ReturnValue;

public class ValueFilterInterceptor
extends Interceptor {
    public ValueFilterInterceptor(ILoadPaths loadPaths) {
        super(loadPaths);
    }

    @Override
    public ReturnValue onInvokeInstanceMethod(IInvoker invoker, Object receiver, Class<?> receiverFormalType, String method, Object ... args) throws SecurityException {
        this.filterAccessor(receiver, method);
        return this.filterReturnValue(super.onInvokeInstanceMethod(invoker, receiver, receiverFormalType, method, this.filterArguments(args)));
    }

    @Override
    public ReturnValue onInvokeStaticMethod(IInvoker invoker, Class<?> receiver, String method, Object ... args) throws SecurityException {
        this.filterAccessor(receiver, method);
        return this.filterReturnValue(super.onInvokeStaticMethod(invoker, receiver, method, this.filterArguments(args)));
    }

    @Override
    public ReturnValue onInvokeConstructor(IInvoker invoker, Class<?> receiver, Object ... args) throws SecurityException {
        this.filterAccessor(receiver, "new");
        return this.filterReturnValue(super.onInvokeConstructor(invoker, receiver, this.filterArguments(args)));
    }

    @Override
    public ReturnValue onGetBeanProperty(IInvoker invoker, Object receiver, String property) throws SecurityException {
        this.filterAccessor(receiver, property);
        return this.filterReturnValue(super.onGetBeanProperty(invoker, receiver, property));
    }

    @Override
    public void onSetBeanProperty(IInvoker invoker, Object receiver, String property, Object value) throws SecurityException {
        this.filterAccessor(receiver, property);
        super.onSetBeanProperty(invoker, receiver, property, this.filterArgument(value));
    }

    @Override
    public ReturnValue onGetStaticField(IInvoker invoker, Class<?> receiver, String fieldName) throws SecurityException {
        this.filterAccessor(receiver, fieldName);
        return this.filterReturnValue(super.onGetStaticField(invoker, receiver, fieldName));
    }

    @Override
    public ReturnValue onGetInstanceField(IInvoker invoker, Object receiver, Class<?> receiverFormalType, String fieldName) throws SecurityException {
        this.filterAccessor(receiver, fieldName);
        return this.filterReturnValue(super.onGetInstanceField(invoker, receiver, receiverFormalType, fieldName));
    }

    protected ReturnValue filterReturnValue(ReturnValue returnValue) {
        return returnValue;
    }

    protected Object filterArgument(Object arg) {
        return this.filter(arg);
    }

    protected Object filter(Object o) {
        return o;
    }

    protected Object filterAccessor(Object o, String accessor) {
        return o;
    }

    private Object[] filterArguments(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.filterArgument(args[i]);
        }
        return args;
    }
}

