/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.excel;

import com.github.jlangch.venice.impl.util.excel.Excel;
import com.github.jlangch.venice.util.excel.ExcelCellStyleBuilder;
import com.github.jlangch.venice.util.excel.ExcelFontBuilder;
import com.github.jlangch.venice.util.excel.ExcelReader;
import com.github.jlangch.venice.util.excel.ExcelSheetBuilder;
import java.io.OutputStream;

public class ExcelBuilder {
    private final Excel managedExcel;

    private ExcelBuilder(Excel managedExcel) {
        this.managedExcel = managedExcel;
    }

    public static ExcelBuilder createXls() {
        return new ExcelBuilder(Excel.createXls());
    }

    public static ExcelBuilder createXlsx() {
        return new ExcelBuilder(Excel.createXlsx());
    }

    public ExcelFontBuilder withFont(String name) {
        return new ExcelFontBuilder(this, this.managedExcel, name);
    }

    public ExcelCellStyleBuilder withCellStyle(String name) {
        return new ExcelCellStyleBuilder(this, this.managedExcel, name);
    }

    public <T> ExcelSheetBuilder<T> withSheet(String name, Class<T> type) {
        return new ExcelSheetBuilder(this, this.managedExcel.createSheet(name));
    }

    public void evaluateAllFormulas() {
        this.managedExcel.evaluateAllFormulas();
    }

    public Excel toExcel() {
        return this.managedExcel;
    }

    public void write(OutputStream outputStream) {
        this.managedExcel.write(outputStream);
    }

    public byte[] writeToBytes() {
        return this.managedExcel.writeToBytes();
    }

    public ExcelReader reader() {
        this.managedExcel.close();
        return new ExcelReader(this.managedExcel);
    }

    public ExcelBuilder end() {
        this.managedExcel.close();
        return this;
    }
}

