/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.impl.Namespace;
import com.github.jlangch.venice.impl.types.VncSymbol;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class NamespaceRegistry {
    private final Map<VncSymbol, Namespace> namespaces = new ConcurrentHashMap<VncSymbol, Namespace>();

    public void add(Namespace ns) {
        Objects.requireNonNull(ns);
        this.namespaces.put(ns.getNS(), ns);
    }

    public Namespace get(VncSymbol sym) {
        Objects.requireNonNull(sym);
        return this.namespaces.get(sym);
    }

    public Namespace computeIfAbsent(VncSymbol sym) {
        Objects.requireNonNull(sym);
        return this.namespaces.computeIfAbsent(sym, s -> new Namespace((VncSymbol)s));
    }

    public Namespace remove(VncSymbol sym) {
        Objects.requireNonNull(sym);
        return this.namespaces.remove(sym);
    }

    public void clear() {
        this.namespaces.clear();
    }
}

