/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.NotInTailPositionException;
import com.github.jlangch.venice.SecurityException;
import com.github.jlangch.venice.Version;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Destructuring;
import com.github.jlangch.venice.impl.FunctionBuilder;
import com.github.jlangch.venice.impl.IVeniceInterpreter;
import com.github.jlangch.venice.impl.InterruptChecker;
import com.github.jlangch.venice.impl.ModuleLoader;
import com.github.jlangch.venice.impl.Modules;
import com.github.jlangch.venice.impl.Namespace;
import com.github.jlangch.venice.impl.NamespaceRegistry;
import com.github.jlangch.venice.impl.Namespaces;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.RecursionPoint;
import com.github.jlangch.venice.impl.RunMode;
import com.github.jlangch.venice.impl.SpecialFormsHandler;
import com.github.jlangch.venice.impl.debug.agent.DebugAgent;
import com.github.jlangch.venice.impl.debug.breakpoint.BreakpointFnRef;
import com.github.jlangch.venice.impl.debug.breakpoint.FunctionScope;
import com.github.jlangch.venice.impl.env.ComputedVar;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.ReservedSymbols;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.Functions;
import com.github.jlangch.venice.impl.functions.TransducerFunctions;
import com.github.jlangch.venice.impl.reader.Reader;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncMultiArityFunction;
import com.github.jlangch.venice.impl.types.VncMultiFunction;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncLazySeq;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMapEntry;
import com.github.jlangch.venice.impl.types.collections.VncMutableSet;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.CallFrameFnData;
import com.github.jlangch.venice.impl.util.CallStack;
import com.github.jlangch.venice.impl.util.MetaUtil;
import com.github.jlangch.venice.impl.util.MeterRegistry;
import com.github.jlangch.venice.impl.util.WithCallStack;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class VeniceInterpreter
implements IVeniceInterpreter,
Serializable {
    private static final long serialVersionUID = -8130740279914790685L;
    private static final VncKeyword PRE_CONDITION_KEY = new VncKeyword(":pre");
    private static final BreakpointFnRef BREAKPOINT_REF_IF = new BreakpointFnRef("if");
    private static final BreakpointFnRef BREAKPOINT_REF_LET = new BreakpointFnRef("let");
    private static final BreakpointFnRef BREAKPOINT_REF_BINDINGS = new BreakpointFnRef("bindings");
    private static final BreakpointFnRef BREAKPOINT_REF_LOOP = new BreakpointFnRef("loop");
    private final IInterceptor interceptor;
    private final boolean checkSandbox;
    private final MeterRegistry meterRegistry;
    private final NamespaceRegistry nsRegistry;
    private final SpecialFormsHandler specialFormHandler;
    private final FunctionBuilder functionBuilder;
    private final AtomicBoolean sealedSystemNS;
    private final boolean optimized;
    private volatile boolean macroexpand = false;

    public VeniceInterpreter(IInterceptor interceptor) {
        this(interceptor, null);
    }

    public VeniceInterpreter(IInterceptor interceptor, MeterRegistry meterRegistry) {
        if (interceptor == null) {
            throw new SecurityException("VeniceInterpreter can not run without an interceptor");
        }
        MeterRegistry mr = meterRegistry == null ? new MeterRegistry(false) : meterRegistry;
        this.interceptor = interceptor;
        this.meterRegistry = mr;
        this.nsRegistry = new NamespaceRegistry();
        this.sealedSystemNS = new AtomicBoolean(false);
        this.checkSandbox = !(interceptor instanceof AcceptAllInterceptor);
        this.optimized = false;
        this.specialFormHandler = new SpecialFormsHandler(this, this::evaluate, this::evaluate_values, this::evaluate_sequence_values, this.nsRegistry, this.meterRegistry, this.sealedSystemNS);
        this.functionBuilder = new FunctionBuilder(this::evaluate, this.optimized);
        ThreadContext.setInterceptor(interceptor);
        ThreadContext.setMeterRegistry(mr);
        if (this.optimized && this.checkSandbox) {
            throw new VncException("Venice interpreter supports optimized mode only with AcceptAllInterceptor!");
        }
    }

    @Override
    public void initNS() {
        this.nsRegistry.clear();
        Namespaces.setCurrentNamespace(this.nsRegistry.computeIfAbsent(Namespaces.NS_USER));
    }

    @Override
    public void sealSystemNS() {
        this.sealedSystemNS.set(true);
    }

    @Override
    public void setMacroExpandOnLoad(boolean macroExpandOnLoad, Env env) {
        env.setMacroExpandOnLoad(VncBoolean.of(macroExpandOnLoad));
        this.macroexpand = macroExpandOnLoad;
    }

    @Override
    public boolean isMacroExpandOnLoad() {
        return this.macroexpand;
    }

    @Override
    public VncVal READ(String script, String filename) {
        if (this.meterRegistry.enabled) {
            long nanos = System.nanoTime();
            VncVal val = Reader.read_str(script, filename);
            this.meterRegistry.record("venice.read", System.nanoTime() - nanos);
            return val;
        }
        return Reader.read_str(script, filename);
    }

    @Override
    public VncVal EVAL(VncVal ast, Env env) {
        if (this.meterRegistry.enabled) {
            long nanos = System.nanoTime();
            VncVal val = this.evaluate(ast, env, false);
            this.meterRegistry.record("venice.eval", System.nanoTime() - nanos);
            return val;
        }
        return this.evaluate(ast, env, false);
    }

    @Override
    public VncVal MACROEXPAND(VncVal ast, Env env) {
        return this.macroexpand_all(new CallFrame("macroexpand-all", ast.getMeta()), ast, env);
    }

    @Override
    public VncVal RE(String script, String name, Env env) {
        VncVal ast = this.READ(script, name);
        if (this.macroexpand) {
            ast = this.MACROEXPAND(ast, env);
        }
        return this.EVAL(ast, env);
    }

    @Override
    public String PRINT(VncVal exp) {
        return Printer.pr_str(exp, true);
    }

    @Override
    public Env createEnv(boolean macroexpandOnLoad, boolean ansiTerminal, RunMode runMode) {
        return this.createEnv(null, macroexpandOnLoad, ansiTerminal, runMode);
    }

    @Override
    public Env createEnv(List<String> preloadedExtensionModules, boolean macroExpandOnLoad, boolean ansiTerminal, RunMode runMode) {
        this.sealedSystemNS.set(false);
        Env env = new Env(null);
        VncMutableSet loadedModules = VncMutableSet.ofAll(Modules.PRELOADED_MODULES);
        for (Map.Entry<VncVal, VncVal> e : Functions.functions.entrySet()) {
            VncSymbol sym = (VncSymbol)e.getKey();
            VncVal val = e.getValue();
            if (val instanceof VncFunction) {
                VncFunction fn = (VncFunction)e.getValue();
                env.setGlobal(new Var(sym, fn, fn.isRedefinable()));
                continue;
            }
            env.setGlobal(new Var(sym, val, true));
        }
        env.setGlobal(new Var(new VncSymbol("*version*"), new VncString(Version.VERSION), false));
        env.setGlobal(new ComputedVar(new VncSymbol("*ns*"), () -> Namespaces.getCurrentNS(), false));
        env.setGlobal(new Var(new VncSymbol("*newline*"), new VncString(System.lineSeparator()), false));
        env.setGlobal(new Var(new VncSymbol("*ansi-term*"), VncBoolean.of(ansiTerminal), false));
        env.setGlobal(new Var(new VncSymbol("*run-mode*"), runMode == null ? Constants.Nil : runMode.mode, false));
        env.setGlobal(new Var(new VncSymbol("*loaded-modules*"), loadedModules, true));
        env.setGlobal(new Var(new VncSymbol("*loaded-files*"), new VncMutableSet(), true));
        this.initNS();
        this.setMacroExpandOnLoad(macroExpandOnLoad, env);
        this.loadModule("core", env, loadedModules);
        this.sealedSystemNS.set(true);
        VeniceInterpreter.toEmpty(preloadedExtensionModules).forEach(m -> this.loadModule((String)m, env, loadedModules));
        return env;
    }

    @Override
    public List<String> getAvailableModules() {
        ArrayList<String> modules = new ArrayList<String>(Modules.VALID_MODULES);
        modules.removeAll(Arrays.asList("core", "test", "http", "jackson"));
        Collections.sort(modules);
        return modules;
    }

    private void loadModule(String module, Env env, VncMutableSet loadedModules) {
        try {
            long nanos = System.nanoTime();
            this.RE("(eval " + ModuleLoader.loadModule(module) + ")", module, env);
            if (this.meterRegistry.enabled) {
                this.meterRegistry.record("venice.module." + module + ".load", System.nanoTime() - nanos);
            }
            loadedModules.add(new VncKeyword(module));
        }
        catch (RuntimeException ex) {
            throw new VncException("Failed to load module '" + module + "'", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private VncVal evaluate(VncVal ast_, Env env_, boolean inTailPosition) {
        orig_ast = ast_;
        env = env_;
        recursionPoint = null;
        tailPosition = inTailPosition;
        block197: while (true) {
            if (!(orig_ast instanceof VncList)) {
                return this.evaluate_values(orig_ast, env);
            }
            ast = (VncList)orig_ast;
            if (ast.isEmpty()) {
                return ast;
            }
            a0 = ast.first();
            a0meta = a0.getMeta();
            a0sym = a0 instanceof VncSymbol != false ? ((VncSymbol)a0).getName() : "__<*fn*>__";
            args = ast.rest();
            var13_13 = a0sym;
            var14_14 = -1;
            switch (var13_13.hashCode()) {
                case 3211: {
                    if (!var13_13.equals("do")) break;
                    var14_14 = 0;
                    break;
                }
                case 3357: {
                    if (!var13_13.equals("if")) break;
                    var14_14 = 1;
                    break;
                }
                case 107035: {
                    if (!var13_13.equals("let")) break;
                    var14_14 = 2;
                    break;
                }
                case 3327652: {
                    if (!var13_13.equals("loop")) break;
                    var14_14 = 3;
                    break;
                }
                case 108389165: {
                    if (!var13_13.equals("recur")) break;
                    var14_14 = 4;
                    break;
                }
                case 1896636553: {
                    if (!var13_13.equals("quasiquote")) break;
                    var14_14 = 5;
                    break;
                }
                case 107953788: {
                    if (!var13_13.equals("quote")) break;
                    var14_14 = 6;
                    break;
                }
                case 3272: {
                    if (!var13_13.equals("fn")) break;
                    var14_14 = 7;
                    break;
                }
                case 3125404: {
                    if (!var13_13.equals("eval")) break;
                    var14_14 = 8;
                    break;
                }
                case 99333: {
                    if (!var13_13.equals("def")) break;
                    var14_14 = 9;
                    break;
                }
                case 1545213958: {
                    if (!var13_13.equals("defonce")) break;
                    var14_14 = 10;
                    break;
                }
                case 1590555255: {
                    if (!var13_13.equals("def-dynamic")) break;
                    var14_14 = 11;
                    break;
                }
                case 654758631: {
                    if (!var13_13.equals("defmacro")) break;
                    var14_14 = 12;
                    break;
                }
                case 1654537629: {
                    if (!var13_13.equals("defprotocol")) break;
                    var14_14 = 13;
                    break;
                }
                case -1289044198: {
                    if (!var13_13.equals("extend")) break;
                    var14_14 = 14;
                    break;
                }
                case -1820889402: {
                    if (!var13_13.equals("extends?")) break;
                    var14_14 = 15;
                    break;
                }
                case 1545373887: {
                    if (!var13_13.equals("deftype")) break;
                    var14_14 = 16;
                    break;
                }
                case 661950304: {
                    if (!var13_13.equals("deftype?")) break;
                    var14_14 = 17;
                    break;
                }
                case 479068581: {
                    if (!var13_13.equals("deftype-of")) break;
                    var14_14 = 18;
                    break;
                }
                case 479068593: {
                    if (!var13_13.equals("deftype-or")) break;
                    var14_14 = 19;
                    break;
                }
                case 385882137: {
                    if (!var13_13.equals("deftype-describe")) break;
                    var14_14 = 20;
                    break;
                }
                case 1484: {
                    if (!var13_13.equals(".:")) break;
                    var14_14 = 21;
                    break;
                }
                case 655363156: {
                    if (!var13_13.equals("defmulti")) break;
                    var14_14 = 22;
                    break;
                }
                case -1173127898: {
                    if (!var13_13.equals("defmethod")) break;
                    var14_14 = 23;
                    break;
                }
                case 3525: {
                    if (!var13_13.equals("ns")) break;
                    var14_14 = 24;
                    break;
                }
                case 1951546764: {
                    if (!var13_13.equals("ns-remove")) break;
                    var14_14 = 25;
                    break;
                }
                case -1180934629: {
                    if (!var13_13.equals("ns-unmap")) break;
                    var14_14 = 26;
                    break;
                }
                case -2116577370: {
                    if (!var13_13.equals("ns-list")) break;
                    var14_14 = 27;
                    break;
                }
                case -1184795739: {
                    if (!var13_13.equals("import")) break;
                    var14_14 = 28;
                    break;
                }
                case 1926037870: {
                    if (!var13_13.equals("imports")) break;
                    var14_14 = 29;
                    break;
                }
                case 1097368044: {
                    if (!var13_13.equals("resolve")) break;
                    var14_14 = 30;
                    break;
                }
                case 235003824: {
                    if (!var13_13.equals("var-get")) break;
                    var14_14 = 31;
                    break;
                }
                case -823702997: {
                    if (!var13_13.equals("var-ns")) break;
                    var14_14 = 32;
                    break;
                }
                case -1304611471: {
                    if (!var13_13.equals("var-name")) break;
                    var14_14 = 33;
                    break;
                }
                case 354199450: {
                    if (!var13_13.equals("var-local?")) break;
                    var14_14 = 34;
                    break;
                }
                case 227578673: {
                    if (!var13_13.equals("var-thread-local?")) break;
                    var14_14 = 35;
                    break;
                }
                case -2122054570: {
                    if (!var13_13.equals("var-global?")) break;
                    var14_14 = 36;
                    break;
                }
                case 3526655: {
                    if (!var13_13.equals("set!")) break;
                    var14_14 = 37;
                    break;
                }
                case 1957454356: {
                    if (!var13_13.equals("inspect")) break;
                    var14_14 = 38;
                    break;
                }
                case 820867430: {
                    if (!var13_13.equals("macroexpand")) break;
                    var14_14 = 39;
                    break;
                }
                case -544777552: {
                    if (!var13_13.equals("macroexpand-all*")) break;
                    var14_14 = 40;
                    break;
                }
                case 99640: {
                    if (!var13_13.equals("doc")) break;
                    var14_14 = 41;
                    break;
                }
                case 1187278228: {
                    if (!var13_13.equals("print-highlight")) break;
                    var14_14 = 42;
                    break;
                }
                case 1227433863: {
                    if (!var13_13.equals("modules")) break;
                    var14_14 = 43;
                    break;
                }
                case -108220795: {
                    if (!var13_13.equals("binding")) break;
                    var14_14 = 44;
                    break;
                }
                case -1383205247: {
                    if (!var13_13.equals("bound?")) break;
                    var14_14 = 45;
                    break;
                }
                case 115131: {
                    if (!var13_13.equals("try")) break;
                    var14_14 = 46;
                    break;
                }
                case 1908075928: {
                    if (!var13_13.equals("try-with")) break;
                    var14_14 = 47;
                    break;
                }
                case 338706135: {
                    if (!var13_13.equals("locking")) break;
                    var14_14 = 48;
                    break;
                }
                case 95772192: {
                    if (!var13_13.equals("dorun")) break;
                    var14_14 = 49;
                    break;
                }
                case 1827513477: {
                    if (!var13_13.equals("dobench")) break;
                    var14_14 = 50;
                    break;
                }
                case 3449689: {
                    if (!var13_13.equals("prof")) break;
                    var14_14 = 51;
                    break;
                }
                case -696667305: {
                    if (!var13_13.equals("tail-pos")) break;
                    var14_14 = 52;
                }
            }
            switch (var14_14) {
                case 0: {
                    expressions = args;
                    this.evaluate_sequence_values(expressions.butlast(), env);
                    orig_ast = expressions.last();
                    tailPosition = true;
                    break;
                }
                case 1: {
                    numArgs = args.size();
                    if (numArgs == 2 || numArgs == 3) {
                        cond = this.evaluate(args.first(), env, false);
                        if (!this.optimized && (debugAgent = (threadCtx = ThreadContext.get()).getDebugAgent_()) != null && debugAgent.hasBreakpointFor(VeniceInterpreter.BREAKPOINT_REF_IF)) {
                            debugAgent.onBreakSpecialForm("if", FunctionScope.FunctionEntry, VncVector.of(new VncVal[]{new VncString("cond")}), VncList.of(new VncVal[]{cond}), a0meta, env, threadCtx.getCallStack_());
                        }
                        orig_ast = VncBoolean.isFalseOrNil(cond) != false ? args.third() : args.second();
                        tailPosition = true;
                        break;
                    }
                    cf = new CallFrame("if", args, a0meta);
                    cs = new WithCallStack(cf);
                    debugAgent = null;
                    ArityExceptions.assertArity("if", ArityExceptions.FnType.SpecialForm, args, 2, 3);
                    if (cs == null) continue block197;
                    if (debugAgent == null) ** GOTO lbl259
                    try {
                        cs.close();
                    }
                    catch (Throwable var19_27) {
                        debugAgent.addSuppressed(var19_27);
                    }
                    continue block197;
lbl259:
                    // 1 sources

                    cs.close();
                    break;
                    catch (Throwable var19_28) {
                        try {
                            debugAgent = var19_28;
                            throw var19_28;
                        }
                        catch (Throwable var20_32) {
                            if (cs != null) {
                                if (debugAgent != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var21_35) {
                                        debugAgent.addSuppressed(var21_35);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw var20_32;
                        }
                    }
                }
                case 2: {
                    if (args.isEmpty()) {
                        cf = new CallFrame("let", args, a0meta);
                        cs = new WithCallStack(cf);
                        cs = null;
                        try {
                            ArityExceptions.assertMinArity("let", ArityExceptions.FnType.SpecialForm, args, 1);
                        }
                        catch (Throwable debugAgent) {
                            cs = debugAgent;
                            throw debugAgent;
                        }
                        finally {
                            if (cs != null) {
                                if (cs != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable debugAgent) {
                                        cs.addSuppressed(debugAgent);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                        }
                    }
                    env = new Env(env);
                    threadCtx = ThreadContext.get();
                    debugAgent = threadCtx.getDebugAgent_();
                    bindings = Coerce.toVncVector(args.first());
                    expressions = args.rest();
                    bindingsIter = bindings.iterator();
                    vars = new ArrayList<Var>();
                    while (bindingsIter.hasNext()) {
                        sym = bindingsIter.next();
                        symIsSymbol = sym instanceof VncSymbol;
                        if (!bindingsIter.hasNext()) {
                            cf = new CallFrame("let", args, a0meta);
                            cs = new WithCallStack(cf);
                            var25_43 /* !! */  = null;
                            try {
                                try {
                                    throw new VncException("let requires an even number of forms in the binding vector!");
                                }
                                catch (Throwable var26_46) {
                                    var25_43 /* !! */  = var26_46;
                                    throw var26_46;
                                }
                            }
                            catch (Throwable var27_50) {
                                if (cs != null) {
                                    if (var25_43 /* !! */  != null) {
                                        try {
                                            cs.close();
                                        }
                                        catch (Throwable var28_54) {
                                            var25_43 /* !! */ .addSuppressed(var28_54);
                                        }
                                    } else {
                                        cs.close();
                                    }
                                }
                                throw var27_50;
                            }
                        }
                        if (symIsSymbol && ((VncSymbol)sym).hasNamespace()) {
                            s = (VncSymbol)sym;
                            cf = new CallFrame(s.getQualifiedName(), args, s.getMeta());
                            cs = new WithCallStack(cf);
                            var26_45 = null;
                            try {
                                try {
                                    throw new VncException("Can't use qualified symbols with let!");
                                }
                                catch (Throwable var27_51) {
                                    var26_45 = var27_51;
                                    throw var27_51;
                                }
                            }
                            catch (Throwable var29_57) {
                                if (cs != null) {
                                    if (var26_45 != null) {
                                        try {
                                            cs.close();
                                        }
                                        catch (Throwable var30_59) {
                                            var26_45.addSuppressed(var30_59);
                                        }
                                    } else {
                                        cs.close();
                                    }
                                }
                                throw var29_57;
                            }
                        }
                        val = this.evaluate((VncVal)bindingsIter.next(), env, false);
                        if (symIsSymbol) {
                            env.setLocal(new Var((VncSymbol)sym, val));
                            if (debugAgent == null) continue;
                            vars.add(new Var((VncSymbol)sym, val));
                            continue;
                        }
                        varTmp = Destructuring.destructure(sym, val);
                        env.addLocalVars(varTmp);
                        if (debugAgent == null) continue;
                        vars.addAll(varTmp);
                    }
                    if (debugAgent != null && debugAgent.hasBreakpointFor(VeniceInterpreter.BREAKPOINT_REF_LET)) {
                        callStack = threadCtx.getCallStack_();
                        debugAgent.onBreakSpecialForm("let", FunctionScope.FunctionEntry, vars, a0meta, env, callStack);
                    }
                    if (expressions.size() == 1) {
                        orig_ast = expressions.first();
                    } else {
                        this.evaluate_sequence_values(expressions.butlast(), env);
                        orig_ast = expressions.last();
                    }
                    tailPosition = true;
                    break;
                }
                case 3: {
                    recursionPoint = null;
                    if (args.size() < 2) {
                        cf = new CallFrame("loop", args, a0meta);
                        cs = new WithCallStack(cf);
                        bindings = null;
                        try {
                            ArityExceptions.assertMinArity("loop", ArityExceptions.FnType.SpecialForm, args, 2);
                        }
                        catch (Throwable expressions) {
                            bindings = expressions;
                            throw expressions;
                        }
                        finally {
                            if (cs != null) {
                                if (bindings != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable expressions) {
                                        bindings.addSuppressed(expressions);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                        }
                    }
                    env = new Env(env);
                    bindings = Coerce.toVncVector(args.first());
                    expressions = args.rest();
                    if (bindings.size() % 2 != 0) {
                        cf = new CallFrame("loop", args, a0meta);
                        cs = new WithCallStack(cf);
                        bindingsIter = null;
                        try {
                            try {
                                throw new VncException("loop requires an even number of forms in the binding vector!");
                            }
                            catch (Throwable vars) {
                                bindingsIter = vars;
                                throw vars;
                            }
                        }
                        catch (Throwable var33_62) {
                            if (cs != null) {
                                if (bindingsIter != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var34_63) {
                                        bindingsIter.addSuppressed(var34_63);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw var33_62;
                        }
                    }
                    bindingNames = new ArrayList<E>(bindings.size() / 2);
                    bindingsIter = bindings.iterator();
                    while (bindingsIter.hasNext()) {
                        sym = Coerce.toVncSymbol(bindingsIter.next());
                        val = this.evaluate(bindingsIter.next(), env, false);
                        env.setLocal(new Var(sym, val));
                        bindingNames.add(sym);
                    }
                    threadCtx = ThreadContext.get();
                    debugAgent = threadCtx.getDebugAgent_();
                    recursionPoint = new RecursionPoint((List<VncSymbol>)bindingNames, expressions, env, a0meta, debugAgent);
                    if (debugAgent != null && debugAgent.hasBreakpointFor(VeniceInterpreter.BREAKPOINT_REF_LOOP)) {
                        debugAgent.onBreakLoop(FunctionScope.FunctionEntry, recursionPoint.getLoopBindingNames(), recursionPoint.getMeta(), env, threadCtx.getCallStack_());
                    }
                    if (expressions.size() == 1) {
                        orig_ast = expressions.first();
                    } else {
                        this.evaluate_sequence_values(expressions.butlast(), env);
                        orig_ast = expressions.last();
                    }
                    tailPosition = true;
                    break;
                }
                case 4: {
                    if (recursionPoint == null) {
                        cf = new CallFrame("recur", args, a0meta);
                        cs = new WithCallStack(cf);
                        bindingNames = null;
                        try {
                            try {
                                throw new NotInTailPositionException("The recur expression is not in tail position!");
                            }
                            catch (Throwable bindingsIter) {
                                bindingNames = bindingsIter;
                                throw bindingsIter;
                            }
                        }
                        catch (Throwable var35_64) {
                            if (cs != null) {
                                if (bindingNames != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var36_65) {
                                        bindingNames.addSuppressed(var36_65);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw var35_64;
                        }
                    }
                    if (args.size() != recursionPoint.getLoopBindingNamesCount()) {
                        cf = new CallFrame("recur", args, a0meta);
                        cs = new WithCallStack(cf);
                        bindingNames = null;
                        try {
                            try {
                                throw new VncException(String.format("The recur args (%d) do not match the loop args (%d) !", new Object[]{args.size(), recursionPoint.getLoopBindingNamesCount()}));
                            }
                            catch (Throwable bindingsIter) {
                                bindingNames = bindingsIter;
                                throw bindingsIter;
                            }
                        }
                        catch (Throwable var37_66) {
                            if (cs != null) {
                                if (bindingNames != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var38_67) {
                                        bindingNames.addSuppressed(var38_67);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw var37_66;
                        }
                    }
                    env = this.buildRecursionEnv(args, env, recursionPoint);
                    debugAgent = recursionPoint.getDebugAgent();
                    if (debugAgent != null && debugAgent.hasBreakpointFor(VeniceInterpreter.BREAKPOINT_REF_LOOP)) {
                        debugAgent.onBreakLoop(FunctionScope.FunctionEntry, recursionPoint.getLoopBindingNames(), recursionPoint.getMeta(), env, ThreadContext.getCallStack());
                    }
                    if ((expressions = recursionPoint.getLoopExpressions()).size() == 1) {
                        orig_ast = expressions.first();
                    } else {
                        this.evaluate_sequence_values(expressions.butlast(), env);
                        orig_ast = expressions.last();
                    }
                    tailPosition = true;
                    break;
                }
                case 5: {
                    orig_ast = this.specialFormHandler.quasiquote_(args, env, a0meta);
                    break;
                }
                case 6: {
                    return this.specialFormHandler.quote_(args, env, a0meta);
                }
                case 7: {
                    return this.fn_(args, env, a0meta);
                }
                case 8: {
                    return this.eval_(args, env, a0meta);
                }
                case 9: {
                    return this.def_(args, env, a0meta);
                }
                case 10: {
                    return this.defonce_(args, env, a0meta);
                }
                case 11: {
                    return this.def_dynamic_(args, env, a0meta);
                }
                case 12: {
                    return this.defmacro_(args, env, a0meta);
                }
                case 13: {
                    return this.defprotocol_(args, env, a0meta);
                }
                case 14: {
                    return this.extend_(args, env, a0meta);
                }
                case 15: {
                    return this.extendsQ_(args, env, a0meta);
                }
                case 16: {
                    return this.specialFormHandler.deftype_(args, env, a0meta);
                }
                case 17: {
                    return this.specialFormHandler.deftypeQ_(args, env, a0meta);
                }
                case 18: {
                    return this.specialFormHandler.deftype_of_(args, env, a0meta);
                }
                case 19: {
                    return this.specialFormHandler.deftype_or_(args, env, a0meta);
                }
                case 20: {
                    return this.specialFormHandler.deftype_describe_(args, env, a0meta);
                }
                case 21: {
                    return this.specialFormHandler.deftype_create_(args, env, a0meta);
                }
                case 22: {
                    return this.defmulti_(args, env, a0meta);
                }
                case 23: {
                    return this.defmethod_(args, env, a0meta);
                }
                case 24: {
                    return this.specialFormHandler.ns_(args, env, a0meta);
                }
                case 25: {
                    return this.specialFormHandler.ns_remove_(args, env, a0meta);
                }
                case 26: {
                    return this.specialFormHandler.ns_unmap_(args, env, a0meta);
                }
                case 27: {
                    return this.specialFormHandler.ns_list_(args, env, a0meta);
                }
                case 28: {
                    return this.specialFormHandler.import_(args, env, a0meta);
                }
                case 29: {
                    return this.specialFormHandler.imports_(args, env, a0meta);
                }
                case 30: {
                    return this.specialFormHandler.resolve_(args, env, a0meta);
                }
                case 31: {
                    return this.specialFormHandler.var_get_(args, env, a0meta);
                }
                case 32: {
                    return this.specialFormHandler.var_ns_(args, env, a0meta);
                }
                case 33: {
                    return this.specialFormHandler.var_name_(args, env, a0meta);
                }
                case 34: {
                    return this.specialFormHandler.var_localQ_(args, env, a0meta);
                }
                case 35: {
                    return this.specialFormHandler.var_thread_localQ_(args, env, a0meta);
                }
                case 36: {
                    return this.specialFormHandler.var_globalQ_(args, env, a0meta);
                }
                case 37: {
                    return this.specialFormHandler.setBANG_(args, env, a0meta);
                }
                case 38: {
                    return this.specialFormHandler.inspect_(args, env, a0meta);
                }
                case 39: {
                    return this.macroexpand(args, env, a0meta);
                }
                case 40: {
                    return this.macroexpand_all(new CallFrame("macroexpand-all*", args, a0meta), this.evaluate(args.first(), env, false), env);
                }
                case 41: {
                    return this.specialFormHandler.doc_(args, env, a0meta);
                }
                case 42: {
                    return this.specialFormHandler.print_highlight_(args, env, a0meta);
                }
                case 43: {
                    return this.specialFormHandler.modules_(args, env, a0meta);
                }
                case 44: {
                    return this.binding_(args, env, a0meta);
                }
                case 45: {
                    return this.specialFormHandler.boundQ_(args, env, a0meta);
                }
                case 46: {
                    return this.specialFormHandler.try_(args, env, a0meta);
                }
                case 47: {
                    return this.specialFormHandler.try_with_(args, env, a0meta);
                }
                case 48: {
                    return this.specialFormHandler.locking_(args, env, a0meta);
                }
                case 49: {
                    return this.specialFormHandler.dorun_(args, env, a0meta);
                }
                case 50: {
                    return this.specialFormHandler.dobench_(args, env, a0meta);
                }
                case 51: {
                    return this.specialFormHandler.prof_(args, env, a0meta);
                }
                case 52: {
                    return this.specialFormHandler.tail_pos_check(tailPosition, args, env, a0meta);
                }
                default: {
                    v0 = fn0 = a0 instanceof VncSymbol != false ? env.get((VncSymbol)a0) : this.evaluate(a0, env, false);
                    if (!(fn0 instanceof VncFunction)) ** GOTO lbl691
                    fn = (VncFunction)fn0;
                    if (fn.isMacro()) {
                        expandedAst = this.doMacroexpand(ast, env);
                        if (expandedAst instanceof VncList) {
                            orig_ast = expandedAst;
                            continue block197;
                        }
                        return this.evaluate_values(expandedAst, env);
                    }
                    fnName = fn.getQualifiedName();
                    if (this.optimized) {
                        fnArgs = (VncList)this.evaluate_sequence_values(args, env);
                        return fn.apply(fnArgs);
                    }
                    threadCtx = ThreadContext.get();
                    callStack = threadCtx.getCallStack_();
                    debugAgent = threadCtx.getDebugAgent_();
                    if (debugAgent != null && debugAgent.hasBreakpointFor(new BreakpointFnRef(fnName))) {
                        debugAgent.onBreakFnCall(fnName, fn, args, env, callStack);
                    }
                    fnArgs = (VncList)this.evaluate_sequence_values(args, env);
                    v1 = nanos = this.meterRegistry.enabled != false ? System.nanoTime() : 0L;
                    if (!this.checkSandbox) ** GOTO lbl642
                    cf = new CallFrame(fnName, fnArgs, a0meta, env);
                    cs = new WithCallStack(cf);
                    var26_45 = null;
                    try {
                        this.interceptor.validateVeniceFunction(fnName);
                    }
                    catch (Throwable var27_52) {
                        var26_45 = var27_52;
                        throw var27_52;
                    }
                    finally {
                        if (cs != null) {
                            if (var26_45 != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable var27_49) {
                                    var26_45.addSuppressed(var27_49);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                    this.interceptor.validateMaxExecutionTime();
lbl642:
                    // 2 sources

                    currThread = Thread.currentThread();
                    InterruptChecker.checkInterrupted(currThread, fn);
                    if (tailPosition && !fn.isNative() && !callStack.isEmpty() && fnName.equals(callStack.peek().getFnName())) {
                        effFn = fn.getFunctionForArgs(fnArgs);
                        env.addLocalVars(Destructuring.destructure(effFn.getParams(), fnArgs));
                        if (debugAgent != null && debugAgent.hasBreakpointFor(new BreakpointFnRef(fnName))) {
                            debugAgent.onBreakFnEnter(fnName, effFn, fnArgs, env, callStack);
                        }
                        body /* !! */  = (VncList)effFn.getBody();
                        this.evaluate_sequence_values(body /* !! */ .butlast(), env);
                        orig_ast = body /* !! */ .last();
                        break;
                    }
                    try {
                        if (fn.isNative()) {
                            callStack.push(new CallFrame(fnName, fnArgs, a0meta, env));
                            if (debugAgent != null && debugAgent.hasBreakpointFor(new BreakpointFnRef(fnName))) {
                                env.setLocal(new Var(new VncSymbol("debug::fn-args"), fnArgs));
                                try {
                                    debugAgent.onBreakFnEnter(fnName, fn, fnArgs, env, callStack);
                                    retVal = fn.apply(fnArgs);
                                    debugAgent.onBreakFnExit(fnName, fn, fnArgs, retVal, env, callStack);
                                    body /* !! */  = retVal;
                                    return body /* !! */ ;
                                }
                                catch (Exception ex) {
                                    debugAgent.onBreakFnException(fnName, fn, fnArgs, ex, env, callStack);
                                    throw ex;
                                }
                            }
                            var25_43 /* !! */  = fn.apply(fnArgs);
                            return var25_43 /* !! */ ;
                        }
                        threadCtx.setCallFrameFnData_(new CallFrameFnData(fnName, a0meta));
                        var25_43 /* !! */  = fn.apply(fnArgs);
                        return var25_43 /* !! */ ;
                    }
                    finally {
                        threadCtx.setCallFrameFnData_(null);
                        if (fn.isNative()) {
                            callStack.pop();
                        }
                        InterruptChecker.checkInterrupted(currThread, fn);
                        if (this.checkSandbox) {
                            this.interceptor.validateMaxExecutionTime();
                        }
                        if (this.meterRegistry.enabled) {
                            elapsed = System.nanoTime() - nanos;
                            if (fn instanceof VncMultiArityFunction) {
                                f = fn.getFunctionForArgs(fnArgs);
                                this.meterRegistry.record(fnName + "[" + f.getParams().size() + "]", elapsed);
                            } else {
                                this.meterRegistry.record(fnName, elapsed);
                            }
                        }
                    }
lbl691:
                    // 1 sources

                    if (fn0 instanceof IVncFunction) {
                        cf = new CallFrame(fn0.getType().toString(), args, a0meta, env);
                        cs = new WithCallStack(cf);
                        var18_19 = null;
                        try {
                            fn = (IVncFunction)fn0;
                            fnArgs = (VncList)this.evaluate_sequence_values(args, env);
                            var21_34 = fn.apply(fnArgs);
                            return var21_34;
                        }
                        catch (Throwable var19_29) {
                            var18_19 = var19_29;
                            throw var19_29;
                        }
                        finally {
                            if (cs != null) {
                                if (var18_19 != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var22_39) {
                                        var18_19.addSuppressed(var22_39);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                        }
                    }
                    cf = new CallFrame("unknown", args, a0meta);
                    cs = new WithCallStack(cf);
                    var18_19 = null;
                    try {
                        try {
                            throw new VncException(String.format("Expected a function or keyword/set/map/vector as s-expression symbol value but got a value of type '%s'!", new Object[]{Types.getType(fn0)}));
                        }
                        catch (Throwable var19_30) {
                            var18_19 = var19_30;
                            throw var19_30;
                        }
                    }
                    catch (Throwable var47_75) {
                        if (cs != null) {
                            if (var18_19 != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable var48_76) {
                                    var18_19.addSuppressed(var48_76);
                                }
                            } else {
                                cs.close();
                            }
                        }
                        throw var47_75;
                    }
                }
            }
        }
    }

    private VncVal evaluate_values(VncVal ast, Env env) {
        if (ast == Constants.Nil) {
            return Constants.Nil;
        }
        if (ast instanceof VncSymbol) {
            return env.get((VncSymbol)ast);
        }
        if (ast instanceof VncSequence) {
            return this.evaluate_sequence_values((VncSequence)ast, env);
        }
        if (ast instanceof VncMap) {
            VncMap map = (VncMap)ast;
            HashMap<VncVal, VncVal> vals = new HashMap<VncVal, VncVal>(map.size());
            for (Map.Entry<VncVal, VncVal> e : map.getJavaMap().entrySet()) {
                vals.put(this.evaluate(e.getKey(), env, false), this.evaluate(e.getValue(), env, false));
            }
            return map.withValues(vals);
        }
        if (ast instanceof VncSet) {
            VncSet set = (VncSet)ast;
            ArrayList<VncVal> vals = new ArrayList<VncVal>(set.size());
            for (VncVal v : set) {
                vals.add(this.evaluate(v, env, false));
            }
            return set.withValues(vals);
        }
        return ast;
    }

    private VncSequence evaluate_sequence_values(VncSequence seq, Env env) {
        if (seq instanceof VncLazySeq) {
            return seq;
        }
        switch (seq.size()) {
            case 0: {
                return seq;
            }
            case 1: {
                return seq.withVariadicValues(this.evaluate(seq.first(), env, false));
            }
            case 2: {
                return seq.withVariadicValues(this.evaluate(seq.first(), env, false), this.evaluate(seq.second(), env, false));
            }
            case 3: {
                return seq.withVariadicValues(this.evaluate(seq.first(), env, false), this.evaluate(seq.second(), env, false), this.evaluate(seq.third(), env, false));
            }
            case 4: {
                return seq.withVariadicValues(this.evaluate(seq.first(), env, false), this.evaluate(seq.second(), env, false), this.evaluate(seq.third(), env, false), this.evaluate(seq.fourth(), env, false));
            }
        }
        return seq.map(v -> this.evaluate((VncVal)v, env, false));
    }

    private VncVal doMacroexpand(VncVal ast, Env env) {
        VncVal fn;
        VncVal a0;
        long nanos = this.meterRegistry.enabled ? System.nanoTime() : 0L;
        VncVal ast_ = ast;
        int expandedMacros = 0;
        while (ast_ instanceof VncList && (a0 = ((VncList)ast_).first()) instanceof VncSymbol && (fn = env.getGlobalOrNull((VncSymbol)a0)) != null && fn instanceof VncFunction && ((VncFunction)fn).isMacro()) {
            VncFunction macro = (VncFunction)fn;
            VncList macroArgs = ((VncList)ast_).rest();
            if (this.checkSandbox) {
                this.interceptor.validateVeniceFunction(macro.getQualifiedName());
            }
            ++expandedMacros;
            CallFrame cf = new CallFrame(macro.getQualifiedName(), macroArgs, a0.getMeta());
            WithCallStack cs = new WithCallStack(cf);
            Throwable throwable = null;
            try {
                if (this.meterRegistry.enabled) {
                    long nanosRun = System.nanoTime();
                    ast_ = macro.apply(macroArgs);
                    this.meterRegistry.record(macro.getQualifiedName() + "[m]", System.nanoTime() - nanosRun);
                    continue;
                }
                ast_ = macro.apply(macroArgs);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cs == null) continue;
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                cs.close();
            }
        }
        if (expandedMacros > 0 && this.meterRegistry.enabled) {
            this.meterRegistry.record("macroexpand", System.nanoTime() - nanos);
        }
        return ast_;
    }

    private VncVal macroexpand(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("macroexpand", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("macroexpand", ArityExceptions.FnType.SpecialForm, args, 1);
            VncVal ast = this.evaluate(args.first(), env, false);
            VncVal vncVal = this.doMacroexpand(ast, env);
            return vncVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal macroexpand_all(CallFrame callframe, VncVal form, final Env env) {
        Throwable throwable = null;
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncVal vncVal;
            VncFunction handler = new VncFunction(VncFunction.createAnonymousFuncName("macroexpand-all-handler")){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    VncList list;
                    VncVal first;
                    VncVal form = args.first();
                    if (Types.isVncList(form) && Types.isVncSymbol(first = (list = (VncList)form).first())) {
                        VncVal second = list.second();
                        if (list.size() == 2 && "ns".equals(((VncSymbol)first).getName()) && second instanceof VncSymbol) {
                            Namespaces.setCurrentNamespace(VeniceInterpreter.this.nsRegistry.computeIfAbsent((VncSymbol)second));
                        } else {
                            return VeniceInterpreter.this.doMacroexpand(list, env);
                        }
                    }
                    return form;
                }
            };
            final VncFunction walk = new VncFunction(VncFunction.createAnonymousFuncName("macroexpand-all-walk")){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    VncFunction inner = (VncFunction)args.first();
                    VncVal form = args.second();
                    if (Types.isVncList(form)) {
                        return TransducerFunctions.map.applyOf(inner, form);
                    }
                    if (Types.isVncMapEntry(form)) {
                        return CoreFunctions.new_map_entry.applyOf(inner.applyOf(((VncMapEntry)form).getKey()), inner.applyOf(((VncMapEntry)form).getValue()));
                    }
                    if (Types.isVncCollection(form)) {
                        return CoreFunctions.into.applyOf(CoreFunctions.empty.applyOf(form), TransducerFunctions.map.applyOf(inner, form));
                    }
                    return form;
                }
            };
            VncFunction prewalk = new VncFunction(VncFunction.createAnonymousFuncName("macroexpand-all-prewalk")){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    VncFunction f = (VncFunction)args.first();
                    VncVal form = args.second();
                    return walk.applyOf(CoreFunctions.partial.applyOf(this, f), f.applyOf(form));
                }
            };
            Namespace original_ns = Namespaces.getCurrentNamespace();
            try {
                vncVal = prewalk.applyOf(handler, form);
            }
            catch (Throwable throwable2) {
                try {
                    Namespaces.setCurrentNamespace(original_ns);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            Namespaces.setCurrentNamespace(original_ns);
            return vncVal;
        }
    }

    private VncVal defmacro_(VncList args, Env env, VncVal meta) {
        CallFrame cf = new CallFrame("defmacro", args, meta);
        try (WithCallStack cs = new WithCallStack(cf);){
            ArityExceptions.assertMinArity("defmacro", ArityExceptions.FnType.SpecialForm, args, 2);
            VncFunction vncFunction = this.defmacro_(args, env);
            return vncFunction;
        }
    }

    private VncFunction defmacro_(VncList args, Env env) {
        VncSymbol macroName;
        VncVal meta;
        int argPos = 0;
        if (MetaUtil.isPrivate(meta = (macroName = Namespaces.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(args.nth(argPos++), env))).getMeta())) {
            throw new VncException(String.format("The macro '%s' must not be defined as private! Venice does not support private macros.", macroName.getName()));
        }
        VncSequence paramsOrSig = Coerce.toVncSequence(args.nth(argPos));
        String name = macroName.getName();
        String ns = macroName.getNamespace();
        if (ns == null && !Namespaces.isCoreNS(ns = Namespaces.getCurrentNS().getName())) {
            name = ns + "/" + name;
        }
        meta = MetaUtil.addMetaVal(meta, MetaUtil.NS, new VncString(ns), MetaUtil.MACRO, VncBoolean.True);
        VncSymbol macroName_ = new VncSymbol(name, meta);
        if (Types.isVncVector(paramsOrSig)) {
            VncVector params = (VncVector)paramsOrSig;
            VncList body = args.slice(++argPos);
            VncFunction macroFn = this.functionBuilder.buildFunction(macroName_.getName(), params, body, null, true, meta, env);
            env.setGlobal(new Var(macroName_, macroFn.withMeta(meta), false));
            return macroFn;
        }
        ArrayList<VncFunction> fns = new ArrayList<VncFunction>();
        VncVal meta_ = meta;
        args.slice(argPos).forEach((Consumer<? super VncVal>)((Consumer<VncVal>)s -> {
            int pos = 0;
            VncList fnSig = Coerce.toVncList(s);
            VncVector fnParams = Coerce.toVncVector(fnSig.nth(pos++));
            VncList fnBody = fnSig.slice(pos);
            fns.add(this.functionBuilder.buildFunction(macroName_.getName() + "-arity-" + fnParams.size(), fnParams, fnBody, null, true, meta_, env));
        }));
        VncMultiArityFunction macroFn = new VncMultiArityFunction(macroName_.getName(), fns, true, meta);
        env.setGlobal(new Var(macroName_, macroFn, false));
        return macroFn;
    }

    private VncVal def_(VncList args, Env env, VncVal meta) {
        CallFrame cf = new CallFrame("def", args, meta);
        try (WithCallStack cs = new WithCallStack(cf);){
            ArityExceptions.assertArity("def", ArityExceptions.FnType.SpecialForm, args, 1, 2);
            VncSymbol name = this.validateSymbolWithCurrNS(Namespaces.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(args.first(), env)), "def");
            VncVal val = args.second();
            VncVal res = this.evaluate(val, env, false);
            res = res.withMeta(MetaUtil.mergeMeta(res.getMeta(), name.getMeta()));
            env.setGlobal(new Var(name, res, true));
            VncSymbol vncSymbol = name;
            return vncSymbol;
        }
    }

    private VncVal defonce_(VncList args, Env env, VncVal meta) {
        CallFrame cf = new CallFrame("defonce", args, meta);
        try (WithCallStack cs = new WithCallStack(cf);){
            ArityExceptions.assertArity("defonce", ArityExceptions.FnType.SpecialForm, args, 1, 2);
            VncSymbol name = this.validateSymbolWithCurrNS(Namespaces.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(args.first(), env)), "defonce");
            VncVal val = args.second();
            VncVal res = this.evaluate(val, env, false).withMeta(name.getMeta());
            env.setGlobal(new Var(name, res, false));
            VncSymbol vncSymbol = name;
            return vncSymbol;
        }
    }

    private VncVal def_dynamic_(VncList args, Env env, VncVal meta) {
        CallFrame cf = new CallFrame("def-dynamic", args, meta);
        try (WithCallStack cs = new WithCallStack(cf);){
            ArityExceptions.assertArity("def-dynamic", ArityExceptions.FnType.SpecialForm, args, 1, 2);
            VncSymbol name = this.validateSymbolWithCurrNS(Namespaces.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(args.first(), env)), "def-dynamic");
            VncVal val = args.second();
            VncVal res = this.evaluate(val, env, false).withMeta(name.getMeta());
            env.setGlobalDynamic(name, res);
            VncSymbol vncSymbol = name;
            return vncSymbol;
        }
    }

    public VncVal defprotocol_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("defprotocol", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertMinArity("defprotocol", ArityExceptions.FnType.SpecialForm, args, 2);
        }
        VncSymbol protocol = Namespaces.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(args.first(), env));
        return this.specialFormHandler.defprotocol_(this, protocol, args, env, meta);
    }

    public VncVal extend_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("extend", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertMinArity("extend", ArityExceptions.FnType.SpecialForm, args, 2);
            VncSymbol protocol = Namespaces.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(args.second(), env));
            VncVal vncVal = this.specialFormHandler.extend_(args.first(), protocol, args, env);
            return vncVal;
        }
    }

    public VncVal extendsQ_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("extends?", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertMinArity("extends?", ArityExceptions.FnType.SpecialForm, args, 2);
            VncSymbol protocol = Namespaces.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(args.second(), env));
            VncVal vncVal = this.specialFormHandler.extendsQ_(args.first(), protocol, env);
            return vncVal;
        }
    }

    private VncVal defmulti_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("defmulti", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncVal dispatchFn;
            ArityExceptions.assertArity("defmulti", ArityExceptions.FnType.SpecialForm, args, 2);
            VncSymbol name = this.validateSymbolWithCurrNS(Namespaces.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(args.first(), env)), "defmulti");
            if (Types.isVncKeyword(args.second())) {
                dispatchFn = (VncKeyword)args.second();
            } else if (Types.isVncSymbol(args.second())) {
                dispatchFn = Coerce.toVncFunction(env.get((VncSymbol)args.second()));
            } else {
                VncList fnAst = Coerce.toVncList(args.second());
                dispatchFn = this.fn_(fnAst.rest(), env, meta);
            }
            VncMultiFunction multiFn = new VncMultiFunction(name.getName(), (IVncFunction)((Object)dispatchFn)).withMeta(name.getMeta());
            env.setGlobal(new Var(name, multiFn, true));
            VncMultiFunction vncMultiFunction = multiFn;
            return vncMultiFunction;
        }
    }

    private VncVal defmethod_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("defmethod", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertMinArity("defmethod", ArityExceptions.FnType.SpecialForm, args, 2);
            VncSymbol multiFnName = Namespaces.qualifySymbolWithCurrNS(Coerce.toVncSymbol(args.first()));
            VncVal multiFnVal = env.getGlobalOrNull(multiFnName);
            if (multiFnVal == null) {
                throw new VncException(String.format("No multifunction '%s' defined for the method definition", multiFnName.getName()));
            }
            VncMultiFunction multiFn = Coerce.toVncMultiFunction(multiFnVal);
            VncVal dispatchVal = args.second();
            VncVector params = Coerce.toVncVector(args.third());
            if (params.size() != multiFn.getParams().size()) {
                throw new VncException(String.format("A method definition for the multifunction '%s' must have %d parameters", multiFnName.getName(), multiFn.getParams().size()));
            }
            VncVector preConditions = this.getFnPreconditions(args.fourth());
            VncList body = args.slice(preConditions == null ? 3 : 4);
            VncFunction fn = this.functionBuilder.buildFunction(multiFnName.getName(), params, body, preConditions, false, meta, env);
            VncMultiFunction vncMultiFunction = multiFn.addFn(dispatchVal, fn.withMeta(meta));
            return vncMultiFunction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal eval_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("eval", args, meta);
        Throwable throwable = null;
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncVal vncVal;
            this.specialFormCallValidation("eval");
            ArityExceptions.assertMinArity("eval", ArityExceptions.FnType.SpecialForm, args, 0);
            Namespace ns = Namespaces.getCurrentNamespace();
            try {
                vncVal = this.evaluate(Coerce.toVncSequence(this.evaluate_sequence_values(args, env)).last(), env, false);
            }
            catch (Throwable throwable2) {
                try {
                    Namespaces.setCurrentNamespace(ns);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            Namespaces.setCurrentNamespace(ns);
            return vncVal;
        }
    }

    private VncFunction fn_(VncList args, Env env, VncVal callMeta) {
        CallFrame callframe = new CallFrame("fn", args, callMeta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncVal meta;
            VncSymbol name;
            int argPos;
            ArityExceptions.assertMinArity("fn", ArityExceptions.FnType.SpecialForm, args, 1);
            if (Types.isVncSymbol(args.first())) {
                argPos = 1;
                name = (VncSymbol)args.first();
                meta = name.getMeta();
            } else {
                argPos = 0;
                name = new VncSymbol(VncFunction.createAnonymousFuncName());
                meta = args.second().getMeta();
            }
            VncSymbol fnName = Namespaces.qualifySymbolWithCurrNS(name);
            ReservedSymbols.validateNotReservedSymbol(fnName);
            VncSequence paramsOrSig = Coerce.toVncSequence(args.nth(argPos));
            if (Types.isVncVector(paramsOrSig)) {
                VncVector preCon;
                VncVector params = (VncVector)paramsOrSig;
                if ((preCon = this.getFnPreconditions(args.nthOrDefault(++argPos, null))) != null) {
                    ++argPos;
                }
                VncList body = args.slice(argPos);
                VncFunction vncFunction = this.functionBuilder.buildFunction(fnName.getName(), params, body, preCon, false, meta, env);
                return vncFunction;
            }
            ArrayList<VncFunction> fns = new ArrayList<VncFunction>();
            args.slice(argPos).forEach((Consumer<? super VncVal>)((Consumer<VncVal>)s -> {
                int pos = 0;
                VncList sig = Coerce.toVncList(s);
                VncVector params = Coerce.toVncVector(sig.nth(pos++));
                VncVector preCon = this.getFnPreconditions(sig.nth(pos));
                if (preCon != null) {
                    ++pos;
                }
                VncList body = sig.slice(pos);
                fns.add(this.functionBuilder.buildFunction(fnName.getName(), params, body, preCon, false, meta, env));
            }));
            VncMultiArityFunction vncMultiArityFunction = new VncMultiArityFunction(fnName.getName(), fns, false, meta);
            return vncMultiArityFunction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal binding_(VncList args, Env env, VncVal meta) {
        Env bind_env = new Env(env);
        VncSequence bindings = Coerce.toVncSequence(args.first());
        VncList expressions = args.rest();
        if (bindings.size() % 2 != 0) {
            WithCallStack cs = new WithCallStack(new CallFrame("bindings", args, meta));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException("bindings requires an even number of forms in the binding vector!");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        ArrayList<Var> bindingVars = new ArrayList<Var>();
        try {
            for (int i = 0; i < bindings.size(); i += 2) {
                VncVal sym = bindings.nth(i);
                VncVal val = this.evaluate(bindings.nth(i + 1), bind_env, false);
                if (sym instanceof VncSymbol) {
                    bind_env.pushGlobalDynamic((VncSymbol)sym, val);
                    bindingVars.add(new Var((VncSymbol)sym, val));
                    continue;
                }
                List<Var> vars = Destructuring.destructure(sym, val);
                vars.forEach(v -> bind_env.pushGlobalDynamic(v.getName(), v.getVal()));
                bindingVars.addAll(vars);
            }
            ThreadContext threadCtx = ThreadContext.get();
            DebugAgent debugAgent = threadCtx.getDebugAgent_();
            if (debugAgent != null && debugAgent.hasBreakpointFor(BREAKPOINT_REF_BINDINGS)) {
                CallStack callStack = threadCtx.getCallStack_();
                debugAgent.onBreakSpecialForm("bindings", FunctionScope.FunctionEntry, bindingVars, meta, bind_env, callStack);
            }
            this.evaluate_sequence_values(expressions.butlast(), bind_env);
            VncVal vncVal = this.evaluate(expressions.last(), bind_env, false);
            return vncVal;
        }
        finally {
            bindingVars.forEach(v -> bind_env.popGlobalDynamic(v.getName()));
        }
    }

    private Env buildRecursionEnv(VncList args, Env env, RecursionPoint recursionPoint) {
        Env recur_env = recursionPoint.getLoopEnv();
        int argCount = args.size();
        switch (argCount) {
            case 0: {
                break;
            }
            case 1: {
                recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(0), this.evaluate(args.first(), env, false)));
                break;
            }
            case 2: {
                VncVal v1 = this.evaluate(args.first(), env, false);
                VncVal v2 = this.evaluate(args.second(), env, false);
                recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(0), v1));
                recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(1), v2));
                break;
            }
            default: {
                int ii;
                VncVal[] newValues = new VncVal[argCount];
                for (ii = 0; ii < argCount; ++ii) {
                    newValues[ii] = this.evaluate(args.nth(ii), env, false);
                }
                for (ii = 0; ii < argCount; ++ii) {
                    recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(ii), newValues[ii]));
                }
            }
        }
        return recur_env;
    }

    private VncVector getFnPreconditions(VncVal prePostConditions) {
        VncVal val;
        if (Types.isVncMap(prePostConditions) && Types.isVncVector(val = ((VncMap)prePostConditions).get(PRE_CONDITION_KEY))) {
            return (VncVector)val;
        }
        return null;
    }

    private VncSymbol evaluateSymbolMetaData(VncVal symVal, Env env) {
        VncSymbol sym = Coerce.toVncSymbol(symVal);
        ReservedSymbols.validateNotReservedSymbol(sym);
        return sym.withMeta(this.evaluate(sym.getMeta(), env, false));
    }

    private static <T> List<T> toEmpty(List<T> list) {
        return list == null ? new ArrayList() : list;
    }

    private VncSymbol validateSymbolWithCurrNS(VncSymbol sym, String specialFormName) {
        String ns;
        if (sym != null && (ns = sym.getNamespace()) != null && !ns.equals(Namespaces.getCurrentNS().getName())) {
            CallFrame cf = new CallFrame(specialFormName, sym.getMeta());
            WithCallStack cs = new WithCallStack(cf);
            Throwable throwable = null;
            try {
                try {
                    throw new VncException(String.format("Special form '%s': Invalid use of namespace. The symbol '%s' can only be defined for the current namespace '%s'.", specialFormName, sym.getSimpleName(), Namespaces.getCurrentNS().toString()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        return sym;
    }

    private void specialFormCallValidation(String name) {
        ThreadContext.getInterceptor().validateVeniceFunction(name);
    }
}

