/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.InterruptedException;
import com.github.jlangch.venice.Version;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.javainterop.DynamicClassLoader2;
import com.github.jlangch.venice.impl.thread.ThreadBridge;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.CallStack;
import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.javainterop.IInterceptor;
import com.github.jlangch.venice.javainterop.RejectAllInterceptor;
import com.github.jlangch.venice.javainterop.ReturnValue;
import com.github.jlangch.venice.javainterop.SandboxInterceptor;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class SystemFunctions {
    public static VncFunction version = new VncFunction("version", (VncVal)VncFunction.meta().arglists("(version)").doc("Returns the Venice version.").examples("(version)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncString(Version.VERSION);
        }
    };
    public static VncFunction uuid = new VncFunction("uuid", (VncVal)VncFunction.meta().arglists("(uuid)").doc("Generates a UUID.").examples("(uuid)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncString(UUID.randomUUID().toString());
        }
    };
    public static VncFunction objid = new VncFunction("objid", (VncVal)VncFunction.meta().arglists("(objid)").doc("Returns the original unique hash code for the given object.").examples("(objid x)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return new VncLong(System.identityHashCode(args.first()));
        }
    };
    public static VncFunction current_time_millis = new VncFunction("current-time-millis", (VncVal)VncFunction.meta().arglists("(current-time-millis)").doc("Returns the current time in milliseconds.").examples("(current-time-millis)").seeAlso("nano-time").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncLong(System.currentTimeMillis());
        }
    };
    public static VncFunction nano_time = new VncFunction("nano-time", (VncVal)VncFunction.meta().arglists("(nano-time)").doc("Returns the current value of the running Java Virtual Machine's high-resolution time source, in nanoseconds.").examples("(nano-time)", "(let [t (nano-time)                        \n      _ (sleep 100)                        \n      e (nano-time)]                       \n  (format-nano-time (- e t) :precision 2))  ").seeAlso("current-time-millis", "format-nano-time").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncLong(System.nanoTime());
        }
    };
    public static VncFunction format_milli_time = new VncFunction("format-milli-time", (VncVal)VncFunction.meta().arglists("(format-milli-time time)", "(format-milli-time time & options)").doc("Formats a time given in milliseconds as long or double. \n\nOptions: \n\n| :precision p | e.g :precision 4 (defaults to 3)|\n").examples("(format-milli-time 203)", "(format-milli-time 20389.0 :precision 2)", "(format-milli-time 20389 :precision 2)", "(format-milli-time 20389 :precision 0)").seeAlso("format-micro-time", "format-nano-time").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            long time;
            ArityExceptions.assertMinArity(this, args, 1);
            VncVal val = args.first();
            if ((Types.isVncLong(val) || Types.isVncInteger(val)) && (time = VncLong.of(val).getValue().longValue()) < 1000L) {
                return new VncString(String.format("%dms", time));
            }
            VncHashMap options = VncHashMap.ofAll(args.rest());
            int precision = Coerce.toVncLong(options.get(new VncKeyword("precision"), new VncLong(3L))).getIntValue();
            double time2 = VncDouble.of(val).getValue();
            String unit = "s";
            double scale = 1000.0;
            if (time2 < 1000.0) {
                unit = "ms";
                scale = 1.0;
            }
            return new VncString(String.format("%." + precision + "f" + unit, time2 / scale));
        }
    };
    public static VncFunction format_micro_time = new VncFunction("format-micro-time", (VncVal)VncFunction.meta().arglists("(format-micro-time time)", "(format-micro-time time & options)").doc("Formats a time given in microseconds as long or double. \n\nOptions: \n\\n| :precision p | e.g :precision 4 (defaults to 3)|").examples("(format-micro-time 203)", "(format-micro-time 20389.0 :precision 2)", "(format-micro-time 20389 :precision 2)", "(format-micro-time 20389 :precision 0)", "(format-micro-time 20386766)", "(format-micro-time 20386766 :precision 2)", "(format-micro-time 20386766 :precision 6)").seeAlso("format-milli-time", "format-nano-time").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            long time;
            ArityExceptions.assertMinArity(this, args, 1);
            VncVal val = args.first();
            if ((Types.isVncLong(val) || Types.isVncInteger(val)) && (time = VncLong.of(val).getValue().longValue()) < 1000L) {
                return new VncString(String.format("%d\u00b5s", time));
            }
            VncHashMap options = VncHashMap.ofAll(args.rest());
            int precision = Coerce.toVncLong(options.get(new VncKeyword("precision"), new VncLong(3L))).getIntValue();
            double time2 = VncDouble.of(val).getValue();
            String unit = "s";
            double scale = 1000000.0;
            if (time2 < 1000.0) {
                unit = "\u00b5s";
                scale = 1.0;
            } else if (time2 < 1000000.0) {
                unit = "ms";
                scale = 1000000.0;
            }
            return new VncString(String.format("%." + precision + "f" + unit, time2 / scale));
        }
    };
    public static VncFunction format_nano_time = new VncFunction("format-nano-time", (VncVal)VncFunction.meta().arglists("(format-nano-time time)", "(format-nano-time time & options)").doc("Formats a time given in nanoseconds as long or double. \n\nOptions: \n\n| :precision p | e.g :precision 4 (defaults to 3)|").examples("(format-nano-time 203)", "(format-nano-time 20389.0 :precision 2)", "(format-nano-time 20389 :precision 2)", "(format-nano-time 20389 :precision 0)", "(format-nano-time 203867669)", "(format-nano-time 20386766988 :precision 2)", "(format-nano-time 20386766988 :precision 6)").seeAlso("format-milli-time", "format-micro-time", "nano-time").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            long time;
            ArityExceptions.assertMinArity(this, args, 1);
            VncVal val = args.first();
            if ((Types.isVncLong(val) || Types.isVncInteger(val)) && (time = VncLong.of(val).getValue().longValue()) < 1000L) {
                return new VncString(String.format("%dns", time));
            }
            VncHashMap options = VncHashMap.ofAll(args.rest());
            int precision = Coerce.toVncLong(options.get(new VncKeyword("precision"), new VncLong(3L))).getIntValue();
            double time2 = VncDouble.of(val).getValue();
            String unit = "s";
            double scale = 1.0E9;
            if (time2 < 1000.0) {
                unit = "ns";
                scale = 1.0;
            } else if (time2 < 1000000.0) {
                unit = "\u00b5s";
                scale = 1000.0;
            } else if (time2 < 1.0E9) {
                unit = "ms";
                scale = 1000000.0;
            }
            return new VncString(String.format("%." + precision + "f" + unit, time2 / scale));
        }
    };
    public static VncFunction sleep = new VncFunction("sleep", (VncVal)VncFunction.meta().arglists("(sleep n)", "(sleep n time-unit)").doc("Sleep for the time n. The default time unit is milliseconds.\u00b6Time unit is one of :milliseconds, :seconds, :minutes, :hours, or :days. ").examples("(sleep 30)", "(sleep 30 :milliseconds)", "(sleep 5 :seconds)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            try {
                long sleep = Coerce.toVncLong(args.first()).getValue();
                TimeUnit unit = args.size() == 1 ? TimeUnit.MILLISECONDS : SystemFunctions.toTimeUnit(Coerce.toVncKeyword(args.second()));
                Thread.sleep(unit.toMillis(Math.max(0L, sleep)));
            }
            catch (java.lang.InterruptedException ex) {
                throw new InterruptedException("interrupted while calling (sleep n)", ex);
            }
            return Constants.Nil;
        }
    };
    public static VncFunction pid = new VncFunction("pid", (VncVal)VncFunction.meta().arglists("(pid)").doc("Returns the PID of this process.").examples("(pid)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            if (SystemFunctions.javaMajorVersion() <= 8L) {
                return new VncString(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
            }
            ReturnValue procHandle = ReflectionAccessor.invokeStaticMethod(ReflectionAccessor.classForName("java.lang.ProcessHandle"), "current", new Object[0]);
            ReturnValue ret = ReflectionAccessor.invokeInstanceMethod(procHandle.getValue(), procHandle.getFormalType(), "pid", new Object[0]);
            return new VncLong((Long)ret.getValue());
        }
    };
    public static VncFunction host_name = new VncFunction("host-name", (VncVal)VncFunction.meta().arglists("(host-name)").doc("Returns this host's name.").examples("(host-name)").seeAlso("host-address").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            try {
                return new VncString(InetAddress.getLocalHost().getHostName());
            }
            catch (Exception ex) {
                throw new VncException("(host-name) failed", ex);
            }
        }
    };
    public static VncFunction host_address = new VncFunction("host-address", (VncVal)VncFunction.meta().arglists("(host-address)").doc("Returns this host's ip address.").examples("(host-address)").seeAlso("host-name").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            try {
                return new VncString(InetAddress.getLocalHost().getHostAddress());
            }
            catch (Exception ex) {
                throw new VncException("(host-address) failed", ex);
            }
        }
    };
    public static VncFunction user_name = new VncFunction("user-name", (VncVal)VncFunction.meta().arglists("(user-name)").doc("Returns the logged-in's user name.").examples("(user-name)").seeAlso("io/user-home-dir").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            try {
                return new VncString(System.getProperty("user.name"));
            }
            catch (Exception ex) {
                throw new VncException("(user-name) failed", ex);
            }
        }
    };
    public static VncFunction ip_private_Q = new VncFunction("ip-private?", (VncVal)VncFunction.meta().arglists("(ip-private? addr)").doc("Returns true if the IP address is private. \n\nIPv4 addresses reserved for private networks:\n\n * 192.168.0.0 - 192.168.255.255\n * 172.16.0.0 - 172.31.255.255\n * 10.0.0.0 - 10.255.255.255\n").examples("(ip-private? \"192.168.170.181\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            try {
                return VncBoolean.of(InetAddress.getByName(Coerce.toVncString(args.first()).getValue()).isSiteLocalAddress());
            }
            catch (Exception ex) {
                throw new VncException("function ip-private? failed", ex);
            }
        }
    };
    public static VncFunction gc = new VncFunction("gc", (VncVal)VncFunction.meta().arglists("(gc)").doc("Run the Java garbage collector. Runs the finalization methods of any objects pending finalization prior to the GC.").examples("(gc)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            this.sandboxFunctionCallValidation();
            Runtime.getRuntime().runFinalization();
            Runtime.getRuntime().gc();
            return Constants.Nil;
        }
    };
    public static VncFunction cpus = new VncFunction("cpus", (VncVal)VncFunction.meta().arglists("(cpus)").doc("Returns the number of available processors or number of hyperthreads if the CPU supports hyperthreads.").examples("(cpus)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncLong(Runtime.getRuntime().availableProcessors());
        }
    };
    public static VncFunction shutdown_hook = new VncFunction("shutdown-hook", (VncVal)VncFunction.meta().arglists("(shutdown-hook f)").doc("Registers the function f as JVM shutdown hook.").examples("(shutdown-hook (fn [] (println \"shutdown\")))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            VncFunction fn = Coerce.toVncFunction(args.first());
            ThreadBridge threadBridge = ThreadBridge.create("shutdown-hook", new CallFrame[]{new CallFrame(this, args), new CallFrame(fn)}, new ThreadBridge.Options[0]);
            Runnable taskWrapper = threadBridge.bridgeRunnable(() -> fn.applyOf(new VncVal[0]));
            Thread hook = new Thread(taskWrapper);
            hook.setUncaughtExceptionHandler(ThreadBridge::handleUncaughtException);
            Runtime.getRuntime().addShutdownHook(hook);
            return Constants.Nil;
        }
    };
    public static VncFunction callstack = new VncFunction("callstack", (VncVal)VncFunction.meta().arglists("(callstack)").doc("Returns the current callstack.").examples("(do                             \n   (defn f1 [x] (f2 x))         \n   (defn f2 [x] (f3 x))         \n   (defn f3 [x] (f4 x))         \n   (defn f4 [x] (callstack))    \n   (f1 100))                      ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            CallStack stack = ThreadContext.getCallStack();
            return VncVector.ofList(stack.callstack().stream().map(f -> VncOrderedMap.of(CALLSTACK_KEY_FN_NAME, f.getFnName() == null ? Constants.Nil : new VncString(f.getFnName()), CALLSTACK_KEY_FILE, new VncString(f.getFile()), CALLSTACK_KEY_LINE, new VncLong(f.getLine()), CALLSTACK_KEY_COL, new VncLong(f.getCol()))).collect(Collectors.toList()));
        }
    };
    public static VncFunction charset_default_encoding = new VncFunction("charset-default-encoding", (VncVal)VncFunction.meta().arglists("(charset-default-encoding)").doc("Returns the default charset of this Java virtual machine.").examples("(charset-default-encoding)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncKeyword(Charset.defaultCharset().name());
        }
    };
    public static VncFunction os_type = new VncFunction("os-type", (VncVal)VncFunction.meta().arglists("(os-type)").doc("Returns the OS type").examples("(os-type)").seeAlso("os-type?", "os-arch", "os-name", "os-version").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncKeyword(SystemFunctions.osType());
        }
    };
    public static VncFunction os_type_Q = new VncFunction("os-type?", (VncVal)VncFunction.meta().arglists("(os-type? type)").doc("Returns true if the OS id of the type otherwise false. Type is one of :windows, :mac-osx, or :linux").examples("(os-type? :mac-osx)", "(os-type? :windows)").seeAlso("os-type", "os-arch", "os-name", "os-version").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            String type = Coerce.toVncKeyword(args.first()).getValue();
            String osName = System.getProperty("os.name");
            switch (type) {
                case "windows": {
                    return VncBoolean.of(osName.startsWith("Windows"));
                }
                case "mac-osx": {
                    return VncBoolean.of(osName.startsWith("Mac OS X"));
                }
                case "linux": {
                    return VncBoolean.of(osName.startsWith("Linux"));
                }
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction os_arch = new VncFunction("os-arch", (VncVal)VncFunction.meta().arglists("(os-arch)").doc("Returns the OS architecture").examples("(os-arch)").seeAlso("os-type", "os-type?", "os-name", "os-version").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncString(System.getProperty("os.arch"));
        }
    };
    public static VncFunction os_name = new VncFunction("os-name", (VncVal)VncFunction.meta().arglists("(os-name)").doc("Returns the OS name").examples("(os-name)").seeAlso("os-type", "os-type?", "os-arch", "os-version").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncString(System.getProperty("os.name"));
        }
    };
    public static VncFunction os_version = new VncFunction("os-version", (VncVal)VncFunction.meta().arglists("(os-version)").doc("Returns the OS version").examples("(os-version)").seeAlso("os-type", "os-type?", "os-arch", "os-name").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncString(System.getProperty("os.version"));
        }
    };
    public static VncFunction sandboxed_Q = new VncFunction("sandboxed?", (VncVal)VncFunction.meta().arglists("(sandboxed?)").doc("Returns true if there is a sandbox other than `:AcceptAllInterceptor` otherwise false.").examples("(sandboxed?)").seeAlso("sandbox-type").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return VncBoolean.of(ThreadContext.isSandboxed());
        }
    };
    public static VncFunction sandbox_type = new VncFunction("sandbox-type", (VncVal)VncFunction.meta().arglists("(sandbox-type)").doc("Returns the sandbox type. \n\nVenice sandbox types:\n\n * `:" + AcceptAllInterceptor.class.getSimpleName() + "` - accepts all (no restrictions)\n * `:" + RejectAllInterceptor.class.getSimpleName() + "` - safe sandbox, rejects access to all I/O functions, system properties, environment vars, extension modules, dynamic code loading, multi-threaded functions (futures, agents, ...), and Java calls\n * `:" + SandboxInterceptor.class.getSimpleName() + "` - customized sandbox").examples("(sandbox-type)").seeAlso("sandboxed?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            IInterceptor interceptor = ThreadContext.getInterceptor();
            return interceptor == null ? Constants.Nil : new VncKeyword(interceptor.getClass().getSimpleName());
        }
    };
    public static VncFunction system_prop = new VncFunction("system-prop", (VncVal)VncFunction.meta().arglists("(system-prop)", "(system-prop name)", "(system-prop name default-val)").doc("Returns the system property with the given name. Returns the default-val if the property does not exist or it's value is nil.\n\nWithout arguments returns all system properties authorized by the configured sandbox.").examples("(system-prop :os.name)", "(system-prop :foo.org \"abc\")", "(system-prop \"os.name\")").seeAlso("system-env").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0, 1, 2);
            if (args.isEmpty()) {
                Set<String> names = System.getProperties().stringPropertyNames();
                HashMap<VncString, VncString> env = new HashMap<VncString, VncString>();
                for (String name : names) {
                    try {
                        String val = ThreadContext.getInterceptor().onReadSystemProperty(name);
                        env.put(new VncString(name), new VncString(val));
                    }
                    catch (Exception ex) {}
                }
                return new VncHashMap(env);
            }
            VncString key = Coerce.toVncString(CoreFunctions.name.apply(VncList.of(args.first())));
            VncVal defaultVal = args.size() == 2 ? args.second() : Constants.Nil;
            String val = ThreadContext.getInterceptor().onReadSystemProperty(key.getValue());
            return val == null ? defaultVal : new VncString(val);
        }
    };
    public static VncFunction system_env = new VncFunction("system-env", (VncVal)VncFunction.meta().arglists("(system-env)", "(system-env name)", "(system-env name default-val)").doc("Returns the system env variable with the given name. Returns the default-val if the variable does not exist or it's value is nil.\n\nWithout arguments returns all system env variables authorized by the configured sandbox.").examples("(system-env :SHELL)", "(system-env :FOO \"test\")", "(system-env \"SHELL\")").seeAlso("system-prop").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0, 1, 2);
            if (args.isEmpty()) {
                Set<String> names = System.getenv().keySet();
                HashMap<VncString, VncString> env = new HashMap<VncString, VncString>();
                for (String name : names) {
                    try {
                        String val = ThreadContext.getInterceptor().onReadSystemEnv(name);
                        env.put(new VncString(name), new VncString(val));
                    }
                    catch (Exception ex) {}
                }
                return new VncHashMap(env);
            }
            VncString key = Coerce.toVncString(CoreFunctions.name.apply(VncList.of(args.first())));
            VncVal defaultVal = args.size() == 2 ? args.second() : Constants.Nil;
            String val = ThreadContext.getInterceptor().onReadSystemEnv(key.getValue());
            return val == null ? defaultVal : new VncString(val);
        }
    };
    public static VncFunction system_exit_code = new VncFunction("system-exit-code", (VncVal)VncFunction.meta().arglists("(system-exit-code code)").doc("Defines the exit code that is used if the Java VM exits. Defaults to 0. \n\nNote:\u00b6The exit code is only used when the Venice launcher has been used to run a script file, a command line script, a Venice app archive, or the REPL.").examples("(system-exit-code 0)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncLong code = Coerce.toVncLong(args.first());
            SYSTEM_EXIT_CODE.set(code.getIntValue());
            return Constants.Nil;
        }
    };
    public static VncFunction java_version = new VncFunction("java-version", (VncVal)VncFunction.meta().arglists("(java-version)").doc("Returns the Java VM version (1.8.0_252, 11.0.7, ...)").examples("(java-version)").seeAlso("java-major-version", "java-version-info").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            String version = System.getProperty("java.version");
            return new VncString(version);
        }
    };
    public static VncFunction java_major_version = new VncFunction("java-major-version", (VncVal)VncFunction.meta().arglists("(java-major-version)").doc("Returns the Java major version (8, 9, 11, ...).").examples("(java-major-version)").seeAlso("java-version", "java-version-info").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncLong(SystemFunctions.javaMajorVersion());
        }
    };
    public static VncFunction java_version_info = new VncFunction("java-version-info", (VncVal)VncFunction.meta().arglists("(java-version-info)").doc("Returns the Java VM version info.").examples("(java-version-info)").seeAlso("java-version", "java-major-version").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return VncOrderedMap.of(new VncKeyword("version"), new VncString(System.getProperty("java.version")), new VncKeyword("vendor"), new VncString(System.getProperty("java.vendor")), new VncKeyword("vm-version"), new VncString(System.getProperty("java.vm.version")), new VncKeyword("vm-name"), new VncString(System.getProperty("java.vm.name")), new VncKeyword("vm-vendor"), new VncString(System.getProperty("java.vm.vendor")));
        }
    };
    public static VncFunction java_source_location = new VncFunction("java-source-location", (VncVal)VncFunction.meta().arglists("(java-source-location class)").doc("Returns the path of the source location of a class (fully qualified class name).").examples("(java-source-location :com.github.jlangch.venice.Venice)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            try {
                String className = Coerce.toVncString(CoreFunctions.name.apply(VncList.of(args.first()))).getValue();
                Class<?> clazz = Class.forName(className);
                URI uri = clazz.getProtectionDomain().getCodeSource().getLocation().toURI();
                return new VncString(new File(uri).getPath());
            }
            catch (Exception ex) {
                return Constants.Nil;
            }
        }
    };
    public static VncFunction total_memory = new VncFunction("total-memory", (VncVal)VncFunction.meta().arglists("(total-memory)").doc("Returns the total amount of memory available to the Java VM.").examples("(total-memory)").seeAlso("used-memory").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            System.gc();
            Runtime rt = Runtime.getRuntime();
            double totalMB = (double)rt.totalMemory() / 1024.0 / 1024.0;
            return new VncString(String.format("%.1fMB", totalMB));
        }
    };
    public static VncFunction used_memory = new VncFunction("used-memory", (VncVal)VncFunction.meta().arglists("(used-memory)").doc("Returns the currently used memory by the Java VM.").examples("(used-memory)").seeAlso("total-memory").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            System.gc();
            Runtime rt = Runtime.getRuntime();
            double usedMB = (double)(rt.totalMemory() - rt.freeMemory()) / 1024.0 / 1024.0;
            return new VncString(String.format("%.1fMB", usedMB));
        }
    };
    public static VncFunction load_jar = new VncFunction("load-jar", (VncVal)VncFunction.meta().arglists("(load-jar url)").doc("Dynamically load a JAR into the classpath. \n\nDynamically loading JARs is experimental and for security reasons available in the REPL only!").examples("(do                                                              \n  (load-module :maven)                                           \n  (let [uri (maven/uri \"org.knowm.xchart:xchart:3.6.5\" :jar)]  \n    (load-jar uri)))                                               ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncString url = Coerce.toVncString(args.first());
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null && cl instanceof DynamicClassLoader2) {
                try {
                    ((DynamicClassLoader2)cl).addURL(new URL(url.getValue()));
                    return Constants.Nil;
                }
                catch (MalformedURLException ex) {
                    throw new VncException(String.format("Malformed URL '%s'", url.getValue()), ex);
                }
            }
            throw new VncException("There is no thread context ClassLoader available to dynamically load a JAR. For security reasons dynamically loading JARs is only available in the REPL!");
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().add(uuid).add(objid).add(current_time_millis).add(nano_time).add(format_nano_time).add(format_micro_time).add(format_milli_time).add(pid).add(host_name).add(host_address).add(user_name).add(ip_private_Q).add(gc).add(cpus).add(shutdown_hook).add(sandboxed_Q).add(sandbox_type).add(sleep).add(callstack).add(os_type).add(os_type_Q).add(os_arch).add(os_name).add(os_version).add(version).add(system_prop).add(system_env).add(system_exit_code).add(java_version).add(java_version_info).add(java_source_location).add(java_major_version).add(total_memory).add(used_memory).add(charset_default_encoding).add(load_jar).toMap();
    public static final VncKeyword CALLSTACK_KEY_FN_NAME = new VncKeyword(":fn-name");
    public static final VncKeyword CALLSTACK_KEY_FILE = new VncKeyword(":file");
    public static final VncKeyword CALLSTACK_KEY_LINE = new VncKeyword(":line");
    public static final VncKeyword CALLSTACK_KEY_COL = new VncKeyword(":col");
    public static final AtomicInteger SYSTEM_EXIT_CODE = new AtomicInteger(0);

    private static TimeUnit toTimeUnit(VncKeyword unit) {
        switch (unit.getValue()) {
            case "milliseconds": {
                return TimeUnit.MILLISECONDS;
            }
            case "seconds": {
                return TimeUnit.SECONDS;
            }
            case "minutes": {
                return TimeUnit.MINUTES;
            }
            case "hours": {
                return TimeUnit.HOURS;
            }
            case "days": {
                return TimeUnit.DAYS;
            }
        }
        throw new VncException("Invalid scheduler time-unit " + unit.getValue() + ". Use one of {:milliseconds, :seconds, :minutes, :hours, :days}");
    }

    public static long javaMajorVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2);
        }
        return Long.parseLong(version.substring(0, version.indexOf(".")));
    }

    public static String osType() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            return "windows";
        }
        if (osName.startsWith("Mac OS X")) {
            return "mac-osx";
        }
        if (osName.startsWith("Linux")) {
            return "linux";
        }
        return "unknown";
    }
}

