/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.MetaUtil;
import com.github.jlangch.venice.impl.util.dag.DAG;
import com.github.jlangch.venice.impl.util.dag.DagCycleException;
import com.github.jlangch.venice.impl.util.dag.Edge;
import com.github.jlangch.venice.impl.util.dag.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class VncDAG
extends VncCollection {
    public static final String TYPE = ":dag/dag";
    private static final long serialVersionUID = -1848883965231344442L;
    private final DAG<VncVal> dag;

    public VncDAG(VncVal meta) {
        super(meta);
        this.dag = new DAG();
    }

    private VncDAG(DAG<VncVal> dag, VncVal meta) {
        super(meta);
        this.dag = dag;
    }

    @Override
    public VncDAG withMeta(VncVal meta) {
        return new VncDAG(this.dag, meta);
    }

    @Override
    public VncKeyword getType() {
        return new VncKeyword(TYPE, MetaUtil.typeMeta(new VncKeyword(":core/val")));
    }

    @Override
    public VncDAG emptyWithMeta() {
        return new VncDAG(this.getMeta());
    }

    public VncDAG addNode(VncVal node) {
        try {
            return new VncDAG(this.dag.addNode(node), this.getMeta());
        }
        catch (DagCycleException ex) {
            throw new VncException("The edge is a cycle", ex);
        }
    }

    public VncDAG addEdge(VncVal parent, VncVal child) {
        try {
            return new VncDAG(this.dag.addEdge(parent, child), this.getMeta());
        }
        catch (DagCycleException ex) {
            throw new VncException("The edge is a cycle", ex);
        }
    }

    public VncDAG addNodes(VncSequence nodes) {
        try {
            ArrayList list = new ArrayList();
            nodes.forEach((Consumer<? super VncVal>)((Consumer<VncVal>)n -> list.add(n)));
            return new VncDAG(this.dag.addNodes(list), this.getMeta());
        }
        catch (DagCycleException ex) {
            throw new VncException("The edge is a cycle", ex);
        }
    }

    public VncDAG addEdges(VncSequence edges) {
        try {
            ArrayList list = new ArrayList();
            edges.forEach((Consumer<? super VncVal>)((Consumer<VncVal>)e -> {
                VncSequence nodes;
                if (Types.isVncSequence(e)) {
                    nodes = (VncSequence)e;
                    if (nodes.size() != 2) {
                        throw new VncException(String.format("Invalid DAG (directed acyclic graph) edge sequence with %d elements! Two sequence elements are required to define an edge, e.g.: [\"A\" \"B\"].", nodes.size()));
                    }
                } else {
                    throw new VncException(String.format("%s is not allowed to pass a DAG (directed acyclic graph) edge! A sequence with two values (e.g.: [\"A\" \"B\"]) is required.", Types.getType(e)));
                }
                list.add(new Edge<VncVal>(nodes.first(), nodes.second()));
            }));
            return new VncDAG(this.dag.addEdges(list), this.getMeta());
        }
        catch (DagCycleException ex) {
            throw new VncException("The edge is a cycle", ex);
        }
    }

    public VncList nodes() {
        return VncList.ofColl(this.dag.getNodes().stream().map(n -> (VncVal)n.getValue()).collect(Collectors.toList()));
    }

    public VncList edges() {
        return VncList.ofColl(this.dag.getEdges().stream().map(e -> VncVector.of((VncVal)((Node)e.getParent()).getValue(), (VncVal)((Node)e.getChild()).getValue())).collect(Collectors.toList()));
    }

    public VncList children(VncVal val) {
        try {
            return VncList.ofColl(this.dag.children(val));
        }
        catch (NoSuchElementException ex) {
            throw new VncException("Node not found: " + val.toString(true));
        }
    }

    public VncList directChildren(VncVal val) {
        try {
            return VncList.ofColl(this.dag.directChildren(val));
        }
        catch (NoSuchElementException ex) {
            throw new VncException("Node not found: " + val.toString(true));
        }
    }

    public VncList parents(VncVal val) {
        try {
            return VncList.ofColl(this.dag.parents(val));
        }
        catch (NoSuchElementException ex) {
            throw new VncException("Node not found: " + val.toString(true));
        }
    }

    public VncList directParents(VncVal val) {
        try {
            return VncList.ofColl(this.dag.directParents(val));
        }
        catch (NoSuchElementException ex) {
            throw new VncException("Node not found: " + val.toString(true));
        }
    }

    public VncList roots() {
        return VncList.ofColl(this.dag.roots());
    }

    public VncVector topologicalSort() {
        try {
            return VncVector.ofColl(this.dag.topologicalSort());
        }
        catch (DagCycleException ex) {
            throw new VncException("The graph has cycles!", ex);
        }
    }

    public VncFunction compareFn() {
        final Comparator<VncVal> c = this.dag.comparator();
        return new VncFunction(VncFunction.createAnonymousFuncName("toposort-compare")){
            private static final long serialVersionUID = 1L;

            @Override
            public VncVal apply(VncList args) {
                return new VncLong(c.compare(args.first(), args.second()));
            }
        };
    }

    public VncBoolean isParentOf(VncVal parent, VncVal value) {
        try {
            return VncBoolean.of(this.dag.isParentOf(parent, value));
        }
        catch (NoSuchElementException ex) {
            throw new VncException("Node not found!");
        }
    }

    public VncBoolean isChildOf(VncVal child, VncVal value) {
        try {
            return VncBoolean.of(this.dag.isChildOf(child, value));
        }
        catch (NoSuchElementException ex) {
            throw new VncException("Node not found!");
        }
    }

    public VncBoolean isNode(VncVal value) {
        return VncBoolean.of(this.dag.isNode(value));
    }

    @Override
    public VncList toVncList() {
        return VncList.ofColl(this.dag.getValues());
    }

    @Override
    public VncVector toVncVector() {
        return VncVector.ofColl(this.dag.getValues());
    }

    @Override
    public int size() {
        return this.dag.size();
    }

    @Override
    public boolean isEmpty() {
        return this.dag.isEmpty();
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.DAG;
    }

    @Override
    public Object convertToJavaObject() {
        return this.dag.getEdges().stream().map(e -> Arrays.asList(((VncVal)((Node)e.getParent()).getValue()).convertToJavaObject(), ((VncVal)((Node)e.getChild()).getValue()).convertToJavaObject())).collect(Collectors.toList());
    }

    @Override
    public int compareTo(VncVal o) {
        return this.dag == ((VncDAG)o).dag ? 0 : -1;
    }

    @Override
    public int hashCode() {
        return this.dag.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncDAG other = (VncDAG)obj;
        return this.dag.equals(other.dag);
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean print_machine_readably) {
        VncList elements = this.getIsolatedNodes().addAllAtEnd(this.edges());
        return "(" + Printer.join(elements, " ", print_machine_readably) + ")";
    }

    private VncList getIsolatedNodes() {
        return VncList.ofColl(this.dag.getIsolatedNodes().stream().map(n -> (VncVal)n.getValue()).collect(Collectors.toList()));
    }
}

