/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

public class HexUtil {
    public static String toString(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < data.length; ++ii) {
            String s = Integer.toHexString(0xFF & data[ii]);
            if (s.length() == 1) {
                sb.append('0');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String toStringUpperCase(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < data.length; ++ii) {
            String s = Integer.toHexString(0xFF & data[ii]);
            if (s.length() == 1) {
                sb.append('0');
            }
            sb.append(s);
        }
        return sb.toString().toUpperCase();
    }

    public static byte[] toBytes(String hex) {
        if (hex == null) {
            throw new IllegalArgumentException("A hex string must not be null");
        }
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("A hex string must have an even number of characters");
        }
        byte[] data = new byte[hex.length() / 2];
        for (int ii = 0; ii < hex.length() / 2; ++ii) {
            String h = hex.substring(ii * 2, ii * 2 + 2);
            data[ii] = (byte)Integer.parseInt(h, 16);
        }
        return data;
    }
}

