/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncMultiArityFunction;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.types.util.Types;
import java.util.ArrayList;
import java.util.function.Consumer;

public class Inspector {
    public static VncVal inspect(VncVal val) {
        if (val == Constants.Nil) {
            return VncOrderedMap.of(new VncKeyword("type"), Types.getType(val), new VncKeyword("meta"), val.getMeta());
        }
        if (Types.isVncMultiArityFunction(val)) {
            ArrayList arityFunctions = new ArrayList();
            ((VncMultiArityFunction)val).getFunctions().forEach((Consumer<? super VncVal>)((Consumer<VncVal>)f -> arityFunctions.add(VncOrderedMap.of(new VncKeyword("arity"), new VncLong(((VncFunction)f).getFixedArgsCount()), new VncKeyword("variadic?"), VncBoolean.of(((VncFunction)f).hasVariadicArgs()), new VncKeyword("fn"), Inspector.inspect((VncFunction)f)))));
            return VncOrderedMap.of(new VncKeyword("name"), new VncString(((VncFunction)val).getQualifiedName()), new VncKeyword("type"), Types.getType(val), new VncKeyword("meta"), Inspector.toNil(val.getMeta()), new VncKeyword("arity-fn"), VncList.ofList(arityFunctions), new VncKeyword("private?"), VncBoolean.of(((VncFunction)val).isPrivate()));
        }
        if (Types.isVncMultiFunction(val)) {
            return VncOrderedMap.of(new VncKeyword("name"), new VncString(((VncFunction)val).getQualifiedName()), new VncKeyword("type"), Types.getType(val), new VncKeyword("meta"), Inspector.toNil(val.getMeta()), new VncKeyword("body"), Inspector.toNil(((VncFunction)val).getBody()), new VncKeyword("params"), Inspector.toNil(((VncFunction)val).getParams()), new VncKeyword("private?"), VncBoolean.of(((VncFunction)val).isPrivate()));
        }
        if (Types.isVncMacro(val)) {
            return VncOrderedMap.of(new VncKeyword("name"), new VncString(((VncFunction)val).getQualifiedName()), new VncKeyword("type"), Types.getType(val), new VncKeyword("meta"), Inspector.toNil(val.getMeta()), new VncKeyword("body"), Inspector.toNil(((VncFunction)val).getBody()), new VncKeyword("params"), Inspector.toNil(((VncFunction)val).getParams()), new VncKeyword("private?"), VncBoolean.of(((VncFunction)val).isPrivate()));
        }
        if (Types.isVncFunction(val)) {
            return VncOrderedMap.of(new VncKeyword("name"), new VncString(((VncFunction)val).getQualifiedName()), new VncKeyword("type"), Types.getType(val), new VncKeyword("meta"), Inspector.toNil(val.getMeta()), new VncKeyword("body"), Inspector.toNil(((VncFunction)val).getBody()), new VncKeyword("params"), Inspector.toNil(((VncFunction)val).getParams()), new VncKeyword("native?"), VncBoolean.of(((VncFunction)val).isNative()), new VncKeyword("private?"), VncBoolean.of(((VncFunction)val).isPrivate()), new VncKeyword("variadic?"), VncBoolean.of(((VncFunction)val).hasVariadicArgs()), new VncKeyword("anonymous?"), VncBoolean.of(((VncFunction)val).isAnonymous()));
        }
        return VncOrderedMap.of(new VncKeyword("type"), Types.getType(val), new VncKeyword("meta"), val.getMeta());
    }

    private static VncVal toNil(VncVal val) {
        return val == null ? Constants.Nil : val;
    }
}

