/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.concurrent;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.thread.ThreadPoolUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public abstract class ManagedExecutor {
    private final String threadPoolName;
    private ExecutorService executor;

    public ManagedExecutor(String threadPoolName) {
        this.threadPoolName = threadPoolName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService getExecutor() {
        ManagedExecutor managedExecutor = this;
        synchronized (managedExecutor) {
            if (this.executor == null) {
                this.executor = this.createExecutorService();
            }
            return this.executor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        ManagedExecutor managedExecutor = this;
        synchronized (managedExecutor) {
            return this.executor != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShutdown() {
        ManagedExecutor managedExecutor = this;
        synchronized (managedExecutor) {
            return this.executor == null ? true : this.executor.isShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitTermination(long timeoutMillis) {
        ManagedExecutor managedExecutor = this;
        synchronized (managedExecutor) {
            if (this.executor != null) {
                try {
                    this.executor.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS);
                }
                catch (Exception ex) {
                    throw new VncException("Failed awaiting for executor termination", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminated() {
        ManagedExecutor managedExecutor = this;
        synchronized (managedExecutor) {
            return this.executor == null ? true : this.executor.isTerminated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ManagedExecutor managedExecutor = this;
        synchronized (managedExecutor) {
            if (this.executor != null) {
                try {
                    this.executor.shutdown();
                }
                catch (Exception exception) {
                }
                finally {
                    this.executor = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow() {
        ManagedExecutor managedExecutor = this;
        synchronized (managedExecutor) {
            if (this.executor != null) {
                try {
                    this.executor.shutdownNow();
                }
                catch (Exception exception) {
                }
                finally {
                    this.executor = null;
                }
            }
        }
    }

    protected abstract ExecutorService createExecutorService();

    protected ThreadFactory createThreadFactory() {
        return ThreadPoolUtil.createCountedThreadFactory(this.threadPoolName, true);
    }
}

