/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.io.zip;

import com.github.jlangch.venice.impl.util.io.IOStreamUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZipper {
    public static final short GZIP_HEADER = 8075;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] gzip(byte[] binary) {
        if (binary == null) {
            throw new IllegalArgumentException("A 'binary' must not be null");
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (GZIPOutputStream gzos = new GZIPOutputStream(baos);){
                gzos.write(binary, 0, binary.length);
                gzos.flush();
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] gzip(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A 'file' must not be null");
        }
        try (FileInputStream is = new FileInputStream(file);){
            byte[] byArray = GZipper.gzip(is);
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] gzip(InputStream is) {
        if (is == null) {
            throw new IllegalArgumentException("An 'is' must not be null");
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (GZIPOutputStream gzos = new GZIPOutputStream(baos);){
                IOStreamUtil.copy(is, gzos);
                gzos.flush();
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static void gzip(byte[] binary, OutputStream os) {
        if (binary == null) {
            throw new IllegalArgumentException("A 'binary' must not be null");
        }
        if (os == null) {
            throw new IllegalArgumentException("An 'os' must not be null");
        }
        try (GZIPOutputStream gzos = new GZIPOutputStream(os);){
            gzos.write(binary, 0, binary.length);
            gzos.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static void gzip(InputStream is, OutputStream os) {
        if (is == null) {
            throw new IllegalArgumentException("An 'is' must not be null");
        }
        if (os == null) {
            throw new IllegalArgumentException("An 'os' must not be null");
        }
        try (GZIPOutputStream gzos = new GZIPOutputStream(os);){
            IOStreamUtil.copy(is, gzos);
            gzos.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] ungzip(byte[] binary) {
        if (binary == null) {
            throw new IllegalArgumentException("A 'binary' must not be null");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(binary);
        try (GZIPInputStream gzis = new GZIPInputStream(bais);){
            byte[] byArray = GZipper.slurpBytes(gzis);
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] ungzip(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A 'file' must not be null");
        }
        try (FileInputStream is = new FileInputStream(file);){
            byte[] byArray = GZipper.ungzip(is);
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] ungzip(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("A 'inputStream' must not be null");
        }
        try (GZIPInputStream gzis = new GZIPInputStream(inputStream);){
            byte[] byArray = GZipper.slurpBytes(gzis);
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static InputStream ungzipToStream(byte[] binary) {
        if (binary == null) {
            throw new IllegalArgumentException("A 'binary' must not be null");
        }
        return GZipper.ungzipToStream(new ByteArrayInputStream(binary));
    }

    public static InputStream ungzipToStream(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("An 'inputStream' must not be null");
        }
        try {
            return new GZIPInputStream(inputStream);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isGZipFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A 'file' must not be null");
        }
        try (FileInputStream is = new FileInputStream(file);){
            boolean bl = GZipper.isGZipFile(is);
            return bl;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static boolean isGZipFile(InputStream is) {
        if (is == null) {
            throw new IllegalArgumentException("An 'is' must not be null");
        }
        try {
            is.mark(2);
            byte[] bytes = IOStreamUtil.copyIStoByteArray(is, 2);
            is.reset();
            return GZipper.isGZipFile(bytes);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static boolean isGZipFile(byte[] bytes) {
        if (bytes == null || bytes.length < 2) {
            return false;
        }
        return ByteBuffer.wrap(bytes).getShort() == 8075;
    }

    private static byte[] slurpBytes(Object source) throws IOException {
        if (source == null) {
            return new byte[0];
        }
        if (source instanceof byte[]) {
            return (byte[])source;
        }
        if (source instanceof InputStream) {
            return IOStreamUtil.copyIStoByteArray((InputStream)source);
        }
        if (source instanceof File) {
            try (FileInputStream fis = new FileInputStream((File)source);){
                byte[] byArray = IOStreamUtil.copyIStoByteArray(fis);
                return byArray;
            }
        }
        throw new IllegalArgumentException("Only entry values of type byte[], File or InputStream are supported!");
    }
}

