/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.markdown.block;

import com.github.jlangch.venice.impl.reader.LineReader;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.markdown.block.CodeBlock;

public class CodeBlockParser {
    private final LineReader reader;

    public CodeBlockParser(LineReader reader) {
        this.reader = reader;
    }

    public CodeBlock parse() {
        if (this.reader.eof()) {
            return new CodeBlock();
        }
        String line = this.reader.peek();
        if (CodeBlockParser.isBlockStart(line)) {
            this.reader.consume();
            int indentLen = CodeBlockParser.parseIndent(line);
            String language = CodeBlockParser.parseLanguage(line);
            CodeBlock block = new CodeBlock(language);
            while (!this.reader.eof()) {
                line = this.reader.peek();
                this.reader.consume();
                if (CodeBlockParser.isFence(line)) break;
                block.addLine(CodeBlockParser.removeIndent(StringUtil.trimRight(line), indentLen));
            }
            block.parseChunks();
            return block;
        }
        return new CodeBlock();
    }

    public static boolean isBlockStart(String line) {
        return CodeBlockParser.isFence(line);
    }

    private static boolean isFence(String line) {
        return line.matches(" *```.*");
    }

    private static String parseLanguage(String line) {
        return StringUtil.removeStart(line.trim(), "```").trim();
    }

    private static int parseIndent(String line) {
        return StringUtil.indexNotOf(line, " ", 0);
    }

    private static String removeIndent(String line, int indent) {
        if (indent == 0) {
            return line;
        }
        int lineIndent = Math.min(CodeBlockParser.parseIndent(line), indent);
        return lineIndent == 0 ? line : line.substring(lineIndent);
    }
}

