/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.NotInTailPositionException;
import com.github.jlangch.venice.ValueException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Destructuring;
import com.github.jlangch.venice.impl.IFormEvaluator;
import com.github.jlangch.venice.impl.ISequenceValuesEvaluator;
import com.github.jlangch.venice.impl.IValuesEvaluator;
import com.github.jlangch.venice.impl.IVeniceInterpreter;
import com.github.jlangch.venice.impl.InterruptChecker;
import com.github.jlangch.venice.impl.Modules;
import com.github.jlangch.venice.impl.Namespace;
import com.github.jlangch.venice.impl.NamespaceRegistry;
import com.github.jlangch.venice.impl.Namespaces;
import com.github.jlangch.venice.impl.debug.agent.DebugAgent;
import com.github.jlangch.venice.impl.debug.breakpoint.BreakpointFnRef;
import com.github.jlangch.venice.impl.debug.breakpoint.FunctionScope;
import com.github.jlangch.venice.impl.docgen.runtime.DocForm;
import com.github.jlangch.venice.impl.env.DynamicVar;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.GenSym;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.specialforms.CatchBlock;
import com.github.jlangch.venice.impl.specialforms.DefTypeForm;
import com.github.jlangch.venice.impl.specialforms.FinallyBlock;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncJust;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncMultiArityFunction;
import com.github.jlangch.venice.impl.types.VncProtocolFunction;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.custom.CustomWrappableTypes;
import com.github.jlangch.venice.impl.types.custom.VncCustomBaseTypeDef;
import com.github.jlangch.venice.impl.types.custom.VncProtocol;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.CallStack;
import com.github.jlangch.venice.impl.util.Inspector;
import com.github.jlangch.venice.impl.util.MetaUtil;
import com.github.jlangch.venice.impl.util.MeterRegistry;
import com.github.jlangch.venice.impl.util.WithCallStack;
import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class SpecialFormsHandler {
    private static final VncKeyword CAUSE_TYPE_SELECTOR_KEY = new VncKeyword(":cause-type");
    private final CustomWrappableTypes wrappableTypes = new CustomWrappableTypes();
    private final NamespaceRegistry nsRegistry;
    private final MeterRegistry meterRegistry;
    private final AtomicBoolean sealedSystemNS;
    private final IVeniceInterpreter interpreter;
    private final IFormEvaluator evaluator;
    private final IValuesEvaluator valuesEvaluator;

    public SpecialFormsHandler(IVeniceInterpreter interpreter, IFormEvaluator evaluator, IValuesEvaluator valuesEvaluator, ISequenceValuesEvaluator sequenceValuesEvaluator, NamespaceRegistry nsRegistry, MeterRegistry meterRegistry, AtomicBoolean sealedSystemNS) {
        this.interpreter = interpreter;
        this.evaluator = evaluator;
        this.valuesEvaluator = valuesEvaluator;
        this.nsRegistry = nsRegistry;
        this.meterRegistry = meterRegistry;
        this.sealedSystemNS = sealedSystemNS;
    }

    public VncVal quote_(VncList args, Env env, VncVal meta) {
        if (args.size() != 1) {
            CallFrame callframe = new CallFrame("quote", args, meta);
            try (WithCallStack cs = new WithCallStack(callframe);){
                ArityExceptions.assertArity("quote", ArityExceptions.FnType.SpecialForm, args, 1);
            }
        }
        return args.first();
    }

    public VncVal quasiquote_(VncList args, Env env, VncVal meta) {
        if (args.size() != 1) {
            CallFrame callframe = new CallFrame("quasiquote", args, meta);
            try (WithCallStack cs = new WithCallStack(callframe);){
                ArityExceptions.assertArity("quasiquote", ArityExceptions.FnType.SpecialForm, args, 1);
            }
        }
        return SpecialFormsHandler.quasiquote(args.first());
    }

    public VncVal import_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("import", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertMinArity("import", ArityExceptions.FnType.SpecialForm, args, 0);
            args.forEach((Consumer<? super VncVal>)((Consumer<VncVal>)i -> Namespaces.getCurrentNamespace().getJavaImports().add(Coerce.toVncString(i).getValue())));
            VncConstant vncConstant = Constants.Nil;
            return vncConstant;
        }
    }

    public VncVal imports_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("imports", args, meta);
        Throwable throwable = null;
        try (WithCallStack cs = new WithCallStack(callframe);){
            if (args.isEmpty()) {
                VncList vncList = Namespaces.getCurrentNamespace().getJavaImportsAsVncList();
                return vncList;
            }
            VncSymbol ns = Coerce.toVncSymbol(args.first());
            Namespace namespace = this.nsRegistry.get(ns);
            if (namespace != null) {
                VncList vncList = namespace.getJavaImportsAsVncList();
                return vncList;
            }
            try {
                throw new VncException(String.format("The namespace '%s' does not exist", ns.toString()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public VncVal ns_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("ns", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncSymbol ns;
            this.specialFormCallValidation("ns");
            ArityExceptions.assertArity("ns", ArityExceptions.FnType.SpecialForm, args, 1);
            VncVal name = args.first();
            VncSymbol vncSymbol = ns = Types.isVncSymbol(name) ? (VncSymbol)name : (VncSymbol)CoreFunctions.symbol.apply(VncList.of(this.evaluator.evaluate(name, env, false)));
            if (ns.hasNamespace() && !"core".equals(ns.getNamespace())) {
                throw new VncException(String.format("A namespace '%s' must not have itself a namespace! However you can use '%s'.", ns.getQualifiedName(), ns.getNamespace() + "." + ns.getSimpleName()));
            }
            VncSymbol ns_ = new VncSymbol(ns.getSimpleName());
            if (Namespaces.isSystemNS(ns_.getSimpleName()) && this.sealedSystemNS.get()) {
                throw new VncException("Namespace '" + ns_.getName() + "' cannot be reopened!");
            }
            Namespaces.setCurrentNamespace(this.nsRegistry.computeIfAbsent(ns_));
            VncSymbol vncSymbol2 = ns_;
            return vncSymbol2;
        }
    }

    public VncVal ns_remove_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("ns-remove", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.specialFormCallValidation("ns-remove");
            ArityExceptions.assertArity("ns-remove", ArityExceptions.FnType.SpecialForm, args, 1);
            VncSymbol ns = Coerce.toVncSymbol(this.evaluator.evaluate(args.first(), env, false));
            VncSymbol nsCurr = Namespaces.getCurrentNS();
            if (Namespaces.isSystemNS(ns.getName()) && this.sealedSystemNS.get()) {
                throw new VncException("Namespace '" + ns.getName() + "' cannot be removed!");
            }
            if (ns.equals(nsCurr)) {
                throw new VncException("The current samespace '" + nsCurr.getName() + "' cannot be removed!");
            }
            env.removeGlobalSymbolsByNS(ns);
            this.nsRegistry.remove(ns);
            VncConstant vncConstant = Constants.Nil;
            return vncConstant;
        }
    }

    public VncVal ns_unmap_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("ns-unmap", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.specialFormCallValidation("ns-unmap");
            ArityExceptions.assertArity("ns-unmap", ArityExceptions.FnType.SpecialForm, args, 2);
            VncSymbol ns = Coerce.toVncSymbol(this.evaluator.evaluate(args.first(), env, false));
            if (Namespaces.isSystemNS(ns.getName()) && this.sealedSystemNS.get()) {
                throw new VncException("Cannot remove a symbol from namespace '" + ns.getName() + "'!");
            }
            VncSymbol sym = Coerce.toVncSymbol(this.evaluator.evaluate(args.second(), env, false));
            env.removeGlobalSymbol(sym.withNamespace(ns));
            VncConstant vncConstant = Constants.Nil;
            return vncConstant;
        }
    }

    public VncVal ns_list_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("ns-list", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.specialFormCallValidation("ns-list");
            ArityExceptions.assertArity("ns-list", ArityExceptions.FnType.SpecialForm, args, 1);
            VncSymbol ns = Coerce.toVncSymbol(this.evaluator.evaluate(args.first(), env, false));
            String nsCore = Namespaces.NS_CORE.getName();
            String nsName = nsCore.equals(ns.getName()) ? null : ns.getName();
            VncList vncList = VncList.ofList(env.getAllGlobalSymbols().keySet().stream().filter(s -> Objects.equals(nsName, s.getNamespace())).sorted().collect(Collectors.toList()));
            return vncList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VncVal locking_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("locking", args, meta);
        Throwable throwable = null;
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncVal mutex;
            ArityExceptions.assertMinArity("locking", ArityExceptions.FnType.SpecialForm, args, 2);
            VncVal vncVal = mutex = this.evaluator.evaluate(args.first(), env, false);
            synchronized (vncVal) {
                try {
                    VncVal vncVal2 = this.evaluateBody(args.rest(), env, true);
                    return vncVal2;
                }
                catch (Throwable throwable2) {
                    try {
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
            }
        }
    }

    public VncVal setBANG_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("set!", args, meta);
        Throwable throwable = null;
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.specialFormCallValidation("set!");
            ArityExceptions.assertArity("set!", ArityExceptions.FnType.SpecialForm, args, 2);
            VncSymbol sym = Types.isVncSymbol(args.first()) ? (VncSymbol)args.first() : Coerce.toVncSymbol(this.evaluator.evaluate(args.first(), env, false));
            Var globVar = env.getGlobalVarOrNull(sym);
            if (globVar != null) {
                VncVal expr = args.second();
                VncVal val = this.evaluator.evaluate(expr, env, false);
                if (globVar instanceof DynamicVar) {
                    env.popGlobalDynamic(globVar.getName());
                    env.pushGlobalDynamic(globVar.getName(), val);
                } else {
                    env.setGlobal(new Var(globVar.getName(), val, globVar.isOverwritable()));
                }
                VncVal vncVal = val;
                return vncVal;
            }
            try {
                throw new VncException(String.format("The global or thread-local var '%s' does not exist!", sym.getName()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public VncVal boundQ_(VncList args, Env env, VncVal meta) {
        return VncBoolean.of(env.isBound(Coerce.toVncSymbol(this.evaluator.evaluate(args.first(), env, false))));
    }

    public VncVal modules_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("modules", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncList vncList = VncList.ofList(Modules.VALID_MODULES.stream().filter(s -> !s.equals("core")).sorted().map(s -> new VncKeyword((String)s)).collect(Collectors.toList()));
            return vncList;
        }
    }

    public VncVal resolve_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("resolve", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.specialFormCallValidation("resolve");
            ArityExceptions.assertArity("resolve", ArityExceptions.FnType.SpecialForm, args, 1);
            VncVal vncVal = env.getOrNil(Coerce.toVncSymbol(this.evaluator.evaluate(args.first(), env, false)));
            return vncVal;
        }
    }

    public VncVal var_get_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("var-get", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.specialFormCallValidation("var-get");
            ArityExceptions.assertArity("var-get", ArityExceptions.FnType.SpecialForm, args, 1);
            VncSymbol sym = Types.isVncSymbol(args.first()) ? (VncSymbol)args.first() : Coerce.toVncSymbol(this.evaluator.evaluate(args.first(), env, false));
            VncVal vncVal = env.getOrNil(sym);
            return vncVal;
        }
    }

    public VncVal var_ns_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("var-ns", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncSymbol sym;
            this.specialFormCallValidation("var-ns");
            ArityExceptions.assertArity("var-ns", ArityExceptions.FnType.SpecialForm, args, 1);
            VncSymbol vncSymbol = sym = Types.isVncSymbol(args.first()) ? (VncSymbol)args.first() : Coerce.toVncSymbol(this.evaluator.evaluate(args.first(), env, false));
            if (sym.hasNamespace()) {
                VncString vncString = new VncString(sym.getNamespace());
                return vncString;
            }
            if (env.isLocal(sym)) {
                VncConstant vncConstant = Constants.Nil;
                return vncConstant;
            }
            Var v = env.getGlobalVarOrNull(sym);
            VncVal vncVal = v == null ? Constants.Nil : new VncString(v.getName().hasNamespace() ? v.getName().getNamespace() : Namespaces.NS_CORE.getName());
            return vncVal;
        }
    }

    public VncVal var_name_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("var-name", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.specialFormCallValidation("var-name");
            ArityExceptions.assertArity("var-name", ArityExceptions.FnType.SpecialForm, args, 1);
            VncSymbol sym = Types.isVncSymbol(args.first()) ? (VncSymbol)args.first() : Coerce.toVncSymbol(this.evaluator.evaluate(args.first(), env, false));
            VncString vncString = new VncString(sym.getSimpleName());
            return vncString;
        }
    }

    public VncVal var_localQ_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("var-local?", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("var-local?", ArityExceptions.FnType.SpecialForm, args, 1);
            VncSymbol sym = Types.isVncSymbol(args.first()) ? (VncSymbol)args.first() : Coerce.toVncSymbol(this.evaluator.evaluate(args.first(), env, false));
            VncBoolean vncBoolean = VncBoolean.of(env.isLocal(sym));
            return vncBoolean;
        }
    }

    public VncVal var_thread_localQ_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("var-thread-local?", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("var-thread-local?", ArityExceptions.FnType.SpecialForm, args, 1);
            VncSymbol sym = Types.isVncSymbol(args.first()) ? (VncSymbol)args.first() : Coerce.toVncSymbol(this.evaluator.evaluate(args.first(), env, false));
            VncBoolean vncBoolean = VncBoolean.of(env.isDynamic(sym));
            return vncBoolean;
        }
    }

    public VncVal var_globalQ_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("var-global?", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("var-global?", ArityExceptions.FnType.SpecialForm, args, 1);
            VncSymbol sym = Types.isVncSymbol(args.first()) ? (VncSymbol)args.first() : Coerce.toVncSymbol(this.evaluator.evaluate(args.first(), env, false));
            VncBoolean vncBoolean = VncBoolean.of(env.isGlobal(sym));
            return vncBoolean;
        }
    }

    public VncVal defprotocol_(IVeniceInterpreter interpreter, VncSymbol name, VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("defprotocol", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.validateDefProtocol(args);
            VncMap protocolFns = VncHashMap.empty();
            for (VncVal s : args.rest()) {
                VncMultiArityFunction fn = this.parseProtocolFnSpec(s, env);
                VncSymbol fnName = new VncSymbol(name.getNamespace(), fn.getSimpleName(), meta);
                VncProtocolFunction fnProtocol = new VncProtocolFunction(fnName.getQualifiedName(), name, fn, fn.getMeta());
                VncVal p = env.getGlobalOrNull(fnName);
                if (p instanceof VncProtocolFunction && !((VncProtocolFunction)p).getProtocolName().equals(name)) {
                    throw new VncException(String.format("The protocol function '%s' of protocol '%s' collides with the same function in protocol '%s' in the same namespace!", fn.getSimpleName(), ((VncProtocolFunction)p).getProtocolName(), name));
                }
                env.setGlobal(new Var(fnName, fnProtocol));
                protocolFns = protocolFns.assoc(new VncString(fn.getSimpleName()), fn);
            }
            VncProtocol protocol = new VncProtocol(name, protocolFns, name.getMeta());
            env.setGlobal(new Var(name, protocol));
            VncProtocol vncProtocol = protocol;
            return vncProtocol;
        }
    }

    public VncVal extend_(VncVal typeRef, VncSymbol protocolSym, VncList args, Env env) {
        if (!(typeRef instanceof VncKeyword)) {
            throw new VncException(String.format("The type '%s' must be a keyword like :core/long!", typeRef.getType()));
        }
        VncVal p = env.getGlobalOrNull(protocolSym);
        if (!(p instanceof VncProtocol)) {
            throw new VncException(String.format("The protocol '%s' is not defined!", protocolSym.getQualifiedName()));
        }
        VncKeyword type = (VncKeyword)typeRef;
        if (!type.hasNamespace()) {
            throw new VncException(String.format("The type '%s' must be qualified!", type.getQualifiedName()));
        }
        VncProtocol protocol = (VncProtocol)p;
        VncList fnSpecList = args.slice(2);
        boolean isObjectProtocol = protocol.getName().equals(new VncSymbol("Object"));
        for (VncVal fnSpec : fnSpecList.getJavaList()) {
            VncCustomBaseTypeDef customBaseTypeDef;
            VncVal typeDef;
            VncKeyword qualifiedType;
            VncVal fnName;
            if (!Types.isVncList(fnSpec)) {
                throw new VncException(String.format("Invalid extend for protocol '%s' with type '%s' . Expected a function spec like '(foo [x] nil)'!", protocolSym.getQualifiedName(), typeRef.getType()));
            }
            VncFunction fn = this.extendFnSpec(type, (VncList)fnSpec, protocol, env);
            if (!isObjectProtocol || !((fnName = ((VncList)fnSpec).first()) instanceof VncSymbol)) continue;
            if (((VncSymbol)fnName).getSimpleName().equals("toString")) {
                qualifiedType = type.hasNamespace() ? type : type.withNamespace(Namespaces.getCurrentNS());
                typeDef = env.getGlobalOrNull(qualifiedType.toSymbol());
                if (!(typeDef instanceof VncCustomBaseTypeDef)) continue;
                customBaseTypeDef = (VncCustomBaseTypeDef)typeDef;
                customBaseTypeDef.setCustomToStringFn(fn);
                continue;
            }
            if (!((VncSymbol)fnName).getSimpleName().equals("compareTo") || !((typeDef = env.getGlobalOrNull((qualifiedType = type.hasNamespace() ? type : type.withNamespace(Namespaces.getCurrentNS())).toSymbol())) instanceof VncCustomBaseTypeDef)) continue;
            customBaseTypeDef = (VncCustomBaseTypeDef)typeDef;
            customBaseTypeDef.setCustomCompareToFn(fn);
        }
        protocol.register(type);
        return Constants.Nil;
    }

    public VncVal extendsQ_(VncVal typeRef, VncSymbol protocolSym, Env env) {
        VncVal typeRefEval = this.evaluator.evaluate(typeRef, env, false);
        if (!(typeRefEval instanceof VncKeyword)) {
            throw new VncException(String.format("The type '%s' must be a keyword like :core/long!", typeRefEval.getType()));
        }
        VncVal p = env.getGlobalOrNull(protocolSym);
        if (!(p instanceof VncProtocol)) {
            throw new VncException(String.format("The protocol '%s' is not defined!", protocolSym.getQualifiedName()));
        }
        VncKeyword type = (VncKeyword)typeRefEval;
        if (!type.hasNamespace()) {
            throw new VncException(String.format("The type '%s' must be qualified!", type.getQualifiedName()));
        }
        VncProtocol protocol = (VncProtocol)p;
        return VncBoolean.of(protocol.isRegistered(type));
    }

    public VncVal deftype_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("deftype", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertMinArity("deftype", ArityExceptions.FnType.SpecialForm, args, 2);
            VncSequence deftypeArgs = args.takeWhile(e -> !Types.isVncSymbol(e));
            VncList extendArgs = args.drop(((VncList)deftypeArgs).size());
            VncKeyword type = Coerce.toVncKeyword(this.evaluator.evaluate(((VncList)deftypeArgs).first(), env, false));
            VncVector fields = Coerce.toVncVector(deftypeArgs.second());
            VncFunction validationFn = ((VncList)deftypeArgs).size() == 3 ? Coerce.toVncFunction(this.evaluator.evaluate(args.third(), env, false)) : null;
            VncVal customType = DefTypeForm.defineCustomType(type, fields, validationFn, this.interpreter, env);
            while (!extendArgs.isEmpty()) {
                VncVal protocolSym = extendArgs.first();
                VncSequence extDefs = extendArgs.drop(1).takeWhile(e -> Types.isVncList(e));
                if (Types.isVncSymbol(protocolSym)) {
                    extendArgs = extendArgs.drop(((VncList)extDefs).size() + 1);
                    this.extend_(customType, (VncSymbol)protocolSym, ((VncList)extDefs).addAtStart(protocolSym).addAtStart(type), env);
                    continue;
                }
                throw new VncException(String.format("Invalid extend protocol definitions for custom type '%s'", type.toString()));
            }
            VncVal vncVal = customType;
            return vncVal;
        }
    }

    public VncVal deftypeQ_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("deftype?", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("deftype?", ArityExceptions.FnType.SpecialForm, args, 1);
            VncVal type = this.evaluator.evaluate(args.first(), env, false);
            VncBoolean vncBoolean = VncBoolean.of(DefTypeForm.isCustomType(type, env));
            return vncBoolean;
        }
    }

    public VncVal deftype_of_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("deftype-of", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertMinArity("deftype-of", ArityExceptions.FnType.SpecialForm, args, 2);
            VncKeyword type = Coerce.toVncKeyword(this.evaluator.evaluate(args.first(), env, false));
            VncKeyword baseType = Coerce.toVncKeyword(this.evaluator.evaluate(args.second(), env, false));
            VncFunction validationFn = args.size() == 3 ? Coerce.toVncFunction(this.evaluator.evaluate(args.third(), env, false)) : null;
            VncVal vncVal = DefTypeForm.defineCustomWrapperType(type, baseType, validationFn, this.interpreter, env, this.wrappableTypes);
            return vncVal;
        }
    }

    public VncVal deftype_or_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("deftype-or", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertMinArity("deftype-or", ArityExceptions.FnType.SpecialForm, args, 2);
            VncKeyword type = Coerce.toVncKeyword(this.evaluator.evaluate(args.first(), env, false));
            VncList choiceVals = args.rest();
            VncVal vncVal = DefTypeForm.defineCustomChoiceType(type, choiceVals, this.interpreter, env);
            return vncVal;
        }
    }

    public VncVal deftype_describe_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame(".:", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("deftype-describe", ArityExceptions.FnType.SpecialForm, args, 1);
            VncVal evaluatedArg = this.evaluator.evaluate(args.first(), env, false);
            VncVal vncVal = DefTypeForm.describeType(evaluatedArg, env);
            return vncVal;
        }
    }

    public VncVal deftype_create_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame(".:", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertMinArity(".:", ArityExceptions.FnType.SpecialForm, args, 1);
            ArrayList<VncVal> evaluatedArgs = new ArrayList<VncVal>();
            for (VncVal v : args) {
                evaluatedArgs.add(this.evaluator.evaluate(v, env, false));
            }
            VncVal vncVal = DefTypeForm.createType(evaluatedArgs, env);
            return vncVal;
        }
    }

    public VncVal inspect_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("inspect", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.specialFormCallValidation("inspect");
            ArityExceptions.assertArity("inspect", ArityExceptions.FnType.SpecialForm, args, 1);
            VncSymbol sym = Coerce.toVncSymbol(this.evaluator.evaluate(args.first(), env, false));
            VncVal vncVal = Inspector.inspect(env.get(sym));
            return vncVal;
        }
    }

    public VncVal doc_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("doc", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("doc", ArityExceptions.FnType.SpecialForm, args, 1);
            VncString doc = DocForm.doc(args.first(), env);
            this.evaluator.evaluate(VncList.of(new VncSymbol("println"), doc), env, false);
            VncConstant vncConstant = Constants.Nil;
            return vncConstant;
        }
    }

    public VncVal print_highlight_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("print-highlight", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            ArityExceptions.assertArity("print-highlight", ArityExceptions.FnType.SpecialForm, args, 1);
            VncString form = DocForm.highlight(Coerce.toVncString(args.first()), env);
            this.evaluator.evaluate(VncList.of(new VncSymbol("println"), form), env, false);
            VncConstant vncConstant = Constants.Nil;
            return vncConstant;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VncVal dobench_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("dobench", args, meta);
        Throwable throwable = null;
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncList vncList;
            this.specialFormCallValidation("dobench");
            ArityExceptions.assertArity("dobench", ArityExceptions.FnType.SpecialForm, args, 2);
            try {
                long count = Coerce.toVncLong(args.first()).getValue();
                VncVal expr = args.second();
                ArrayList<VncLong> elapsed = new ArrayList<VncLong>();
                int ii = 0;
                while ((long)ii < count) {
                    long start = System.nanoTime();
                    VncVal result = this.evaluator.evaluate(expr, env, false);
                    long end = System.nanoTime();
                    elapsed.add(new VncLong(end - start));
                    InterruptChecker.checkInterrupted(Thread.currentThread(), "dobench");
                    ThreadContext.setValue(new VncKeyword("*benchmark-val*"), new VncJust(result));
                    ++ii;
                }
                vncList = VncList.ofList(elapsed);
            }
            catch (Throwable throwable2) {
                try {
                    ThreadContext.removeValue(new VncKeyword("*benchmark-val*"));
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            ThreadContext.removeValue(new VncKeyword("*benchmark-val*"));
            return vncList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VncVal dorun_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("dorun", args, meta);
        Throwable throwable = null;
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncVal vncVal;
            VncVal v;
            this.specialFormCallValidation("dorun");
            ArityExceptions.assertArity("dorun", ArityExceptions.FnType.SpecialForm, args, 2);
            VncVal vCount = this.evaluator.evaluate(args.first(), env, false);
            long count = Coerce.toVncLong(vCount).getValue();
            if (count <= 0L) {
                VncConstant vncConstant = Constants.Nil;
                return vncConstant;
            }
            VncVal expr = args.second();
            if (Types.isVncSymbol(expr) && Types.isVncFunction(v = env.getOrNil((VncSymbol)expr))) {
                VncFunction fn = (VncFunction)v;
                if (fn.getFixedArgsCount() == 1) {
                    int ii22 = 0;
                    while ((long)ii22 < count - 1L) {
                        fn.apply(VncList.of(new VncLong(ii22)));
                        ++ii22;
                    }
                    VncVal ii22 = fn.apply(VncList.of(new VncLong(count - 1L)));
                    return ii22;
                }
                VncList fnArgs = VncList.empty();
                int ii = 0;
                while ((long)ii < count - 1L) {
                    fn.apply(fnArgs);
                    ++ii;
                }
                VncVal vncVal2 = fn.apply(fnArgs);
                return vncVal2;
            }
            try {
                VncVal first = this.evaluator.evaluate(expr, env, false);
                int ii = 1;
                while ((long)ii < count) {
                    VncVal result = this.evaluator.evaluate(expr, env, false);
                    InterruptChecker.checkInterrupted(Thread.currentThread(), "dorun");
                    ThreadContext.setValue(new VncKeyword("*benchmark-val*"), new VncJust(result));
                    ++ii;
                }
                vncVal = first;
            }
            catch (Throwable throwable2) {
                try {
                    ThreadContext.removeValue(new VncKeyword("*benchmark-val*"));
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            ThreadContext.removeValue(new VncKeyword("*benchmark-val*"));
            return vncVal;
        }
    }

    public VncVal prof_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("prof", args, meta);
        Throwable throwable = null;
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.specialFormCallValidation("prof");
            ArityExceptions.assertArity("prof", ArityExceptions.FnType.SpecialForm, args, 1, 2, 3);
            if (Types.isVncKeyword(args.first())) {
                VncKeyword cmd = (VncKeyword)args.first();
                switch (cmd.getValue()) {
                    case "on": 
                    case "enable": {
                        this.meterRegistry.enable();
                        VncKeyword vncKeyword = new VncKeyword("on");
                        return vncKeyword;
                    }
                    case "off": 
                    case "disable": {
                        this.meterRegistry.disable();
                        VncKeyword vncKeyword = new VncKeyword("off");
                        return vncKeyword;
                    }
                    case "status": {
                        VncKeyword vncKeyword = new VncKeyword(this.meterRegistry.isEnabled() ? "on" : "off");
                        return vncKeyword;
                    }
                    case "clear": {
                        this.meterRegistry.reset();
                        VncKeyword vncKeyword = new VncKeyword(this.meterRegistry.isEnabled() ? "on" : "off");
                        return vncKeyword;
                    }
                    case "clear-all-but": {
                        this.meterRegistry.resetAllBut(Coerce.toVncSequence(args.second()));
                        VncKeyword vncKeyword = new VncKeyword(this.meterRegistry.isEnabled() ? "on" : "off");
                        return vncKeyword;
                    }
                    case "data": {
                        VncList vncList = this.meterRegistry.getVncTimerData();
                        return vncList;
                    }
                    case "data-formatted": {
                        VncVal opt1 = args.second();
                        VncVal opt2 = args.third();
                        String title = "Metrics";
                        if (Types.isVncString(opt1) && !Types.isVncKeyword(opt1)) {
                            title = ((VncString)opt1).getValue();
                        }
                        if (Types.isVncString(opt2) && !Types.isVncKeyword(opt2)) {
                            title = ((VncString)opt2).getValue();
                        }
                        boolean anonFn = false;
                        if (Types.isVncKeyword(opt1)) {
                            boolean bl = anonFn = anonFn || ((VncKeyword)opt1).hasValue("anon-fn");
                        }
                        if (Types.isVncKeyword(opt2)) {
                            anonFn = anonFn || ((VncKeyword)opt2).hasValue("anon-fn");
                        }
                        VncString vncString = new VncString(this.meterRegistry.getTimerDataFormatted(title, anonFn));
                        return vncString;
                    }
                }
            }
            try {
                throw new VncException("Function 'prof' expects a single keyword argument: :on, :off, :status, :clear, :clear-all-but, :data, or :data-formatted");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public VncVal try_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("try", args, meta);
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncVal vncVal = this.handleTryCatchFinally("try", args, env, meta, new ArrayList<Var>());
            return vncVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VncVal try_with_(VncList args, Env env, VncVal meta) {
        CallFrame callframe = new CallFrame("try-with", args, meta);
        Throwable throwable = null;
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncVal vncVal;
            Env localEnv = new Env(env);
            VncSequence bindings = Coerce.toVncSequence(args.first());
            ArrayList<Var> boundResources = new ArrayList<Var>();
            for (int i = 0; i < bindings.size(); i += 2) {
                VncVal sym = bindings.nth(i);
                VncVal val = this.evaluator.evaluate(bindings.nth(i + 1), localEnv, false);
                if (!Types.isVncSymbol(sym)) {
                    throw new VncException(String.format("Invalid 'try-with' destructuring symbol value type %s. Expected symbol.", Types.getType(sym)));
                }
                Var binding = new Var((VncSymbol)sym, val);
                localEnv.setLocal(binding);
                boundResources.add(binding);
            }
            try {
                vncVal = this.handleTryCatchFinally("try-with", args.rest(), localEnv, meta, boundResources);
            }
            catch (Throwable throwable2) {
                try {
                    Collections.reverse(boundResources);
                    boundResources.stream().forEach(b -> {
                        Object r;
                        VncVal resource = b.getVal();
                        if (Types.isVncJavaObject(resource) && (r = ((VncJavaObject)resource).getDelegate()) instanceof AutoCloseable) {
                            try {
                                ((AutoCloseable)r).close();
                            }
                            catch (Exception ex) {
                                throw new VncException(String.format("'try-with' failed to close resource %s.", b.getName()));
                            }
                        }
                    });
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            Collections.reverse(boundResources);
            boundResources.stream().forEach(b -> {
                Object r;
                VncVal resource = b.getVal();
                if (Types.isVncJavaObject(resource) && (r = ((VncJavaObject)resource).getDelegate()) instanceof AutoCloseable) {
                    try {
                        ((AutoCloseable)r).close();
                    }
                    catch (Exception ex) {
                        throw new VncException(String.format("'try-with' failed to close resource %s.", b.getName()));
                    }
                }
            });
            return vncVal;
        }
    }

    public VncVal tail_pos_check(boolean inTailPosition, VncList args, Env env, VncVal meta) {
        if (!inTailPosition) {
            CallFrame callframe = new CallFrame("tail-pos", args, meta);
            VncString name = Coerce.toVncString(args.nthOrDefault(0, VncString.empty()));
            WithCallStack cs = new WithCallStack(callframe);
            Throwable throwable = null;
            try {
                try {
                    throw new NotInTailPositionException(name.isEmpty() ? "Not in tail position" : String.format("The tail-pos expression '%s' is not in tail position", name.getValue()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        return Constants.Nil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal handleTryCatchFinally(String specialForm, VncList args, Env env, VncVal meta, List<Var> bindings) {
        ThreadContext threadCtx = ThreadContext.get();
        DebugAgent debugAgent = threadCtx.getDebugAgent_();
        if (debugAgent != null && debugAgent.hasBreakpointFor(new BreakpointFnRef(specialForm))) {
            CallStack callStack = threadCtx.getCallStack_();
            debugAgent.onBreakSpecialForm(specialForm, FunctionScope.FunctionEntry, bindings, meta, env, callStack);
        }
        try {
            Env bodyEnv = new Env(env);
            VncVal vncVal = this.evaluateBody(this.getTryBody(args), bodyEnv, true);
            return vncVal;
        }
        catch (Exception ex) {
            RuntimeException wrappedEx = ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException(ex);
            CatchBlock catchBlock = this.findCatchBlockMatchingThrowable(env, args, ex);
            if (catchBlock == null) {
                throw wrappedEx;
            }
            Env catchEnv = new Env(env);
            catchEnv.setLocal(new Var(catchBlock.getExSym(), new VncJavaObject(wrappedEx)));
            this.catchBlockDebug(threadCtx, debugAgent, catchBlock.getMeta(), catchEnv, catchBlock.getExSym(), wrappedEx);
            VncVal vncVal = this.evaluateBody(catchBlock.getBody(), catchEnv, false);
            return vncVal;
        }
        finally {
            FinallyBlock finallyBlock = this.findFirstFinallyBlock(args);
            if (finallyBlock != null) {
                Env finallyEnv = new Env(env);
                this.finallyBlockDebug(threadCtx, debugAgent, finallyBlock.getMeta(), finallyEnv);
                this.evaluateBody(finallyBlock.getBody(), finallyEnv, false);
            }
        }
    }

    private VncList getTryBody(VncList args) {
        String symName;
        VncVal first;
        VncVal e;
        ArrayList<VncVal> body = new ArrayList<VncVal>();
        Iterator<VncVal> iterator = args.iterator();
        while (!(!iterator.hasNext() || Types.isVncList(e = iterator.next()) && Types.isVncSymbol(first = ((VncList)e).first()) && ((symName = ((VncSymbol)first).getName()).equals("catch") || symName.equals("finally")))) {
            body.add(e);
        }
        return VncList.ofList(body);
    }

    private CatchBlock findCatchBlockMatchingThrowable(Env env, VncList blocks, Throwable th) {
        for (VncVal b : blocks) {
            VncList block;
            VncVal catchSym;
            if (!Types.isVncList(b) || !Types.isVncSymbol(catchSym = (block = (VncList)b).first()) || !((VncSymbol)catchSym).getName().equals("catch") || !this.isCatchBlockMatchingThrowable(env, block, th)) continue;
            return new CatchBlock(Coerce.toVncSymbol(block.third()), block.slice(3), catchSym.getMeta());
        }
        return null;
    }

    private boolean isCatchBlockMatchingThrowable(Env env, VncList block, Throwable th) {
        VncVal selector = this.evaluator.evaluate(block.second(), env, false);
        if (Types.isVncString(selector)) {
            String className = this.resolveClassName(((VncString)selector).getValue());
            Class<?> targetClass = ReflectionAccessor.classForName(className);
            return targetClass.isAssignableFrom(th.getClass());
        }
        if (Types.isVncFunction(selector)) {
            VncFunction predicate = (VncFunction)selector;
            if (th instanceof ValueException) {
                VncVal exVal = this.getValueExceptionValue((ValueException)th);
                VncVal result = predicate.apply(VncList.of(exVal));
                return VncBoolean.isTrue(result);
            }
            VncVal result = predicate.apply(VncList.of(Constants.Nil));
            return VncBoolean.isTrue(result);
        }
        if (Types.isVncSequence(selector)) {
            VncVal exVal;
            VncSequence seq = (VncSequence)selector;
            if (seq.first().equals(CAUSE_TYPE_SELECTOR_KEY) && Types.isVncKeyword(seq.second())) {
                Throwable cause = th.getCause();
                if (cause != null) {
                    VncKeyword classRef = (VncKeyword)seq.second();
                    String className = this.resolveClassName(classRef.getSimpleName());
                    Class<?> targetClass = ReflectionAccessor.classForName(className);
                    if (!targetClass.isAssignableFrom(cause.getClass())) {
                        return false;
                    }
                    if (seq.size() == 2) {
                        return true;
                    }
                }
                seq = seq.drop(2);
            }
            if (th instanceof ValueException && Types.isVncMap(exVal = this.getValueExceptionValue((ValueException)th))) {
                VncMap exValMap = (VncMap)exVal;
                while (!seq.isEmpty()) {
                    VncVal key = seq.first();
                    VncVal val = seq.second();
                    if (!Types._equal_strict_Q(val, exValMap.get(key))) {
                        return false;
                    }
                    seq = seq.drop(2);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private FinallyBlock findFirstFinallyBlock(VncList blocks) {
        for (VncVal b : blocks) {
            VncList block;
            VncVal first;
            if (!Types.isVncList(b) || !Types.isVncSymbol(first = (block = (VncList)b).first()) || !((VncSymbol)first).getName().equals("finally")) continue;
            return new FinallyBlock(block.rest(), first.getMeta());
        }
        return null;
    }

    private void catchBlockDebug(ThreadContext threadCtx, DebugAgent debugAgent, VncVal meta, Env env, VncSymbol exSymbol, RuntimeException ex) {
        if (debugAgent != null && debugAgent.hasBreakpointFor(new BreakpointFnRef("catch"))) {
            debugAgent.onBreakSpecialForm("catch", FunctionScope.FunctionEntry, VncVector.of(exSymbol), VncList.of(new VncJavaObject(ex)), meta, env, threadCtx.getCallStack_());
        }
    }

    private void finallyBlockDebug(ThreadContext threadCtx, DebugAgent debugAgent, VncVal meta, Env env) {
        if (debugAgent != null && debugAgent.hasBreakpointFor(new BreakpointFnRef("finally"))) {
            debugAgent.onBreakSpecialForm("finally", FunctionScope.FunctionEntry, new ArrayList<Var>(), meta, env, threadCtx.getCallStack_());
        }
    }

    private VncVal getValueExceptionValue(ValueException ex) {
        Object val = ex.getValue();
        return val == null ? Constants.Nil : (val instanceof VncVal ? (VncVal)val : new VncJavaObject(val));
    }

    private VncVal evaluateBody(VncList body, Env env, boolean withTailPosition) {
        this.valuesEvaluator.evaluate_values(body.butlast(), env);
        return this.evaluator.evaluate(body.last(), env, withTailPosition);
    }

    private String resolveClassName(String className) {
        return Namespaces.getCurrentNamespace().getJavaImports().resolveClassName(className);
    }

    private void specialFormCallValidation(String name) {
        ThreadContext.getInterceptor().validateVeniceFunction(name);
    }

    private static VncVal quasiquote(VncVal ast) {
        if (SpecialFormsHandler.isNonEmptySequence(ast)) {
            VncVal a00;
            VncVal a0 = Coerce.toVncSequence(ast).first();
            if (Types.isVncSymbol(a0) && ((VncSymbol)a0).getName().equals("unquote")) {
                return ((VncSequence)ast).second();
            }
            if (SpecialFormsHandler.isNonEmptySequence(a0) && Types.isVncSymbol(a00 = Coerce.toVncSequence(a0).first()) && ((VncSymbol)a00).getName().equals("splice-unquote")) {
                return VncList.of(new VncSymbol("concat"), Coerce.toVncSequence(a0).second(), SpecialFormsHandler.quasiquote(((VncSequence)ast).rest()));
            }
            return VncList.of(new VncSymbol("cons"), SpecialFormsHandler.quasiquote(a0), SpecialFormsHandler.quasiquote(((VncSequence)ast).rest()));
        }
        return VncList.of(new VncSymbol("quote"), ast);
    }

    private void validateDefProtocol(VncList args) {
        if (!Types.isVncSymbol(args.first())) {
            throw new VncException("A protocol definition must have a symbol as its name!\nE.g.: as 'P' in (defprotocol P (foo [x]))");
        }
        for (VncVal spec : args.rest()) {
            if (!Types.isVncList(spec)) {
                throw new VncException("A protocol definition must have a list with function specifications!\nE.g.: as '(foo [x])' (defprotocol P (foo [x]) (bar [x]))");
            }
            VncList specList = (VncList)spec;
            VncSymbol fnName = (VncSymbol)specList.first();
            VncList specs = specList.rest();
            VncSequence paramSpecs = specs.takeWhile(s -> Types.isVncVector(s));
            if (!Types.isVncSymbol(fnName)) {
                throw new VncException("A protocol function specification must have a symbol as its name!\nE.g.: as 'foo' in (defprotocol P (foo [x]))");
            }
            if (((VncList)paramSpecs).isEmpty()) {
                throw new VncException(String.format("The protocol function specification '%s' must have at least one parameter specification!\nE.g.: as '[x]' in (defprotocol P (foo [x]))", fnName));
            }
            HashSet<Integer> aritySet = new HashSet<Integer>();
            for (VncVal ps : paramSpecs) {
                if (!Types.isVncVector(ps)) {
                    throw new VncException(String.format("The protocol function specification '%s' must have one or multiple vectors of param symbols followed by an optional return value of any type but vector!\nE.g.: (defprotocol P (foo [x] [x y] nil))", fnName));
                }
                int arity = ((VncVector)ps).size();
                if (aritySet.contains(arity)) {
                    throw new VncException(String.format("The protocol function specification '%s' has multiple parameter definitions for the arity %d!\nE.g.: as '[x y]' in (defprotocol P (foo [x] [x y] [x y]))", fnName, arity));
                }
                aritySet.add(arity);
                for (VncVal p : (VncVector)ps) {
                    if (Types.isVncSymbol(p)) continue;
                    throw new VncException(String.format("The protocol function specification '%s' must have vector of param symbols!\nE.g.: as '[x y]' in (defprotocol P (foo [x y]))", fnName));
                }
            }
        }
    }

    private VncMultiArityFunction parseProtocolFnSpec(VncVal spec, final Env env) {
        VncList specList = (VncList)spec;
        VncSymbol fnName = (VncSymbol)specList.first();
        VncList specs = specList.rest();
        VncSequence paramSpecs = specs.takeWhile(s -> Types.isVncVector(s));
        VncList body = specs.slice(((VncList)paramSpecs).size());
        Namespace ns = Namespaces.getCurrentNamespace();
        List argList = ((VncList)paramSpecs).stream().map(spc -> String.format("(%s %s)", fnName.getName(), spc.toString())).map(s -> new VncString((String)s)).collect(Collectors.toList());
        List<VncFunction> functions = ((VncList)paramSpecs).getJavaList().stream().map(p -> new VncFunction(fnName.getQualifiedName(), (VncVector)p, fnName.getMeta(), (VncVal)p, ns, body){
            private static final long serialVersionUID = -1L;
            final /* synthetic */ VncVal val$p;
            final /* synthetic */ Namespace val$ns;
            final /* synthetic */ VncList val$body;
            {
                this.val$p = vncVal;
                this.val$ns = namespace;
                this.val$body = vncList;
                super(name, params, meta);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VncVal apply(VncList args) {
                ThreadContext threadCtx = ThreadContext.get();
                Env localEnv = new Env(env);
                localEnv.addLocalVars(Destructuring.destructure(this.val$p, args));
                Namespace curr_ns = threadCtx.getCurrNS_();
                try {
                    threadCtx.setCurrNS_(this.val$ns);
                    SpecialFormsHandler.this.valuesEvaluator.evaluate_values(this.val$body.butlast(), localEnv);
                    VncVal vncVal = SpecialFormsHandler.this.evaluator.evaluate(this.val$body.last(), localEnv, false);
                    return vncVal;
                }
                finally {
                    threadCtx.setCurrNS_(curr_ns);
                }
            }
        }).collect(Collectors.toList());
        return new VncMultiArityFunction(fnName.getQualifiedName(), functions, false, MetaUtil.mergeMeta(VncHashMap.of(MetaUtil.ARGLIST, VncList.ofColl(argList)), fnName.getMeta()));
    }

    private VncFunction extendFnSpec(VncKeyword type, VncList fnSpec, VncProtocol protocol, Env env) {
        String name = ((VncSymbol)fnSpec.first()).getName();
        VncSymbol fnProtoSym = new VncSymbol(protocol.getName().getNamespace(), name, fnSpec.first().getMeta());
        VncSymbol fnSym = new VncSymbol(GenSym.generateAutoSym(name).getName(), fnSpec.first().getMeta());
        VncVal protocolFn = env.getGlobalOrNull(fnProtoSym);
        if (!(protocolFn instanceof VncProtocolFunction)) {
            throw new VncException(String.format("The protocol function '%s' does not exist!", fnProtoSym.getQualifiedName()));
        }
        VncList fnDef = VncList.of(new VncSymbol("defn"), fnSym).addAllAtEnd(fnSpec.rest());
        this.evaluator.evaluate(fnDef, env, false);
        VncFunction fn = (VncFunction)env.getGlobalOrNull(fnSym);
        env.removeGlobalSymbol(fnSym);
        ((VncProtocolFunction)protocolFn).register(type, fn);
        return fn;
    }

    private static boolean isNonEmptySequence(VncVal x) {
        return Types.isVncSequence(x) && !((VncSequence)x).isEmpty();
    }
}

