/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.docgen.cheatsheet;

import com.github.jlangch.venice.Parameters;
import com.github.jlangch.venice.Venice;
import com.github.jlangch.venice.impl.RunMode;
import com.github.jlangch.venice.impl.VeniceClasspath;
import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.docgen.cheatsheet.CheatsheetRenderer;
import com.github.jlangch.venice.impl.docgen.cheatsheet.CodeSnippetReader;
import com.github.jlangch.venice.impl.docgen.cheatsheet.CrossRef;
import com.github.jlangch.venice.impl.docgen.cheatsheet.DocColorTheme;
import com.github.jlangch.venice.impl.docgen.cheatsheet.DocHighlighter;
import com.github.jlangch.venice.impl.docgen.cheatsheet.DocItem;
import com.github.jlangch.venice.impl.docgen.cheatsheet.DocSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.ExampleOutput;
import com.github.jlangch.venice.impl.docgen.cheatsheet.IdGen;
import com.github.jlangch.venice.impl.docgen.cheatsheet.MarkdownDoc;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.repl.ReplFunctions;
import com.github.jlangch.venice.impl.specialforms.SpecialFormsDoc;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.custom.VncProtocol;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.io.ClassPathResource;
import com.github.jlangch.venice.impl.util.markdown.Markdown;
import com.github.jlangch.venice.impl.util.markdown.renderer.html.HtmlRenderer;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.util.CapturingPrintStream;
import com.lowagie.text.pdf.PdfReader;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class DocGenerator {
    private static final boolean MARKDOWN_FN_DESCR = true;
    private static final List<ExampleOutput> EMPTY_EXAMPLES = Collections.unmodifiableList(new ArrayList());
    private static final int CROSSREF_MAX_LEN = 145;
    private final List<String> preloadedModules = new ArrayList<String>();
    private final Map<String, DocItem> docItems = new HashMap<String, DocItem>();
    private final Env env;
    private final DocHighlighter codeHighlighter;
    private boolean runExamples = false;
    private final IdGen idgen = new IdGen();

    public DocGenerator() {
        this.preloadedModules.addAll(Arrays.asList("app", "xml", "crypt", "gradle", "trace", "ansi", "maven", "kira", "java", "semver", "excel", "hexdump", "shell", "geoip", "benchmark", "component", "config", "parsifal"));
        Env docEnv = new VeniceInterpreter(new AcceptAllInterceptor()).createEnv(this.preloadedModules, false, false, RunMode.DOCGEN).setStdoutPrintStream(null).setStderrPrintStream(null);
        this.env = ReplFunctions.register(docEnv, null, null);
        this.codeHighlighter = new DocHighlighter(DocColorTheme.getLightTheme());
    }

    public static List<DocSection> docInfo() {
        return new DocGenerator().includeExamples(false).buildDocInfo();
    }

    public DocGenerator includeExamples(boolean runExamples) {
        this.runExamples = runExamples;
        return this;
    }

    public void run(String version) {
        try {
            System.out.println("Creating cheatsheet V" + version);
            List<DocSection> left = this.getLeftSections();
            List<DocSection> right = this.getRightSections();
            List<DocSection> leftModules = this.getModulesLeftSections();
            List<DocSection> rightModules = this.getModulesRightSections();
            List<MarkdownDoc> topics = this.getTopics();
            this.validateUniqueSectionsId(left, right);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("meta-author", "Venice");
            data.put("version", version);
            data.put("toc", this.getTOC());
            data.put("left", left);
            data.put("right", right);
            data.put("left-modules", leftModules);
            data.put("right-modules", rightModules);
            data.put("details", this.getDocItems(this.concat(left, right, leftModules, rightModules)));
            data.put("snippets", new CodeSnippetReader().readSnippets());
            data.put("topics", topics);
            data.put("pdfmode", false);
            String html = CheatsheetRenderer.renderXHTML(data);
            this.save(new File(this.getUserDir(), "cheatsheet.html"), html);
            data.put("pdfmode", true);
            String xhtml = CheatsheetRenderer.renderXHTML(data);
            ByteBuffer pdf = CheatsheetRenderer.renderPDF(xhtml);
            byte[] pdfArr = pdf.array();
            this.save(new File(this.getUserDir(), "cheatsheet.pdf"), pdfArr);
            PdfReader reader = new PdfReader(pdf.array());
            int pages = reader.getNumberOfPages();
            reader.close();
            System.out.println(String.format("Generated Cheat Sheet at: %s. XHTML: %dKB, PDF: %dKB / %d pages", this.getUserDir(), xhtml.length() / 1024, pdfArr.length / 1024, pages));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private List<DocSection> buildDocInfo() {
        ArrayList<DocSection> sections = new ArrayList<DocSection>();
        sections.addAll(this.getLeftSections());
        sections.addAll(this.getRightSections());
        return sections;
    }

    private List<DocSection> getTOC() {
        ArrayList<DocSection> content = new ArrayList<DocSection>();
        DocSection primitives = new DocSection("Primitives", "primitives");
        primitives.addSection(new DocSection("Literals", "primitives.literals"));
        primitives.addSection(new DocSection("Numbers", "primitives.numbers"));
        primitives.addSection(new DocSection("Strings", "primitives.strings"));
        primitives.addSection(new DocSection("Chars", "primitives.chars"));
        primitives.addSection(new DocSection("Other", "primitives.other"));
        content.add(primitives);
        DocSection collections = new DocSection("Collections", "collections");
        collections.addSection(new DocSection("List", "collections.lists"));
        collections.addSection(new DocSection("Vector", "collections.vectors"));
        collections.addSection(new DocSection("Set", "collections.sets"));
        collections.addSection(new DocSection("Map", "collections.maps"));
        collections.addSection(new DocSection("LazySeq", "lazyseq"));
        collections.addSection(new DocSection("Stack", "collections.stack"));
        collections.addSection(new DocSection("Queue", "collections.queue"));
        collections.addSection(new DocSection("DAG", "collections.dag"));
        collections.addSection(new DocSection("Array", "arrays"));
        collections.addSection(new DocSection("ByteBuf", "bytebuf"));
        content.add(collections);
        DocSection datatypes = new DocSection("Custom\u00a0Types", "datatypes");
        datatypes.addSection(new DocSection("Types", "types"));
        datatypes.addSection(new DocSection("Protocols", "protocols"));
        content.add(datatypes);
        DocSection functions = new DocSection("Core\u00a0Functions", "functions");
        functions.addSection(new DocSection("Functions", "functions"));
        functions.addSection(new DocSection("Macros", "macros"));
        functions.addSection(new DocSection("Special\u00a0Forms", "specialforms"));
        functions.addSection(new DocSection("Transducers", "transducers"));
        functions.addSection(new DocSection("Namespaces", "namespace"));
        functions.addSection(new DocSection("Exceptions", "exceptions"));
        content.add(functions);
        DocSection concurrency = new DocSection("Concurrency", "concurrency");
        concurrency.addSection(new DocSection("Atoms", "concurrency.atoms"));
        concurrency.addSection(new DocSection("Futures", "concurrency.futures"));
        concurrency.addSection(new DocSection("Promises", "concurrency.promises"));
        concurrency.addSection(new DocSection("Delay", "concurrency.delay"));
        concurrency.addSection(new DocSection("Agents", "concurrency.agents"));
        concurrency.addSection(new DocSection("Scheduler", "concurrency.scheduler"));
        concurrency.addSection(new DocSection("Locking", "concurrency.locking"));
        concurrency.addSection(new DocSection("Volatiles", "concurrency.volatiles"));
        concurrency.addSection(new DocSection("Parallel", "concurrency.parallel"));
        content.add(concurrency);
        DocSection threads = new DocSection("Threads", "concurrency.threads");
        threads.addSection(new DocSection("ThreadLocal", "concurrency.threadlocal"));
        threads.addSection(new DocSection("Threads", "concurrency.threads"));
        content.add(threads);
        DocSection system = new DocSection("System\u00a0&\u00a0Java", "system");
        system.addSection(new DocSection("System", "system"));
        system.addSection(new DocSection("System\u00a0Vars", "sysvars"));
        system.addSection(new DocSection("Java\u00a0Interop", "javainterop"));
        system.addSection(new DocSection("REPL", "repl"));
        content.add(system);
        DocSection util = new DocSection("Util", "util");
        util.addSection(new DocSection("Math", "math"));
        util.addSection(new DocSection("Time", "time"));
        util.addSection(new DocSection("Regex", "regex"));
        util.addSection(new DocSection("CIDR", "cidr"));
        content.add(util);
        DocSection io = new DocSection("I/O", "io");
        io.addSection(new DocSection("I/O", "io.util"));
        io.addSection(new DocSection("File", "io.file"));
        io.addSection(new DocSection("Zip/GZip", "io.zip"));
        content.add(io);
        DocSection documents = new DocSection("Documents", "miscellaneous");
        documents.addSection(new DocSection("JSON", "json"));
        documents.addSection(new DocSection("PDF", "pdf"));
        documents.addSection(new DocSection("PDF Tools", "pdf.pdftools"));
        documents.addSection(new DocSection("CSV", "csv"));
        documents.addSection(new DocSection("XML", "modules.xml"));
        documents.addSection(new DocSection("Excel", "modules.excel"));
        content.add(documents);
        DocSection extmod = new DocSection("Modules", "modules");
        extmod.addSection(new DocSection("Kira\u00a0Templates", "modules.kira"));
        extmod.addSection(new DocSection("Parsifal", "modules.parsifal"));
        extmod.addSection(new DocSection("Configuration", "modules.config"));
        extmod.addSection(new DocSection("Component", "modules.component"));
        extmod.addSection(new DocSection("XML", "modules.xml"));
        extmod.addSection(new DocSection("Cryptography", "modules.cryptography"));
        extmod.addSection(new DocSection("Java", "modules.java"));
        extmod.addSection(new DocSection("Semver", "modules.semver"));
        extmod.addSection(new DocSection("Hexdump", "modules.hexdump"));
        extmod.addSection(new DocSection("Shell", "modules.shell"));
        extmod.addSection(new DocSection("Geo IP", "modules.geoip"));
        extmod.addSection(new DocSection("Ansi", "modules.ansi"));
        extmod.addSection(new DocSection("Gradle", "modules.gradle"));
        extmod.addSection(new DocSection("Maven", "modules.maven"));
        extmod.addSection(new DocSection("Tracing", "modules.tracing"));
        extmod.addSection(new DocSection("Benchmark", "modules.benchmark"));
        extmod.addSection(new DocSection("App", "modules.app"));
        content.add(extmod);
        DocSection others = new DocSection("Others", "others");
        others.addSection(new DocSection("Embedding in Java", "embedding"));
        others.addSection(new DocSection("Venice Doc", "venicedoc"));
        others.addSection(new DocSection("Markdown", "markdown"));
        content.add(others);
        return content;
    }

    private List<MarkdownDoc> getTopics() {
        ArrayList<MarkdownDoc> topics = new ArrayList<MarkdownDoc>();
        topics.add(new MarkdownDoc("VeniceDoc", new HtmlRenderer().render(this.loadVeniceDocMarkdown()), "venicedoc"));
        topics.add(new MarkdownDoc("Markdown", new HtmlRenderer().render(this.loadMarkdownDoc()), "markdown"));
        return topics;
    }

    private List<DocSection> getLeftSections() {
        return Arrays.asList(this.getPrimitivesSection(), this.getByteBufSection(), this.getRegexSection(), this.getMathSection(), this.getTransducersSection(), this.getFunctionsSection(), this.getMacrosSection(), this.getSpecialFormsSection(), this.getExceptionsSection(), this.getTypesSection(), this.getProtocolsSection(), this.getNamespaceSection(), this.getJavaInteropSection(), this.getReplSection(), this.getPdfSection(), this.getIOZipSection());
    }

    private List<DocSection> getRightSections() {
        return Arrays.asList(this.getCollectionsSection(), this.getLazySequencesSection(), this.getArraysSection(), this.getConcurrencySection(), this.getSystemSection(), this.getSystemVarSection(), this.getTimeSection(), this.getIOSection(), this.getIOFileSection(), this.getJsonSection(), this.getCidrSection(), this.getAppSection(), this.getCsvSection());
    }

    private List<DocSection> getModulesLeftSections() {
        return Arrays.asList(this.getModuleKiraSection(), this.getModuleCryptographySection(), this.getModuleXmlSection(), this.getModuleJavaSection(), this.getModuleParsifalSection(), this.getModuleGradleSection(), this.getModuleMavenSection(), this.getModuleTracingSection(), this.getModuleShellSection(), this.getModuleAnsiSection());
    }

    private List<DocSection> getModulesRightSections() {
        return Arrays.asList(this.getModuleHexdumpSection(), this.getModuleSemverSection(), this.getModuleGeoipSection(), this.getModuleExcelSection(), this.getModuleConfigSection(), this.getModuleComponentSection(), this.getModuleAppSection(), this.getModuleBenchmarkSection());
    }

    private List<DocItem> getDocItems(List<DocSection> sections) {
        return sections.stream().map(s -> s.getSections()).flatMap(Collection::stream).map(s -> s.getSections()).flatMap(Collection::stream).map(s -> s.getItems()).flatMap(Collection::stream).filter(i -> !StringUtil.isBlank(i.getName())).distinct().sorted(Comparator.comparing(DocItem::getName)).collect(Collectors.toList());
    }

    private DocSection getPrimitivesSection() {
        DocSection section = new DocSection("Primitives", "primitives");
        DocSection lit = new DocSection("Literals", "primitives.literals");
        section.addSection(lit);
        lit.addLiteralItem("Nil", "nil", this.id());
        lit.addLiteralItem("Boolean", "true, false", this.id());
        lit.addLiteralItem("Integer", "150I, 1_000_000I, 0x1FFI", this.id());
        lit.addLiteralItem("Long", "1500, 1_000_000, 0x00A055FF", this.id());
        lit.addLiteralItem("Double", "3.569, 2.0E+10", this.id());
        lit.addLiteralItem("BigDecimal", "6.897M, 2.345E+10M", this.id());
        lit.addLiteralItem("BigInteger", "1000N, 1_000_000N", this.id());
        lit.addLiteralItem("Char", "#\\A, #\\\u03c0, #\\u03C0", this.id());
        lit.addLiteralItem("", "#\\space, #\\newline, #\\return, #\\tab, #\\formfeed, #\\backspace, #\\lparen, #\\rparen, #\\quote", this.id());
        lit.addLiteralItem("String", "\"abcd\", \"ab\\\"cd\", \"PI: \\u03C0\"", this.id());
        lit.addLiteralItem("", "\"\"\"{ \"age\": 42 }\"\"\"", this.id());
        lit.addLiteralItem("String interpolation", "\"~{x}\", \"\"\"~{x}\"\"\"", this.id());
        lit.addLiteralItem("", "\"~(inc x)\", \"\"\"~(inc x)\"\"\"", this.id());
        DocSection numbers = new DocSection("Numbers", "primitives.numbers");
        section.addSection(numbers);
        DocSection arithmetic = new DocSection("Arithmetic", "primitives.arithmetic");
        numbers.addSection(arithmetic);
        arithmetic.addItem(this.getDocItem("+"));
        arithmetic.addItem(this.getDocItem("-"));
        arithmetic.addItem(this.getDocItem("*"));
        arithmetic.addItem(this.getDocItem("/"));
        DocSection convert = new DocSection("Convert", "primitives.convert");
        numbers.addSection(convert);
        convert.addItem(this.getDocItem("int"));
        convert.addItem(this.getDocItem("long"));
        convert.addItem(this.getDocItem("double"));
        convert.addItem(this.getDocItem("decimal"));
        convert.addItem(this.getDocItem("bigint"));
        DocSection compare = new DocSection("Compare", "primitives.compare");
        numbers.addSection(compare);
        compare.addItem(this.getDocItem("=="));
        compare.addItem(this.getDocItem("="));
        compare.addItem(this.getDocItem("<"));
        compare.addItem(this.getDocItem(">"));
        compare.addItem(this.getDocItem("<="));
        compare.addItem(this.getDocItem(">="));
        compare.addItem(this.getDocItem("compare"));
        DocSection test = new DocSection("Test", "primitives.test");
        numbers.addSection(test);
        test.addItem(this.getDocItem("zero?"));
        test.addItem(this.getDocItem("pos?"));
        test.addItem(this.getDocItem("neg?"));
        test.addItem(this.getDocItem("even?"));
        test.addItem(this.getDocItem("odd?"));
        test.addItem(this.getDocItem("number?"));
        test.addItem(this.getDocItem("int?"));
        test.addItem(this.getDocItem("long?"));
        test.addItem(this.getDocItem("double?"));
        test.addItem(this.getDocItem("decimal?"));
        DocSection nan = new DocSection("NaN/Infinite", "primitives.nan");
        numbers.addSection(nan);
        nan.addItem(this.getDocItem("nan?"));
        nan.addItem(this.getDocItem("infinite?"));
        DocSection bigdecimal = new DocSection("BigDecimal", "primitives.bigdecimal");
        numbers.addSection(bigdecimal);
        bigdecimal.addItem(this.getDocItem("dec/add"));
        bigdecimal.addItem(this.getDocItem("dec/sub"));
        bigdecimal.addItem(this.getDocItem("dec/mul"));
        bigdecimal.addItem(this.getDocItem("dec/div"));
        bigdecimal.addItem(this.getDocItem("dec/scale"));
        DocSection strings = new DocSection("Strings", "primitives.strings");
        section.addSection(strings);
        DocSection create = new DocSection("Create", "primitives.strings.create");
        strings.addSection(create);
        create.addItem(this.getDocItem("str"));
        create.addItem(this.getDocItem("str/format"));
        create.addItem(this.getDocItem("str/quote"));
        create.addItem(this.getDocItem("str/double-quote"));
        create.addItem(this.getDocItem("str/double-unquote"));
        DocSection use = new DocSection("Use", "primitives.strings.use");
        strings.addSection(use);
        use.addItem(this.getDocItem("count"));
        use.addItem(this.getDocItem("compare"));
        use.addItem(this.getDocItem("empty-to-nil"));
        use.addItem(this.getDocItem("first"));
        use.addItem(this.getDocItem("last"));
        use.addItem(this.getDocItem("nth"));
        use.addItem(this.getDocItem("nfirst"));
        use.addItem(this.getDocItem("nlast"));
        use.addItem(this.getDocItem("seq"));
        use.addItem(this.getDocItem("rest"));
        use.addItem(this.getDocItem("butlast"));
        use.addItem(this.getDocItem("reverse"));
        use.addItem(this.getDocItem("shuffle"));
        use.addItem(this.getDocItem("str/index-of"));
        use.addItem(this.getDocItem("str/last-index-of"));
        use.addItem(this.getDocItem("str/subs"));
        use.addItem(this.getDocItem("str/nfirst"));
        use.addItem(this.getDocItem("str/nlast"));
        use.addItem(this.getDocItem("str/rest"));
        use.addItem(this.getDocItem("str/butlast"));
        use.addItem(this.getDocItem("str/chars"));
        use.addItem(this.getDocItem("str/pos"));
        use.addItem(this.getDocItem("str/repeat"));
        use.addItem(this.getDocItem("str/reverse"));
        use.addItem(this.getDocItem("str/truncate"));
        use.addItem(this.getDocItem("str/expand"));
        use.addItem(this.getDocItem("str/lorem-ipsum"));
        DocSection split = new DocSection("Split/Join", "primitives.strings.splitjoin");
        strings.addSection(split);
        split.addItem(this.getDocItem("str/split"));
        split.addItem(this.getDocItem("str/split-lines"));
        split.addItem(this.getDocItem("str/join"));
        DocSection replace = new DocSection("Replace", "primitives.strings.replace");
        strings.addSection(replace);
        replace.addItem(this.getDocItem("str/replace-first"));
        replace.addItem(this.getDocItem("str/replace-last"));
        replace.addItem(this.getDocItem("str/replace-all"));
        DocSection strip = new DocSection("Strip", "primitives.strings.strip");
        strings.addSection(strip);
        strip.addItem(this.getDocItem("str/strip-start"));
        strip.addItem(this.getDocItem("str/strip-end"));
        strip.addItem(this.getDocItem("str/strip-indent"));
        strip.addItem(this.getDocItem("str/strip-margin"));
        DocSection conv = new DocSection("Conversion", "primitives.strings.conversion");
        strings.addSection(conv);
        conv.addItem(this.getDocItem("str/lower-case"));
        conv.addItem(this.getDocItem("str/upper-case"));
        conv.addItem(this.getDocItem("str/cr-lf", false));
        DocSection regex = new DocSection("Regex", "primitives.strings.regex");
        strings.addSection(regex);
        regex.addItem(this.getDocItem("match?"));
        regex.addItem(this.getDocItem("not-match?"));
        DocSection trim = new DocSection("Trim", "primitives.strings.trim");
        strings.addSection(trim);
        trim.addItem(this.getDocItem("str/trim"));
        trim.addItem(this.getDocItem("str/trim-to-nil"));
        trim.addItem(this.getDocItem("str/trim-left"));
        trim.addItem(this.getDocItem("str/trim-right"));
        DocSection hex = new DocSection("Hex", "primitives.strings.hex");
        strings.addSection(hex);
        hex.addItem(this.getDocItem("str/hex-to-bytebuf"));
        hex.addItem(this.getDocItem("str/bytebuf-to-hex"));
        hex.addItem(this.getDocItem("str/format-bytebuf"));
        DocSection encode = new DocSection("Encode/Decode", "primitives.strings.encode");
        strings.addSection(encode);
        encode.addItem(this.getDocItem("str/encode-base64"));
        encode.addItem(this.getDocItem("str/decode-base64"));
        encode.addItem(this.getDocItem("str/encode-url"));
        encode.addItem(this.getDocItem("str/decode-url"));
        encode.addItem(this.getDocItem("str/escape-html"));
        encode.addItem(this.getDocItem("str/escape-xml"));
        DocSection validation = new DocSection("Validation", "primitives.strings.validation");
        strings.addSection(validation);
        validation.addItem(this.getDocItem("str/valid-email-addr?"));
        DocSection str_test = new DocSection("Test", "primitives.strings.test");
        strings.addSection(str_test);
        str_test.addItem(this.getDocItem("string?"));
        str_test.addItem(this.getDocItem("empty?"));
        str_test.addItem(this.getDocItem("not-empty?"));
        str_test.addItem(this.getDocItem("str/blank?"));
        str_test.addItem(this.getDocItem("str/not-blank?"));
        str_test.addItem(this.getDocItem("str/starts-with?"));
        str_test.addItem(this.getDocItem("str/ends-with?"));
        str_test.addItem(this.getDocItem("str/contains?"));
        str_test.addItem(this.getDocItem("str/equals-ignore-case?"));
        str_test.addItem(this.getDocItem("str/quoted?"));
        str_test.addItem(this.getDocItem("str/double-quoted?"));
        DocSection str_test_char = new DocSection("Test char", "primitives.strings.testchar");
        strings.addSection(str_test_char);
        str_test_char.addItem(this.getDocItem("str/char?"));
        str_test_char.addItem(this.getDocItem("str/digit?"));
        str_test_char.addItem(this.getDocItem("str/hexdigit?"));
        str_test_char.addItem(this.getDocItem("str/letter?"));
        str_test_char.addItem(this.getDocItem("str/whitespace?"));
        str_test_char.addItem(this.getDocItem("str/linefeed?"));
        str_test_char.addItem(this.getDocItem("str/lower-case?"));
        str_test_char.addItem(this.getDocItem("str/upper-case?"));
        DocSection str_leven_char = new DocSection("Other", "primitives.strings.other");
        strings.addSection(str_leven_char);
        str_leven_char.addItem(this.getDocItem("str/levenshtein"));
        DocSection chars = new DocSection("Chars", "primitives.chars");
        section.addSection(chars);
        DocSection charuse = new DocSection("Use", this.id());
        chars.addSection(charuse);
        charuse.addItem(this.getDocItem("char"));
        charuse.addItem(this.getDocItem("char?"));
        charuse.addItem(this.getDocItem("char-literals", false));
        DocSection charconv = new DocSection("Conversion", "primitives.chars.conversion");
        chars.addSection(charconv);
        charconv.addItem(this.getDocItem("str"));
        charconv.addItem(this.getDocItem("str/lower-case"));
        charconv.addItem(this.getDocItem("str/upper-case"));
        DocSection chartest = new DocSection("Test char", "primitives.chars.test");
        chars.addSection(chartest);
        chartest.addItem(this.getDocItem("str/char?"));
        chartest.addItem(this.getDocItem("str/digit?"));
        chartest.addItem(this.getDocItem("str/letter?"));
        chartest.addItem(this.getDocItem("str/whitespace?"));
        chartest.addItem(this.getDocItem("str/linefeed?"));
        chartest.addItem(this.getDocItem("str/lower-case?"));
        chartest.addItem(this.getDocItem("str/upper-case?"));
        DocSection other = new DocSection("Other", "primitives.other");
        section.addSection(other);
        DocSection nil = new DocSection("Nil", this.id());
        other.addSection(nil);
        nil.addItem(this.getDocItem("nil?"));
        nil.addItem(this.getDocItem("some?"));
        DocSection keywords = new DocSection("Keywords", "primitives.other.keywords");
        other.addSection(keywords);
        keywords.addItem(new DocItem(":a :blue", null));
        keywords.addItem(this.getDocItem("keyword?"));
        keywords.addItem(this.getDocItem("keyword"));
        DocSection symbols = new DocSection("Symbols", "primitives.other.symbols");
        other.addSection(symbols);
        symbols.addItem(new DocItem("'a 'blue", null));
        symbols.addItem(this.getDocItem("symbol?"));
        symbols.addItem(this.getDocItem("symbol"));
        DocSection just = new DocSection("Just", "primitives.other.just");
        other.addSection(just);
        just.addItem(this.getDocItem("just"));
        just.addItem(this.getDocItem("just?"));
        DocSection boolean_ = new DocSection("Boolean", "primitives.other.boolean");
        other.addSection(boolean_);
        boolean_.addItem(this.getDocItem("boolean"));
        boolean_.addItem(this.getDocItem("not"));
        boolean_.addItem(this.getDocItem("boolean?"));
        boolean_.addItem(this.getDocItem("true?"));
        boolean_.addItem(this.getDocItem("false?"));
        return section;
    }

    private DocSection getCollectionsSection() {
        DocSection section = new DocSection("Collections", "collections");
        DocSection collections = new DocSection("Collections", "collections.collections");
        section.addSection(collections);
        DocSection generic = new DocSection("Generic", "collections.collections.generic");
        collections.addSection(generic);
        generic.addItem(this.getDocItem("count"));
        generic.addItem(this.getDocItem("compare"));
        generic.addItem(this.getDocItem("empty-to-nil"));
        generic.addItem(this.getDocItem("empty"));
        generic.addItem(this.getDocItem("into"));
        generic.addItem(this.getDocItem("cons"));
        generic.addItem(this.getDocItem("conj"));
        generic.addItem(this.getDocItem("remove"));
        generic.addItem(this.getDocItem("repeat"));
        generic.addItem(this.getDocItem("repeatedly"));
        generic.addItem(this.getDocItem("cycle"));
        generic.addItem(this.getDocItem("replace"));
        generic.addItem(this.getDocItem("range"));
        generic.addItem(this.getDocItem("group-by"));
        generic.addItem(this.getDocItem("frequencies"));
        generic.addItem(this.getDocItem("get-in"));
        generic.addItem(this.getDocItem("seq"));
        generic.addItem(this.getDocItem("reverse"));
        generic.addItem(this.getDocItem("shuffle"));
        DocSection coll_test = new DocSection("Tests", "collections.collections.tests");
        collections.addSection(coll_test);
        coll_test.addItem(this.getDocItem("empty?"));
        coll_test.addItem(this.getDocItem("not-empty?"));
        coll_test.addItem(this.getDocItem("coll?"));
        coll_test.addItem(this.getDocItem("list?"));
        coll_test.addItem(this.getDocItem("vector?"));
        coll_test.addItem(this.getDocItem("set?"));
        coll_test.addItem(this.getDocItem("sorted-set?"));
        coll_test.addItem(this.getDocItem("mutable-set?"));
        coll_test.addItem(this.getDocItem("map?"));
        coll_test.addItem(this.getDocItem("sequential?"));
        coll_test.addItem(this.getDocItem("hash-map?"));
        coll_test.addItem(this.getDocItem("ordered-map?"));
        coll_test.addItem(this.getDocItem("sorted-map?"));
        coll_test.addItem(this.getDocItem("mutable-map?"));
        coll_test.addItem(this.getDocItem("bytebuf?"));
        DocSection coll_process = new DocSection("Process", "collections.collections.process");
        collections.addSection(coll_process);
        coll_process.addItem(this.getDocItem("map"));
        coll_process.addItem(this.getDocItem("map-indexed"));
        coll_process.addItem(this.getDocItem("filter"));
        coll_process.addItem(this.getDocItem("reduce"));
        coll_process.addItem(this.getDocItem("keep"));
        coll_process.addItem(this.getDocItem("docoll"));
        DocSection lists = new DocSection("Lists", "collections.lists");
        section.addSection(lists);
        DocSection list_create = new DocSection("Create", "collections.lists.create");
        lists.addSection(list_create);
        list_create.addItem(this.getDocItem("()"));
        list_create.addItem(this.getDocItem("list"));
        list_create.addItem(this.getDocItem("list*"));
        list_create.addItem(this.getDocItem("mutable-list"));
        DocSection list_access = new DocSection("Access", "collections.lists.access");
        lists.addSection(list_access);
        list_access.addItem(this.getDocItem("first"));
        list_access.addItem(this.getDocItem("second"));
        list_access.addItem(this.getDocItem("third"));
        list_access.addItem(this.getDocItem("fourth"));
        list_access.addItem(this.getDocItem("nth"));
        list_access.addItem(this.getDocItem("last"));
        list_access.addItem(this.getDocItem("peek"));
        list_access.addItem(this.getDocItem("rest"));
        list_access.addItem(this.getDocItem("butlast"));
        list_access.addItem(this.getDocItem("nfirst"));
        list_access.addItem(this.getDocItem("nlast"));
        list_access.addItem(this.getDocItem("sublist"));
        list_access.addItem(this.getDocItem("some"));
        DocSection list_modify = new DocSection("Modify", "collections.lists.modify");
        lists.addSection(list_modify);
        list_modify.addItem(this.getDocItem("cons"));
        list_modify.addItem(this.getDocItem("conj"));
        list_modify.addItem(this.getDocItem("rest"));
        list_modify.addItem(this.getDocItem("pop"));
        list_modify.addItem(this.getDocItem("into"));
        list_modify.addItem(this.getDocItem("concat"));
        list_modify.addItem(this.getDocItem("distinct"));
        list_modify.addItem(this.getDocItem("dedupe"));
        list_modify.addItem(this.getDocItem("partition"));
        list_modify.addItem(this.getDocItem("partition-by"));
        list_modify.addItem(this.getDocItem("interpose"));
        list_modify.addItem(this.getDocItem("interleave"));
        list_modify.addItem(this.getDocItem("cartesian-product"));
        list_modify.addItem(this.getDocItem("combinations"));
        list_modify.addItem(this.getDocItem("mapcat"));
        list_modify.addItem(this.getDocItem("flatten"));
        list_modify.addItem(this.getDocItem("sort"));
        list_modify.addItem(this.getDocItem("sort-by"));
        list_modify.addItem(this.getDocItem("take"));
        list_modify.addItem(this.getDocItem("take-while"));
        list_modify.addItem(this.getDocItem("take-last"));
        list_modify.addItem(this.getDocItem("drop"));
        list_modify.addItem(this.getDocItem("drop-while"));
        list_modify.addItem(this.getDocItem("drop-last"));
        list_modify.addItem(this.getDocItem("split-at"));
        list_modify.addItem(this.getDocItem("split-with"));
        DocSection list_test = new DocSection("Test", "collections.lists.test");
        lists.addSection(list_test);
        list_test.addItem(this.getDocItem("list?"));
        list_test.addItem(this.getDocItem("mutable-list?"));
        list_test.addItem(this.getDocItem("every?"));
        list_test.addItem(this.getDocItem("not-every?"));
        list_test.addItem(this.getDocItem("any?"));
        list_test.addItem(this.getDocItem("not-any?"));
        DocSection vectors = new DocSection("Vectors", "collections.vectors");
        section.addSection(vectors);
        DocSection vec_create = new DocSection("Create", "collections.vectors.create");
        vectors.addSection(vec_create);
        vec_create.addItem(this.getDocItem("[]"));
        vec_create.addItem(this.getDocItem("vector"));
        vec_create.addItem(this.getDocItem("vector*"));
        vec_create.addItem(this.getDocItem("mutable-vector"));
        vec_create.addItem(this.getDocItem("mapv"));
        DocSection vec_access = new DocSection("Access", "collections.vectors.access");
        vectors.addSection(vec_access);
        vec_access.addItem(this.getDocItem("first"));
        vec_access.addItem(this.getDocItem("second"));
        vec_access.addItem(this.getDocItem("third"));
        vec_access.addItem(this.getDocItem("nth"));
        vec_access.addItem(this.getDocItem("last"));
        vec_access.addItem(this.getDocItem("peek"));
        vec_access.addItem(this.getDocItem("butlast"));
        vec_access.addItem(this.getDocItem("rest"));
        vec_access.addItem(this.getDocItem("nfirst"));
        vec_access.addItem(this.getDocItem("nlast"));
        vec_access.addItem(this.getDocItem("subvec"));
        vec_access.addItem(this.getDocItem("some"));
        DocSection vec_modify = new DocSection("Modify", "collections.vectors.modify");
        vectors.addSection(vec_modify);
        vec_modify.addItem(this.getDocItem("cons"));
        vec_modify.addItem(this.getDocItem("conj"));
        vec_modify.addItem(this.getDocItem("rest"));
        vec_modify.addItem(this.getDocItem("pop"));
        vec_modify.addItem(this.getDocItem("into"));
        vec_modify.addItem(this.getDocItem("concat"));
        vec_modify.addItem(this.getDocItem("distinct"));
        vec_modify.addItem(this.getDocItem("dedupe"));
        vec_modify.addItem(this.getDocItem("partition"));
        vec_modify.addItem(this.getDocItem("partition-by"));
        vec_modify.addItem(this.getDocItem("interpose"));
        vec_modify.addItem(this.getDocItem("interleave"));
        vec_modify.addItem(this.getDocItem("cartesian-product"));
        vec_modify.addItem(this.getDocItem("combinations"));
        vec_modify.addItem(this.getDocItem("mapcat"));
        vec_modify.addItem(this.getDocItem("flatten"));
        vec_modify.addItem(this.getDocItem("sort"));
        vec_modify.addItem(this.getDocItem("sort-by"));
        vec_modify.addItem(this.getDocItem("take"));
        vec_modify.addItem(this.getDocItem("take-while"));
        vec_modify.addItem(this.getDocItem("take-last"));
        vec_modify.addItem(this.getDocItem("drop"));
        vec_modify.addItem(this.getDocItem("drop-while"));
        vec_modify.addItem(this.getDocItem("drop-last"));
        vec_modify.addItem(this.getDocItem("update"));
        vec_modify.addItem(this.getDocItem("update!"));
        vec_modify.addItem(this.getDocItem("assoc"));
        vec_modify.addItem(this.getDocItem("assoc!"));
        vec_modify.addItem(this.getDocItem("split-with"));
        DocSection vec_nested = new DocSection("Nested", "collections.vectors.nested");
        vectors.addSection(vec_nested);
        vec_nested.addItem(this.getDocItem("get-in"));
        vec_nested.addItem(this.getDocItem("assoc-in"));
        vec_nested.addItem(this.getDocItem("update-in"));
        vec_nested.addItem(this.getDocItem("dissoc-in"));
        DocSection vec_test = new DocSection("Test", "collections.vectors.test");
        vectors.addSection(vec_test);
        vec_test.addItem(this.getDocItem("vector?"));
        vec_test.addItem(this.getDocItem("mutable-vector?"));
        vec_test.addItem(this.getDocItem("contains?"));
        vec_test.addItem(this.getDocItem("not-contains?"));
        vec_test.addItem(this.getDocItem("every?"));
        vec_test.addItem(this.getDocItem("not-every?"));
        vec_test.addItem(this.getDocItem("any?"));
        vec_test.addItem(this.getDocItem("not-any?"));
        DocSection sets = new DocSection("Sets", "collections.sets");
        section.addSection(sets);
        DocSection set_create = new DocSection("Create", "collections.sets.create");
        sets.addSection(set_create);
        set_create.addItem(this.getDocItem("#{}"));
        set_create.addItem(this.getDocItem("set"));
        set_create.addItem(this.getDocItem("sorted-set"));
        set_create.addItem(this.getDocItem("mutable-set"));
        DocSection set_modify = new DocSection("Modify", "collections.sets.modify");
        sets.addSection(set_modify);
        set_modify.addItem(this.getDocItem("cons"));
        set_modify.addItem(this.getDocItem("cons!"));
        set_modify.addItem(this.getDocItem("conj"));
        set_modify.addItem(this.getDocItem("conj!"));
        set_modify.addItem(this.getDocItem("disj"));
        DocSection algebra = new DocSection("Algebra", "collections.sets.algebra");
        sets.addSection(algebra);
        algebra.addItem(this.getDocItem("difference"));
        algebra.addItem(this.getDocItem("union"));
        algebra.addItem(this.getDocItem("intersection"));
        algebra.addItem(this.getDocItem("subset?"));
        algebra.addItem(this.getDocItem("superset?"));
        DocSection set_test = new DocSection("Test", "collections.sets.test");
        sets.addSection(set_test);
        set_test.addItem(this.getDocItem("set?"));
        set_test.addItem(this.getDocItem("sorted-set?"));
        set_test.addItem(this.getDocItem("mutable-set?"));
        set_test.addItem(this.getDocItem("contains?"));
        set_test.addItem(this.getDocItem("not-contains?"));
        set_test.addItem(this.getDocItem("every?"));
        set_test.addItem(this.getDocItem("not-every?"));
        set_test.addItem(this.getDocItem("any?"));
        set_test.addItem(this.getDocItem("not-any?"));
        DocSection maps = new DocSection("Maps", "collections.maps");
        section.addSection(maps);
        DocSection maps_create = new DocSection("Create", "collections.maps.create");
        maps.addSection(maps_create);
        maps_create.addItem(this.getDocItem("{}"));
        maps_create.addItem(this.getDocItem("hash-map"));
        maps_create.addItem(this.getDocItem("ordered-map"));
        maps_create.addItem(this.getDocItem("sorted-map"));
        maps_create.addItem(this.getDocItem("mutable-map"));
        maps_create.addItem(this.getDocItem("zipmap"));
        DocSection map_access = new DocSection("Access", "collections.maps.access");
        maps.addSection(map_access);
        map_access.addItem(this.getDocItem("find"));
        map_access.addItem(this.getDocItem("get"));
        map_access.addItem(this.getDocItem("keys"));
        map_access.addItem(this.getDocItem("vals"));
        DocSection map_modify = new DocSection("Modify", "collections.maps.modify");
        maps.addSection(map_modify);
        map_modify.addItem(this.getDocItem("cons"));
        map_modify.addItem(this.getDocItem("conj"));
        map_modify.addItem(this.getDocItem("assoc"));
        map_modify.addItem(this.getDocItem("assoc!"));
        map_modify.addItem(this.getDocItem("update"));
        map_modify.addItem(this.getDocItem("update!"));
        map_modify.addItem(this.getDocItem("dissoc"));
        map_modify.addItem(this.getDocItem("dissoc!"));
        map_modify.addItem(this.getDocItem("into"));
        map_modify.addItem(this.getDocItem("concat"));
        map_modify.addItem(this.getDocItem("flatten"));
        map_modify.addItem(this.getDocItem("filter-k"));
        map_modify.addItem(this.getDocItem("filter-kv"));
        map_modify.addItem(this.getDocItem("reduce-kv"));
        map_modify.addItem(this.getDocItem("merge"));
        map_modify.addItem(this.getDocItem("merge-with"));
        map_modify.addItem(this.getDocItem("merge-deep"));
        map_modify.addItem(this.getDocItem("map-invert"));
        map_modify.addItem(this.getDocItem("map-keys"));
        map_modify.addItem(this.getDocItem("map-vals"));
        map_modify.addItem(this.getDocItem("select-keys"));
        DocSection map_entries = new DocSection("Entries", "collections.maps.entries");
        maps.addSection(map_entries);
        map_entries.addItem(this.getDocItem("map-entry"));
        map_entries.addItem(this.getDocItem("key"));
        map_entries.addItem(this.getDocItem("val"));
        map_entries.addItem(this.getDocItem("entries"));
        map_entries.addItem(this.getDocItem("map-entry?"));
        DocSection map_nested = new DocSection("Nested", "collections.maps.nested");
        maps.addSection(map_nested);
        map_nested.addItem(this.getDocItem("get-in"));
        map_nested.addItem(this.getDocItem("assoc-in"));
        map_nested.addItem(this.getDocItem("update-in"));
        map_nested.addItem(this.getDocItem("dissoc-in"));
        DocSection map_test = new DocSection("Test", "collections.maps.test");
        maps.addSection(map_test);
        map_test.addItem(this.getDocItem("map?"));
        map_test.addItem(this.getDocItem("sequential?"));
        map_test.addItem(this.getDocItem("hash-map?"));
        map_test.addItem(this.getDocItem("ordered-map?"));
        map_test.addItem(this.getDocItem("sorted-map?"));
        map_test.addItem(this.getDocItem("mutable-map?"));
        map_test.addItem(this.getDocItem("contains?"));
        map_test.addItem(this.getDocItem("not-contains?"));
        DocSection stacks = new DocSection("Stack", "collections.stack");
        section.addSection(stacks);
        DocSection stacks_create = new DocSection("Create", "collections.stack.create");
        stacks.addSection(stacks_create);
        stacks_create.addItem(this.getDocItem("stack"));
        DocSection stacks_access = new DocSection("Access", "collections.stack.access");
        stacks.addSection(stacks_access);
        stacks_access.addItem(this.getDocItem("peek"));
        stacks_access.addItem(this.getDocItem("pop!"));
        stacks_access.addItem(this.getDocItem("push!"));
        stacks_access.addItem(this.getDocItem("count"));
        DocSection stacks_test = new DocSection("Test", "collections.stack.test");
        stacks.addSection(stacks_test);
        stacks_test.addItem(this.getDocItem("empty?"));
        stacks_test.addItem(this.getDocItem("stack?"));
        DocSection queues = new DocSection("Queue", "collections.queue");
        section.addSection(queues);
        DocSection queues_create = new DocSection("Create", "collections.queue.create");
        queues.addSection(queues_create);
        queues_create.addItem(this.getDocItem("queue"));
        DocSection queues_access = new DocSection("Access", "collections.queue.access");
        queues.addSection(queues_access);
        queues_access.addItem(this.getDocItem("peek"));
        queues_access.addItem(this.getDocItem("poll!"));
        queues_access.addItem(this.getDocItem("offer!"));
        queues_access.addItem(this.getDocItem("count"));
        DocSection queues_test = new DocSection("Test", "collections.queue.test");
        queues.addSection(queues_test);
        queues_test.addItem(this.getDocItem("empty?"));
        queues_test.addItem(this.getDocItem("queue?"));
        DocSection dag = new DocSection("DAG", "directed acyclic graph", "collections.dag");
        section.addSection(dag);
        DocSection dag_create = new DocSection("Create", "collections.dag.create");
        dag.addSection(dag_create);
        dag_create.addItem(this.getDocItem("dag/dag"));
        dag_create.addItem(this.getDocItem("dag/add-edges"));
        dag_create.addItem(this.getDocItem("dag/add-nodes"));
        DocSection dag_access = new DocSection("Access", "collections.dag.access");
        dag.addSection(dag_access);
        dag_access.addItem(this.getDocItem("dag/nodes"));
        dag_access.addItem(this.getDocItem("dag/edges"));
        dag_access.addItem(this.getDocItem("dag/roots"));
        dag_access.addItem(this.getDocItem("count"));
        DocSection dag_children = new DocSection("Children", "collections.dag.children");
        dag.addSection(dag_children);
        dag_children.addItem(this.getDocItem("dag/children"));
        dag_children.addItem(this.getDocItem("dag/direct-children"));
        DocSection dag_parents = new DocSection("Parents", "collections.dag.parents");
        dag.addSection(dag_parents);
        dag_parents.addItem(this.getDocItem("dag/parents"));
        dag_parents.addItem(this.getDocItem("dag/direct-parents"));
        DocSection dag_sort = new DocSection("Sort", "collections.dag.sort");
        dag.addSection(dag_sort);
        dag_sort.addItem(this.getDocItem("dag/topological-sort"));
        dag_sort.addItem(this.getDocItem("dag/compare-fn"));
        DocSection dag_test = new DocSection("Test", "collections.dag.test");
        dag.addSection(dag_test);
        dag_test.addItem(this.getDocItem("dag/dag?"));
        dag_test.addItem(this.getDocItem("dag/node?"));
        dag_test.addItem(this.getDocItem("dag/parent-of?"));
        dag_test.addItem(this.getDocItem("dag/child-of?"));
        dag_test.addItem(this.getDocItem("empty?"));
        return section;
    }

    private DocSection getLazySequencesSection() {
        DocSection section = new DocSection("Lazy Sequences", "lazyseq");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection create = new DocSection("Create", "lazyseq.create");
        all.addSection(create);
        create.addItem(this.getDocItem("lazy-seq"));
        DocSection realize = new DocSection("Realize", "lazyseq.realize");
        all.addSection(realize);
        realize.addItem(this.getDocItem("doall"));
        DocSection test = new DocSection("Test", "lazyseq.test");
        all.addSection(test);
        test.addItem(this.getDocItem("lazy-seq?"));
        return section;
    }

    private DocSection getArraysSection() {
        DocSection section = new DocSection("Arrays", "arrays");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection create = new DocSection("Create", "arrays.create");
        all.addSection(create);
        create.addItem(this.getDocItem("make-array"));
        create.addItem(this.getDocItem("object-array"));
        create.addItem(this.getDocItem("string-array"));
        create.addItem(this.getDocItem("int-array"));
        create.addItem(this.getDocItem("long-array"));
        create.addItem(this.getDocItem("float-array"));
        create.addItem(this.getDocItem("double-array"));
        DocSection use = new DocSection("Use", "arrays.use");
        all.addSection(use);
        use.addItem(this.getDocItem("aget"));
        use.addItem(this.getDocItem("aset"));
        use.addItem(this.getDocItem("alength"));
        use.addItem(this.getDocItem("asub"));
        use.addItem(this.getDocItem("acopy"));
        use.addItem(this.getDocItem("amap"));
        return section;
    }

    private DocSection getRegexSection() {
        DocSection section = new DocSection("Regex", "regex");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection general = new DocSection("General", "regex.general");
        all.addSection(general);
        general.addItem(this.getDocItem("regex/pattern"));
        general.addItem(this.getDocItem("regex/matcher"));
        general.addItem(this.getDocItem("regex/reset"));
        general.addItem(this.getDocItem("regex/matches?"));
        general.addItem(this.getDocItem("regex/matches"));
        general.addItem(this.getDocItem("regex/group"));
        general.addItem(this.getDocItem("regex/count"));
        general.addItem(this.getDocItem("regex/find?"));
        general.addItem(this.getDocItem("regex/find"));
        general.addItem(this.getDocItem("regex/find-all"));
        general.addItem(this.getDocItem("regex/find+"));
        general.addItem(this.getDocItem("regex/find-all+"));
        return section;
    }

    private DocSection getMathSection() {
        DocSection section = new DocSection("Math", "math");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection constants = new DocSection("Constants", "math.constants");
        section.addSection(constants);
        constants.addLiteralItem("E", "math/E", this.id());
        constants.addLiteralItem("PI", "math/PI", this.id());
        DocSection arithmetic = new DocSection("Arithmetic", "math.arithmetic");
        all.addSection(arithmetic);
        arithmetic.addItem(this.getDocItem("mod"));
        arithmetic.addItem(this.getDocItem("inc"));
        arithmetic.addItem(this.getDocItem("dec"));
        arithmetic.addItem(this.getDocItem("min"));
        arithmetic.addItem(this.getDocItem("max"));
        arithmetic.addItem(this.getDocItem("abs"));
        arithmetic.addItem(this.getDocItem("sgn"));
        arithmetic.addItem(this.getDocItem("negate"));
        arithmetic.addItem(this.getDocItem("floor"));
        arithmetic.addItem(this.getDocItem("ceil"));
        arithmetic.addItem(this.getDocItem("sqrt"));
        arithmetic.addItem(this.getDocItem("square"));
        arithmetic.addItem(this.getDocItem("pow"));
        arithmetic.addItem(this.getDocItem("exp"));
        arithmetic.addItem(this.getDocItem("log"));
        arithmetic.addItem(this.getDocItem("log10"));
        DocSection util = new DocSection("Util", "math.util");
        all.addSection(util);
        util.addItem(this.getDocItem("digits"));
        DocSection random = new DocSection("Random", "math.random");
        all.addSection(random);
        random.addItem(this.getDocItem("rand-long"));
        random.addItem(this.getDocItem("rand-double"));
        random.addItem(this.getDocItem("rand-gaussian"));
        DocSection trigonometry = new DocSection("Trigonometry", "math.trigonometry");
        all.addSection(trigonometry);
        trigonometry.addItem(this.getDocItem("math/to-radians"));
        trigonometry.addItem(this.getDocItem("math/to-degrees"));
        trigonometry.addItem(this.getDocItem("math/sin"));
        trigonometry.addItem(this.getDocItem("math/cos"));
        trigonometry.addItem(this.getDocItem("math/tan"));
        trigonometry.addItem(this.getDocItem("math/asin"));
        trigonometry.addItem(this.getDocItem("math/acos"));
        trigonometry.addItem(this.getDocItem("math/atan"));
        DocSection statistics = new DocSection("Statistics", "math.statistics");
        all.addSection(statistics);
        statistics.addItem(this.getDocItem("math/mean"));
        statistics.addItem(this.getDocItem("math/median"));
        statistics.addItem(this.getDocItem("math/quartiles"));
        statistics.addItem(this.getDocItem("math/quantile"));
        statistics.addItem(this.getDocItem("math/standard-deviation"));
        DocSection algo = new DocSection("Algorithms", "math.algo");
        all.addSection(algo);
        algo.addItem(this.getDocItem("math/softmax"));
        return section;
    }

    private DocSection getFunctionsSection() {
        DocSection section = new DocSection("Functions", "functions");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection create = new DocSection("Create", "functions.create");
        all.addSection(create);
        create.addItem(this.getDocItem("fn"));
        create.addItem(this.getDocItem("defn"));
        create.addItem(this.getDocItem("defn-"));
        create.addItem(this.getDocItem("identity"));
        create.addItem(this.getDocItem("comp"));
        create.addItem(this.getDocItem("partial"));
        create.addItem(this.getDocItem("memoize"));
        create.addItem(this.getDocItem("juxt"));
        create.addItem(this.getDocItem("fnil"));
        create.addItem(this.getDocItem("trampoline"));
        create.addItem(this.getDocItem("complement"));
        create.addItem(this.getDocItem("constantly"));
        create.addItem(this.getDocItem("every-pred"));
        create.addItem(this.getDocItem("any-pred"));
        DocSection call = new DocSection("Call", "functions.call");
        all.addSection(call);
        call.addItem(this.getDocItem("apply"));
        call.addItem(this.getDocItem("->"));
        call.addItem(this.getDocItem("->>"));
        DocSection test = new DocSection("Test", "functions.test");
        all.addSection(test);
        test.addItem(this.getDocItem("fn?"));
        DocSection misc = new DocSection("Misc", "functions.misc");
        all.addSection(misc);
        misc.addItem(this.getDocItem("nil?"));
        misc.addItem(this.getDocItem("some?"));
        misc.addItem(this.getDocItem("eval"));
        misc.addItem(this.getDocItem("name"));
        misc.addItem(this.getDocItem("namespace"));
        misc.addItem(this.getDocItem("fn-name"));
        misc.addItem(this.getDocItem("callstack"));
        misc.addItem(this.getDocItem("coalesce"));
        misc.addItem(this.getDocItem("load-resource"));
        DocSection env = new DocSection("Environment", "functions.environment");
        all.addSection(env);
        env.addItem(this.getDocItem("set!"));
        env.addItem(this.getDocItem("resolve"));
        env.addItem(this.getDocItem("bound?"));
        env.addItem(this.getDocItem("var-get"));
        env.addItem(this.getDocItem("var-name"));
        env.addItem(this.getDocItem("var-ns"));
        env.addItem(this.getDocItem("var-thread-local?"));
        env.addItem(this.getDocItem("var-local?"));
        env.addItem(this.getDocItem("var-global?"));
        env.addItem(this.getDocItem("name"));
        env.addItem(this.getDocItem("namespace"));
        DocSection walk = new DocSection("Tree Walker", "functions.treewalker");
        all.addSection(walk);
        walk.addItem(this.getDocItem("prewalk"));
        walk.addItem(this.getDocItem("postwalk"));
        walk.addItem(this.getDocItem("prewalk-replace"));
        walk.addItem(this.getDocItem("postwalk-replace"));
        DocSection meta = new DocSection("Meta", "functions.meta");
        all.addSection(meta);
        meta.addItem(this.getDocItem("meta"));
        meta.addItem(this.getDocItem("with-meta"));
        meta.addItem(this.getDocItem("vary-meta"));
        DocSection doc = new DocSection("Documentation", "functions.doc");
        all.addSection(doc);
        doc.addItem(this.getDocItem("doc", false));
        doc.addItem(this.getDocItem("modules"));
        DocSection def = new DocSection("Definiton", "functions.def");
        all.addSection(def);
        def.addItem(this.getDocItem("fn-body"));
        def.addItem(this.getDocItem("fn-pre-conditions"));
        DocSection syntax = new DocSection("Syntax", "functions.syntax");
        all.addSection(syntax);
        syntax.addItem(this.getDocItem("highlight"));
        return section;
    }

    private DocSection getMacrosSection() {
        DocSection section = new DocSection("Macros", "macros");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection create = new DocSection("Create", "macros.create");
        all.addSection(create);
        create.addItem(this.getDocItem("def-", false));
        create.addItem(this.getDocItem("defn"));
        create.addItem(this.getDocItem("defn-"));
        create.addItem(this.getDocItem("defmacro"));
        create.addItem(this.getDocItem("macroexpand"));
        create.addItem(this.getDocItem("macroexpand-all"));
        create.addItem(this.getDocItem("macro?"));
        DocSection test = new DocSection("Test", "macros.test");
        all.addSection(test);
        test.addItem(this.getDocItem("macro?"));
        DocSection quote = new DocSection("Quoting", "macros.quoting");
        all.addSection(quote);
        quote.addItem(this.getDocItem("quote"));
        quote.addItem(this.getDocItem("quasiquote"));
        DocSection branch = new DocSection("Branch", "macros.branch");
        all.addSection(branch);
        branch.addItem(this.getDocItem("and"));
        branch.addItem(this.getDocItem("or"));
        branch.addItem(this.getDocItem("when"));
        branch.addItem(this.getDocItem("when-not"));
        branch.addItem(this.getDocItem("if-not"));
        branch.addItem(this.getDocItem("if-let"));
        branch.addItem(this.getDocItem("when-let"));
        branch.addItem(this.getDocItem("letfn"));
        DocSection cond = new DocSection("Conditions", "macros.cond");
        all.addSection(cond);
        cond.addItem(this.getDocItem("cond"));
        cond.addItem(this.getDocItem("condp"));
        cond.addItem(this.getDocItem("case"));
        DocSection loop = new DocSection("Loop", "macros.loop");
        all.addSection(loop);
        loop.addItem(this.getDocItem("while"));
        loop.addItem(this.getDocItem("dotimes"));
        loop.addItem(this.getDocItem("list-comp"));
        loop.addItem(this.getDocItem("doseq"));
        DocSection call = new DocSection("Call", "macros.call");
        all.addSection(call);
        call.addItem(this.getDocItem("doto"));
        call.addItem(this.getDocItem("->"));
        call.addItem(this.getDocItem("->>"));
        call.addItem(this.getDocItem("-<>"));
        call.addItem(this.getDocItem("as->"));
        call.addItem(this.getDocItem("cond->"));
        call.addItem(this.getDocItem("cond->>"));
        call.addItem(this.getDocItem("some->"));
        call.addItem(this.getDocItem("some->>"));
        DocSection loading = new DocSection("Loading", "macros.loading");
        all.addSection(loading);
        loading.addItem(this.getDocItem("load-module"));
        loading.addItem(this.getDocItem("load-file", false));
        loading.addItem(this.getDocItem("load-classpath-file"));
        loading.addItem(this.getDocItem("load-string"));
        DocSection assert_ = new DocSection("Assert", "macros.assert");
        all.addSection(assert_);
        assert_.addItem(this.getDocItem("assert", true, true));
        DocSection util = new DocSection("Util", "macros.util");
        all.addSection(util);
        util.addItem(this.getDocItem("comment"));
        util.addItem(this.getDocItem("gensym"));
        util.addItem(this.getDocItem("time"));
        util.addItem(this.getDocItem("with-out-str"));
        util.addItem(this.getDocItem("with-err-str"));
        DocSection profil = new DocSection("Profiling", "macros.profiling");
        all.addSection(profil);
        profil.addItem(this.getDocItem("time"));
        profil.addItem(this.getDocItem("perf", false));
        return section;
    }

    private DocSection getSpecialFormsSection() {
        DocSection section = new DocSection("Special Forms", "specialforms");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection generic = new DocSection("Forms", "specialforms.forms");
        all.addSection(generic);
        generic.addItem(this.getDocItem("def"));
        generic.addItem(this.getDocItem("defonce"));
        generic.addItem(this.getDocItem("def-dynamic"));
        generic.addItem(this.getDocItem("if"));
        generic.addItem(this.getDocItem("do"));
        generic.addItem(this.getDocItem("let"));
        generic.addItem(this.getDocItem("binding"));
        generic.addItem(this.getDocItem("fn"));
        generic.addItem(this.getDocItem("set!"));
        DocSection multi = new DocSection("Multi Methods", "specialforms.multimethod");
        all.addSection(multi);
        multi.addItem(this.getDocItem("defmulti"));
        multi.addItem(this.getDocItem("defmethod"));
        DocSection proto = new DocSection("Protocols", "specialforms.protocol");
        all.addSection(proto);
        proto.addItem(this.getDocItem("defprotocol"));
        proto.addItem(this.getDocItem("extend"));
        proto.addItem(this.getDocItem("extends?"));
        DocSection recur = new DocSection("Recursion", "specialforms.recursion");
        all.addSection(recur);
        recur.addItem(this.getDocItem("loop"));
        recur.addItem(this.getDocItem("recur"));
        recur.addItem(this.getDocItem("tail-pos", true, true));
        DocSection ex = new DocSection("Exception", "specialforms.exception");
        all.addSection(ex);
        ex.addItem(this.getDocItem("throw", true, true));
        ex.addItem(this.getDocItem("try", true, true));
        ex.addItem(this.getDocItem("try-with", true, true));
        DocSection profiling = new DocSection("Profiling", "specialforms.profiling");
        all.addSection(profiling);
        profiling.addItem(this.getDocItem("dobench"));
        profiling.addItem(this.getDocItem("dorun"));
        profiling.addItem(this.getDocItem("prof"));
        return section;
    }

    private DocSection getExceptionsSection() {
        DocSection section = new DocSection("Exceptions", "exceptions");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection block = new DocSection("Throw/Catch", "exceptions.block");
        all.addSection(block);
        block.addItem(this.getDocItem("try", true, true));
        block.addItem(this.getDocItem("try-with", true, true));
        block.addItem(this.getDocItem("throw", true, true));
        DocSection create = new DocSection("Create", "exceptions.create");
        all.addSection(create);
        create.addItem(this.getDocItem("ex"));
        DocSection test = new DocSection("Test", "exceptions.test");
        all.addSection(test);
        test.addItem(this.getDocItem("ex?"));
        test.addItem(this.getDocItem("ex-venice?"));
        DocSection util = new DocSection("Util", "exceptions.util");
        all.addSection(util);
        util.addItem(this.getDocItem("ex-message"));
        util.addItem(this.getDocItem("ex-cause"));
        util.addItem(this.getDocItem("ex-value"));
        DocSection stacktrace = new DocSection("Stacktrace", "exceptions.stacktrace");
        all.addSection(stacktrace);
        stacktrace.addItem(this.getDocItem("ex-venice-stacktrace"));
        stacktrace.addItem(this.getDocItem("ex-java-stacktrace", false, true));
        return section;
    }

    private DocSection getSystemSection() {
        DocSection section = new DocSection("System", "system");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection venice = new DocSection("Venice", "system.venice");
        all.addSection(venice);
        venice.addItem(this.getDocItem("version"));
        venice.addItem(this.getDocItem("sandboxed?"));
        venice.addItem(this.getDocItem("sandbox-type"));
        DocSection system = new DocSection("System", "system.system");
        all.addSection(system);
        system.addItem(this.getDocItem("system-prop"));
        system.addItem(this.getDocItem("system-env"));
        system.addItem(this.getDocItem("system-exit-code"));
        system.addItem(this.getDocItem("charset-default-encoding"));
        DocSection java = new DocSection("Java", "system.java");
        all.addSection(java);
        java.addItem(this.getDocItem("java-version"));
        java.addItem(this.getDocItem("java-version-info"));
        java.addItem(this.getDocItem("java-major-version"));
        java.addItem(this.getDocItem("java-source-location", false));
        DocSection javaVM = new DocSection("Java VM", "system.java-vm");
        all.addSection(javaVM);
        javaVM.addItem(this.getDocItem("pid"));
        javaVM.addItem(this.getDocItem("gc"));
        javaVM.addItem(this.getDocItem("total-memory"));
        javaVM.addItem(this.getDocItem("used-memory"));
        DocSection os = new DocSection("OS", "system.os");
        all.addSection(os);
        os.addItem(this.getDocItem("os-type"));
        os.addItem(this.getDocItem("os-type?"));
        os.addItem(this.getDocItem("os-arch"));
        os.addItem(this.getDocItem("os-name"));
        os.addItem(this.getDocItem("os-version"));
        DocSection time = new DocSection("Time", "system.time");
        all.addSection(time);
        time.addItem(this.getDocItem("current-time-millis"));
        time.addItem(this.getDocItem("nano-time"));
        time.addItem(this.getDocItem("format-nano-time"));
        time.addItem(this.getDocItem("format-micro-time"));
        time.addItem(this.getDocItem("format-milli-time"));
        DocSection host = new DocSection("Host", "system.host");
        all.addSection(host);
        host.addItem(this.getDocItem("host-name"));
        host.addItem(this.getDocItem("host-address"));
        host.addItem(this.getDocItem("ip-private?"));
        host.addItem(this.getDocItem("cpus"));
        DocSection user = new DocSection("User", "system.user");
        all.addSection(user);
        user.addItem(this.getDocItem("user-name"));
        user.addItem(this.getDocItem("io/user-home-dir"));
        DocSection util = new DocSection("Util", "system.util");
        all.addSection(util);
        util.addItem(this.getDocItem("uuid"));
        util.addItem(this.getDocItem("sleep"));
        util.addItem(this.getDocItem("shutdown-hook"));
        DocSection shell = new DocSection("Shell", "system.shell");
        all.addSection(shell);
        shell.addItem(this.getDocItem("sh", false));
        shell.addItem(this.getDocItem("with-sh-dir", false));
        shell.addItem(this.getDocItem("with-sh-env", false));
        shell.addItem(this.getDocItem("with-sh-throw", false));
        DocSection tools = new DocSection("Shell Tools", "system.shell.tools");
        all.addSection(tools);
        tools.addItem(this.getDocItem("sh/open", false));
        tools.addItem(this.getDocItem("sh/pwd", false));
        return section;
    }

    private DocSection getTypesSection() {
        DocSection section = new DocSection("Types", "types");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection util = new DocSection("Util", "types.util");
        all.addSection(util);
        util.addItem(this.getDocItem("type"));
        util.addItem(this.getDocItem("supertype"));
        util.addItem(this.getDocItem("supertypes"));
        DocSection test = new DocSection("Test", "types.test");
        all.addSection(test);
        test.addItem(this.getDocItem("instance-of?"));
        test.addItem(this.getDocItem("deftype?"));
        DocSection define = new DocSection("Define", "types.define");
        all.addSection(define);
        define.addItem(this.getDocItem("deftype"));
        define.addItem(this.getDocItem("deftype-of"));
        define.addItem(this.getDocItem("deftype-or"));
        DocSection create = new DocSection("Create", "types.create");
        all.addSection(create);
        create.addItem(this.getDocItem(".:"));
        DocSection describe = new DocSection("Describe", "types.describe");
        all.addSection(describe);
        describe.addItem(this.getDocItem("deftype-describe"));
        return section;
    }

    private DocSection getProtocolsSection() {
        DocSection section = new DocSection("Protocols", "protocols");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection core = new DocSection("Core", "protocols.core");
        all.addSection(core);
        core.addItem(this.getDocItem("Object"));
        return section;
    }

    private DocSection getTransducersSection() {
        DocSection section = new DocSection("Transducers", "transducers");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection run = new DocSection("Use", "transducers.use");
        all.addSection(run);
        run.addItem(this.getDocItem("transduce"));
        DocSection func = new DocSection("Functions", "transducers.functions");
        all.addSection(func);
        func.addItem(this.getDocItem("map"));
        func.addItem(this.getDocItem("map-indexed"));
        func.addItem(this.getDocItem("filter"));
        func.addItem(this.getDocItem("drop"));
        func.addItem(this.getDocItem("drop-while"));
        func.addItem(this.getDocItem("drop-last"));
        func.addItem(this.getDocItem("take"));
        func.addItem(this.getDocItem("take-while"));
        func.addItem(this.getDocItem("take-last"));
        func.addItem(this.getDocItem("keep"));
        func.addItem(this.getDocItem("remove"));
        func.addItem(this.getDocItem("dedupe"));
        func.addItem(this.getDocItem("distinct"));
        func.addItem(this.getDocItem("sorted"));
        func.addItem(this.getDocItem("reverse"));
        func.addItem(this.getDocItem("flatten"));
        func.addItem(this.getDocItem("halt-when"));
        DocSection red = new DocSection("Reductions", "transducers.reductions");
        all.addSection(red);
        red.addItem(this.getDocItem("rf-first"));
        red.addItem(this.getDocItem("rf-last"));
        red.addItem(this.getDocItem("rf-every?"));
        red.addItem(this.getDocItem("rf-any?"));
        DocSection early = new DocSection("Early", "transducers.early");
        all.addSection(early);
        early.addItem(this.getDocItem("reduced"));
        early.addItem(this.getDocItem("reduced?"));
        early.addItem(this.getDocItem("deref"));
        early.addItem(this.getDocItem("deref?"));
        return section;
    }

    private DocSection getConcurrencySection() {
        DocSection section = new DocSection("Concurrency", "concurrency");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection atoms = new DocSection("Atoms", "concurrency.atoms");
        all.addSection(atoms);
        atoms.addItem(this.getDocItem("atom"));
        atoms.addItem(this.getDocItem("atom?"));
        atoms.addItem(this.getDocItem("deref"));
        atoms.addItem(this.getDocItem("deref?"));
        atoms.addItem(this.getDocItem("reset!"));
        atoms.addItem(this.getDocItem("swap!"));
        atoms.addItem(this.getDocItem("swap-vals!"));
        atoms.addItem(this.getDocItem("compare-and-set!"));
        atoms.addItem(this.getDocItem("add-watch"));
        atoms.addItem(this.getDocItem("remove-watch"));
        DocSection futures = new DocSection("Futures", "concurrency.futures");
        all.addSection(futures);
        futures.addItem(this.getDocItem("future"));
        futures.addItem(this.getDocItem("future-task"));
        futures.addItem(this.getDocItem("future?"));
        futures.addItem(this.getDocItem("futures-fork"));
        futures.addItem(this.getDocItem("futures-wait"));
        futures.addItem(this.getDocItem("futures-thread-pool-info"));
        futures.addItem(this.getDocItem("done?"));
        futures.addItem(this.getDocItem("cancel"));
        futures.addItem(this.getDocItem("cancelled?"));
        futures.addItem(this.getDocItem("deref"));
        futures.addItem(this.getDocItem("deref?"));
        futures.addItem(this.getDocItem("realized?"));
        DocSection promises = new DocSection("Promises", "concurrency.promises");
        all.addSection(promises);
        promises.addItem(this.getDocItem("promise"));
        promises.addItem(this.getDocItem("promise?"));
        promises.addItem(this.getDocItem("deliver"));
        promises.addItem(this.getDocItem("deliver-ex"));
        promises.addItem(this.getDocItem("realized?"));
        promises.addItem(this.getDocItem("then-accept"));
        promises.addItem(this.getDocItem("then-accept-both"));
        promises.addItem(this.getDocItem("then-apply"));
        promises.addItem(this.getDocItem("then-combine"));
        promises.addItem(this.getDocItem("then-compose"));
        promises.addItem(this.getDocItem("when-complete"));
        promises.addItem(this.getDocItem("accept-either"));
        promises.addItem(this.getDocItem("apply-to-either"));
        promises.addItem(this.getDocItem("all-of"));
        promises.addItem(this.getDocItem("any-of"));
        promises.addItem(this.getDocItem("or-timeout", true, true));
        promises.addItem(this.getDocItem("complete-on-timeout", true, true));
        promises.addItem(this.getDocItem("timeout-after", true, true));
        promises.addItem(this.getDocItem("done?"));
        promises.addItem(this.getDocItem("cancel"));
        promises.addItem(this.getDocItem("cancelled?"));
        DocSection delay = new DocSection("Delay", "concurrency.delay");
        all.addSection(delay);
        delay.addItem(this.getDocItem("delay"));
        delay.addItem(this.getDocItem("delay?"));
        delay.addItem(this.getDocItem("deref"));
        delay.addItem(this.getDocItem("deref?"));
        delay.addItem(this.getDocItem("force"));
        delay.addItem(this.getDocItem("realized?"));
        DocSection agents = new DocSection("Agents", "concurrency.agents");
        all.addSection(agents);
        agents.addItem(this.getDocItem("agent"));
        agents.addItem(this.getDocItem("send"));
        agents.addItem(this.getDocItem("send-off"));
        agents.addItem(this.getDocItem("restart-agent"));
        agents.addItem(this.getDocItem("set-error-handler!"));
        agents.addItem(this.getDocItem("agent-error"));
        agents.addItem(this.getDocItem("await"));
        agents.addItem(this.getDocItem("await-for"));
        agents.addItem(this.getDocItem("shutdown-agents", false));
        agents.addItem(this.getDocItem("shutdown-agents?", false));
        agents.addItem(this.getDocItem("await-termination-agents", false));
        agents.addItem(this.getDocItem("await-termination-agents?", false));
        agents.addItem(this.getDocItem("agent-send-thread-pool-info"));
        agents.addItem(this.getDocItem("agent-send-off-thread-pool-info"));
        DocSection sched = new DocSection("Scheduler", "concurrency.scheduler");
        all.addSection(sched);
        sched.addItem(this.getDocItem("schedule-delay", false));
        sched.addItem(this.getDocItem("schedule-at-fixed-rate", false));
        DocSection locking = new DocSection("Locking", "concurrency.locking");
        all.addSection(locking);
        locking.addItem(this.getDocItem("locking"));
        DocSection volatiles = new DocSection("Volatiles", "concurrency.volatiles");
        all.addSection(volatiles);
        volatiles.addItem(this.getDocItem("volatile"));
        volatiles.addItem(this.getDocItem("volatile?"));
        volatiles.addItem(this.getDocItem("deref"));
        volatiles.addItem(this.getDocItem("deref?"));
        volatiles.addItem(this.getDocItem("reset!"));
        volatiles.addItem(this.getDocItem("swap!"));
        DocSection thlocal = new DocSection("ThreadLocal", "concurrency.threadlocal");
        all.addSection(thlocal);
        thlocal.addItem(this.getDocItem("thread-local"));
        thlocal.addItem(this.getDocItem("thread-local?"));
        thlocal.addItem(this.getDocItem("thread-local-clear"));
        thlocal.addItem(this.getDocItem("thread-local-map"));
        thlocal.addItem(this.getDocItem("assoc"));
        thlocal.addItem(this.getDocItem("dissoc"));
        thlocal.addItem(this.getDocItem("get"));
        thlocal.addItem(this.getDocItem("binding"));
        thlocal.addItem(this.getDocItem("def-dynamic"));
        DocSection threads = new DocSection("Threads", "concurrency.threads");
        all.addSection(threads);
        threads.addItem(this.getDocItem("thread-id"));
        threads.addItem(this.getDocItem("thread-name"));
        threads.addItem(this.getDocItem("thread-daemon?"));
        threads.addItem(this.getDocItem("thread-interrupted?"));
        threads.addItem(this.getDocItem("thread-interrupted"));
        DocSection parallel = new DocSection("Parallel", "concurrency.parallel");
        all.addSection(parallel);
        parallel.addItem(this.getDocItem("pmap"));
        parallel.addItem(this.getDocItem("pcalls"));
        return section;
    }

    private DocSection getIOSection() {
        DocSection section = new DocSection("I/O", "io.util");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection to = new DocSection("to", "io.to");
        all.addSection(to);
        to.addItem(this.getDocItem("print"));
        to.addItem(this.getDocItem("println"));
        to.addItem(this.getDocItem("printf"));
        to.addItem(this.getDocItem("flush"));
        to.addItem(this.getDocItem("newline"));
        to.addItem(this.getDocItem("pr"));
        to.addItem(this.getDocItem("prn"));
        DocSection to_str = new DocSection("to-str", "io.tostr");
        all.addSection(to_str);
        to_str.addItem(this.getDocItem("pr-str"));
        to_str.addItem(this.getDocItem("with-out-str"));
        DocSection from = new DocSection("from", "io.from");
        all.addSection(from);
        from.addItem(this.getDocItem("read-line"));
        from.addItem(this.getDocItem("read-string"));
        DocSection classpath = new DocSection("classpath", "io.classpath");
        all.addSection(classpath);
        classpath.addItem(this.getDocItem("io/load-classpath-resource"));
        classpath.addItem(this.getDocItem("io/classpath-resource?"));
        DocSection stream = new DocSection("stream", "io.stream");
        all.addSection(stream);
        stream.addItem(this.getDocItem("io/slurp"));
        stream.addItem(this.getDocItem("io/slurp-lines"));
        stream.addItem(this.getDocItem("io/copy-stream"));
        stream.addItem(this.getDocItem("io/slurp-stream"));
        stream.addItem(this.getDocItem("io/spit-stream"));
        stream.addItem(this.getDocItem("io/uri-stream", false));
        stream.addItem(this.getDocItem("io/file-in-stream", false));
        stream.addItem(this.getDocItem("io/string-in-stream", false));
        stream.addItem(this.getDocItem("io/bytebuf-in-stream", false));
        stream.addItem(this.getDocItem("io/wrap-os-with-buffered-writer"));
        stream.addItem(this.getDocItem("io/wrap-os-with-print-writer"));
        stream.addItem(this.getDocItem("io/wrap-is-with-buffered-reader"));
        DocSection rd_wr = new DocSection("reader/writer", "io.readerwriter");
        all.addSection(rd_wr);
        rd_wr.addItem(this.getDocItem("io/buffered-reader"));
        rd_wr.addItem(this.getDocItem("io/buffered-writer"));
        DocSection http = new DocSection("http", "io.http");
        all.addSection(http);
        http.addItem(this.getDocItem("io/download", false));
        http.addItem(this.getDocItem("io/internet-avail?", false));
        DocSection other = new DocSection("other", "io.other");
        all.addSection(other);
        other.addItem(this.getDocItem("with-out-str"));
        other.addItem(this.getDocItem("io/mime-type"));
        other.addItem(this.getDocItem("io/default-charset"));
        return section;
    }

    private DocSection getIOFileSection() {
        DocSection section = new DocSection("File I/O", "io.file");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection file = new DocSection("file", "io.file_");
        all.addSection(file);
        file.addItem(this.getDocItem("io/file"));
        file.addItem(this.getDocItem("io/file-parent"));
        file.addItem(this.getDocItem("io/file-name"));
        file.addItem(this.getDocItem("io/file-path"));
        file.addItem(this.getDocItem("io/file-absolute-path"));
        file.addItem(this.getDocItem("io/file-canonical-path"));
        file.addItem(this.getDocItem("io/file-ext"));
        file.addItem(this.getDocItem("io/file-ext?"));
        file.addItem(this.getDocItem("io/file-size", false));
        file.addItem(this.getDocItem("io/file-last-modified", false));
        DocSection file_dir = new DocSection("file dir", "io.filedir");
        all.addSection(file_dir);
        file_dir.addItem(this.getDocItem("io/mkdir"));
        file_dir.addItem(this.getDocItem("io/mkdirs"));
        DocSection file_io = new DocSection("file i/o", "io.fileio");
        all.addSection(file_io);
        file_io.addItem(this.getDocItem("io/slurp"));
        file_io.addItem(this.getDocItem("io/slurp-lines"));
        file_io.addItem(this.getDocItem("io/spit"));
        file_io.addItem(this.getDocItem("io/copy-file"));
        file_io.addItem(this.getDocItem("io/move-file"));
        file_io.addItem(this.getDocItem("io/delete-file"));
        file_io.addItem(this.getDocItem("io/delete-file-on-exit"));
        file_io.addItem(this.getDocItem("io/delete-file-tree"));
        DocSection file_list = new DocSection("file list", "io.filelist");
        all.addSection(file_list);
        file_list.addItem(this.getDocItem("io/list-files", false));
        file_list.addItem(this.getDocItem("io/list-files-glob", false));
        file_list.addItem(this.getDocItem("io/list-file-tree", false));
        DocSection file_test = new DocSection("file test", "io.filetest");
        all.addSection(file_test);
        file_test.addItem(this.getDocItem("io/file?"));
        file_test.addItem(this.getDocItem("io/exists-file?"));
        file_test.addItem(this.getDocItem("io/exists-dir?"));
        file_test.addItem(this.getDocItem("io/file-can-read?", false));
        file_test.addItem(this.getDocItem("io/file-can-write?", false));
        file_test.addItem(this.getDocItem("io/file-can-execute?", false));
        file_test.addItem(this.getDocItem("io/file-hidden?", false));
        file_test.addItem(this.getDocItem("io/file-symbolic-link?", false));
        DocSection file_uri = new DocSection("URL/URI", "io.url_uri");
        all.addSection(file_uri);
        file_uri.addItem(this.getDocItem("io/->url"));
        file_uri.addItem(this.getDocItem("io/->uri"));
        DocSection file_watch = new DocSection("file watch", "io.filewatch");
        all.addSection(file_watch);
        file_watch.addItem(this.getDocItem("io/await-for", false));
        file_watch.addItem(this.getDocItem("io/watch-dir", false));
        file_watch.addItem(this.getDocItem("io/close-watcher", false));
        DocSection file_other = new DocSection("file other", "io.fileother");
        all.addSection(file_other);
        file_other.addItem(this.getDocItem("io/temp-file"));
        file_other.addItem(this.getDocItem("io/tmp-dir"));
        file_other.addItem(this.getDocItem("io/user-dir"));
        file_other.addItem(this.getDocItem("io/user-home-dir"));
        return section;
    }

    private DocSection getIOZipSection() {
        DocSection section = new DocSection("Zip/GZip", "io.zip");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection zip = new DocSection("zip", "io.zip_");
        all.addSection(zip);
        zip.addItem(this.getDocItem("io/zip", false));
        zip.addItem(this.getDocItem("io/zip-file", false));
        zip.addItem(this.getDocItem("io/zip-list", false));
        zip.addItem(this.getDocItem("io/zip-list-entry-names", false));
        zip.addItem(this.getDocItem("io/zip-append", false));
        zip.addItem(this.getDocItem("io/zip-remove", false));
        zip.addItem(this.getDocItem("io/zip?"));
        zip.addItem(this.getDocItem("io/unzip"));
        zip.addItem(this.getDocItem("io/unzip-first"));
        zip.addItem(this.getDocItem("io/unzip-nth"));
        zip.addItem(this.getDocItem("io/unzip-all"));
        zip.addItem(this.getDocItem("io/unzip-to-dir", false));
        DocSection gzip = new DocSection("gzip", "io.gzip");
        all.addSection(gzip);
        gzip.addItem(this.getDocItem("io/gzip", false));
        gzip.addItem(this.getDocItem("io/gzip-to-stream"));
        gzip.addItem(this.getDocItem("io/gzip?"));
        gzip.addItem(this.getDocItem("io/ungzip"));
        gzip.addItem(this.getDocItem("io/ungzip-to-stream"));
        return section;
    }

    private DocSection getAppSection() {
        DocSection section = new DocSection("Application", "application");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection mgmt = new DocSection("Management", "application.management");
        all.addSection(mgmt);
        mgmt.addItem(this.getDocItem("app/build"));
        mgmt.addItem(this.getDocItem("app/manifest"));
        return section;
    }

    private DocSection getNamespaceSection() {
        DocSection section = new DocSection("Namespace", "namespace");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection open = new DocSection("Open", "namespace.open");
        all.addSection(open);
        open.addItem(this.getDocItem("ns"));
        DocSection curr = new DocSection("Current", "namespace.current");
        all.addSection(curr);
        curr.addItem(this.getDocItem("*ns*"));
        DocSection remove = new DocSection("Remove", "namespace.remove");
        all.addSection(remove);
        remove.addItem(this.getDocItem("ns-unmap"));
        remove.addItem(this.getDocItem("ns-remove"));
        DocSection util = new DocSection("Util", "namespace.util");
        all.addSection(util);
        util.addItem(this.getDocItem("ns-list"));
        util.addItem(this.getDocItem("namespace"));
        DocSection alias = new DocSection("Alias", "namespace.alias");
        all.addSection(alias);
        alias.addItem(this.getDocItem("ns-alias"));
        alias.addItem(this.getDocItem("ns-aliases"));
        alias.addItem(this.getDocItem("ns-unalias"));
        return section;
    }

    private DocSection getByteBufSection() {
        DocSection section = new DocSection("Byte Buffer", "bytebuf");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection bb_create = new DocSection("Create", "bytebuf.create");
        all.addSection(bb_create);
        bb_create.addItem(this.getDocItem("bytebuf"));
        bb_create.addItem(this.getDocItem("bytebuf-allocate"));
        bb_create.addItem(this.getDocItem("bytebuf-from-string"));
        DocSection bb_test = new DocSection("Test", "bytebuf.test");
        all.addSection(bb_test);
        bb_test.addItem(this.getDocItem("empty?"));
        bb_test.addItem(this.getDocItem("not-empty?"));
        bb_test.addItem(this.getDocItem("bytebuf?"));
        DocSection bb_use = new DocSection("Use", "bytebuf.use");
        all.addSection(bb_use);
        bb_use.addItem(this.getDocItem("count"));
        bb_use.addItem(this.getDocItem("bytebuf-capacity"));
        bb_use.addItem(this.getDocItem("bytebuf-limit"));
        bb_use.addItem(this.getDocItem("bytebuf-to-string"));
        bb_use.addItem(this.getDocItem("bytebuf-to-list"));
        bb_use.addItem(this.getDocItem("bytebuf-sub"));
        bb_use.addItem(this.getDocItem("bytebuf-pos"));
        bb_use.addItem(this.getDocItem("bytebuf-pos!"));
        DocSection bb_read = new DocSection("Read", "bytebuf.read");
        all.addSection(bb_read);
        bb_read.addItem(this.getDocItem("bytebuf-get-byte"));
        bb_read.addItem(this.getDocItem("bytebuf-get-int"));
        bb_read.addItem(this.getDocItem("bytebuf-get-long"));
        bb_read.addItem(this.getDocItem("bytebuf-get-float"));
        bb_read.addItem(this.getDocItem("bytebuf-get-double"));
        DocSection bb_write = new DocSection("Write", "bytebuf.write");
        all.addSection(bb_write);
        bb_write.addItem(this.getDocItem("bytebuf-put-byte!"));
        bb_write.addItem(this.getDocItem("bytebuf-put-int!"));
        bb_write.addItem(this.getDocItem("bytebuf-put-long!"));
        bb_write.addItem(this.getDocItem("bytebuf-put-float!"));
        bb_write.addItem(this.getDocItem("bytebuf-put-double!"));
        bb_write.addItem(this.getDocItem("bytebuf-put-buf!"));
        DocSection encode = new DocSection("Base64", "bytebuf.base64");
        all.addSection(encode);
        encode.addItem(this.getDocItem("str/encode-base64"));
        encode.addItem(this.getDocItem("str/decode-base64"));
        DocSection hex = new DocSection("Hex", "bytebuf.hex");
        all.addSection(hex);
        hex.addItem(this.getDocItem("str/hex-to-bytebuf"));
        hex.addItem(this.getDocItem("str/bytebuf-to-hex"));
        hex.addItem(this.getDocItem("str/format-bytebuf"));
        return section;
    }

    private DocSection getTimeSection() {
        DocSection section = new DocSection("Time", "time");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection date = new DocSection("Date", "time.date");
        all.addSection(date);
        date.addItem(this.getDocItem("time/date"));
        date.addItem(this.getDocItem("time/date?"));
        DocSection local_date = new DocSection("Local Date", "time.localdate");
        all.addSection(local_date);
        local_date.addItem(this.getDocItem("time/local-date"));
        local_date.addItem(this.getDocItem("time/local-date?"));
        local_date.addItem(this.getDocItem("time/local-date-parse"));
        DocSection local_date_time = new DocSection("Local Date Time", "time.localdatetime");
        all.addSection(local_date_time);
        local_date_time.addItem(this.getDocItem("time/local-date-time"));
        local_date_time.addItem(this.getDocItem("time/local-date-time?"));
        local_date_time.addItem(this.getDocItem("time/local-date-time-parse"));
        DocSection zoned_date_time = new DocSection("Zoned Date Time", "time.zoneddatetime");
        all.addSection(zoned_date_time);
        zoned_date_time.addItem(this.getDocItem("time/zoned-date-time"));
        zoned_date_time.addItem(this.getDocItem("time/zoned-date-time?"));
        zoned_date_time.addItem(this.getDocItem("time/zoned-date-time-parse"));
        DocSection fields = new DocSection("Fields", "time.fields");
        all.addSection(fields);
        fields.addItem(this.getDocItem("time/year"));
        fields.addItem(this.getDocItem("time/month"));
        fields.addItem(this.getDocItem("time/day-of-week"));
        fields.addItem(this.getDocItem("time/day-of-month"));
        fields.addItem(this.getDocItem("time/day-of-year"));
        fields.addItem(this.getDocItem("time/hour"));
        fields.addItem(this.getDocItem("time/minute"));
        fields.addItem(this.getDocItem("time/second"));
        DocSection etc = new DocSection("Fields etc", "time.fieldsetc");
        all.addSection(etc);
        etc.addItem(this.getDocItem("time/length-of-year"));
        etc.addItem(this.getDocItem("time/length-of-month"));
        etc.addItem(this.getDocItem("time/first-day-of-month"));
        etc.addItem(this.getDocItem("time/last-day-of-month"));
        DocSection zone = new DocSection("Zone", "time.zone");
        all.addSection(zone);
        zone.addItem(this.getDocItem("time/zone"));
        zone.addItem(this.getDocItem("time/zone-offset"));
        DocSection format = new DocSection("Format", "time.format");
        all.addSection(format);
        format.addItem(this.getDocItem("time/formatter"));
        format.addItem(this.getDocItem("time/format"));
        DocSection compare = new DocSection("Test", "time.test");
        all.addSection(compare);
        compare.addItem(this.getDocItem("time/after?"));
        compare.addItem(this.getDocItem("time/not-after?"));
        compare.addItem(this.getDocItem("time/before?"));
        compare.addItem(this.getDocItem("time/not-before?"));
        compare.addItem(this.getDocItem("time/within?"));
        compare.addItem(this.getDocItem("time/leap-year?"));
        DocSection misc = new DocSection("Miscellaneous", "time.misc");
        all.addSection(misc);
        misc.addItem(this.getDocItem("time/with-time"));
        misc.addItem(this.getDocItem("time/plus"));
        misc.addItem(this.getDocItem("time/minus"));
        misc.addItem(this.getDocItem("time/period"));
        misc.addItem(this.getDocItem("time/earliest"));
        misc.addItem(this.getDocItem("time/latest"));
        DocSection util = new DocSection("Util", "time.util");
        all.addSection(util);
        util.addItem(this.getDocItem("time/zone-ids"));
        util.addItem(this.getDocItem("time/to-millis"));
        return section;
    }

    private DocSection getJavaInteropSection() {
        DocSection section = new DocSection("Java Interoperability", "javainterop");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection java = new DocSection("Java", "javainterop.java");
        all.addSection(java);
        java.addItem(this.getDocItem("."));
        java.addItem(this.getDocItem("import"));
        java.addItem(this.getDocItem("java-iterator-to-list"));
        java.addItem(this.getDocItem("java-enumeration-to-list"));
        java.addItem(this.getDocItem("java-unwrap-optional"));
        java.addItem(this.getDocItem("cast"));
        java.addItem(this.getDocItem("class"));
        DocSection proxy = new DocSection("Proxify", "javainterop.proxify");
        all.addSection(proxy);
        proxy.addItem(this.getDocItem("proxify"));
        proxy.addItem(this.getDocItem("as-runnable"));
        proxy.addItem(this.getDocItem("as-callable"));
        proxy.addItem(this.getDocItem("as-predicate"));
        proxy.addItem(this.getDocItem("as-function"));
        proxy.addItem(this.getDocItem("as-consumer"));
        proxy.addItem(this.getDocItem("as-supplier"));
        proxy.addItem(this.getDocItem("as-bipredicate"));
        proxy.addItem(this.getDocItem("as-bifunction"));
        proxy.addItem(this.getDocItem("as-biconsumer"));
        proxy.addItem(this.getDocItem("as-binaryoperator"));
        DocSection test = new DocSection("Test", "javainterop.test");
        all.addSection(test);
        test.addItem(this.getDocItem("java-obj?"));
        test.addItem(this.getDocItem("exists-class?"));
        DocSection support = new DocSection("Support", "javainterop.support");
        all.addSection(support);
        support.addItem(this.getDocItem("imports"));
        support.addItem(this.getDocItem("supers"));
        support.addItem(this.getDocItem("bases"));
        support.addItem(this.getDocItem("formal-type"));
        support.addItem(this.getDocItem("stacktrace", false, false));
        DocSection clazz = new DocSection("Classes", "javainterop.classes");
        all.addSection(clazz);
        clazz.addItem(this.getDocItem("class"));
        clazz.addItem(this.getDocItem("class-of"));
        clazz.addItem(this.getDocItem("class-name"));
        clazz.addItem(this.getDocItem("class-version"));
        clazz.addItem(this.getDocItem("classloader"));
        clazz.addItem(this.getDocItem("classloader-of"));
        DocSection jar = new DocSection("JARs", "javainterop.jar");
        all.addSection(jar);
        jar.addItem(this.getDocItem("jar-maven-manifest-version"));
        jar.addItem(this.getDocItem("java-package-version"));
        DocSection modules = new DocSection("Modules", "javainterop.modules");
        all.addSection(modules);
        modules.addItem(this.getDocItem("module-name", false));
        return section;
    }

    private DocSection getReplSection() {
        DocSection section = new DocSection("REPL", "repl");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection repl = new DocSection("Info", "repl.info");
        all.addSection(repl);
        repl.addItem(this.getDocItem("repl/info", false));
        DocSection term = new DocSection("Terminal", "repl.terminal");
        all.addSection(term);
        term.addItem(this.getDocItem("repl/term-rows", false));
        term.addItem(this.getDocItem("repl/term-cols", false));
        return section;
    }

    private DocSection getPdfSection() {
        String footer = "Required 3rd party libraries:\n\n* org.xhtmlrenderer:flying-saucer-core:9.1.22\n* org.xhtmlrenderer:flying-saucer-pdf-openpdf:9.1.22\n* com.github.librepdf:openpdf:1.3.26\n* com.github.librepdf:pdf-toolbox:1.3.26\n";
        DocSection section = new DocSection("PDF", null, "pdf", null, "Required 3rd party libraries:\n\n* org.xhtmlrenderer:flying-saucer-core:9.1.22\n* org.xhtmlrenderer:flying-saucer-pdf-openpdf:9.1.22\n* com.github.librepdf:openpdf:1.3.26\n* com.github.librepdf:pdf-toolbox:1.3.26\n");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection pdf = new DocSection("PDF", "pdf.pdf");
        all.addSection(pdf);
        pdf.addItem(this.getDocItem("pdf/render", false));
        pdf.addItem(this.getDocItem("pdf/text-to-pdf", false));
        pdf.addItem(this.getDocItem("pdf/available?", false));
        pdf.addItem(this.getDocItem("pdf/check-required-libs", false));
        DocSection pdf_tools = new DocSection("PDF Tools", "pdf.pdftools");
        all.addSection(pdf_tools);
        pdf_tools.addItem(this.getDocItem("pdf/merge", false));
        pdf_tools.addItem(this.getDocItem("pdf/copy", false));
        pdf_tools.addItem(this.getDocItem("pdf/pages"));
        pdf_tools.addItem(this.getDocItem("pdf/watermark", false));
        return section;
    }

    private DocSection getSystemVarSection() {
        DocSection section = new DocSection("System Vars", "sysvars");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection other = new DocSection("System Vars", "sysvars.var");
        all.addSection(other);
        other.addItem(this.getDocItem("*version*"));
        other.addItem(this.getDocItem("*newline*"));
        other.addItem(this.getDocItem("*loaded-modules*"));
        other.addItem(this.getDocItem("*loaded-files*"));
        other.addItem(this.getDocItem("*ns*"));
        other.addItem(this.getDocItem("*run-mode*"));
        other.addItem(this.getDocItem("*ansi-term*"));
        return section;
    }

    private DocSection getJsonSection() {
        DocSection section = new DocSection("JSON", "json");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection read = new DocSection("read", "json.read");
        all.addSection(read);
        read.addItem(this.getDocItem("json/read-str"));
        read.addItem(this.getDocItem("json/slurp"));
        DocSection write = new DocSection("write", "json.write");
        all.addSection(write);
        write.addItem(this.getDocItem("json/write-str"));
        write.addItem(this.getDocItem("json/spit"));
        DocSection prettify = new DocSection("prettify", "json.prettify");
        all.addSection(prettify);
        prettify.addItem(this.getDocItem("json/pretty-print"));
        return section;
    }

    private DocSection getCsvSection() {
        DocSection section = new DocSection("CSV", "csv");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection read = new DocSection("read", "csv.read");
        all.addSection(read);
        read.addItem(this.getDocItem("csv/read"));
        DocSection write = new DocSection("write", "csv.write");
        all.addSection(write);
        write.addItem(this.getDocItem("csv/write", false));
        write.addItem(this.getDocItem("csv/write-str"));
        return section;
    }

    private DocSection getCidrSection() {
        DocSection section = new DocSection("CIDR", "classless inter-domain routing", "cidr");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection cidr = new DocSection("CIDR", "cidr.cidr");
        all.addSection(cidr);
        cidr.addItem(this.getDocItem("cidr/parse"));
        cidr.addItem(this.getDocItem("cidr/in-range?"));
        cidr.addItem(this.getDocItem("cidr/start-inet-addr"));
        cidr.addItem(this.getDocItem("cidr/end-inet-addr"));
        cidr.addItem(this.getDocItem("cidr/inet-addr"));
        cidr.addItem(this.getDocItem("cidr/inet-addr-to-bytes"));
        cidr.addItem(this.getDocItem("cidr/inet-addr-from-bytes"));
        DocSection cidr_trie = new DocSection("CIDR Trie", "cidr.cidrtrie");
        all.addSection(cidr_trie);
        cidr_trie.addItem(this.getDocItem("cidr/trie"));
        cidr_trie.addItem(this.getDocItem("cidr/size"));
        cidr_trie.addItem(this.getDocItem("cidr/insert"));
        cidr_trie.addItem(this.getDocItem("cidr/lookup"));
        cidr_trie.addItem(this.getDocItem("cidr/lookup-reverse"));
        return section;
    }

    private DocSection getModuleKiraSection() {
        DocSection section = new DocSection("Kira", "Templating system", "modules.kira");
        DocSection all = new DocSection("(load-module :kira)", this.id());
        section.addSection(all);
        DocSection kira = new DocSection("Kira", this.id());
        all.addSection(kira);
        kira.addItem(this.getDocItem("kira/eval"));
        kira.addItem(this.getDocItem("kira/fn"));
        DocSection escape = new DocSection("Escape", this.id());
        all.addSection(escape);
        escape.addItem(this.getDocItem("kira/escape-xml"));
        escape.addItem(this.getDocItem("kira/escape-html"));
        return section;
    }

    private DocSection getModuleTracingSection() {
        DocSection section = new DocSection("Tracing", "Tracing functions", "modules.tracing");
        DocSection all = new DocSection("(load-module :trace)", this.id());
        section.addSection(all);
        DocSection trace = new DocSection("Tracing", this.id());
        all.addSection(trace);
        trace.addItem(this.getDocItem("trace/trace"));
        trace.addItem(this.getDocItem("trace/trace-var"));
        trace.addItem(this.getDocItem("trace/untrace-var"));
        DocSection test = new DocSection("Test", this.id());
        all.addSection(test);
        test.addItem(this.getDocItem("trace/traced?"));
        test.addItem(this.getDocItem("trace/traceable?"));
        DocSection util = new DocSection("Util", this.id());
        all.addSection(util);
        util.addItem(this.getDocItem("trace/trace-str-limit"));
        DocSection tee = new DocSection("Tee", this.id());
        all.addSection(tee);
        tee.addItem(this.getDocItem("trace/tee->"));
        tee.addItem(this.getDocItem("trace/tee->>"));
        tee.addItem(this.getDocItem("trace/tee"));
        return section;
    }

    private DocSection getModuleShellSection() {
        DocSection section = new DocSection("Shell", "Functions to deal with the operating system", "modules.shell");
        DocSection all = new DocSection("(load-module :shell)", this.id());
        section.addSection(all);
        DocSection trace = new DocSection("Open", this.id());
        all.addSection(trace);
        trace.addItem(this.getDocItem("shell/open", false));
        trace.addItem(this.getDocItem("shell/open-macos-app", false));
        DocSection test = new DocSection("Process", this.id());
        all.addSection(test);
        test.addItem(this.getDocItem("shell/kill", false));
        test.addItem(this.getDocItem("shell/kill-forcibly", false));
        test.addItem(this.getDocItem("shell/wait-for-process-exit", false));
        test.addItem(this.getDocItem("shell/alive?", false));
        test.addItem(this.getDocItem("shell/pid", false));
        test.addItem(this.getDocItem("shell/process-handle", false));
        test.addItem(this.getDocItem("shell/process-handle?", false));
        test.addItem(this.getDocItem("shell/process-info", false));
        test.addItem(this.getDocItem("shell/processes", false));
        test.addItem(this.getDocItem("shell/processes-info", false));
        test.addItem(this.getDocItem("shell/descendant-processes", false));
        test.addItem(this.getDocItem("shell/parent-process", false));
        DocSection util = new DocSection("Util", this.id());
        all.addSection(util);
        util.addItem(this.getDocItem("shell/diff", false));
        return section;
    }

    private DocSection getModuleXmlSection() {
        DocSection section = new DocSection("XML", "modules.xml");
        DocSection all = new DocSection("(load-module :xml)", this.id());
        section.addSection(all);
        DocSection xml = new DocSection("XML", this.id());
        all.addSection(xml);
        xml.addItem(this.getDocItem("xml/parse-str"));
        xml.addItem(this.getDocItem("xml/parse"));
        xml.addItem(this.getDocItem("xml/path->"));
        xml.addItem(this.getDocItem("xml/children"));
        xml.addItem(this.getDocItem("xml/text"));
        return section;
    }

    private DocSection getModuleCryptographySection() {
        DocSection section = new DocSection("Cryptography", "modules.cryptography");
        DocSection all = new DocSection("(load-module :crypt)", this.id());
        section.addSection(all);
        DocSection hashes = new DocSection("Hashes", this.id());
        all.addSection(hashes);
        hashes.addItem(this.getDocItem("crypt/md5-hash"));
        hashes.addItem(this.getDocItem("crypt/sha1-hash"));
        hashes.addItem(this.getDocItem("crypt/sha512-hash"));
        hashes.addItem(this.getDocItem("crypt/pbkdf2-hash"));
        DocSection crypt = new DocSection("Encrypt", this.id());
        all.addSection(crypt);
        crypt.addItem(this.getDocItem("crypt/encrypt"));
        crypt.addItem(this.getDocItem("crypt/decrypt"));
        return section;
    }

    private DocSection getModuleGradleSection() {
        DocSection section = new DocSection("Gradle", "modules.gradle");
        DocSection all = new DocSection("(load-module :gradle)", this.id());
        section.addSection(all);
        DocSection gradle = new DocSection("Gradle", this.id());
        all.addSection(gradle);
        gradle.addItem(this.getDocItem("gradle/with-home", false));
        gradle.addItem(this.getDocItem("gradle/version", false));
        gradle.addItem(this.getDocItem("gradle/task", false));
        return section;
    }

    private DocSection getModuleMavenSection() {
        DocSection section = new DocSection("Maven", "modules.maven");
        DocSection all = new DocSection("(load-module :maven)", this.id());
        section.addSection(all);
        DocSection maven = new DocSection("Maven", this.id());
        all.addSection(maven);
        maven.addItem(this.getDocItem("maven/download", false));
        maven.addItem(this.getDocItem("maven/get", false));
        maven.addItem(this.getDocItem("maven/uri", false));
        maven.addItem(this.getDocItem("maven/parse-artefact", false));
        return section;
    }

    private DocSection getModuleJavaSection() {
        DocSection section = new DocSection("Java", "modules.java");
        DocSection all = new DocSection("(load-module :java)", this.id());
        section.addSection(all);
        DocSection java = new DocSection("Java", this.id());
        all.addSection(java);
        java.addItem(this.getDocItem("java/javadoc", false));
        return section;
    }

    private DocSection getModuleSemverSection() {
        DocSection section = new DocSection("Semver", "Semantic versioning", "modules.semver");
        DocSection all = new DocSection("(load-module :semver)", this.id());
        section.addSection(all);
        DocSection semver = new DocSection("Semver", this.id());
        all.addSection(semver);
        semver.addItem(this.getDocItem("semver/parse"));
        semver.addItem(this.getDocItem("semver/version"));
        DocSection valid = new DocSection("Validation", this.id());
        all.addSection(valid);
        valid.addItem(this.getDocItem("semver/valid?"));
        valid.addItem(this.getDocItem("semver/valid-format?"));
        DocSection test = new DocSection("Test", this.id());
        all.addSection(test);
        test.addItem(this.getDocItem("semver/newer?"));
        test.addItem(this.getDocItem("semver/older?"));
        test.addItem(this.getDocItem("semver/equal?"));
        test.addItem(this.getDocItem("semver/cmp"));
        return section;
    }

    private DocSection getModuleGeoipSection() {
        DocSection section = new DocSection("Geo IP", "Geolocation mapping for IP adresses", "modules.geoip");
        DocSection all = new DocSection("(load-module :geoip)", this.id());
        section.addSection(all);
        DocSection geoip = new DocSection("Lookup", this.id());
        all.addSection(geoip);
        geoip.addItem(this.getDocItem("geoip/ip-to-country-resolver", false));
        geoip.addItem(this.getDocItem("geoip/ip-to-country-loc-resolver", false));
        geoip.addItem(this.getDocItem("geoip/ip-to-city-loc-resolver", false));
        geoip.addItem(this.getDocItem("geoip/ip-to-city-loc-resolver-mem-optimized", false));
        DocSection db = new DocSection("Databases", this.id());
        all.addSection(db);
        db.addItem(this.getDocItem("geoip/download-google-country-db-to-csvfile", false));
        db.addItem(this.getDocItem("geoip/download-maxmind-db-to-zipfile", false));
        db.addItem(this.getDocItem("geoip/download-maxmind-db", false));
        DocSection dbBuild = new DocSection("DB Parser", this.id());
        all.addSection(dbBuild);
        dbBuild.addItem(this.getDocItem("geoip/parse-maxmind-country-ip-db", false));
        dbBuild.addItem(this.getDocItem("geoip/parse-maxmind-city-ip-db", false));
        dbBuild.addItem(this.getDocItem("geoip/parse-maxmind-country-db", false));
        dbBuild.addItem(this.getDocItem("geoip/parse-maxmind-city-db", false));
        DocSection util = new DocSection("Util", this.id());
        all.addSection(util);
        util.addItem(this.getDocItem("geoip/build-maxmind-country-db-url"));
        util.addItem(this.getDocItem("geoip/build-maxmind-city-db-url"));
        util.addItem(this.getDocItem("geoip/map-location-to-numerics"));
        util.addItem(this.getDocItem("geoip/country-to-location-resolver", false));
        return section;
    }

    private DocSection getModuleHexdumpSection() {
        DocSection section = new DocSection("Hexdump", "modules.hexdump");
        DocSection all = new DocSection("(load-module :hexdump)", this.id());
        section.addSection(all);
        DocSection hexdump = new DocSection("Hexdump", this.id());
        all.addSection(hexdump);
        hexdump.addItem(this.getDocItem("hexdump/dump", false));
        return section;
    }

    private DocSection getModuleAnsiSection() {
        DocSection section = new DocSection("Ansi", "ANSI codes, styles, and colorization helper functions", "modules.ansi");
        DocSection all = new DocSection("(load-module :ansi)", this.id());
        section.addSection(all);
        DocSection colors = new DocSection("Colors", this.id());
        all.addSection(colors);
        colors.addItem(this.getDocItem("ansi/fg-color", false));
        colors.addItem(this.getDocItem("ansi/bg-color", false));
        DocSection style = new DocSection("Styles", this.id());
        all.addSection(style);
        style.addItem(this.getDocItem("ansi/style", false));
        style.addItem(this.getDocItem("ansi/ansi", false));
        style.addItem(this.getDocItem("ansi/with-ansi", false));
        style.addItem(this.getDocItem("ansi/without-ansi", false));
        DocSection cursor = new DocSection("Cursor", this.id());
        all.addSection(cursor);
        cursor.addItem(this.getDocItem("ansi/without-cursor", false));
        DocSection progress = new DocSection("Progress", this.id());
        all.addSection(progress);
        progress.addItem(this.getDocItem("ansi/progress", false));
        progress.addItem(this.getDocItem("ansi/progress-bar", false));
        return section;
    }

    private DocSection getModuleParsifalSection() {
        DocSection section = new DocSection("Parsifal", "A parser combinator", "modules.parsifal", "*Parsifal* is a port of Nate Young's Parsatron Clojure [parser combinators](https://github.com/youngnh/parsatron) project.", null);
        DocSection all = new DocSection("(load-module :parsifal)", this.id());
        section.addSection(all);
        DocSection run = new DocSection("Run", this.id());
        all.addSection(run);
        run.addItem(this.getDocItem("parsifal/run", false));
        DocSection define = new DocSection("Define", this.id());
        all.addSection(define);
        define.addItem(this.getDocItem("parsifal/defparser", false));
        DocSection parsers = new DocSection("Parsers", this.id());
        all.addSection(parsers);
        parsers.addItem(this.getDocItem("parsifal/any", false));
        parsers.addItem(this.getDocItem("parsifal/many", false));
        parsers.addItem(this.getDocItem("parsifal/many1", false));
        parsers.addItem(this.getDocItem("parsifal/times", false));
        parsers.addItem(this.getDocItem("parsifal/either", false));
        parsers.addItem(this.getDocItem("parsifal/choice", false));
        parsers.addItem(this.getDocItem("parsifal/between", false));
        parsers.addItem(this.getDocItem("parsifal/>>", false));
        DocSection special = new DocSection("Special Parsers", this.id());
        all.addSection(special);
        special.addItem(this.getDocItem("parsifal/eof", false));
        special.addItem(this.getDocItem("parsifal/never", false));
        special.addItem(this.getDocItem("parsifal/always", false));
        special.addItem(this.getDocItem("parsifal/lookahead", false));
        special.addItem(this.getDocItem("parsifal/attempt", false));
        DocSection binding = new DocSection("Binding", this.id());
        all.addSection(binding);
        binding.addItem(this.getDocItem("parsifal/let->>", false));
        DocSection ch = new DocSection("Char Parsers", this.id());
        all.addSection(ch);
        ch.addItem(this.getDocItem("parsifal/char", false));
        ch.addItem(this.getDocItem("parsifal/not-char", false));
        ch.addItem(this.getDocItem("parsifal/any-char", false));
        ch.addItem(this.getDocItem("parsifal/digit", false));
        ch.addItem(this.getDocItem("parsifal/hexdigit", false));
        ch.addItem(this.getDocItem("parsifal/letter", false));
        ch.addItem(this.getDocItem("parsifal/letter-or-digit", false));
        ch.addItem(this.getDocItem("parsifal/any-char-of", false));
        ch.addItem(this.getDocItem("parsifal/none-char-of", false));
        ch.addItem(this.getDocItem("parsifal/string", false));
        DocSection tok = new DocSection("Token Parsers", this.id());
        all.addSection(tok);
        tok.addItem(this.getDocItem("parsifal/token", false));
        DocSection proto = new DocSection("Protocols", this.id());
        all.addSection(proto);
        proto.addItem(this.getDocItem("parsifal/SourcePosition", false));
        DocSection line = new DocSection("Line Info", this.id());
        all.addSection(line);
        line.addItem(this.getDocItem("parsifal/lineno", false));
        line.addItem(this.getDocItem("parsifal/pos", false));
        return section;
    }

    private DocSection getModuleBenchmarkSection() {
        DocSection section = new DocSection("Benchmark", "modules.benchmark");
        DocSection all = new DocSection("(load-module :benchmark)", this.id());
        section.addSection(all);
        DocSection colors = new DocSection("Utils", this.id());
        all.addSection(colors);
        colors.addItem(this.getDocItem("benchmark/benchmark", false));
        return section;
    }

    private DocSection getModuleConfigSection() {
        DocSection section = new DocSection("Configuration", "Manages configurations with system property & env var support", "modules.config");
        DocSection all = new DocSection("(load-module :config)", this.id());
        section.addSection(all);
        DocSection build = new DocSection("Build", this.id());
        all.addSection(build);
        build.addItem(this.getDocItem("config/build", false));
        DocSection file = new DocSection("File", this.id());
        all.addSection(file);
        file.addItem(this.getDocItem("config/file", false));
        file.addItem(this.getDocItem("config/resource", true));
        DocSection env = new DocSection("Env", this.id());
        all.addSection(env);
        env.addItem(this.getDocItem("config/env-var", true));
        env.addItem(this.getDocItem("config/env", false));
        DocSection prop = new DocSection("Properties", this.id());
        all.addSection(prop);
        prop.addItem(this.getDocItem("config/property-var", true));
        prop.addItem(this.getDocItem("config/properties", false));
        return section;
    }

    private DocSection getModuleComponentSection() {
        DocSection section = new DocSection("Component", "Managing lifecycle and dependencies of components", "modules.component");
        DocSection all = new DocSection("(load-module :component)", this.id());
        section.addSection(all);
        DocSection system = new DocSection("Build", this.id());
        all.addSection(system);
        system.addItem(this.getDocItem("component/system-map", false));
        system.addItem(this.getDocItem("component/system-using"));
        DocSection protocol = new DocSection("Protocol", this.id());
        all.addSection(protocol);
        protocol.addItem(this.getDocItem("component/Component", false));
        DocSection util = new DocSection("Util", this.id());
        all.addSection(util);
        util.addItem(this.getDocItem("component/deps"));
        util.addItem(this.getDocItem("component/dep"));
        util.addItem(this.getDocItem("component/id"));
        return section;
    }

    private DocSection getModuleAppSection() {
        DocSection section = new DocSection("App", "Venice application archive", "modules.app");
        DocSection all = new DocSection("(load-module :app)", this.id());
        section.addSection(all);
        DocSection build = new DocSection("Build", this.id());
        all.addSection(build);
        build.addItem(this.getDocItem("app/build", false));
        DocSection manifest = new DocSection("Manifest", this.id());
        all.addSection(manifest);
        manifest.addItem(this.getDocItem("app/manifest", false));
        return section;
    }

    private DocSection getModuleExcelSection() {
        String footer = "Required 3rd party libraries:\n\n* org.apache.poi:poi:4.1.2\n* org.apache.poi:ooxml:4.1.2\n* org.apache.poi:ooxml-schemas:4.1.2\n* commons-codec:commons-codec:1.15\n* org.apache.commons:commons-collections:4.4.4\n* org.apache.commons:commons-compress:1.20\n* org.apache.commons:commons-math3:3.6.1\n* org.apache.xmlbeans:xmlbeans:3.1.0\n";
        DocSection section = new DocSection("Excel", "Read/Write Excel files", "modules.excel", null, "Required 3rd party libraries:\n\n* org.apache.poi:poi:4.1.2\n* org.apache.poi:ooxml:4.1.2\n* org.apache.poi:ooxml-schemas:4.1.2\n* commons-codec:commons-codec:1.15\n* org.apache.commons:commons-collections:4.4.4\n* org.apache.commons:commons-compress:1.20\n* org.apache.commons:commons-math3:3.6.1\n* org.apache.xmlbeans:xmlbeans:3.1.0\n");
        DocSection all = new DocSection("(load-module :excel)", this.id());
        section.addSection(all);
        DocSection wr = new DocSection("Writer", this.id());
        all.addSection(wr);
        wr.addItem(this.getDocItem("excel/writer", false));
        wr.addItem(this.getDocItem("excel/add-sheet", false));
        wr.addItem(this.getDocItem("excel/add-font", false));
        wr.addItem(this.getDocItem("excel/add-style", false));
        wr.addItem(this.getDocItem("excel/add-column", false));
        DocSection wr_data = new DocSection("Writer Data", this.id());
        all.addSection(wr_data);
        wr_data.addItem(this.getDocItem("excel/write-data", false));
        wr_data.addItem(this.getDocItem("excel/write-items", false));
        wr_data.addItem(this.getDocItem("excel/write-item", false));
        wr_data.addItem(this.getDocItem("excel/write-value", false));
        DocSection wr_io = new DocSection("Writer I/O", this.id());
        all.addSection(wr_io);
        wr_io.addItem(this.getDocItem("excel/write->file", false));
        wr_io.addItem(this.getDocItem("excel/write->stream", false));
        wr_io.addItem(this.getDocItem("excel/write->bytebuf", false));
        DocSection wr_util = new DocSection("Writer Util", this.id());
        all.addSection(wr_util);
        wr_util.addItem(this.getDocItem("excel/cell-formula", false));
        wr_util.addItem(this.getDocItem("excel/sum-formula", false));
        wr_util.addItem(this.getDocItem("excel/cell-address", false));
        wr_util.addItem(this.getDocItem("excel/auto-size-columns", false));
        wr_util.addItem(this.getDocItem("excel/auto-size-column", false));
        wr_util.addItem(this.getDocItem("excel/row-height", false));
        wr_util.addItem(this.getDocItem("excel/evaluate-formulas", false));
        wr_util.addItem(this.getDocItem("excel/convert->reader", false));
        DocSection rd = new DocSection("Reader", this.id());
        all.addSection(rd);
        rd.addItem(this.getDocItem("excel/open", false));
        rd.addItem(this.getDocItem("excel/sheet", false));
        rd.addItem(this.getDocItem("excel/read-string-val", false));
        rd.addItem(this.getDocItem("excel/read-boolean-val", false));
        rd.addItem(this.getDocItem("excel/read-long-val", false));
        rd.addItem(this.getDocItem("excel/read-double-val", false));
        rd.addItem(this.getDocItem("excel/read-date-val", false));
        DocSection rd_util = new DocSection("Reader Util", this.id());
        all.addSection(rd_util);
        rd_util.addItem(this.getDocItem("excel/sheet-count", false));
        rd_util.addItem(this.getDocItem("excel/sheet-name", false));
        rd_util.addItem(this.getDocItem("excel/sheet-row-range", false));
        rd_util.addItem(this.getDocItem("excel/sheet-col-range", false));
        rd_util.addItem(this.getDocItem("excel/evaluate-formulas", false));
        rd_util.addItem(this.getDocItem("excel/cell-empty?", false));
        rd_util.addItem(this.getDocItem("excel/cell-type", false));
        return section;
    }

    private DocItem getDocItem(String name) {
        return this.getDocItem(name, true, false);
    }

    private DocItem getDocItem(String name, boolean runExamples) {
        return this.getDocItem(name, runExamples, false);
    }

    private DocItem getDocItem(String name, boolean runExamples, boolean catchEx) {
        DocItem item = this.docItems.get(name);
        if (item != null) {
            return item;
        }
        DocItem item_ = this.getDocItem_(name, runExamples, catchEx);
        if (item_ != null) {
            this.docItems.put(name, item_);
        }
        return item_;
    }

    private DocItem getDocItem_(String name, boolean runExamples, boolean catchEx) {
        VncProtocol crossRefProtocol = this.findProtocol(name);
        if (crossRefProtocol != null) {
            String fnDescr = crossRefProtocol.getDoc() == Constants.Nil ? "" : ((VncString)crossRefProtocol.getDoc()).getValue();
            String descr = null;
            String descrXmlStyled = Markdown.parse(fnDescr).renderToHtml();
            return new DocItem(name, new ArrayList<String>(), descr, descrXmlStyled, this.runExamples(name, this.toStringList(crossRefProtocol.getExamples(), name, ":examples"), runExamples, catchEx), this.createCrossRefs(name, crossRefProtocol.getSeeAlso()), this.id(name));
        }
        VncFunction fn = this.findFunction(name);
        if (fn != null) {
            String fnDescr = fn.getDoc() == Constants.Nil ? "" : ((VncString)fn.getDoc()).getValue();
            String descr = null;
            String descrXmlStyled = Markdown.parse(fnDescr).renderToHtml();
            return new DocItem(name, this.toStringList(fn.getArgLists(), name, ":arglists"), descr, descrXmlStyled, this.runExamples(name, this.toStringList(fn.getExamples(), name, ":examples"), runExamples, catchEx), this.createCrossRefs(name, fn.getSeeAlso()), this.id(name));
        }
        throw new RuntimeException(String.format("Unknown doc function %s", name));
    }

    private List<ExampleOutput> runExamples(String name, List<String> examples, boolean run, boolean catchEx) {
        if (this.runExamples) {
            Venice runner = new Venice();
            AtomicLong exampleNr = new AtomicLong(0L);
            try {
                return examples.stream().filter(e -> !StringUtil.isEmpty(e)).map(e -> this.runExample(runner, exampleNr.incrementAndGet(), name, (String)e, run, catchEx)).collect(Collectors.toList());
            }
            catch (RuntimeException ex) {
                throw new RuntimeException(String.format("Failed to run examples #%d (of %d) for %s", exampleNr.get(), examples.size(), name), ex);
            }
        }
        return EMPTY_EXAMPLES;
    }

    private ExampleOutput runExample(Venice runner, long exampleNr, String name, String example, boolean run, boolean catchEx) {
        String exampleHighlighted = this.codeHighlighter.highlight(example);
        if (run) {
            CapturingPrintStream ps_out = new CapturingPrintStream();
            CapturingPrintStream ps_err = new CapturingPrintStream();
            try {
                String modules = this.preloadedModules.stream().map(m -> "  (load-module :" + m + ")").collect(Collectors.joining("\n"));
                String script = "(do \n" + modules + "\n\n  (pr-str " + example + "\n))";
                String result = (String)runner.eval("example", script, Parameters.of("*out*", ps_out, "*err*", ps_err));
                return new ExampleOutput(name, example, exampleHighlighted, ps_out.getOutput(), ps_err.getOutput(), result);
            }
            catch (RuntimeException ex) {
                if (catchEx) {
                    return new ExampleOutput(name, example, exampleHighlighted, ps_out.getOutput(), ps_err.getOutput(), ex);
                }
                throw new RuntimeException(String.format("Failed to run example #%d for '%s'", exampleNr, name), ex);
            }
        }
        return new ExampleOutput(name, example, exampleHighlighted);
    }

    private VncFunction findFunction(String name) {
        VncFunction fn = (VncFunction)SpecialFormsDoc.ns.get(new VncSymbol(name));
        if (fn != null) {
            return fn;
        }
        return this.getFunction(name);
    }

    private VncProtocol findProtocol(String name) {
        VncVal val = this.env.getOrNil(new VncSymbol(name));
        return val instanceof VncProtocol ? (VncProtocol)val : null;
    }

    private List<CrossRef> createCrossRefs(String parentName, VncList seeAlso) {
        ArrayList<CrossRef> crossRefs = new ArrayList<CrossRef>();
        seeAlso.forEach((Consumer<? super VncVal>)((Consumer<VncVal>)v -> {
            String crossRefFnName = ((VncString)v).getValue();
            VncProtocol crossRefProtocol = this.findProtocol(crossRefFnName);
            if (crossRefProtocol != null) {
                String doc;
                String string = doc = crossRefProtocol.getDoc() == Constants.Nil ? null : ((VncString)crossRefProtocol.getDoc()).getValue();
                if (doc != null) {
                    crossRefs.add(this.createCrossRef(crossRefFnName, this.getCrossRefDescr(doc)));
                }
            } else {
                VncFunction crossRefFn = this.findFunction(crossRefFnName);
                if (crossRefFn != null) {
                    String doc;
                    String string = doc = crossRefFn.getDoc() == Constants.Nil ? null : ((VncString)crossRefFn.getDoc()).getValue();
                    if (doc != null) {
                        crossRefs.add(this.createCrossRef(crossRefFnName, this.getCrossRefDescr(doc)));
                    }
                } else {
                    throw new RuntimeException(String.format("Missing cross reference function %s -> %s", parentName, crossRefFnName));
                }
            }
        }));
        return crossRefs;
    }

    private String getCrossRefDescr(String descr) {
        String s;
        String crossRefDescr = Markdown.parse(descr).renderToText(290);
        int posLF = crossRefDescr.indexOf(10);
        String string = s = posLF == -1 ? crossRefDescr.trim() : crossRefDescr.substring(0, posLF).trim();
        if (s.length() > 145) {
            int spacePos = s.indexOf(32, 130);
            String string2 = s = spacePos != -1 ? s.substring(0, spacePos) : s.substring(0, 140).trim();
            if (!s.endsWith(".")) {
                s = s + " ...";
            }
        }
        return s;
    }

    private CrossRef createCrossRef(String name, String descr) {
        return new CrossRef(name, this.id(name), descr);
    }

    private List<String> toStringList(VncList list, String name, String helpType) {
        try {
            return list.stream().map(s -> ((VncString)s).getValue()).collect(Collectors.toList());
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Failed on item '%s' processing %s", name, helpType), ex);
        }
    }

    private List<DocSection> concat(List<DocSection> s1, List<DocSection> s2, List<DocSection> s3, List<DocSection> s4) {
        ArrayList<DocSection> list = new ArrayList<DocSection>();
        list.addAll(s1);
        list.addAll(s2);
        list.addAll(s3);
        list.addAll(s4);
        return list;
    }

    private void save(File file, String text) throws Exception {
        this.save(file, text.getBytes("UTF-8"));
    }

    private void save(File file, byte[] data) throws Exception {
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(data, 0, data.length);
            fos.flush();
        }
    }

    private File getUserDir() {
        return new File(System.getProperty("user.dir"));
    }

    private VncFunction getFunction(String name) {
        VncVal val = this.env.getOrNil(new VncSymbol(name));
        return Types.isVncFunction(val) ? (VncFunction)val : null;
    }

    private Markdown loadVeniceDocMarkdown() {
        try {
            return Markdown.parse(new ClassPathResource(VeniceClasspath.getVeniceBasePath() + "docgen/venice-doc.md").getResourceAsString("UTF-8"));
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to read 'venice-doc.md!", ex);
        }
    }

    private Markdown loadMarkdownDoc() {
        try {
            return Markdown.parse(new ClassPathResource(VeniceClasspath.getVeniceBasePath() + "docgen/markdown-doc.md").getResourceAsString("UTF-8"));
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to read 'markdown-doc.md!", ex);
        }
    }

    private final void validateUniqueSectionsId(List<DocSection> left, List<DocSection> right) {
        HashSet ids = new HashSet();
        left.forEach(s -> this.validateUniqueSectionId((DocSection)s, ids));
        right.forEach(s -> this.validateUniqueSectionId((DocSection)s, ids));
    }

    private final void validateUniqueSectionId(DocSection section, Set<String> ids) {
        String id = section.getId();
        if (id != null) {
            if (ids.contains(section.getId())) {
                throw new RuntimeException(String.format("Non unique section id %s on section %s", id, section.getTitle()));
            }
            ids.add(id);
        }
        section.getSections().forEach(s -> this.validateUniqueSectionId((DocSection)s, ids));
    }

    private String id() {
        return this.idgen.id();
    }

    private String id(String name) {
        return this.idgen.id(name);
    }
}

