/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.ModuleLoader;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Map;

public class ModuleFunctions {
    public static VncFunction loadModule = new VncFunction("load-module*", (VncVal)VncFunction.meta().arglists("(load-module* name)").doc("Loads a Venice extension module.").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            try {
                String name = Coerce.toVncString(CoreFunctions.name.apply(args)).getValue();
                IInterceptor interceptor = ThreadContext.getInterceptor();
                interceptor.validateLoadModule(name);
                return new VncString(ModuleLoader.loadModule(name));
            }
            catch (Exception ex) {
                throw new VncException("Failed to load Venice module", ex);
            }
        }

        @Override
        public boolean isRedefinable() {
            return false;
        }
    };
    public static VncFunction loadClasspathFile = new VncFunction("load-classpath-file*", (VncVal)VncFunction.meta().arglists("(load-classpath-file* name)").doc("Loads a Venice file from the classpath.").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            try {
                String file = ModuleFunctions.suffixWithVeniceFileExt(ModuleFunctions.name(args.first()));
                if (file != null) {
                    String res = ModuleLoader.loadClasspathFile(file);
                    return res == null ? Constants.Nil : new VncString(res);
                }
                return Constants.Nil;
            }
            catch (Exception ex) {
                throw new VncException("Failed to load Venice classpath file", ex);
            }
        }

        @Override
        public boolean isRedefinable() {
            return false;
        }
    };
    public static VncFunction loadFile = new VncFunction("load-file*", (VncVal)VncFunction.meta().arglists("(load-file* file)").doc("Loads a venice file from the given load-paths").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            String file = ModuleFunctions.name(args.first());
            try {
                String data = ModuleLoader.loadExternalFile(file);
                return new VncString(data);
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException("Failed to load the Venice file '" + file + "'", ex);
            }
        }

        @Override
        public boolean isRedefinable() {
            return false;
        }
    };
    public static VncFunction loadResource = new VncFunction("load-resource*", (VncVal)VncFunction.meta().arglists("(load-resource* file & options)").doc("Loads a resource from the given load-paths. Returns a string, a bytebuffer or nil if the file does not exist. \n\nOptions: \n\n| :binary b   | e.g :binary true, defaults to true |\n| :encoding e | e.g :encoding :utf-8, defaults to :utf-8 |").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            String file = ModuleFunctions.name(args.first());
            try {
                VncHashMap options = VncHashMap.ofAll(args.rest());
                boolean binary = VncBoolean.isTrue(options.get(new VncKeyword("binary"), VncBoolean.True));
                String encoding = ModuleFunctions.encoding(options.get(new VncKeyword("encoding")));
                IInterceptor interceptor = ThreadContext.getInterceptor();
                if (binary) {
                    ByteBuffer data = interceptor.getLoadPaths().loadBinaryResource(new File(file));
                    if (data == null) {
                        throw new VncException("Failed to load the resource file '" + file + "'!");
                    }
                    return new VncByteBuffer(data);
                }
                String data = interceptor.getLoadPaths().loadTextResource(new File(file), encoding);
                if (data == null) {
                    throw new VncException("Failed to load the resource file '" + file + "'!");
                }
                return new VncString(data);
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException("Failed to load the resource '" + file + "'", ex);
            }
        }

        @Override
        public boolean isRedefinable() {
            return false;
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().add(loadModule).add(loadFile).add(loadResource).add(loadClasspathFile).toMap();

    private static String name(VncVal val) {
        if (Types.isVncString(val)) {
            return ((VncString)val).getValue();
        }
        if (Types.isVncKeyword(val)) {
            return ((VncKeyword)val).getValue();
        }
        if (Types.isVncSymbol(val)) {
            return ((VncSymbol)val).getName();
        }
        return null;
    }

    private static String suffixWithVeniceFileExt(String s) {
        return s.endsWith(".venice") ? s : s + ".venice";
    }

    private static String encoding(VncVal enc) {
        return enc == Constants.Nil ? Charset.defaultCharset().name() : (Types.isVncKeyword(enc) ? Coerce.toVncKeyword(enc).getValue() : Coerce.toVncString(enc).getValue());
    }
}

