/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.EofException;
import com.github.jlangch.venice.impl.IVeniceInterpreter;
import com.github.jlangch.venice.impl.util.StringUtil;
import org.repackage.org.jline.reader.EOFError;
import org.repackage.org.jline.reader.ParsedLine;
import org.repackage.org.jline.reader.Parser;
import org.repackage.org.jline.reader.SyntaxError;
import org.repackage.org.jline.reader.impl.DefaultParser;

public class ReplParser
extends DefaultParser {
    private final IVeniceInterpreter venice;
    private boolean eof = false;

    public ReplParser(IVeniceInterpreter venice) {
        this.venice = venice;
        this.setQuoteChars(new char[]{'\"'});
    }

    @Override
    public ParsedLine parse(String line, int cursor, Parser.ParseContext context) throws SyntaxError {
        try {
            if (line.startsWith("/") && line.trim().endsWith(".venice")) {
                this.eof = false;
                return super.parse(line, cursor, context);
            }
            if (context != Parser.ParseContext.COMPLETE) {
                this.venice.READ(line, "repl");
            }
            this.eof = false;
            return super.parse(line, cursor, context);
        }
        catch (EofException ex) {
            this.eof = true;
            throw new EOFError(1, 1, ex.getMessage());
        }
    }

    public boolean isEOF() {
        return this.eof;
    }

    public void reset() {
        this.eof = false;
    }

    public static boolean isDroppedVeniceScriptFile(String buffer) {
        return StringUtil.trimToEmpty(buffer).endsWith(".venice");
    }

    public static boolean isCommand(String buffer) {
        String cmd = buffer.trim();
        return cmd.startsWith("!") || cmd.startsWith("$");
    }
}

