/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMapEntry;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VncMutableMap
extends VncMap {
    public static final String TYPE = ":core/mutable-map";
    private static final long serialVersionUID = -1848883965231344442L;
    private final ConcurrentHashMap<VncVal, VncVal> value;

    public VncMutableMap() {
        this((Map<VncVal, VncVal>)null, (VncVal)null);
    }

    public VncMutableMap(VncVal meta) {
        this((Map<VncVal, VncVal>)null, meta);
    }

    public VncMutableMap(Map<VncVal, VncVal> vals) {
        this(vals, null);
    }

    public VncMutableMap(Map<VncVal, VncVal> vals, VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        this.value = vals == null ? new ConcurrentHashMap() : new ConcurrentHashMap<VncVal, VncVal>(vals);
    }

    public static VncMutableMap ofAll(VncSequence lst) {
        if (lst != null && lst.size() % 2 != 0) {
            throw new VncException(String.format("mutable-map: create requires an even number of list items. Got %d items.", lst.size()));
        }
        return new VncMutableMap().assoc(lst);
    }

    public static VncMutableMap of(VncVal ... mvs) {
        if (mvs != null && mvs.length % 2 != 0) {
            throw new VncException(String.format("mutable-map: create requires an even number of items. Got %d items.", mvs.length));
        }
        return new VncMutableMap().assoc(mvs);
    }

    @Override
    public VncMutableMap emptyWithMeta() {
        return new VncMutableMap(this.getMeta());
    }

    @Override
    public VncMutableMap withValues(Map<VncVal, VncVal> replaceVals) {
        return new VncMutableMap(replaceVals, this.getMeta());
    }

    @Override
    public VncMutableMap withValues(Map<VncVal, VncVal> replaceVals, VncVal meta) {
        return new VncMutableMap(replaceVals, meta);
    }

    @Override
    public VncMutableMap withMeta(VncVal meta) {
        return new VncMutableMap(this.value, meta);
    }

    @Override
    public VncKeyword getType() {
        return new VncKeyword(TYPE, MetaUtil.typeMeta(new VncKeyword(":core/map"), new VncKeyword(":core/collection"), new VncKeyword(":core/val")));
    }

    @Override
    public Map<VncVal, VncVal> getJavaMap() {
        return Collections.unmodifiableMap(this.value);
    }

    @Override
    public VncVal get(VncVal key) {
        VncVal val = this.value.get(key);
        return val == null ? Constants.Nil : val;
    }

    @Override
    public VncVal containsKey(VncVal key) {
        return VncBoolean.of(this.value.containsKey(key));
    }

    @Override
    public VncList keys() {
        return VncList.ofList(new ArrayList(this.value.keySet()));
    }

    @Override
    public List<VncMapEntry> entries() {
        return Collections.unmodifiableList(this.value.entrySet().stream().map(e -> new VncMapEntry((VncVal)e.getKey(), (VncVal)e.getValue())).collect(Collectors.toList()));
    }

    @Override
    public VncMutableMap putAll(VncMap map) {
        this.value.putAll(map.getJavaMap());
        return this;
    }

    @Override
    public VncMutableMap assoc(VncVal ... mvs) {
        if (mvs.length % 2 != 0) {
            throw new VncException(String.format("mutable-map: assoc requires an even number of items.", new Object[0]));
        }
        for (int i = 0; i < mvs.length - 1; i += 2) {
            this.value.put(mvs[i], mvs[i + 1]);
        }
        return this;
    }

    @Override
    public VncMutableMap assoc(VncSequence mvs) {
        if (mvs.size() % 2 != 0) {
            throw new VncException(String.format("mutable-map: assoc requires an even number of items.", new Object[0]));
        }
        VncSequence kv = mvs;
        while (!kv.isEmpty()) {
            this.value.put(kv.first(), kv.second());
            kv = kv.drop(2);
        }
        return this;
    }

    @Override
    public VncMutableMap dissoc(VncVal ... keys) {
        for (VncVal key : keys) {
            this.value.remove(key);
        }
        return this;
    }

    @Override
    public VncMutableMap dissoc(VncSequence keys) {
        for (VncVal key : keys) {
            this.value.remove(key);
        }
        return this;
    }

    @Override
    public VncList toVncList() {
        return VncList.ofAll(this.value.entrySet().stream().map(e -> VncVector.of((VncVal)e.getKey(), (VncVal)e.getValue())), this.getMeta());
    }

    @Override
    public VncVector toVncVector() {
        return VncVector.ofAll(this.value.entrySet().stream().map(e -> VncVector.of((VncVal)e.getKey(), (VncVal)e.getValue())), this.getMeta());
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public void clear() {
        this.value.clear();
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.MUTABLEMAP;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncMutableMap(o)) {
            int c = Integer.compare(this.size(), ((VncMutableMap)o).size());
            if (c != 0) {
                return c;
            }
            return this.equals(o) ? 0 : -1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncMutableMap other = (VncMutableMap)obj;
        return this.value.equals(other.value);
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean print_machine_readably) {
        Stream<VncVal> stream = this.value.entrySet().stream().map(e -> Arrays.asList((VncVal)e.getKey(), (VncVal)e.getValue())).flatMap(l -> l.stream());
        return "{" + Printer.join(stream, " ", print_machine_readably) + "}";
    }
}

