/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.ArityException;
import com.github.jlangch.venice.AssertionException;
import com.github.jlangch.venice.impl.Destructuring;
import com.github.jlangch.venice.impl.IFormEvaluator;
import com.github.jlangch.venice.impl.Namespace;
import com.github.jlangch.venice.impl.Namespaces;
import com.github.jlangch.venice.impl.debug.agent.DebugAgent;
import com.github.jlangch.venice.impl.debug.breakpoint.BreakpointFnRef;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.CallFrameFnData;
import com.github.jlangch.venice.impl.util.CallStack;
import com.github.jlangch.venice.impl.util.WithCallStack;

public class FunctionBuilder {
    private final IFormEvaluator evaluator;
    private final boolean optimized;

    public FunctionBuilder(IFormEvaluator evaluator, boolean optimized) {
        this.evaluator = evaluator;
        this.optimized = optimized;
    }

    public VncFunction buildFunction(final String name, final VncVector params, final VncList body, final VncVector preConditions, boolean macro, VncVal meta, final Env env) {
        VncVal[] vncValArray;
        boolean hasPreConditions;
        final Namespace functionNS = Namespaces.getCurrentNamespace();
        final boolean switchToFunctionNamespaceAtRuntime = !macro && !name.equals("macroexpand-all");
        final boolean plainSymbolParams = Destructuring.isFnParamsWithoutDestructuring(params);
        boolean bl = hasPreConditions = preConditions != null && !preConditions.isEmpty();
        if (body.isEmpty()) {
            VncVal[] vncValArray2 = new VncVal[1];
            vncValArray = vncValArray2;
            vncValArray2[0] = Constants.Nil;
        } else {
            vncValArray = body.getJavaList().toArray(new VncVal[0]);
        }
        final VncVal[] bodyExprs = vncValArray;
        final VncVal[] paramArr = params.getJavaList().toArray(new VncVal[0]);
        return new VncFunction(name, params, macro, preConditions, meta){
            private static final long serialVersionUID = -1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VncVal apply(VncList args) {
                ThreadContext threadCtx = ThreadContext.get();
                CallFrameFnData callFrameFnData = threadCtx.getAndClearCallFrameFnData_();
                if (this.hasVariadicArgs()) {
                    if (args.size() < this.getFixedArgsCount()) {
                        FunctionBuilder.this.throwVariadicArityException(this, args, callFrameFnData);
                    }
                } else if (args.size() != this.getFixedArgsCount()) {
                    FunctionBuilder.this.throwFixedArityException(this, args, callFrameFnData);
                }
                Env localEnv = new Env(env);
                this.addFnArgsToEnv(args, localEnv);
                if (switchToFunctionNamespaceAtRuntime) {
                    boolean pushCallstack;
                    Namespace curr_ns;
                    CallStack callStack;
                    block16: {
                        callStack = threadCtx.getCallStack_();
                        DebugAgent debugAgent = threadCtx.getDebugAgent_();
                        curr_ns = threadCtx.getCurrNS_();
                        String fnName = this.getQualifiedName();
                        boolean bl = pushCallstack = !FunctionBuilder.this.optimized && callFrameFnData != null && callFrameFnData.matchesFnName(fnName);
                        if (pushCallstack) {
                            callStack.push(new CallFrame(fnName, args, callFrameFnData.getFnMeta(), localEnv));
                        }
                        threadCtx.setCurrNS_(functionNS);
                        if (debugAgent != null && debugAgent.hasBreakpointFor(new BreakpointFnRef(fnName))) {
                            CallStack cs = threadCtx.getCallStack_();
                            try {
                                debugAgent.onBreakFnEnter(fnName, this, args, localEnv, cs);
                                if (hasPreConditions) {
                                    this.validateFnPreconditions(localEnv);
                                }
                                VncVal retVal = FunctionBuilder.this.evaluateBody(bodyExprs, localEnv, true);
                                debugAgent.onBreakFnExit(fnName, this, args, retVal, localEnv, cs);
                                VncVal vncVal = retVal;
                                return vncVal;
                            }
                            catch (Exception ex) {
                                debugAgent.onBreakFnException(fnName, this, args, ex, localEnv, cs);
                                throw ex;
                            }
                        }
                        if (!hasPreConditions) break block16;
                        this.validateFnPreconditions(localEnv);
                    }
                    VncVal vncVal = FunctionBuilder.this.evaluateBody(bodyExprs, localEnv, true);
                    return vncVal;
                    finally {
                        if (pushCallstack) {
                            callStack.pop();
                        }
                        threadCtx.setCurrNS_(curr_ns);
                    }
                }
                if (hasPreConditions) {
                    this.validateFnPreconditions(localEnv);
                }
                return FunctionBuilder.this.evaluateBody(bodyExprs, localEnv, false);
            }

            @Override
            public boolean isNative() {
                return false;
            }

            @Override
            public VncVal getBody() {
                return body;
            }

            private void addFnArgsToEnv(VncList args, Env env2) {
                if (plainSymbolParams) {
                    for (int ii = 0; ii < paramArr.length; ++ii) {
                        env2.setLocal(new Var((VncSymbol)paramArr[ii], args.nthOrDefault(ii, Constants.Nil)));
                    }
                } else {
                    env2.addLocalVars(Destructuring.destructure(params, args));
                }
            }

            private void validateFnPreconditions(Env env2) {
                Env local = new Env(env2);
                for (VncVal v : preConditions) {
                    if (FunctionBuilder.this.isFnConditionTrue(FunctionBuilder.this.evaluator.evaluate(v, local, false))) continue;
                    CallFrame cf = new CallFrame(name, v.getMeta());
                    WithCallStack cs = new WithCallStack(cf);
                    Throwable throwable = null;
                    try {
                        try {
                            throw new AssertionException(String.format("pre-condition assert failed: %s", v.toString(true)));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (cs != null) {
                            if (throwable != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                cs.close();
                            }
                        }
                        throw throwable3;
                    }
                }
            }
        };
    }

    private void throwVariadicArityException(VncFunction fn, VncList args, CallFrameFnData callFrameFnData) {
        VncVal meta = callFrameFnData == null ? null : callFrameFnData.getFnMeta();
        CallFrame cf = new CallFrame(fn.getQualifiedName(), meta);
        WithCallStack cs = new WithCallStack(cf);
        Throwable throwable = null;
        try {
            try {
                throw new ArityException(ArityExceptions.formatVariadicArityExMsg(fn.getQualifiedName(), fn.isMacro() ? ArityExceptions.FnType.Macro : ArityExceptions.FnType.Function, args.size(), fn.getFixedArgsCount(), fn.getArgLists()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    private void throwFixedArityException(VncFunction fn, VncList args, CallFrameFnData callFrameFnData) {
        VncVal meta = callFrameFnData == null ? null : callFrameFnData.getFnMeta();
        CallFrame cf = new CallFrame(fn.getQualifiedName(), meta);
        WithCallStack cs = new WithCallStack(cf);
        Throwable throwable = null;
        try {
            try {
                throw new ArityException(ArityExceptions.formatArityExMsg(fn.getQualifiedName(), fn.isMacro() ? ArityExceptions.FnType.Macro : ArityExceptions.FnType.Function, args.size(), fn.getFixedArgsCount(), fn.getArgLists()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    private boolean isFnConditionTrue(VncVal result) {
        return Types.isVncSequence(result) ? VncBoolean.isTrue(((VncSequence)result).first()) : VncBoolean.isTrue(result);
    }

    private VncVal evaluateBody(VncVal[] body, Env env, boolean withTailPosition) {
        if (body.length == 1) {
            return this.evaluator.evaluate(body[0], env, withTailPosition);
        }
        for (int ii = 0; ii < body.length - 1; ++ii) {
            this.evaluator.evaluate(body[ii], env, false);
        }
        return this.evaluator.evaluate(body[body.length - 1], env, withTailPosition);
    }
}

