/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.MetaUtil;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class VncChar
extends VncVal {
    private static final Map<String, VncChar> SYMBOLS = VncChar.symbols();
    public static final String TYPE = ":core/char";
    private static final long serialVersionUID = -1848883965231344442L;
    private final Character value;

    public VncChar(char v) {
        this(Character.valueOf(v), null);
    }

    public VncChar(Character v) {
        this(v, null);
    }

    public VncChar(Character v, VncWrappingTypeDef wrappingTypeDef) {
        super(wrappingTypeDef, Constants.Nil);
        this.value = v;
    }

    public Character getValue() {
        return this.value;
    }

    public String toUnicode() {
        return String.format("\\u%04X", this.value.charValue());
    }

    @Override
    public VncChar withMeta(VncVal meta) {
        return this;
    }

    @Override
    public VncChar wrap(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        return new VncChar(this.value, wrappingTypeDef);
    }

    @Override
    public VncKeyword getType() {
        return this.isWrapped() ? new VncKeyword(this.getWrappingTypeDef().getType().getQualifiedName(), MetaUtil.typeMeta(new VncKeyword(TYPE), new VncKeyword(":core/val"))) : new VncKeyword(TYPE, MetaUtil.typeMeta(new VncKeyword(":core/val")));
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.CHAR;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncChar(o)) {
            return this.getValue().compareTo(((VncChar)o).getValue());
        }
        if (Types.isVncString(o)) {
            return this.getValue().toString().compareTo(((VncString)o).getValue());
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.value.equals(((VncChar)obj).value);
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public String toString(boolean print_machine_readably) {
        if (print_machine_readably) {
            char ch = this.value.charValue();
            if (ch <= ' ') {
                if (ch == ' ') {
                    return "#\\space";
                }
                if (ch == '\n') {
                    return "#\\newline";
                }
                if (ch == '\t') {
                    return "#\\tab";
                }
                if (ch == '\r') {
                    return "#\\return";
                }
                if (ch == '\f') {
                    return "#\\formfeed";
                }
                if (ch == '\b') {
                    return "#\\backspace";
                }
                return "#" + StringUtil.toEscapedUnicode(ch);
            }
            if (ch == '\\') {
                return "#\\backslash";
            }
            if (ch == '\u007f') {
                return "#" + StringUtil.toEscapedUnicode(ch);
            }
            return "#\\" + ch;
        }
        return this.value.toString();
    }

    public static VncChar fromSymbol(String symbol) {
        return SYMBOLS.get(symbol);
    }

    public static Map<String, VncChar> symbols() {
        LinkedHashMap<String, VncChar> map = new LinkedHashMap<String, VncChar>();
        map.put("#\\space", new VncChar(' '));
        map.put("#\\newline", new VncChar('\n'));
        map.put("#\\tab", new VncChar('\t'));
        map.put("#\\formfeed", new VncChar('\f'));
        map.put("#\\return", new VncChar('\r'));
        map.put("#\\backspace", new VncChar('\b'));
        map.put("#\\lparen", new VncChar('('));
        map.put("#\\rparen", new VncChar(')'));
        map.put("#\\quote", new VncChar('\"'));
        map.put("#\\backslash", new VncChar('\\'));
        map.put("#\\pilcrow", new VncChar('\u00b6'));
        map.put("#\\middle-dot", new VncChar('\u00b7'));
        map.put("#\\right-guillemet", new VncChar('\u00bb'));
        map.put("#\\left-guillemet", new VncChar('\u00ab'));
        map.put("#\\copyright", new VncChar('\u00a9'));
        map.put("#\\bullet", new VncChar('\u2022'));
        map.put("#\\horz-ellipsis", new VncChar('\u2026'));
        map.put("#\\per-mille-sign", new VncChar('\u2030'));
        map.put("#\\diameter-sign", new VncChar('\u2300'));
        map.put("#\\check-mark", new VncChar('\u2713'));
        map.put("#\\cross-mark", new VncChar('\u2717'));
        map.put("#\\pi", new VncChar('\u03c0'));
        map.put("#\\nbsp", new VncChar('\u00a0'));
        map.put("#\\en-space", new VncChar('\u2002'));
        map.put("#\\em-space", new VncChar('\u2003'));
        map.put("#\\three-per-em-space", new VncChar('\u2004'));
        map.put("#\\four-per-em-space", new VncChar('\u2005'));
        map.put("#\\six-per-em-space", new VncChar('\u2006'));
        return Collections.unmodifiableMap(map);
    }
}

