/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util;

import com.github.jlangch.venice.SecurityException;
import com.github.jlangch.venice.util.NullOutputStream;
import java.io.PrintStream;

public class CapturingPrintStream
extends PrintStream {
    public static final int DEFAULT_LIMIT = 0xA00000;
    private final int limit;
    private final StringBuilder sb = new StringBuilder();

    public CapturingPrintStream() {
        this(0xA00000);
    }

    public CapturingPrintStream(int limit) {
        super(new NullOutputStream());
        this.limit = limit;
    }

    @Override
    public PrintStream append(CharSequence csq) {
        this.print(csq == null ? "null" : csq.toString());
        return this;
    }

    @Override
    public PrintStream append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.print(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public PrintStream append(char c) {
        this.print(c);
        return this;
    }

    @Override
    public void print(boolean x) {
        this.print(String.valueOf(x));
    }

    @Override
    public void print(int x) {
        this.print(String.valueOf(x));
    }

    @Override
    public void print(long x) {
        this.print(String.valueOf(x));
    }

    @Override
    public void print(float x) {
        this.print(String.valueOf(x));
    }

    @Override
    public void print(double x) {
        this.print(String.valueOf(x));
    }

    @Override
    public void print(char x) {
        this.print(String.valueOf(x));
    }

    @Override
    public void print(char[] x) {
        this.print(String.valueOf(x));
    }

    @Override
    public void print(Object x) {
        this.print(String.valueOf(x));
    }

    @Override
    public void print(String s) {
        this.appendToBuffer(s);
    }

    @Override
    public void println() {
        this.println("");
    }

    @Override
    public void println(boolean x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(int x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(long x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(float x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(double x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(char x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(char[] x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(Object x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(String s) {
        this.appendToBuffer(s);
        this.appendToBuffer(System.lineSeparator());
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        throw new RuntimeException("Method write(byte[],int,int) is not supported");
    }

    @Override
    public void write(int b) {
        throw new RuntimeException("Method write(int) is not supported");
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        CapturingPrintStream capturingPrintStream = this;
        synchronized (capturingPrintStream) {
            this.sb.setLength(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        CapturingPrintStream capturingPrintStream = this;
        synchronized (capturingPrintStream) {
            return this.sb.length() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOutput() {
        CapturingPrintStream capturingPrintStream = this;
        synchronized (capturingPrintStream) {
            return this.sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendToBuffer(String s) {
        CapturingPrintStream capturingPrintStream = this;
        synchronized (capturingPrintStream) {
            int left = this.limit - this.sb.length();
            if (left <= 0) {
                throw new SecurityException(String.format("CapturingPrintStream exceeded the limit of %d chars", this.limit));
            }
            if (s.length() > left) {
                this.sb.append(s.substring(0, left));
                throw new SecurityException(String.format("CapturingPrintStream exceeded the limit of %d chars", this.limit));
            }
            this.sb.append(s);
        }
    }
}

