/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.docgen.cheatsheet.section;

import com.github.jlangch.venice.impl.docgen.cheatsheet.DocItemBuilder;
import com.github.jlangch.venice.impl.docgen.cheatsheet.DocSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.ISectionBuilder;

public class ConcurrencySection
implements ISectionBuilder {
    private final DocItemBuilder diBuilder;

    public ConcurrencySection(DocItemBuilder diBuilder) {
        this.diBuilder = diBuilder;
    }

    @Override
    public DocSection section() {
        DocSection section = new DocSection("Concurrency", "concurrency");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection atoms = new DocSection("Atoms", "concurrency.atoms");
        all.addSection(atoms);
        atoms.addItem(this.diBuilder.getDocItem("atom"));
        atoms.addItem(this.diBuilder.getDocItem("atom?"));
        atoms.addItem(this.diBuilder.getDocItem("deref"));
        atoms.addItem(this.diBuilder.getDocItem("deref?"));
        atoms.addItem(this.diBuilder.getDocItem("reset!"));
        atoms.addItem(this.diBuilder.getDocItem("swap!"));
        atoms.addItem(this.diBuilder.getDocItem("swap-vals!"));
        atoms.addItem(this.diBuilder.getDocItem("compare-and-set!"));
        atoms.addItem(this.diBuilder.getDocItem("add-watch"));
        atoms.addItem(this.diBuilder.getDocItem("remove-watch"));
        DocSection futures = new DocSection("Futures", "concurrency.futures");
        all.addSection(futures);
        futures.addItem(this.diBuilder.getDocItem("future"));
        futures.addItem(this.diBuilder.getDocItem("future-task"));
        futures.addItem(this.diBuilder.getDocItem("future?"));
        futures.addItem(this.diBuilder.getDocItem("futures-fork"));
        futures.addItem(this.diBuilder.getDocItem("futures-wait"));
        futures.addItem(this.diBuilder.getDocItem("futures-thread-pool-info"));
        futures.addItem(this.diBuilder.getDocItem("done?"));
        futures.addItem(this.diBuilder.getDocItem("cancel"));
        futures.addItem(this.diBuilder.getDocItem("cancelled?"));
        futures.addItem(this.diBuilder.getDocItem("deref"));
        futures.addItem(this.diBuilder.getDocItem("deref?"));
        futures.addItem(this.diBuilder.getDocItem("realized?"));
        DocSection promises = new DocSection("Promises", "concurrency.promises");
        all.addSection(promises);
        promises.addItem(this.diBuilder.getDocItem("promise"));
        promises.addItem(this.diBuilder.getDocItem("promise?"));
        promises.addItem(this.diBuilder.getDocItem("deliver"));
        promises.addItem(this.diBuilder.getDocItem("deliver-ex"));
        promises.addItem(this.diBuilder.getDocItem("realized?"));
        promises.addItem(this.diBuilder.getDocItem("then-accept"));
        promises.addItem(this.diBuilder.getDocItem("then-accept-both"));
        promises.addItem(this.diBuilder.getDocItem("then-apply"));
        promises.addItem(this.diBuilder.getDocItem("then-combine"));
        promises.addItem(this.diBuilder.getDocItem("then-compose"));
        promises.addItem(this.diBuilder.getDocItem("when-complete"));
        promises.addItem(this.diBuilder.getDocItem("accept-either"));
        promises.addItem(this.diBuilder.getDocItem("apply-to-either"));
        promises.addItem(this.diBuilder.getDocItem("all-of"));
        promises.addItem(this.diBuilder.getDocItem("any-of"));
        promises.addItem(this.diBuilder.getDocItem("or-timeout", true, true));
        promises.addItem(this.diBuilder.getDocItem("complete-on-timeout", true, true));
        promises.addItem(this.diBuilder.getDocItem("timeout-after", true, true));
        promises.addItem(this.diBuilder.getDocItem("done?"));
        promises.addItem(this.diBuilder.getDocItem("cancel"));
        promises.addItem(this.diBuilder.getDocItem("cancelled?"));
        DocSection delay = new DocSection("Delay", "concurrency.delay");
        all.addSection(delay);
        delay.addItem(this.diBuilder.getDocItem("delay"));
        delay.addItem(this.diBuilder.getDocItem("delay?"));
        delay.addItem(this.diBuilder.getDocItem("deref"));
        delay.addItem(this.diBuilder.getDocItem("deref?"));
        delay.addItem(this.diBuilder.getDocItem("force"));
        delay.addItem(this.diBuilder.getDocItem("realized?"));
        DocSection agents = new DocSection("Agents", "concurrency.agents");
        all.addSection(agents);
        agents.addItem(this.diBuilder.getDocItem("agent"));
        agents.addItem(this.diBuilder.getDocItem("send"));
        agents.addItem(this.diBuilder.getDocItem("send-off"));
        agents.addItem(this.diBuilder.getDocItem("restart-agent"));
        agents.addItem(this.diBuilder.getDocItem("set-error-handler!"));
        agents.addItem(this.diBuilder.getDocItem("agent-error"));
        agents.addItem(this.diBuilder.getDocItem("await"));
        agents.addItem(this.diBuilder.getDocItem("await-for"));
        agents.addItem(this.diBuilder.getDocItem("shutdown-agents", false));
        agents.addItem(this.diBuilder.getDocItem("shutdown-agents?", false));
        agents.addItem(this.diBuilder.getDocItem("await-termination-agents", false));
        agents.addItem(this.diBuilder.getDocItem("await-termination-agents?", false));
        agents.addItem(this.diBuilder.getDocItem("agent-send-thread-pool-info"));
        agents.addItem(this.diBuilder.getDocItem("agent-send-off-thread-pool-info"));
        DocSection sched = new DocSection("Scheduler", "concurrency.scheduler");
        all.addSection(sched);
        sched.addItem(this.diBuilder.getDocItem("schedule-delay", false));
        sched.addItem(this.diBuilder.getDocItem("schedule-at-fixed-rate", false));
        DocSection locking = new DocSection("Locking", "concurrency.locking");
        all.addSection(locking);
        locking.addItem(this.diBuilder.getDocItem("locking"));
        DocSection volatiles = new DocSection("Volatiles", "concurrency.volatiles");
        all.addSection(volatiles);
        volatiles.addItem(this.diBuilder.getDocItem("volatile"));
        volatiles.addItem(this.diBuilder.getDocItem("volatile?"));
        volatiles.addItem(this.diBuilder.getDocItem("deref"));
        volatiles.addItem(this.diBuilder.getDocItem("deref?"));
        volatiles.addItem(this.diBuilder.getDocItem("reset!"));
        volatiles.addItem(this.diBuilder.getDocItem("swap!"));
        DocSection thlocal = new DocSection("ThreadLocal", "concurrency.threadlocal");
        all.addSection(thlocal);
        thlocal.addItem(this.diBuilder.getDocItem("thread-local"));
        thlocal.addItem(this.diBuilder.getDocItem("thread-local?"));
        thlocal.addItem(this.diBuilder.getDocItem("thread-local-clear"));
        thlocal.addItem(this.diBuilder.getDocItem("thread-local-map"));
        thlocal.addItem(this.diBuilder.getDocItem("assoc"));
        thlocal.addItem(this.diBuilder.getDocItem("dissoc"));
        thlocal.addItem(this.diBuilder.getDocItem("get"));
        thlocal.addItem(this.diBuilder.getDocItem("binding"));
        thlocal.addItem(this.diBuilder.getDocItem("def-dynamic"));
        DocSection threads = new DocSection("Threads", "concurrency.threads");
        all.addSection(threads);
        threads.addItem(this.diBuilder.getDocItem("thread-id"));
        threads.addItem(this.diBuilder.getDocItem("thread-name"));
        threads.addItem(this.diBuilder.getDocItem("thread-daemon?"));
        threads.addItem(this.diBuilder.getDocItem("thread-interrupted?"));
        threads.addItem(this.diBuilder.getDocItem("thread-interrupted"));
        DocSection parallel = new DocSection("Parallel", "concurrency.parallel");
        all.addSection(parallel);
        parallel.addItem(this.diBuilder.getDocItem("pmap"));
        parallel.addItem(this.diBuilder.getDocItem("pcalls"));
        return section;
    }

    private String id() {
        return this.diBuilder.id();
    }
}

