/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.InterruptedException;
import com.github.jlangch.venice.SecurityException;
import com.github.jlangch.venice.TimeoutException;
import com.github.jlangch.venice.ValueException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.ScheduleFunctions;
import com.github.jlangch.venice.impl.thread.ThreadBridge;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IDeref;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.VncAtom;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncThreadLocal;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.VncVolatile;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncLazySeq;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.concurrent.Agent;
import com.github.jlangch.venice.impl.types.concurrent.Delay;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.MetaUtil;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.impl.util.concurrent.ManagedCachedThreadPoolExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ConcurrencyFunctions {
    public static VncFunction deref = new VncFunction("deref", (VncVal)VncFunction.meta().arglists("(deref x)", "(deref x timeout-ms timeout-val)").doc("Dereferences an atom, a future or a promise object. When applied to an atom, returns its current state. When applied to a future, will block if computation is not complete. The variant taking a timeout can be used for futures and will return `timeout-val` if the timeout (in milliseconds) is reached before a value is available. If a future is deref'd and the waiting thread is interrupted the futures are cancelled.").examples("(do                             \n   (def counter (atom 10))      \n   (deref counter))               ", "(do                             \n   (def counter (atom 10))      \n   @counter)                      ", "(do                             \n   (defn task [] 100)           \n   (let [f (future task)]       \n      (deref f)))                 ", "(do                             \n   (defn task [] 100)           \n   (let [f (future task)]       \n      @f))                        ", "(do                             \n   (defn task [] 100)           \n   (let [f (future task)]       \n      (deref f 300 :timeout)))    ", "(do                                              \n   (def x (delay (println \"working...\") 100))  \n   @x)                                             ", "(do                             \n   (def p (promise))            \n   (deliver p 10)               \n   @p)                            ", "(do                             \n   (def x (agent 100))          \n   @x)                            ", "(do                             \n   (def counter (volatile 10))  \n   @counter)                      ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 3);
            VncVal first = args.first();
            if (Types.isIDeref(first)) {
                IDeref d = Coerce.toIDeref(args.first());
                return d.deref();
            }
            if (Types.isVncJavaObject(first)) {
                Object delegate = ((VncJavaObject)first).getDelegate();
                if (delegate instanceof Future) {
                    Future future = (Future)delegate;
                    try {
                        if (args.size() == 1) {
                            VncVal v = (VncVal)future.get();
                            return v == null ? Constants.Nil : v;
                        }
                        long timeout = Coerce.toVncLong(args.second()).getValue();
                        VncVal v = (VncVal)future.get(timeout, TimeUnit.MILLISECONDS);
                        return v == null ? Constants.Nil : v;
                    }
                    catch (java.util.concurrent.TimeoutException ex) {
                        return args.size() == 3 ? args.third() : Constants.Nil;
                    }
                    catch (CompletionException | ExecutionException ex) {
                        if (ex.getCause() != null) {
                            if (ex.getCause() instanceof SecurityException) {
                                throw (SecurityException)ex.getCause();
                            }
                            if (ex.getCause() instanceof java.util.concurrent.TimeoutException) {
                                if (args.size() == 3) {
                                    return args.third();
                                }
                                throw new TimeoutException(ex.getCause());
                            }
                            if (ex.getCause() instanceof VncException) {
                                throw (VncException)ex.getCause();
                            }
                        }
                        throw new VncException("Future execution failure", ex);
                    }
                    catch (CancellationException ex) {
                        throw new VncException("Future has been cancelled", ex);
                    }
                    catch (java.lang.InterruptedException ex) {
                        ConcurrencyFunctions.safelyCancelFuture(future);
                        throw new InterruptedException("Interrupted while waiting for future to return result (deref future).");
                    }
                    catch (Exception ex) {
                        throw new VncException("Failed to deref future", ex);
                    }
                }
                if (Types.isIDeref(delegate)) {
                    return ((IDeref)delegate).deref();
                }
            }
            throw new VncException(String.format("Function 'deref' does not allow type %s as parameter.", Types.getType(first)));
        }
    };
    public static VncFunction deref_Q = new VncFunction("deref?", (VncVal)VncFunction.meta().arglists("(deref? x)").doc("Returns true if x is dereferencable.").examples("(deref? (atom 10))", "(deref? (delay 100))", "(deref? (promise))", "(deref? (future (fn [] 10)))", "(deref? (volatile 100))", "(deref? (agent 100))", "(deref? (just 100))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            Object delegate;
            ArityExceptions.assertArity(this, args, 1);
            VncVal first = args.first();
            if (Types.isIDeref(first)) {
                return VncBoolean.True;
            }
            if (Types.isVncJavaObject(first) && ((delegate = ((VncJavaObject)first).getDelegate()) instanceof Future || Types.isIDeref(delegate))) {
                return VncBoolean.True;
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction realized_Q = new VncFunction("realized?", (VncVal)VncFunction.meta().arglists("(realized? x)").doc("Returns true if a value has been produced for a promise, delay, or future.").examples("(do                                \n   (def task (fn [] 100))          \n   (let [f (future task)]          \n        (println (realized? f))    \n        (println @f)               \n        (println (realized? f))))    ", "(do                                \n   (def p (promise))               \n   (println (realized? p))         \n   (deliver p 123)                 \n   (println @p)                    \n   (println (realized? p)))          ", "(do                                \n   (def x (delay 100))             \n   (println (realized? x))         \n   (println @x)                    \n   (println (realized? x)))          ").seeAlso("future", "delay", "promise").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (Types.isVncJavaObject(args.first())) {
                Object delegate = ((VncJavaObject)args.first()).getDelegate();
                if (delegate instanceof Future) {
                    return VncBoolean.of(((Future)delegate).isDone());
                }
                if (delegate instanceof CompletableFuture) {
                    return VncBoolean.of(((CompletableFuture)delegate).isDone());
                }
                if (delegate instanceof Delay) {
                    return VncBoolean.of(((Delay)delegate).isRealized());
                }
            }
            return VncBoolean.True;
        }
    };
    public static VncFunction add_watch = new VncFunction("add-watch", (VncVal)VncFunction.meta().arglists("(add-watch ref key fn)").doc("Adds a watch function to an agent/atom reference. The watch fn must be a fn of 4 args: a key, the reference, its old-state, its new-state.").examples("(do                                      \n   (def x (agent 10))                    \n   (defn watcher [key ref old new]       \n         (println \"watcher: \" key))    \n   (add-watch x :test watcher))            ").seeAlso("agent").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3);
            VncVal ref = args.first();
            VncKeyword key = Coerce.toVncKeyword(args.second());
            VncFunction fn = Coerce.toVncFunction(args.nth(2));
            if (Types.isVncJavaObject(ref)) {
                Object delegate = ((VncJavaObject)args.first()).getDelegate();
                if (delegate instanceof Agent) {
                    ((Agent)delegate).addWatch(key, fn);
                    return Constants.Nil;
                }
            } else if (Types.isVncAtom(ref)) {
                ((VncAtom)ref).addWatch(key, fn);
                return Constants.Nil;
            }
            throw new VncException(String.format("Function 'add-watch' does not allow type %s as ref.", Types.getType(ref)));
        }
    };
    public static VncFunction remove_watch = new VncFunction("remove-watch", (VncVal)VncFunction.meta().arglists("(remove-watch ref key)").doc("Removes a watch function from an agent/atom reference.").examples("(do                                      \n   (def x (agent 10))                    \n   (defn watcher [key ref old new]       \n         (println \"watcher: \" key))    \n   (add-watch x :test watcher)           \n   (remove-watch x :test))                 ").seeAlso("agent").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncVal ref = args.first();
            VncKeyword key = Coerce.toVncKeyword(args.second());
            if (Types.isVncJavaObject(ref)) {
                Object delegate = ((VncJavaObject)args.first()).getDelegate();
                if (delegate instanceof Agent) {
                    ((Agent)delegate).removeWatch(key);
                    return Constants.Nil;
                }
            } else if (Types.isVncAtom(ref)) {
                ((VncAtom)ref).removeWatch(key);
                return Constants.Nil;
            }
            throw new VncException(String.format("Function 'remove-watch' does not allow type %s as ref.", Types.getType(ref)));
        }
    };
    public static VncFunction new_atom = new VncFunction("atom", (VncVal)VncFunction.meta().arglists("(atom x)", "(atom x & options)").doc("Creates an atom with the initial value x. \n\nOptions: \u00b6\n&ensp; :meta metadata-map \u00b6\n&ensp; :validator validate-fn \n\nIf metadata-map is supplied, it will become the metadata on the atom. validate-fn must be nil or a side-effect-free fn of one argument, which will be passed the intended new state on any state change. If the new state is unacceptable, the validate-fn should return false or throw an exception.").examples("(do                       \n  (def counter (atom 0))  \n  (swap! counter inc)     \n  (deref counter))          ", "(do                       \n  (def counter (atom 0))  \n  (reset! counter 9)      \n  @counter)                 ").seeAlso("deref", "reset!", "swap!", "compare-and-set!", "add-watch", "remove-watch").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            VncHashMap options = VncHashMap.ofAll(args.rest());
            VncVal meta = options.get(new VncKeyword("meta"));
            VncVal validator = options.get(new VncKeyword("validator"));
            return new VncAtom(args.first(), validator == Constants.Nil ? null : Coerce.toVncFunction(validator), MetaUtil.mergeMeta(args.getMeta(), meta));
        }
    };
    public static VncFunction atom_Q = new VncFunction("atom?", (VncVal)VncFunction.meta().arglists("(atom? x)").doc("Returns true if x is an atom, otherwise false").examples("(do                        \n   (def counter (atom 0))  \n   (atom? counter))          ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncAtom(args.first()));
        }
    };
    public static VncFunction reset_BANG = new VncFunction("reset!", (VncVal)VncFunction.meta().arglists("(reset! box newval)").doc("Sets the value of an atom or a volatile to newval without regard for the current value. Returns newval.").examples("(do                           \n  (def counter (atom 0))      \n  (reset! counter 99)         \n  @counter)                     ", "(do                           \n  (def counter (atom 0))      \n  (reset! counter 99))          ", "(do                           \n  (def counter (volatile 0))  \n  (reset! counter 99)         \n  @counter)                     ").seeAlso("atom", "volatile").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncVal val = args.first();
            if (Types.isVncAtom(val)) {
                return ((VncAtom)val).reset(args.second());
            }
            if (Types.isVncVolatile(val)) {
                return ((VncVolatile)val).reset(args.second());
            }
            throw new VncException(String.format("Function 'reset!' does not allow type %s as argument.", Types.getType(val)));
        }
    };
    public static VncFunction swap_BANG = new VncFunction("swap!", (VncVal)VncFunction.meta().arglists("(swap! box f & args)").doc("Atomically swaps the value of an atom or a volatile to be: `(apply f current-value-of-box args)`. Note that f may be called multiple times, and thus should be free of side effects. Returns the value that was swapped in.").examples("(do                                  \n   (def counter (atom 0))            \n   (swap! counter inc))                ", "(do                                  \n   (def counter (atom 0))            \n   (swap! counter inc)               \n   (swap! counter + 1)               \n   (swap! counter #(inc %))          \n   (swap! counter (fn [x] (inc x)))  \n   @counter)                           ", "(do                                  \n   (def fruits (atom ()))            \n   (swap! fruits conj :apple)        \n   (swap! fruits conj :mango)        \n   @fruits)                            ", "(do                                  \n   (def counter (volatile 0))        \n   (swap! counter (partial + 6))     \n   @counter)                           ").seeAlso("swap-vals!", "reset!", "compare-and-set!", "atom", "volatile").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            VncVal box = args.first();
            if (Types.isVncAtom(box)) {
                VncFunction fn = Coerce.toVncFunction(args.second());
                VncList swapArgs = args.slice(2);
                return ((VncAtom)box).swap(fn, swapArgs);
            }
            if (Types.isVncVolatile(box)) {
                VncFunction fn = Coerce.toVncFunction(args.second());
                VncList swapArgs = args.slice(2);
                return ((VncVolatile)box).swap(fn, swapArgs);
            }
            throw new VncException(String.format("Function 'swap!' does not allow type %s as argument.", Types.getType(box)));
        }
    };
    public static VncFunction swap_vals_BANG = new VncFunction("swap-vals!", (VncVal)VncFunction.meta().arglists("(swap-vals! atom f & args)").doc("Atomically swaps the value of an atom to be: `(apply f current-value-of-atom args)`. Note that f may be called multiple times, and thus should be free of side effects. Returns [old new], the value of the atom before and after the swap.").examples("(do                                \n   (def queue (atom '(1 2 3)))     \n   (swap-vals! queue pop))           ").seeAlso("swap!", "reset!", "compare-and-set!", "atom", "volatile").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            VncVal box = args.first();
            if (Types.isVncAtom(box)) {
                VncFunction fn = Coerce.toVncFunction(args.second());
                VncList swapArgs = args.slice(2);
                return ((VncAtom)box).swap_vals(fn, swapArgs);
            }
            throw new VncException(String.format("Function 'swap-vals!' does not allow type %s as argument.", Types.getType(box)));
        }
    };
    public static VncFunction compare_and_set_BANG = new VncFunction("compare-and-set!", (VncVal)VncFunction.meta().arglists("(compare-and-set! atom oldval newval)").doc("Atomically sets the value of atom to newval if and only if the current value of the atom is identical to oldval. Returns true if set happened, else false.").examples("(do                               \n   (def counter (atom 2))         \n   (compare-and-set! counter 2 4) \n   @counter)                        ").seeAlso("atom").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3);
            VncAtom atm = Coerce.toVncAtom(args.first());
            return atm.compareAndSet(args.second(), args.nth(2));
        }
    };
    public static VncFunction new_volatile = new VncFunction("volatile", (VncVal)VncFunction.meta().arglists("(volatile x)").doc("Creates a volatile with the initial value x").examples("(do                           \n  (def counter (volatile 0))  \n  (swap! counter inc)         \n  (deref counter))              ", "(do                           \n  (def counter (volatile 0))  \n  (reset! counter 9)          \n  @counter)                     ").seeAlso("deref", "reset!", "swap!").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return new VncVolatile(args.first(), args.getMeta());
        }
    };
    public static VncFunction volatile_Q = new VncFunction("volatile?", (VncVal)VncFunction.meta().arglists("(volatile? x)").doc("Returns true if x is a volatile, otherwise false").examples("(do                            \n   (def counter (volatile 0))  \n   (volatile? counter))          ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncVolatile(args.first()));
        }
    };
    public static VncFunction agent = new VncFunction("agent", (VncVal)VncFunction.meta().arglists("(agent state & options)").doc("Creates and returns an agent with an initial value of state and zero or more options. \n\nOptions: \u00b6\n&ensp; :error-handler handler-fn \u00b6\n&ensp; :error-mode mode-keyword \u00b6\n&ensp; :validator validate-fn \n\nThe `handler-fn` is called if an action throws an exception. It's a function taking two args the agent and the exception. The mode-keyword may be either :continue (the default) or :fail The `validate-fn` must be nil or a side-effect-free fn of one argument, which will be passed the intended new state on any state change. If the new state is unacceptable, the `validate-fn` should return false or throw an exception.").examples("(do                         \n   (def x (agent 100))      \n   (send x + 5)             \n   (sleep 100)              \n   (deref x))                 ").seeAlso("send", "send-off", "await", "await-for", "deref", "set-error-handler!", "agent-error").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            VncHashMap opts = VncHashMap.ofAll(args.rest());
            return new VncJavaObject(new Agent(args.first(), opts));
        }
    };
    public static VncFunction send = new VncFunction("send", (VncVal)VncFunction.meta().arglists("(send agent action-fn args)").doc("Dispatch an action to an agent. Returns the agent immediately.\n\nThe state of the agent will be set to the value of:\u00b6\n&ensp; `(apply action-fn state-of-agent args)`").examples("(do                           \n   (def x (agent 100))        \n   (send x + 5)               \n   (send x (partial + 7))     \n   (sleep 100)                \n   (deref x))                   ").seeAlso("agent", "send-off").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            if (Types.isVncJavaObject(args.first(), Agent.class)) {
                Agent agent = (Agent)Coerce.toVncJavaObject(args.first()).getDelegate();
                VncFunction fn = Coerce.toVncFunction(args.second());
                VncList fnArgs = args.slice(2);
                agent.send(new CallFrame(this, args), fn, fnArgs);
                return args.first();
            }
            throw new VncException(String.format("Function 'send' does not allow type %s as agent parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction send_off = new VncFunction("send-off", (VncVal)VncFunction.meta().arglists("(send-off agent fn args)").doc("Dispatch a potentially blocking action to an agent. Returns the agent immediately.\n\nThe state of the agent will be set to the value of:\u00b6\n&ensp; `(apply action-fn state-of-agent args)`").examples("(do                           \n   (def x (agent 100))        \n   (send-off x + 5)           \n   (send-off x (partial + 7)) \n   (sleep 100)                \n   (deref x))                   ").seeAlso("agent", "send").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            if (Types.isVncJavaObject(args.first(), Agent.class)) {
                Agent agent = (Agent)Coerce.toVncJavaObject(args.first()).getDelegate();
                VncFunction fn = Coerce.toVncFunction(args.second());
                VncList fnArgs = args.slice(2);
                agent.send_off(new CallFrame(this, args), fn, fnArgs);
                return args.first();
            }
            throw new VncException(String.format("Function 'send-off' does not allow type %s as agent parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction restart_agent = new VncFunction("restart-agent", (VncVal)VncFunction.meta().arglists("(restart-agent agent state)").doc("When an agent is failed, changes the agent state to new-state and then un-fails the agent so that sends are allowed again.").examples("(do                          \n   (def x (agent 100))       \n   (restart-agent x 200)     \n   (deref x))                  ").seeAlso("agent").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            if (Types.isVncJavaObject(args.first(), Agent.class)) {
                Agent agent = (Agent)Coerce.toVncJavaObject(args.first()).getDelegate();
                VncVal state = args.second();
                agent.restart(state);
                return args.first();
            }
            throw new VncException(String.format("Function 'restart-agent' does not allow type %s as agent parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction set_error_handler = new VncFunction("set-error-handler!", (VncVal)VncFunction.meta().arglists("(set-error-handler! agent handler-fn)").doc("Sets the error-handler of an agent to `handler-fn`. If an action being run by the agent throws an exception `handler-fn` will be called with two arguments: the agent and the exception.").examples("(do                                          \n   (def x (agent 100))                       \n   (defn err-handler-fn [ag ex]              \n      (println \"error occured: \"           \n               (:message ex)                 \n               \" and we still have value\"  \n               @ag))                         \n   (set-error-handler! x err-handler-fn)     \n   (send x (fn [n] (/ n 0))))                  ").seeAlso("agent", "agent-error-mode", "agent-error").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            if (Types.isVncJavaObject(args.first(), Agent.class)) {
                Agent agent = (Agent)Coerce.toVncJavaObject(args.first()).getDelegate();
                agent.setErrorHandler(Coerce.toVncFunction(args.second()));
                return args.first();
            }
            throw new VncException(String.format("Function 'set-error-handler!' does not allow type %s as agent parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction agent_error = new VncFunction("agent-error", (VncVal)VncFunction.meta().arglists("(agent-error agent)").doc("Returns the exception thrown during an asynchronous action of the agent if the agent is failed. Returns `nil` if the agent is not failed.").examples("(do                                              \n   (def x (agent 100 :error-mode :fail))         \n   (send x (fn [n] (/ n 0)))                     \n   (sleep 500)                                   \n   (agent-error x))                                ").seeAlso("agent", "set-error-handler!", "agent-error-mode").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            if (Types.isVncJavaObject(args.first(), Agent.class)) {
                Agent agent = (Agent)Coerce.toVncJavaObject(args.first()).getDelegate();
                RuntimeException ex = agent.getError();
                return ex == null ? Constants.Nil : new VncJavaObject(ex);
            }
            throw new VncException(String.format("Function 'agent-error' does not allow type %s as agent parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction agent_error_mode = new VncFunction("agent-error-mode", (VncVal)VncFunction.meta().arglists("(agent-error-mode agent)").doc("Returns the agent's error mode").examples("(do                                              \n   (def x (agent 100 :error-mode :fail))         \n   (agent-mode x))                                 ").seeAlso("agent", "set-error-handler!", "agent-error").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (Types.isVncJavaObject(args.first(), Agent.class)) {
                Agent agent = (Agent)Coerce.toVncJavaObject(args.first()).getDelegate();
                return agent.getErrorMode();
            }
            throw new VncException(String.format("Function 'agent-error-mode' does not allow type %s as agent parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction await = new VncFunction("await", (VncVal)VncFunction.meta().arglists("(await agents)").doc("Blocks the current thread (indefinitely) until all actions dispatched thus far (from this thread or agent) to the agents have occurred. ").examples("(do                                              \n   (def x1 (agent 100))                          \n   (def x2 (agent {}))                           \n   (send-off x1 + 5)                             \n   (send-off x2 (fn [state]                      \n                  (sleep 100)                    \n                  (assoc state :done true)))     \n   ;; blocks till the agent actions are finished \n   (await x1 x2))                                 ").seeAlso("agent", "await-for").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            List<Agent> agents = args.stream().map(a -> (Agent)Coerce.toVncJavaObject(a).getDelegate()).collect(Collectors.toList());
            return agents.isEmpty() ? VncBoolean.True : VncBoolean.of(Agent.await(new CallFrame(this, args), agents, -1L));
        }
    };
    public static VncFunction await_for = new VncFunction("await-for", (VncVal)VncFunction.meta().arglists("(await-for timeout-ms agents)").doc("Blocks the current thread until all actions dispatched thus far (from this thread or agent) to the agents have occurred, or the timeout (in milliseconds) has elapsed. Returns logical false if returning due to timeout, logical true otherwise.").examples("(do                                              \n   (def x1 (agent 100))                          \n   (def x2 (agent {}))                           \n   (send-off x1 + 5)                             \n   (send-off x2 (fn [state]                      \n                  (sleep 100)                    \n                  (assoc state :done true)))     \n   ;; blocks till the agent actions are finished \n   (await-for 500 x1 x2))                          ").seeAlso("agent", "await").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            long timeoutMillis = Coerce.toVncLong(args.first()).getValue();
            List<Agent> agents = args.rest().stream().map(a -> (Agent)Coerce.toVncJavaObject(a).getDelegate()).collect(Collectors.toList());
            return agents.isEmpty() ? VncBoolean.True : VncBoolean.of(Agent.await(new CallFrame(this, args), agents, timeoutMillis));
        }
    };
    public static VncFunction shutdown_agents = new VncFunction("shutdown-agents", (VncVal)VncFunction.meta().arglists("(shutdown-agents)").doc("Initiates a shutdown of the thread pools that back the agent system. Running actions will complete, but no new actions will been accepted").examples("(do                           \n   (def x1 (agent 100))       \n   (def x2 (agent 100))       \n   (shutdown-agents))          ").seeAlso("agent").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            this.sandboxFunctionCallValidation();
            Agent.shutdown();
            return Constants.Nil;
        }
    };
    public static VncFunction shutdown_agents_Q = new VncFunction("shutdown-agents?", (VncVal)VncFunction.meta().arglists("(shutdown-agents?)").doc("Returns true if the thread-pool that backs the agents is shut down").examples("(do                           \n   (def x1 (agent 100))       \n   (def x2 (agent 100))       \n   (shutdown-agents)          \n   (sleep 300)                \n   (shutdown-agents?))          ").seeAlso("agent").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return VncBoolean.of(Agent.isShutdown());
        }
    };
    public static VncFunction await_termination_agents = new VncFunction("await-termination-agents", (VncVal)VncFunction.meta().arglists("(shutdown-agents)").doc("Blocks until all actions have completed execution after a shutdown request, or the timeout occurs, or the current thread is interrupted, whichever happens first.").examples("(do                                   \n   (def x1 (agent 100))               \n   (def x2 (agent 100))               \n   (shutdown-agents)                  \n   (await-termination-agents 1000))     ").seeAlso("agent").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            long timeoutMillis = Coerce.toVncLong(args.first()).getValue();
            Agent.awaitTermination(timeoutMillis);
            return Constants.Nil;
        }
    };
    public static VncFunction await_termination_agents_Q = new VncFunction("await-termination-agents?", (VncVal)VncFunction.meta().arglists("(await-termination-agents?)").doc("Returns true if all tasks have been completed following agent shut down").examples("(do                                  \n   (def x1 (agent 100))              \n   (def x2 (agent 100))              \n   (shutdown-agents)                 \n   (await-termination-agents 1000)   \n   (sleep 300)                       \n   (await-termination-agents?))       ").seeAlso("agent").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return VncBoolean.of(Agent.isShutdown());
        }
    };
    public static VncFunction agent_send_thread_pool_info = new VncFunction("agent-send-thread-pool-info", (VncVal)VncFunction.meta().arglists("(agent-send-thread-pool-info)").doc("Returns the thread pool info of the ThreadPoolExecutor serving agent send.\n\n| *core-pool-size*       |  the number of threads to keep in the pool,                             even if they are idle |\n| *maximum-pool-size*    |  the maximum allowed number of threads |\n| *current-pool-size*    |  the current number of threads in the pool |\n| *largest-pool-size*    |  the largest number of threads that have                             ever simultaneously been in the pool |\n| *active-thread-count*  |  the approximate number of threads that are                             actively executing tasks |\n| *scheduled-task-count* |  the approximate total number of tasks that                             have ever been scheduled for execution |\n| *completed-task-count* |  the approximate total number of tasks                             that have completed execution |").examples("(agent-send-thread-pool-info)").seeAlso("agent", "send").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return Agent.sendExecutorInfo();
        }
    };
    public static VncFunction agent_send_off_thread_pool_info = new VncFunction("agent-send-off-thread-pool-info", (VncVal)VncFunction.meta().arglists("(agent-send-off-thread-pool-info)").doc("Returns the thread pool info of the ThreadPoolExecutor serving agent send-off.\n\n| *core-pool-size*       |  the number of threads to keep in the pool,                             even if they are idle |\n| *maximum-pool-size*    |  the maximum allowed number of threads |\n| *current-pool-size*    |  the current number of threads in the pool |\n| *largest-pool-size*    |  the largest number of threads that have                             ever simultaneously been in the pool |\n| *active-thread-count*  |  the approximate number of threads that are                             actively executing tasks |\n| *scheduled-task-count* |  the approximate total number of tasks that                             have ever been scheduled for execution |\n| *completed-task-count* |  the approximate total number of tasks                             that have completed execution |").examples("(agent-send-off-thread-pool-info)").seeAlso("agent", "send-off").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return Agent.sendOffExecutorInfo();
        }
    };
    public static VncFunction deliver = new VncFunction("deliver", (VncVal)VncFunction.meta().arglists("(deliver ref value)").doc("Delivers the supplied value to the promise, releasing any pending derefs. A subsequent call to deliver on a promise will have no effect.").examples("(do                            \n   (def p (promise))           \n   (deliver p 10)              \n   (deliver p 20) ; no effect  \n   @p)                           ").seeAlso("deliver-ex", "promise", "realized?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            Object promise = Coerce.toVncJavaObject(args.first()).getDelegate();
            VncVal value = args.second();
            if (promise instanceof CompletableFuture) {
                ((CompletableFuture)promise).complete(value);
                return Constants.Nil;
            }
            throw new VncException(String.format("Function 'deliver' does not allow type %s as parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction deliver_ex = new VncFunction("deliver-ex", (VncVal)VncFunction.meta().arglists("(deliver-ex ref ex)").doc("Delivers the supplied exception to the promise, releasing any pending derefs. A subsequent call to deliver on a promise will have no effect.").examples("(do                                             \n   (def p (promise))                            \n   (deliver-ex p (ex :VncException \"error\"))  \n   (deliver p 20)  ; no effect                  \n   (try                                         \n     @p                                         \n     (catch :VncException e (ex-message e))))   ").seeAlso("deliver", "promise", "realized?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            Object promise = Coerce.toVncJavaObject(args.first()).getDelegate();
            VncVal value = args.second();
            if (promise instanceof CompletableFuture) {
                CompletableFuture cf = (CompletableFuture)promise;
                if (value instanceof VncJavaObject) {
                    Object delegate = ((VncJavaObject)value).getDelegate();
                    if (delegate instanceof VncException) {
                        cf.completeExceptionally((VncException)delegate);
                    } else if (delegate instanceof Exception) {
                        cf.completeExceptionally((Exception)delegate);
                    } else {
                        cf.completeExceptionally(new ValueException(value));
                    }
                } else {
                    cf.completeExceptionally(new ValueException(value));
                }
                return Constants.Nil;
            }
            throw new VncException(String.format("Function 'deliver-ex' does not allow type %s as parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction promise = new VncFunction("promise", (VncVal)VncFunction.meta().arglists("(promise)", "(promise fn)").doc("Returns a promise object that can be read with deref, and set, once only, with deliver. Calls to deref prior to delivery will block, unless the variant of deref with timeout is used. All subsequent derefs will return the same delivered value without blocking.\n\nPromises are implemented on top of Java's `CompletableFuture`.").examples("(do                              \n   (def p (promise))             \n   (deliver p 10)                \n   (deliver p 20) ; no effect    \n   @p)                             ", ";; deliver the promise from a future           \n(do                                            \n   (def p (promise))                           \n   (defn task1 [] (sleep 500) (deliver p 10))  \n   (defn task2 [] (sleep 800) (deliver p 20))  \n   (future task1)                              \n   (future task2)                              \n   @p)                                           ", ";; deliver the promise from a task's return value    \n(do                                                  \n   (defn task [] (sleep 500) 10)                     \n   (def p (promise task))                            \n   @p)                                                 ").seeAlso("deliver", "promise?", "realized?", "deref", "done?", "cancel", "cancelled?", "all-of", "any-of", "then-accept", "then-accept-both", "then-apply", "then-combine", "then-compose", "when-complete", "accept-either", "apply-to-either", "or-timeout", "complete-on-timeout", "timeout-after").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0, 1);
            this.sandboxFunctionCallValidation();
            if (args.isEmpty()) {
                return new VncJavaObject(new CompletableFuture());
            }
            VncVal arg = args.first();
            if (arg instanceof VncFunction) {
                VncFunction fn = Coerce.toVncFunction(arg);
                ThreadBridge threadBridge = ThreadBridge.create("promise", new CallFrame[]{new CallFrame(this, args), new CallFrame(fn)}, new ThreadBridge.Options[0]);
                Supplier<VncVal> taskWrapper = threadBridge.bridgeSupplier(() -> fn.applyOf(new VncVal[0]));
                return new VncJavaObject(CompletableFuture.supplyAsync(taskWrapper, mngdExecutor.getExecutor()));
            }
            throw new VncException(String.format("Function 'promise' does not allow type %s argument", Types.getType(args.first())));
        }
    };
    public static VncFunction promise_Q = new VncFunction("promise?", (VncVal)VncFunction.meta().arglists("(promise? p)").doc("Returns true if f is a Promise otherwise false").examples("(promise? (promise)))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncJavaObject(args.first(), CompletableFuture.class));
        }
    };
    public static VncFunction all_of = new VncFunction("all-of", (VncVal)VncFunction.meta().arglists("(all-of p & ps)").doc("Returns a new promise that is completed when all of the given promises complete. If any of the given promises complete exceptionally, then the returned promise also does so. Otherwise, the results, if any, of the given promises are not reflected in the returned promise, but may be obtained by inspecting them individually.").examples("(-> (all-of (promise (fn [] (sleep 100) 1))  \n            (promise (fn [] (sleep 100) 2))  \n            (promise (fn [] (sleep 500) 3))) \n    (deref))").seeAlso("promise", "any-of").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            ArrayList<CompletableFuture> cfs = new ArrayList<CompletableFuture>();
            for (VncVal v : args) {
                cfs.add(Coerce.toVncJavaObject(v, CompletableFuture.class));
            }
            CompletableFuture<Void> cf2 = CompletableFuture.allOf(cfs.toArray(new CompletableFuture[0]));
            return new VncJavaObject(cf2);
        }
    };
    public static VncFunction any_of = new VncFunction("any-of", (VncVal)VncFunction.meta().arglists("(any-of p & ps)").doc("Returns a new promise that is completed when any of the given promises complete, with the same result. Otherwise, if it completed exceptionally, the returned promise also does so.").examples("(-> (any-of (promise (fn [] (sleep 300) 1))  \n            (promise (fn [] (sleep 100) 2))  \n            (promise (fn [] (sleep 500) 3))) \n    (deref))").seeAlso("promise", "all-of").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            ArrayList<CompletableFuture> cfs = new ArrayList<CompletableFuture>();
            for (VncVal v : args) {
                cfs.add(Coerce.toVncJavaObject(v, CompletableFuture.class));
            }
            CompletableFuture<Object> cf2 = CompletableFuture.anyOf(cfs.toArray(new CompletableFuture[0]));
            return new VncJavaObject(cf2);
        }
    };
    public static VncFunction then_accept = new VncFunction("then-accept", (VncVal)VncFunction.meta().arglists("(then-accept p f)").doc("Returns a new promise that, when this promise completes normally, is executing the function f with this stage's result as the argument.").examples("(-> (promise (fn [] \"the quick brown fox\"))    \n    (then-accept (fn [v] (println (pr-str v))))  \n    (deref))").seeAlso("promise", "then-accept-both", "then-apply", "then-combine", "then-compose", "when-complete", "accept-either", "apply-to-either", "or-timeout", "complete-on-timeout").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            CompletableFuture cf = Coerce.toVncJavaObject(args.first(), CompletableFuture.class);
            VncFunction fn = Coerce.toVncFunction(args.second());
            ThreadBridge threadBridge = ThreadBridge.create("then-accept", new CallFrame[]{new CallFrame(this, args), new CallFrame(fn)}, new ThreadBridge.Options[0]);
            Consumer<VncVal> taskWrapper = threadBridge.bridgeConsumer(v -> fn.applyOf((VncVal)v));
            CompletionStage cf2 = cf.thenAcceptAsync(taskWrapper, (Executor)mngdExecutor.getExecutor());
            return new VncJavaObject(cf2);
        }
    };
    public static VncFunction then_apply = new VncFunction("then-apply", (VncVal)VncFunction.meta().arglists("(then-apply p f)").doc("Applies a function f on the result of the previous stage of the promise p.").examples("(-> (promise (fn [] \"the quick brown fox\"))           \n    (then-apply str/upper-case)                         \n    (then-apply #(str % \" jumps over the lazy dog\"))  \n    (deref))").seeAlso("promise", "then-accept", "then-accept-both", "then-combine", "then-compose", "when-complete", "accept-either", "apply-to-either", "or-timeout", "complete-on-timeout").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            CompletableFuture cf = Coerce.toVncJavaObject(args.first(), CompletableFuture.class);
            VncFunction fn = Coerce.toVncFunction(args.second());
            ThreadBridge threadBridge = ThreadBridge.create("then-apply", new CallFrame[]{new CallFrame(this, args), new CallFrame(fn)}, new ThreadBridge.Options[0]);
            Function<VncVal, VncVal> taskWrapper = threadBridge.bridgeFunction(v -> fn.applyOf((VncVal)v));
            CompletionStage cf2 = cf.thenApplyAsync(taskWrapper, (Executor)mngdExecutor.getExecutor());
            return new VncJavaObject(cf2);
        }
    };
    public static VncFunction then_combine = new VncFunction("then-combine", (VncVal)VncFunction.meta().arglists("(then-combine p p-other f)").doc("Applies a function f to the result of the previous stage of promise p and the result of another promise p-other").examples("(-> (promise (fn [] \"The Quick Brown Fox\"))                           \n    (then-apply str/upper-case)                                         \n    (then-combine (-> (promise (fn [] \"Jumps Over The Lazy Dog\"))     \n                      (then-apply str/lower-case))                      \n                  #(str %1 \" \" %2))                                   \n    (deref))").seeAlso("promise", "then-accept", "then-accept-both", "then-apply", "then-compose", "when-complete", "accept-either", "apply-to-either", "or-timeout", "complete-on-timeout").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3);
            CompletableFuture cf = Coerce.toVncJavaObject(args.first(), CompletableFuture.class);
            CompletableFuture cf2 = Coerce.toVncJavaObject(args.second(), CompletableFuture.class);
            VncFunction fn = Coerce.toVncFunction(args.third());
            ThreadBridge threadBridge = ThreadBridge.create("then-combine", new CallFrame[]{new CallFrame(this, args), new CallFrame(fn)}, new ThreadBridge.Options[0]);
            BiFunction<VncVal, VncVal, VncVal> taskWrapper = threadBridge.bridgeBiFunction((v1, v2) -> fn.applyOf((VncVal)v1, (VncVal)v2));
            CompletionStage cf3 = cf.thenCombineAsync((CompletionStage)cf2, taskWrapper, (Executor)mngdExecutor.getExecutor());
            return new VncJavaObject(cf3);
        }
    };
    public static VncFunction then_compose = new VncFunction("then-compose", (VncVal)VncFunction.meta().arglists("(then-compose p f)").doc("Composes the result of two promises. f receives the result of the first promise p and returns a new promise that composes that value with this promise. ").examples("(-> (promise (fn [] \"The Quick Brown Fox\"))                                \n    (then-apply str/upper-case)                                              \n    (then-compose (fn [x] (-> (promise (fn [] \"Jumps Over The Lazy Dog\"))  \n                              (then-apply str/lower-case)                    \n                              (then-apply #(str x \" \" %1)))))              \n    (deref))").seeAlso("promise", "then-accept", "then-accept-both", "then-apply", "then-combine", "when-complete", "accept-either", "apply-to-either", "or-timeout", "complete-on-timeout").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            CompletableFuture cf = Coerce.toVncJavaObject(args.first(), CompletableFuture.class);
            VncFunction fn = Coerce.toVncFunction(args.second());
            ThreadBridge threadBridge = ThreadBridge.create("then-compose", new CallFrame[]{new CallFrame(this, args), new CallFrame(fn)}, new ThreadBridge.Options[0]);
            Function<VncVal, CompletableFuture> taskWrapper = threadBridge.bridgeFunction(v1 -> (CompletableFuture)((VncJavaObject)fn.applyOf((VncVal)v1)).getDelegate());
            CompletionStage cf2 = cf.thenComposeAsync(taskWrapper, (Executor)mngdExecutor.getExecutor());
            return new VncJavaObject(cf2);
        }
    };
    public static VncFunction when_complete = new VncFunction("when-complete", (VncVal)VncFunction.meta().arglists("(when-complete p f)").doc("Returns the promise p with the same result or exception at this stage, that executes the action f. Passes the the current stage's result value as first and a possible exception as second argument to the function. The asynchronous function f is called presumably for handling side effects.").examples("(-> (promise (fn [] \"The Quick Brown Fox\"))                       \n    (then-apply str/upper-case)                                     \n    (when-complete (fn [v,e] (println (pr-str {:value v :ex e}))))  \n    (then-apply str/lower-case)                                     \n    (deref))").seeAlso("promise", "then-accept", "then-accept-both", "then-apply", "then-combine", "then-compose", "accept-either", "apply-to-either", "or-timeout", "complete-on-timeout").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            CompletableFuture cf = Coerce.toVncJavaObject(args.first(), CompletableFuture.class);
            VncFunction fn = Coerce.toVncFunction(args.second());
            ThreadBridge threadBridge = ThreadBridge.create("when-complete", new CallFrame[]{new CallFrame(this, args), new CallFrame(fn)}, new ThreadBridge.Options[0]);
            BiConsumer<VncVal, Throwable> taskWrapper = threadBridge.bridgeBiConsumer((v, th) -> fn.applyOf((VncVal)v, th == null ? Constants.Nil : new VncJavaObject(th)));
            CompletionStage cf2 = cf.whenCompleteAsync(taskWrapper, (Executor)mngdExecutor.getExecutor());
            return new VncJavaObject(cf2);
        }
    };
    public static VncFunction accept_either = new VncFunction("accept-either", (VncVal)VncFunction.meta().arglists("(accept-either p p-other f)").doc("Returns a new promise that, when either this or the other given promise completess normally, is executed with the corresponding result as argument to the supplied function f.").examples("(-> (promise (fn [] (sleep 200) \"The quick brown fox\"))                      \n    (accept-either (promise (fn [] (sleep 100) \"jumps over the lazy dog\"))   \n                   (fn [v] (println (pr-str v))))                              \n    (deref))").seeAlso("promise", "then-accept", "then-accept-both", "then-apply", "then-combine", "then-compose", "when-complete", "apply-to-either", "or-timeout", "complete-on-timeout").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3);
            CompletableFuture cf = Coerce.toVncJavaObject(args.first(), CompletableFuture.class);
            CompletableFuture cf2 = Coerce.toVncJavaObject(args.second(), CompletableFuture.class);
            VncFunction fn = Coerce.toVncFunction(args.third());
            ThreadBridge threadBridge = ThreadBridge.create("accept-either", new CallFrame[]{new CallFrame(this, args), new CallFrame(fn)}, new ThreadBridge.Options[0]);
            Consumer<VncVal> taskWrapper = threadBridge.bridgeConsumer(v -> fn.applyOf((VncVal)v));
            CompletionStage cf3 = cf.acceptEitherAsync((CompletionStage)cf2, taskWrapper, (Executor)mngdExecutor.getExecutor());
            return new VncJavaObject(cf3);
        }
    };
    public static VncFunction apply_to_either = new VncFunction("apply-to-either", (VncVal)VncFunction.meta().arglists("(apply-to-either p p-other f)").doc("Returns a new promise that, when either this or the other given promise completes normally, is executed with the corresponding result as argument to the supplied function f.").examples("(-> (promise (fn [] (sleep 200) \"The quick brown fox\"))                      \n    (apply-to-either (promise (fn [] (sleep 100) \"jumps over the lazy dog\")) \n                     (fn [v] (str/upper-case v)))                              \n    (deref))").seeAlso("promise", "then-accept", "then-accept-both", "then-apply", "then-combine", "then-compose", "when-complete", "accept-either", "or-timeout", "complete-on-timeout").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3);
            CompletableFuture cf = Coerce.toVncJavaObject(args.first(), CompletableFuture.class);
            CompletableFuture cf2 = Coerce.toVncJavaObject(args.second(), CompletableFuture.class);
            VncFunction fn = Coerce.toVncFunction(args.third());
            ThreadBridge threadBridge = ThreadBridge.create("apply-to-either", new CallFrame[]{new CallFrame(this, args), new CallFrame(fn)}, new ThreadBridge.Options[0]);
            Function<VncVal, VncVal> taskWrapper = threadBridge.bridgeFunction(v -> fn.applyOf((VncVal)v));
            CompletionStage cf3 = cf.applyToEitherAsync((CompletionStage)cf2, taskWrapper, (Executor)mngdExecutor.getExecutor());
            return new VncJavaObject(cf3);
        }
    };
    public static VncFunction then_accept_both = new VncFunction("then-accept-both", (VncVal)VncFunction.meta().arglists("(then-accept-both p p-other f)").doc("Returns a new promise that, when either this or the other given promise completes normally, is executing the function f with the two results as arguments.").examples("(-> (promise (fn [] (sleep 200) \"The quick brown fox\"))                       \n    (then-accept-both (promise (fn [] (sleep 100) \"jumps over the lazy dog\")) \n                      (fn [u v] (println (pr-str (str u \" \" v)))))            \n    (deref))").seeAlso("promise", "then-accept", "then-apply", "apply-to-either", "then-combine", "then-compose", "when-complete", "accept-either", "or-timeout", "complete-on-timeout").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3);
            CompletableFuture cf = Coerce.toVncJavaObject(args.first(), CompletableFuture.class);
            CompletableFuture cf2 = Coerce.toVncJavaObject(args.second(), CompletableFuture.class);
            VncFunction fn = Coerce.toVncFunction(args.third());
            ThreadBridge threadBridge = ThreadBridge.create("then-accept-both", new CallFrame[]{new CallFrame(this, args), new CallFrame(fn)}, new ThreadBridge.Options[0]);
            BiConsumer<VncVal, VncVal> taskWrapper = threadBridge.bridgeBiConsumer((u, v) -> fn.applyOf((VncVal)u, (VncVal)v));
            CompletionStage cf3 = cf.thenAcceptBothAsync((CompletionStage)cf2, taskWrapper, (Executor)mngdExecutor.getExecutor());
            return new VncJavaObject(cf3);
        }
    };
    public static VncFunction timeout_after = new VncFunction("timeout-after", (VncVal)VncFunction.meta().arglists("(timeout-after p time time-unit)").doc("Returns a promise that timouts afer the specified time. The promise throws a TimeoutException.").examples("(-> (promise (fn [] (sleep 100) \"The quick brown fox\"))   \n    (accept-either (timeout-after 500 :milliseconds)        \n                   (fn [v] (println (pr-str v))))           \n    (deref))", "(-> (promise (fn [] (sleep 1000) \"The quick brown fox\"))  \n    (accept-either (timeout-after 500 :milliseconds)        \n                   (fn [v] (println (pr-str v))))           \n    (deref))", "(-> (promise (fn [] (sleep 1000) \"The quick brown fox\"))  \n    (accept-either (timeout-after 500 :milliseconds)        \n                   (fn [v] (println (pr-str v))))           \n    (deref 2000 :timeout))", "(-> (promise (fn [] (sleep 200) \"The quick brown fox\"))   \n    (apply-to-either (timeout-after 100 :milliseconds)      \n                     identity)                              \n    (deref))").seeAlso("promise", "then-accept", "then-accept-both", "then-apply", "then-combine", "then-compose", "when-complete", "accept-either", "apply-to-either", "or-timeout", "complete-on-timeout").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncLong time = Coerce.toVncLong(args.first());
            VncKeyword unit = Coerce.toVncKeyword(args.second());
            return new VncJavaObject(ConcurrencyFunctions.timeoutAfter(time.getValue(), ScheduleFunctions.toTimeUnit(unit)));
        }
    };
    public static VncFunction or_timeout = new VncFunction("or-timeout", (VncVal)VncFunction.meta().arglists("(or-timeout p time time-unit)").doc("Exceptionally completes the promise with a TimeoutException if not otherwise completed before the given timeout.").examples("(-> (promise (fn [] (sleep 100) \"The quick brown fox\"))   \n    (or-timeout 500 :milliseconds)                          \n    (then-apply str/upper-case)                             \n    (deref))", "(-> (promise (fn [] (sleep 300) \"The quick brown fox\"))   \n    (or-timeout 200 :milliseconds)                          \n    (then-apply str/upper-case)                             \n    (deref))", "(-> (promise (fn [] (sleep 300) \"The quick brown fox\"))   \n    (then-apply str/upper-case)                             \n    (or-timeout 200 :milliseconds)                          \n    (deref))").seeAlso("promise", "then-accept", "then-accept-both", "then-apply", "then-combine", "then-compose", "when-complete", "accept-either", "apply-to-either", "complete-on-timeout").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3);
            CompletableFuture cf = Coerce.toVncJavaObject(args.first(), CompletableFuture.class);
            VncLong time = Coerce.toVncLong(args.second());
            VncKeyword unit = Coerce.toVncKeyword(args.third());
            CompletableFuture cf2 = ConcurrencyFunctions.timeoutAfter(time.getValue(), ScheduleFunctions.toTimeUnit(unit));
            VncFunction fn = CoreFunctions.identity;
            CompletionStage cf3 = cf.applyToEitherAsync((CompletionStage)cf2, x -> fn.applyOf((VncVal)x), (Executor)mngdExecutor.getExecutor());
            return new VncJavaObject(cf3);
        }
    };
    public static VncFunction complete_on_timeout = new VncFunction("complete-on-timeout", (VncVal)VncFunction.meta().arglists("(complete-on-timeout p value time time-unit)").doc("Completes the promise with the given value if not otherwise completed before the given timeout.").examples("(-> (promise (fn [] (sleep 100) \"The quick brown fox\"))             \n    (complete-on-timeout \"The fox did not jump\" 500 :milliseconds)  \n    (deref))", "(-> (promise (fn [] (sleep 500) \"The quick brown fox\"))             \n    (complete-on-timeout \"The fox did not jump\" 100 :milliseconds)  \n    (deref))", "(-> (promise (fn [] (sleep 500) \"The quick brown fox\"))             \n    (complete-on-timeout \"The fox did not jump\" 100 :milliseconds)  \n    (then-apply str/upper-case)                                       \n    (deref))", "(-> (promise (fn [] (sleep 50) 100))             \n    (complete-on-timeout 888 100 :milliseconds)  \n    (then-apply #(do (sleep 200) (* % 3)))       \n    (complete-on-timeout 999 220 :milliseconds)  \n    (deref))").seeAlso("promise", "then-accept", "then-accept-both", "then-apply", "then-combine", "then-compose", "when-complete", "accept-either", "apply-to-either", "or-timeout").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 4);
            CompletableFuture cf = Coerce.toVncJavaObject(args.first(), CompletableFuture.class);
            VncVal timeoutVal = args.second();
            VncLong time = Coerce.toVncLong(args.third());
            VncKeyword unit = Coerce.toVncKeyword(args.fourth());
            CompletableFuture<VncVal> cf2 = ConcurrencyFunctions.timeoutAfter(timeoutVal, time.getValue(), ScheduleFunctions.toTimeUnit(unit));
            VncFunction fn = CoreFunctions.identity;
            CompletionStage cf3 = cf.applyToEitherAsync(cf2, x -> fn.applyOf((VncVal)x), (Executor)mngdExecutor.getExecutor());
            return new VncJavaObject(cf3);
        }
    };
    public static VncFunction future = new VncFunction("future", (VncVal)VncFunction.meta().arglists("(future fn)").doc("Takes a function without arguments and yields a future object that will invoke the function in another thread, and will cache the result and return it on all subsequent calls to deref. If the computation has not yet finished, calls to deref will block, unless the variant of deref with timeout is used.\n\nThread local vars will be inherited by the future child thread. Changes of the child's thread local vars will not be seen on the parent.").examples("(do                                       \n   (defn wait [] (sleep 300) 100)         \n   (let [f (future wait)]                 \n      (deref f)))                           ", "(do                                       \n   (defn wait [x] (sleep 300) (+ x 100))  \n   (let [f (future (partial wait 10))]    \n      (deref f)))                           ", "(do                                       \n   (defn sum [x y] (+ x y))               \n   (let [f (future (partial sum 3 4))]    \n      (deref f)))                           ", ";; demonstrates the use of thread locals with futures         \n(do                                                           \n   ;; parent thread locals                                    \n   (binding [a 10 b 20]                                       \n      ;; future with child thread locals                      \n      (let [f (future (fn [] (binding [b 90] {:a a :b b})))]  \n         {:child @f :parent {:a a :b b}})))                     ").seeAlso("deref", "realized?", "done?", "cancel", "cancelled?", "future-task", "promise", "futures-fork", "futures-wait").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            VncFunction fn = Coerce.toVncFunction(args.first());
            ThreadBridge threadBridge = ThreadBridge.create("future", new CallFrame[]{new CallFrame(this, args), new CallFrame(fn)}, new ThreadBridge.Options[0]);
            Callable<VncVal> taskWrapper = threadBridge.bridgeCallable(() -> fn.applyOf(new VncVal[0]));
            Future<VncVal> future = mngdExecutor.getExecutor().submit(taskWrapper);
            return new VncJavaObject(future);
        }
    };
    public static VncFunction future_task = new VncFunction("future-task", (VncVal)VncFunction.meta().arglists("(future-task f completed-fn)", "(future-task f sucess-fn failure-fn)").doc("Takes a function f without arguments and yields a future object that will invoke the function in another thread. \n\nIf a single completed function is passed it will be called with the future as its argument as soon as the future has completed. If a success and a failure function are passed either the success or failure function will be called as soon as the future has completed. Upon success the success function will be called with the future's result as its argument, upon failure the failure function will be called with the exception as its argument.\n\nIn combination with a queue a completion service can be built. The tasks appear in the queue in the order they have completed.\n\nThread local vars will be inherited by the future child thread. Changes of the child's thread local vars will not be seen on the parent.").examples(";; building a completion service                                                  \n;; CompletionService = incoming worker queue + worker threads + output data queue \n(do                                                                               \n   (def q (queue 10))                                                             \n   (defn process [s v] (sleep s) v)                                               \n   (defn failure [s m] (sleep s) (throw (ex :VncException m)))                    \n   (future-task (partial process 200 2) #(offer! q %) #(offer! q %))              \n   (future-task (partial process 400 4) #(offer! q %) #(offer! q %))              \n   (future-task (partial process 100 1) #(offer! q %) #(offer! q %))              \n   (future-task (partial failure 300 \"Failed 3\") #(offer! q %) #(offer! q %))   \n   (println (poll! q 1000))                                                       \n   (println (poll! q 1000))                                                       \n   (println (poll! q 1000))                                                       \n   (println (poll! q 1000)))                                                        ", ";; building a completion service (future-task API variant)                        \n(do                                                                               \n   (def q (queue 10))                                                             \n   (defn process [s v] (sleep s) v)                                               \n   (defn failure [s m] (sleep s) (throw (ex :VncException m)))                    \n   (defn print_result [f] (try (println @f) (catch :Exception e (println e))))    \n   (future-task (partial process 200 2) #(offer! q %))                            \n   (future-task (partial process 400 4) #(offer! q %))                            \n   (future-task (partial process 100 1) #(offer! q %))                            \n   (future-task (partial failure 300 \"Failed 3\") #(offer! q %))                 \n   (print_result (poll! q 1000))                                                  \n   (print_result (poll! q 1000))                                                  \n   (print_result (poll! q 1000))                                                  \n   (print_result (poll! q 1000)))                                                   ").seeAlso("future").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2, 3);
            this.sandboxFunctionCallValidation();
            VncFunction taskFn = Coerce.toVncFunction(args.first());
            ThreadBridge bridgedTask = this.bridge(taskFn, args);
            Callable<VncVal> taskWrapper = bridgedTask.bridgeCallable(() -> taskFn.applyOf(new VncVal[0]));
            if (args.size() == 2) {
                VncFunction onCompleteFn = Coerce.toVncFunction(args.second());
                ThreadBridge bridgedOnComplete = this.bridge(onCompleteFn, args);
                Consumer<Future> onComplete = f -> onCompleteFn.applyOf(new VncJavaObject(f));
                Consumer<Future<VncVal>> onCompleteWrapper = bridgedOnComplete.bridgeConsumer(onComplete);
                return this.exec(new VncFutureTask(taskWrapper, onCompleteWrapper));
            }
            VncFunction onSuccessFn = Coerce.toVncFunction(args.second());
            VncFunction onFailureFn = Coerce.toVncFunction(args.third());
            ThreadBridge bridgedOnSuccess = this.bridge(onSuccessFn, args);
            ThreadBridge bridgedOnFailure = this.bridge(onFailureFn, args);
            Consumer<VncVal> onSuccess = f -> onSuccessFn.applyOf(new VncJavaObject(f));
            Consumer<VncException> onFailure = f -> onFailureFn.applyOf(new VncJavaObject(f));
            Consumer<VncVal> onSuccessWrapper = bridgedOnSuccess.bridgeConsumer(onSuccess);
            Consumer<VncException> onFailureWrapper = bridgedOnFailure.bridgeConsumer(onFailure);
            return this.exec(new VncFutureTask(taskWrapper, onSuccessWrapper, onFailureWrapper));
        }

        private ThreadBridge bridge(VncFunction fn, VncList args) {
            return ThreadBridge.create("future-task", new CallFrame[]{new CallFrame(this, args), new CallFrame(fn)}, new ThreadBridge.Options[0]);
        }

        private VncJavaObject exec(VncFutureTask futureTask) {
            Future<?> future = mngdExecutor.getExecutor().submit(futureTask);
            return new VncJavaObject(future);
        }
    };
    public static VncFunction future_Q = new VncFunction("future?", (VncVal)VncFunction.meta().arglists("(future? f)").doc("Returns true if f is a Future otherwise false").examples("(future? (future (fn [] 100)))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncJavaObject(args.first(), Future.class));
        }
    };
    public static VncFunction cancel = new VncFunction("cancel", (VncVal)VncFunction.meta().arglists("(cancel f)").doc("Cancels a future or a promise").examples("(do                                                                     \n   (def wait (fn [] (sleep 400) 100))                                   \n   (let [f (future wait)]                                               \n      (sleep 50)                                                        \n      (printf \"After 50ms: cancelled=%b\\n\" (cancelled? f))           \n      (cancel f)                                                        \n      (sleep 100)                                                       \n      (printf \"After 150ms: cancelled=%b\\n\" (cancelled? f))))          ").seeAlso("future", "promise", "done?", "cancelled?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            if (Types.isVncJavaObject(args.first(), Future.class)) {
                try {
                    Future future = Coerce.toVncJavaObject(args.first(), Future.class);
                    future.cancel(true);
                    return args.first();
                }
                catch (Exception ex) {
                    throw new VncException("Failed to cancel future/promise", ex);
                }
            }
            throw new VncException(String.format("Function 'cancel' does not allow type %s as parameter.", Types.getType(args.first())));
        }
    };
    public static VncFunction cancelled_Q = new VncFunction("cancelled?", (VncVal)VncFunction.meta().arglists("(cancelled? f)").doc("Returns true if the future or promise is cancelled otherwise false").examples("(cancelled? (future (fn [] 100)))").seeAlso("future", "promise", "done?", "cancel").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (Types.isVncJavaObject(args.first(), Future.class)) {
                try {
                    Future future = Coerce.toVncJavaObject(args.first(), Future.class);
                    return VncBoolean.of(future.isCancelled());
                }
                catch (Exception ex) {
                    throw new VncException("Failed to check if future/promise is cancelled", ex);
                }
            }
            throw new VncException(String.format("Function 'cancelled?' does not allow type %s as parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction done_Q = new VncFunction("done?", (VncVal)VncFunction.meta().arglists("(done? f)").doc("Returns true if the future or promise is done otherwise false").examples("(do                                                            \n   (def wait (fn [] (sleep 200) 100))                          \n   (let [f (future wait)]                                      \n      (sleep 50)                                               \n      (printf \"After 50ms: done=%b\\n\" (done? f))            \n      (sleep 300)                                              \n      (printf \"After 300ms: done=%b\\n\" (done? f))))           ").seeAlso("future", "promise", "realized?", "cancel", "cancelled?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (Types.isVncJavaObject(args.first(), Future.class)) {
                try {
                    Future future = Coerce.toVncJavaObject(args.first(), Future.class);
                    return VncBoolean.of(future.isDone());
                }
                catch (Exception ex) {
                    throw new VncException("Failed to check if future is done", ex);
                }
            }
            throw new VncException(String.format("Function 'future-done?' does not allow type %s as parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction futures_fork = new VncFunction("futures-fork", (VncVal)VncFunction.meta().arglists("(futures-fork count worker-factory-fn)").doc("Creates a list of count futures. The worker factory is single argument function that gets the worker index (0..count-1) as argument and returns a worker function. Returns a list with the created futures.").examples("(do                                                \n  (def mutex 0)                                    \n  (defn log [& xs]                                 \n    (locking mutex (println (apply str xs))))      \n  (defn factory [n]                                \n    (fn [] (log \"Worker\" n)))                    \n  (apply futures-wait (futures-fork 3 factory)))     ").seeAlso("future", "futures-wait").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            VncLong count = Coerce.toVncLong(args.first());
            VncFunction workerFactoryFn = Coerce.toVncFunction(args.second());
            ArrayList<VncVal> futures = new ArrayList<VncVal>();
            int ii = 0;
            while ((long)ii < count.getValue()) {
                VncFunction worker = (VncFunction)workerFactoryFn.apply(VncList.of(new VncLong(ii)));
                futures.add(future.apply(VncList.of(worker)));
                ++ii;
            }
            return VncList.ofList(futures);
        }
    };
    public static VncFunction futures_thread_pool_info = new VncFunction("futures-thread-pool-info", (VncVal)VncFunction.meta().arglists("(futures-thread-pool-info)").doc("Returns the thread pool info of the ThreadPoolExecutor serving the futures.\n\n| *core-pool-size*       |  the number of threads to keep in the pool,                             even if they are idle |\n| *maximum-pool-size*    |  the maximum allowed number of threads |\n| *current-pool-size*    |  the current number of threads in the pool |\n| *largest-pool-size*    |  the largest number of threads that have                             ever simultaneously been in the pool |\n| *active-thread-count*  |  the approximate number of threads that are                             actively executing tasks |\n| *scheduled-task-count* |  the approximate total number of tasks that                             have ever been scheduled for execution |\n| *completed-task-count* |  the approximate total number of tasks                             that have completed execution |").examples("(futures-thread-pool-info)").seeAlso("future").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return mngdExecutor.info();
        }
    };
    public static VncFunction futures_wait = new VncFunction("futures-wait", (VncVal)VncFunction.meta().arglists("(futures-wait & futures)").doc("Waits for all futures to get terminated. If the waiting thread is interrupted the futures are cancelled. ").examples("(do                                                \n  (def mutex 0)                                    \n  (defn log [& xs]                                 \n    (locking mutex (println (apply str xs))))      \n  (defn factory [n]                                \n    (fn [] (log \"Worker\" n)))                    \n  (apply futures-wait (futures-fork 3 factory)))     ").seeAlso("future", "futures-fork").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 0);
            this.sandboxFunctionCallValidation();
            for (VncVal v : args) {
                Future future = Coerce.toVncJavaObject(v, Future.class);
                try {
                    future.get();
                }
                catch (CancellationException | ExecutionException exception) {
                }
                catch (java.lang.InterruptedException ex) {
                    args.forEach((Consumer<? super VncVal>)((Consumer<VncVal>)f -> ConcurrencyFunctions.safelyCancelFuture(Coerce.toVncJavaObject(f, Future.class))));
                    throw new InterruptedException("Interrupted while waiting for futures to terminate (futures-wait & futures).");
                }
                catch (Exception ex) {
                    throw new VncException("Failed to wait for future", ex);
                }
            }
            return Constants.Nil;
        }
    };
    public static VncFunction delay_Q = new VncFunction("delay?", (VncVal)VncFunction.meta().arglists("(delay? x)").doc("Returns true if x is a Delay created with delay").examples("(do                                              \n   (def x (delay (println \"working...\") 100))  \n   (delay? x))                                     ").seeAlso("delay", "deref", "realized?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncJavaObject(args.first(), Delay.class));
        }
    };
    public static VncFunction force = new VncFunction("force", (VncVal)VncFunction.meta().arglists("(force x)").doc("If x is a delay, returns its value, else returns x").examples("(do                                              \n   (def x (delay (println \"working...\") 100))  \n   (force x))", "(force (+ 1 2))").seeAlso("delay", "deref", "realized?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            if (Types.isVncJavaObject(args.first(), Delay.class)) {
                Delay delay = Coerce.toVncJavaObject(args.first(), Delay.class);
                return delay.deref();
            }
            return args.first();
        }
    };
    public static VncFunction new_thread_local = new VncFunction("thread-local", (VncVal)VncFunction.meta().arglists("(thread-local)").doc("Creates a new thread-local accessor").examples("(do \n  (assoc! (thread-local) :a 1) \n  (get (thread-local) :a))", "(do \n  (assoc! (thread-local) :a 1) \n  (get (thread-local) :b 999))", "(do \n  (thread-local :a 1 :b 2) \n  (get (thread-local) :a))", "(do \n  (thread-local { :a 1 :b 2 }) \n  (get (thread-local) :a))", "(do \n  (thread-local-clear) \n  (assoc! (thread-local) :a 1 :b 2) \n  (dissoc! (thread-local) :a) \n  (get (thread-local) :a 999))").seeAlso("thread-local-clear", "thread-local-map", "assoc!", "dissoc!", "get").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            if (args.size() == 1 && Types.isVncMap(args.first())) {
                return new VncThreadLocal(((VncMap)args.first()).getJavaMap());
            }
            return new VncThreadLocal(args);
        }
    };
    public static VncFunction thread_local_Q = new VncFunction("thread-local?", (VncVal)VncFunction.meta().arglists("(thread-local? x)").doc("Returns true if x is a thread-local, otherwise false").examples("(do\n  (def x (thread-local))\n  (thread-local? x))").seeAlso("thread-local").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncThreadLocal(args.first()));
        }
    };
    public static VncFunction thread_local_clear = new VncFunction("thread-local-clear", (VncVal)VncFunction.meta().arglists("(thread-local-clear)").doc("Removes all thread local vars").examples("(thread-local-clear)").seeAlso("thread-local", "dissoc!").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            new VncThreadLocal().clear(true);
            return this;
        }
    };
    public static VncFunction thread_local_map = new VncFunction("thread-local-map", (VncVal)VncFunction.meta().arglists("(thread-local-map)").doc("Returns a snaphost of the thread local vars as a map.\n\nNote:\u00b6The returned map is a copy of the current thread local vars. Thus \nmodifying this map is not modifying the thread local vars! \nUse `assoc!` and `dissoc!` for that purpose!").examples("(do \n  (thread-local-clear) \n  (thread-local :a 1 :b 2) \n  (thread-local-map))").seeAlso("thread-local", "get", "assoc!", "dissoc!").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return VncThreadLocal.toMap();
        }
    };
    public static VncFunction thread_id = new VncFunction("thread-id", (VncVal)VncFunction.meta().arglists("(thread-id)").doc("Returns the identifier of this Thread. The thread ID is a positive number generated when this thread was created. The thread ID is unique and remains unchanged during its lifetime. When a thread is terminated, this thread ID may be reused.").examples("(thread-id)").seeAlso("thread-name").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncLong(Thread.currentThread().getId());
        }
    };
    public static VncFunction thread_daemon_Q = new VncFunction("thread-daemon?", (VncVal)VncFunction.meta().arglists("(thread-daemon?)").doc("Returns true if this Thread is a daemon thread else false.").examples("(thread-daemon?)").seeAlso("thread-name").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return VncBoolean.of(Thread.currentThread().isDaemon());
        }
    };
    public static VncFunction thread_name = new VncFunction("thread-name", (VncVal)VncFunction.meta().arglists("(thread-name)").doc("Returns this thread's name.").examples("(thread-name)").seeAlso("thread-id").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncString(Thread.currentThread().getName());
        }
    };
    public static VncFunction thread_interrupted_Q = new VncFunction("thread-interrupted?", (VncVal)VncFunction.meta().arglists("(thread-interrupted?)").doc("Tests whether this thread has been interrupted. The interrupted status of the thread is unaffected by this method. \nReturns true if the current thread has been interrupted else false.").examples("(thread-interrupted?)").seeAlso("thread-interrupted").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return VncBoolean.of(Thread.currentThread().isInterrupted());
        }
    };
    public static VncFunction thread_interrupted = new VncFunction("thread-interrupted", (VncVal)VncFunction.meta().arglists("(thread-interrupted)").doc("Tests whether the current thread has been interrupted. The interrupted status of the thread is cleared by this method. In other words, if this method were to be called twice in succession, the second call would return false (unless the current thread were interrupted again, after the first call had cleared its interrupted status and before the second call had examined it).\n\nReturns true if the current thread has been interrupted else false.").examples("(thread-interrupted)").seeAlso("thread-interrupted?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return VncBoolean.of(Thread.interrupted());
        }
    };
    public static VncFunction pmap = new VncFunction("pmap", (VncVal)VncFunction.meta().arglists("(pmap f coll)", "(pmap f coll & colls)").doc("Like `map`, except *f* is applied in parallel. Only useful for computationally intensive functions where the time of *f* dominates the coordination overhead.\n\nThe result collection is sorted in the same way as for `map`, i.e. it preserves the items' order in the *coll* (or *colls*) parameter(s) of `pmap`. In other words: calculation is done parallel, but the result is delivered in the order the input came (in *coll*/*colls*).\nIn contrast, side effects of *f* (if any) are coming in random order!\n\n`pmap` is implemented using Venice futures and processes `(+ 2 (cpus))` items in parallel.").examples(";; With `pmap`, the total elapsed time is just over 2 seconds:\n(do                                          \n  (defn long-running-job [n]                 \n    (sleep 2000)  ; wait for 2 seconds       \n    (+ n 10))                                \n  (time (pmap long-running-job (range 4))))   ", ";; With `map`, the total elapsed time is roughly 4 * 2 seconds:\n(do                                          \n  (defn long-running-job [n]                 \n    (sleep 2000)  ; wait for 2 seconds       \n    (+ n 10))                                \n  (time (map long-running-job (range 4))))  ").seeAlso("pcalls", "map", "cpus").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            VncLazySeq part;
            VncSequence lazySeq;
            ArityExceptions.assertMinArity(this, args, 2);
            if (args.size() == 2 && args.second() == Constants.Nil) {
                return VncList.empty();
            }
            IVncFunction fn = Coerce.toIVncFunction(args.first());
            if (args.size() == 2) {
                VncSequence seq = VncSequence.coerceToSequence(args.second());
                lazySeq = VncLazySeq.ofAll(seq, Constants.Nil).map(v -> future.applyOf(VncFunction.of(() -> fn.applyOf((VncVal)v))));
            } else {
                VncSequence listsOfSeqs = args.rest().filter(v -> v != Constants.Nil);
                VncSequence[] seqs = new VncSequence[((VncList)listsOfSeqs).size()];
                for (int ii = 0; ii < ((VncList)listsOfSeqs).size(); ++ii) {
                    seqs[ii] = VncSequence.coerceToSequence(((VncList)listsOfSeqs).nth(ii));
                }
                VncList mappingFnArgs = VncList.empty();
                while (!ConcurrencyFunctions.isOneSeqEmpty(seqs)) {
                    VncList fnArgs = VncList.empty();
                    for (int ii = 0; ii < seqs.length; ++ii) {
                        fnArgs = fnArgs.addAtEnd(seqs[ii].first());
                        seqs[ii] = seqs[ii].rest();
                    }
                    mappingFnArgs = mappingFnArgs.addAtEnd(fnArgs);
                }
                lazySeq = VncLazySeq.ofAll(mappingFnArgs, Constants.Nil).map(v -> future.applyOf(VncFunction.of(() -> fn.apply((VncList)v))));
            }
            int n = 2 + Runtime.getRuntime().availableProcessors();
            VncList result = VncList.empty();
            while (!(part = ((VncLazySeq)lazySeq).take(n)).isEmpty()) {
                lazySeq = ((VncLazySeq)lazySeq).drop(n);
                VncSequence partialRes = part.realize().map(v -> deref.applyOf((VncVal)v));
                result = result.addAllAtEnd(partialRes);
            }
            return result;
        }
    };
    public static VncFunction pcalls = new VncFunction("pcalls", (VncVal)VncFunction.meta().arglists("(pcalls & fns)").doc("Executes the no-arg *fns* in parallel, returning a sequence of their values in the same order the functions are passed.\nIn contrast, side effects of *fns* (if any) are coming in random order!\n\n`pcalls` is implemented using Venice futures and processes `(+ 2 (cpus))` functions in parallel.").examples("(pcalls #(+ 1 2) #(+ 2 3) #(+ 3 4))").seeAlso("pmap", "cpus").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            return pmap.applyOf(VncFunction.of((VncList x) -> ((VncFunction)x.first()).apply(VncList.empty())), args.map(f -> Coerce.toVncFunction(f)));
        }
    };
    public static Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(deref).add(deref_Q).add(realized_Q).add(add_watch).add(remove_watch).add(new_atom).add(atom_Q).add(reset_BANG).add(swap_BANG).add(swap_vals_BANG).add(compare_and_set_BANG).add(new_volatile).add(volatile_Q).add(agent).add(send).add(send_off).add(restart_agent).add(set_error_handler).add(agent_error).add(agent_error_mode).add(await).add(await_for).add(shutdown_agents).add(shutdown_agents_Q).add(await_termination_agents).add(await_termination_agents_Q).add(agent_send_thread_pool_info).add(agent_send_off_thread_pool_info).add(promise).add(promise_Q).add(deliver).add(deliver_ex).add(then_accept).add(then_apply).add(then_combine).add(then_compose).add(when_complete).add(accept_either).add(apply_to_either).add(then_accept_both).add(timeout_after).add(or_timeout).add(complete_on_timeout).add(all_of).add(any_of).add(future).add(future_task).add(future_Q).add(futures_fork).add(futures_wait).add(futures_thread_pool_info).add(delay_Q).add(force).add(done_Q).add(cancel).add(cancelled_Q).add(thread_id).add(thread_daemon_Q).add(thread_name).add(thread_interrupted_Q).add(thread_interrupted).add(new_thread_local).add(thread_local_Q).add(thread_local_clear).add(thread_local_map).add(pmap).add(pcalls).toMap();
    private static ManagedCachedThreadPoolExecutor mngdExecutor = new ManagedCachedThreadPoolExecutor("venice-future-pool", 200);

    public static void shutdown() {
        mngdExecutor.shutdown();
    }

    public static void setMaximumFutureThreadPoolSize(int maximumPoolSize) {
        mngdExecutor.setMaximumThreadPoolSize(maximumPoolSize);
    }

    private static void safelyCancelFuture(Future<?> future) {
        try {
            future.cancel(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <T> CompletableFuture<T> timeoutAfter(long timeout, TimeUnit unit) {
        ScheduledExecutorService delayer = ScheduleFunctions.getScheduledExecutorService();
        CompletableFuture result = new CompletableFuture();
        delayer.schedule(() -> result.completeExceptionally(new java.util.concurrent.TimeoutException()), timeout, unit);
        return result;
    }

    public static <T> CompletableFuture<T> timeoutAfter(T timeoutVal, long timeout, TimeUnit unit) {
        ScheduledExecutorService delayer = ScheduleFunctions.getScheduledExecutorService();
        CompletableFuture result = new CompletableFuture();
        delayer.schedule(() -> result.complete(timeoutVal), timeout, unit);
        return result;
    }

    private static boolean isOneSeqEmpty(VncSequence[] seqs) {
        for (int ii = 0; ii < seqs.length; ++ii) {
            if (!seqs[ii].isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static class VncFutureTask
    extends FutureTask<VncVal> {
        private final Consumer<Future<VncVal>> doneFn;
        private final Consumer<VncVal> successFn;
        private final Consumer<VncException> failureFn;

        public VncFutureTask(Callable<VncVal> taskFn, Consumer<Future<VncVal>> doneFn) {
            super(taskFn);
            this.doneFn = doneFn;
            this.successFn = null;
            this.failureFn = null;
        }

        public VncFutureTask(Callable<VncVal> taskFn, Consumer<VncVal> successFn, Consumer<VncException> failureFn) {
            super(taskFn);
            this.doneFn = null;
            this.successFn = successFn;
            this.failureFn = failureFn;
        }

        @Override
        protected void done() {
            if (this.doneFn != null) {
                this.doneFn.accept(this);
            } else {
                try {
                    this.successFn.accept((VncVal)this.get());
                }
                catch (VncException ex) {
                    this.failureFn.accept(ex);
                }
                catch (CompletionException | ExecutionException ex) {
                    if (ex.getCause() == null) {
                        this.failureFn.accept(new VncException(ex.getMessage(), ex));
                    } else if (ex.getCause() instanceof VncException) {
                        this.failureFn.accept((VncException)ex.getCause());
                    } else {
                        this.failureFn.accept(new VncException(ex.getCause().getMessage(), ex.getCause()));
                    }
                }
                catch (Exception ex) {
                    this.failureFn.accept(new VncException(ex.getMessage(), ex));
                }
            }
        }
    }
}

