/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncTinyList;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.EmptyIterator;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.repackage.io.vavr.collection.IndexedSeq;
import org.repackage.io.vavr.collection.Seq;
import org.repackage.io.vavr.collection.Vector;

public class VncList
extends VncSequence {
    public static final String TYPE = ":core/list";
    private static final long serialVersionUID = -1848883965231344442L;
    private final Vector<VncVal> value;

    protected VncList(VncVal meta) {
        this((Seq<VncVal>)null, meta);
    }

    protected VncList(Collection<? extends VncVal> vals, VncVal meta) {
        this(vals == null ? null : Vector.ofAll(vals), meta);
    }

    public VncList(Seq<VncVal> vals, VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        this.value = vals == null ? Vector.empty() : (vals instanceof Vector ? (Vector<Object>)vals : Vector.ofAll(vals));
    }

    public static VncList of(VncVal ... mvs) {
        return mvs.length <= 4 ? VncTinyList.of(mvs) : new VncList(Vector.of(mvs), null);
    }

    public static VncList ofList(List<? extends VncVal> list) {
        return list.size() <= 4 ? VncTinyList.ofArr(list.toArray(new VncVal[0]), null) : new VncList(list, null);
    }

    public static VncList ofList(List<? extends VncVal> list, VncVal meta) {
        return list.size() <= 4 ? VncTinyList.ofArr(list.toArray(new VncVal[0]), meta) : new VncList(list, meta);
    }

    public static VncList ofColl(Collection<? extends VncVal> vals) {
        return new VncList(vals, (VncVal)Constants.Nil);
    }

    public static VncList ofColl(Collection<? extends VncVal> vals, VncVal meta) {
        return new VncList(vals, meta);
    }

    public static VncList ofAll(Iterable<? extends VncVal> iter, VncVal meta) {
        return new VncList(Vector.ofAll(iter), meta);
    }

    public static VncList ofAll(Stream<? extends VncVal> stream, VncVal meta) {
        return new VncList(Vector.ofAll(stream), meta);
    }

    @Override
    public VncList emptyWithMeta() {
        return new VncTinyList(this.getMeta());
    }

    @Override
    public VncList withVariadicValues(VncVal ... replaceVals) {
        return replaceVals.length <= 4 ? VncTinyList.ofArr(replaceVals, this.getMeta()) : new VncList(Vector.of(replaceVals), this.getMeta());
    }

    @Override
    public VncList withValues(List<? extends VncVal> replaceVals) {
        return VncList.ofList(replaceVals, this.getMeta());
    }

    @Override
    public VncList withValues(List<? extends VncVal> replaceVals, VncVal meta) {
        return VncList.ofList(replaceVals, meta);
    }

    @Override
    public VncList withMeta(VncVal meta) {
        return new VncList(this.value, meta);
    }

    @Override
    public VncKeyword getType() {
        return new VncKeyword(TYPE, MetaUtil.typeMeta(new VncKeyword(":core/sequence"), new VncKeyword(":core/collection"), new VncKeyword(":core/val")));
    }

    @Override
    public Iterator<VncVal> iterator() {
        return this.isEmpty() ? EmptyIterator.empty() : this.value.iterator();
    }

    @Override
    public Stream<VncVal> stream() {
        return this.value.toJavaStream();
    }

    @Override
    public void forEach(Consumer<? super VncVal> action) {
        this.value.forEach((? super T v) -> action.accept((VncVal)v));
    }

    @Override
    public VncList filter(Predicate<? super VncVal> predicate) {
        return new VncList(this.value.filter(predicate), this.getMeta());
    }

    @Override
    public VncList map(Function<? super VncVal, ? extends VncVal> mapper) {
        return new VncList(this.value.map(mapper), this.getMeta());
    }

    @Override
    public List<VncVal> getJavaList() {
        return this.value.asJava();
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public VncVal nth(int idx) {
        if (idx < 0 || idx >= this.value.size()) {
            throw new VncException(String.format("nth: index %d out of range for a list of size %d.", idx, this.size()));
        }
        return this.value.get(idx);
    }

    @Override
    public VncVal nthOrDefault(int idx, VncVal defaultVal) {
        return idx >= 0 && idx < this.value.size() ? this.value.get(idx) : defaultVal;
    }

    @Override
    public VncVal first() {
        return this.isEmpty() ? Constants.Nil : this.value.head();
    }

    @Override
    public VncVal last() {
        return this.isEmpty() ? Constants.Nil : (VncVal)this.value.last();
    }

    @Override
    public VncList rest() {
        if (this.value.isEmpty()) {
            return this;
        }
        IndexedSeq rest = this.value.tail();
        return rest.size() <= 4 ? VncTinyList.ofList(((Vector)rest).asJava(), this.getMeta()) : new VncList(rest, this.getMeta());
    }

    @Override
    public VncList butlast() {
        if (this.value.isEmpty()) {
            return this;
        }
        return this.value.size() <= 1 ? this.emptyWithMeta() : new VncList(this.value.dropRight(1), this.getMeta());
    }

    @Override
    public VncList drop(int n) {
        if (n <= 0) {
            return this;
        }
        if (n >= this.value.size()) {
            return VncTinyList.EMPTY;
        }
        return this.value.isEmpty() ? this : new VncList(this.value.drop(n), this.getMeta());
    }

    @Override
    public VncList dropWhile(Predicate<? super VncVal> predicate) {
        return new VncList(this.value.dropWhile(predicate), this.getMeta());
    }

    @Override
    public VncList dropRight(int n) {
        if (this.value.isEmpty()) {
            return this;
        }
        return n >= this.value.size() ? this.emptyWithMeta() : new VncList(this.value.dropRight(n), this.getMeta());
    }

    @Override
    public VncList take(int n) {
        return this.value.isEmpty() ? this : new VncList(this.value.take(n), this.getMeta());
    }

    @Override
    public VncList takeWhile(Predicate<? super VncVal> predicate) {
        return new VncList(this.value.takeWhile(predicate), this.getMeta());
    }

    @Override
    public VncList takeRight(int n) {
        if (n >= this.value.size()) {
            return this;
        }
        return n <= 0 ? this.emptyWithMeta() : new VncList(this.value.takeRight(n), this.getMeta());
    }

    @Override
    public VncList reverse() {
        return new VncList(this.value.reverse(), this.getMeta());
    }

    @Override
    public VncList shuffle() {
        return new VncList(this.value.shuffle(), this.getMeta());
    }

    @Override
    public VncList distinct() {
        return new VncList(this.value.distinct(), this.getMeta());
    }

    @Override
    public VncList slice(int start, int end) {
        return new VncList(this.value.subSequence(start, Math.min(end, this.value.size())), this.getMeta());
    }

    @Override
    public VncList slice(int start) {
        return new VncList(this.value.subSequence(start), this.getMeta());
    }

    @Override
    public VncList toVncList() {
        return this;
    }

    @Override
    public VncVector toVncVector() {
        return new VncVector(this.value, this.getMeta());
    }

    @Override
    public VncList addAtStart(VncVal val) {
        return new VncList(this.value.prepend((Object)val), this.getMeta());
    }

    @Override
    public VncList addAllAtStart(VncSequence list, boolean reverseAdd) {
        VncSequence seq = reverseAdd ? list.reverse() : list;
        return new VncList(this.value.prependAll((Iterable)seq), this.getMeta());
    }

    @Override
    public VncList addAtEnd(VncVal val) {
        return new VncList(this.value.append((Object)val), this.getMeta());
    }

    @Override
    public VncList addAllAtEnd(VncSequence list) {
        return new VncList(this.value.appendAll((Iterable)list), this.getMeta());
    }

    @Override
    public VncList setAt(int idx, VncVal val) {
        return new VncList(this.value.update(idx, (Object)val), this.getMeta());
    }

    @Override
    public VncList removeAt(int idx) {
        return new VncList(this.value.removeAt(idx), this.getMeta());
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.LIST;
    }

    @Override
    public boolean isVncList() {
        return true;
    }

    @Override
    public Object convertToJavaObject() {
        return this.stream().map((? super T v) -> v.convertToJavaObject()).collect(Collectors.toList());
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncList(o)) {
            int c = Integer.compare(this.size(), ((VncList)o).size());
            if (c != 0) {
                return c;
            }
            for (int ii = 0; ii < this.size(); ++ii) {
                c = this.nth(ii).compareTo(((VncList)o).nth(ii));
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncList other = (VncList)obj;
        return this.value.equals(other.value);
    }

    public String toString() {
        return "(" + Printer.join(this, " ", true) + ")";
    }

    @Override
    public String toString(boolean print_machine_readably) {
        return "(" + Printer.join(this, " ", print_machine_readably) + ")";
    }

    public static VncList empty() {
        return VncTinyList.EMPTY;
    }
}

