/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.custom;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncMultiArityFunction;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.custom.VncCustomBaseTypeDef;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.util.concurrent.ConcurrentHashMap;

public class VncProtocol
extends VncVal {
    public static final String TYPE = ":core/protocol";
    private static final long serialVersionUID = -1848883965231344442L;
    private final VncSymbol name;
    private final VncMap functions;
    private final ConcurrentHashMap<VncKeyword, VncKeyword> types = new ConcurrentHashMap();

    public VncProtocol(VncSymbol name, VncMap functions, VncVal meta) {
        super(meta);
        this.name = name;
        this.functions = functions;
    }

    public VncSymbol getName() {
        return this.name;
    }

    public VncMap getFunctions() {
        return this.functions;
    }

    public VncMultiArityFunction getFunctionForName(VncString name) {
        return (VncMultiArityFunction)this.functions.get(name);
    }

    public void register(VncKeyword type) {
        this.types.put(type, type);
    }

    public boolean isRegistered(VncKeyword type) {
        return this.types.containsKey(type);
    }

    public void unregister(VncKeyword type) {
        this.types.remove(type);
    }

    @Override
    public VncVal withMeta(VncVal meta) {
        return new VncProtocol(this.name, this.functions, meta);
    }

    @Override
    public VncKeyword getType() {
        return new VncKeyword(TYPE, MetaUtil.typeMeta(new VncKeyword(":core/val")));
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.PROTOCOL_TYPE;
    }

    @Override
    public Object convertToJavaObject() {
        return null;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (o instanceof VncCustomBaseTypeDef) {
            return this.name.getValue().compareTo(((VncProtocol)o).name.getValue());
        }
        return super.compareTo(o);
    }

    public String toString() {
        return this.name.toString();
    }

    @Override
    public String toString(boolean print_machine_readably) {
        return this.name.toString(print_machine_readably);
    }

    public VncVal getDoc() {
        return this.getMetaVal(MetaUtil.DOC);
    }

    public VncList getExamples() {
        return (VncList)this.getMetaVal(MetaUtil.EXAMPLES, VncList.empty());
    }

    public VncList getSeeAlso() {
        return (VncList)this.getMetaVal(MetaUtil.SEE_ALSO, VncList.empty());
    }
}

