/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.util;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IDeref;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.VncAtom;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncBigInteger;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncChar;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncMultiFunction;
import com.github.jlangch.venice.impl.types.VncNumber;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncThreadLocal;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.VncVolatile;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncDAG;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncHashSet;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMutableList;
import com.github.jlangch.venice.impl.types.collections.VncMutableMap;
import com.github.jlangch.venice.impl.types.collections.VncMutableSet;
import com.github.jlangch.venice.impl.types.collections.VncMutableVector;
import com.github.jlangch.venice.impl.types.collections.VncQueue;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncSortedSet;
import com.github.jlangch.venice.impl.types.collections.VncStack;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.custom.VncProtocol;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.WithCallStack;

public class Coerce {
    public static IDeref toIDeref(Object val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to IDeref.");
        }
        if (Types.isIDeref(val)) {
            return (IDeref)val;
        }
        if (Types.isVncVal(val)) {
            WithCallStack cs = new WithCallStack(Coerce.callframe((VncVal)val));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException(String.format("Cannot coerce value of type %s to IDeref.", Types.getType((VncVal)val)));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        throw new VncException(String.format("Cannot coerce value of type %s to IDeref", val.getClass()));
    }

    public static VncAtom toVncAtom(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to atom.");
        }
        if (Types.isVncAtom(val)) {
            return (VncAtom)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to atom.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncVolatile toVncVolatile(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to volatile.");
        }
        if (Types.isVncVolatile(val)) {
            return (VncVolatile)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to volatile.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncThreadLocal toVncThreadLocal(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to thread-local.");
        }
        if (Types.isVncThreadLocal(val)) {
            return (VncThreadLocal)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to thread-local.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncKeyword toVncKeyword(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to keyword.");
        }
        if (Types.isVncKeyword(val)) {
            return (VncKeyword)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to keyword.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncSymbol toVncSymbol(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to symbol.");
        }
        if (Types.isVncSymbol(val)) {
            return (VncSymbol)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to symbol.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static IVncFunction toIVncFunction(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to function.");
        }
        if (Types.isIVncFunction(val)) {
            if (((IVncFunction)((Object)val)).isMacro()) {
                WithCallStack cs = new WithCallStack(Coerce.callframe(val));
                Throwable throwable = null;
                try {
                    try {
                        throw new VncException(String.format("Cannot coerce a macro to a function. The macro '%s' can not be passed as an argument if a function is expected.", ((VncFunction)val).getQualifiedName()));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (cs != null) {
                        if (throwable != null) {
                            try {
                                cs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            cs.close();
                        }
                    }
                    throw throwable3;
                }
            }
            return (IVncFunction)((Object)val);
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to function.", Types.getType(val)));
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
        }
        catch (Throwable throwable6) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable6;
        }
    }

    public static VncFunction toVncFunction(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to function.");
        }
        if (Types.isVncFunction(val)) {
            return (VncFunction)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to function.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncFunction toVncFunctionOptional(VncVal val) {
        if (val == null || val == Constants.Nil) {
            return null;
        }
        if (Types.isVncFunction(val)) {
            return (VncFunction)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to function.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncMultiFunction toVncMultiFunction(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to multi function.");
        }
        if (Types.isVncMultiFunction(val)) {
            return (VncMultiFunction)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to multi function.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncString toVncString(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to string.");
        }
        if (Types.isVncString(val)) {
            return (VncString)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to string.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncChar toVncChar(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to char.");
        }
        if (Types.isVncChar(val)) {
            return (VncChar)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to char.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncBoolean toVncBoolean(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to boolean.");
        }
        if (Types.isVncBoolean(val)) {
            return (VncBoolean)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to boolean.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncNumber toVncNumber(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to a number.");
        }
        if (Types.isVncNumber(val)) {
            return (VncNumber)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to number.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncInteger toVncInteger(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to integer.");
        }
        if (Types.isVncInteger(val)) {
            return (VncInteger)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to int.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncLong toVncLong(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to long.");
        }
        if (Types.isVncLong(val)) {
            return (VncLong)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to long.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncDouble toVncDouble(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to double.");
        }
        if (Types.isVncDouble(val)) {
            return (VncDouble)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to double.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncBigDecimal toVncBigDecimal(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to bigdecimal.");
        }
        if (Types.isVncBigDecimal(val)) {
            return (VncBigDecimal)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to bigdecimal.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncBigInteger toVncBigInteger(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to bigint.");
        }
        if (Types.isVncBigInteger(val)) {
            return (VncBigInteger)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to bigint.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncByteBuffer toVncByteBuffer(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to bytebuf.");
        }
        if (Types.isVncByteBuffer(val)) {
            return (VncByteBuffer)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to bytebuf.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncCollection toVncCollection(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to collection.");
        }
        if (Types.isVncCollection(val)) {
            return (VncCollection)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to collection.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncSequence toVncSequence(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to sequential collection.");
        }
        if (Types.isVncSequence(val)) {
            return (VncSequence)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to a sequential collection.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncList toVncList(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to list.");
        }
        if (Types.isVncList(val)) {
            return (VncList)val;
        }
        if (Types.isVncSequence(val)) {
            return ((VncSequence)val).toVncList();
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to list.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncVector toVncVector(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to vector.");
        }
        if (Types.isVncVector(val)) {
            return (VncVector)val;
        }
        if (Types.isVncSequence(val)) {
            return ((VncSequence)val).toVncVector();
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to vector.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncMutableList toVncMutableList(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to mutable-list.");
        }
        if (val instanceof VncMutableList) {
            return (VncMutableList)val;
        }
        if (Types.isVncSequence(val)) {
            return VncMutableList.ofAll((VncSequence)val, Constants.Nil);
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to mutable-list.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncMutableVector toVncMutableVector(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to mutable-vector.");
        }
        if (val instanceof VncMutableVector) {
            return (VncMutableVector)val;
        }
        if (Types.isVncSequence(val)) {
            return VncMutableVector.ofAll((VncSequence)val, Constants.Nil);
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to mutable-vector.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncMap toVncMap(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to map.");
        }
        if (Types.isVncMap(val)) {
            return (VncMap)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to map.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncHashMap toVncHashMap(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to hash-map.");
        }
        if (val instanceof VncHashMap) {
            return (VncHashMap)val;
        }
        if (Types.isVncMap(val)) {
            return new VncHashMap(((VncMap)val).getJavaMap());
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to hash-map.s", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncMutableMap toVncMutableMap(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to mutable-map.");
        }
        if (val instanceof VncMutableMap) {
            return (VncMutableMap)val;
        }
        if (Types.isVncMap(val)) {
            return new VncMutableMap(((VncMap)val).getJavaMap());
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to mutable-map.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncSet toVncSet(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to set.");
        }
        if (Types.isVncSet(val)) {
            return (VncSet)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to set.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncHashSet toVncHashSet(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to hash-set.");
        }
        if (Types.isVncHashSet(val)) {
            return (VncHashSet)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to hash-set.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncSortedSet toVncSortedSet(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to sorted-set.");
        }
        if (Types.isVncSortedSet(val)) {
            return (VncSortedSet)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to sorted set.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncMutableSet toVncMutableSet(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to mutable-set.");
        }
        if (val instanceof VncMutableSet) {
            return (VncMutableSet)val;
        }
        if (Types.isVncSet(val)) {
            return VncMutableSet.ofAll((VncSet)val, Constants.Nil);
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to mutable-set.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncStack toVncStack(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to stack.");
        }
        if (val instanceof VncStack) {
            return (VncStack)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to stack.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncQueue toVncQueue(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to queue.");
        }
        if (val instanceof VncQueue) {
            return (VncQueue)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to queue.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncDAG toVncDAG(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to dag.");
        }
        if (val instanceof VncDAG) {
            return (VncDAG)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to dag.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncJavaObject toVncJavaObject(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to java-object.");
        }
        if (Types.isVncJavaObject(val)) {
            return (VncJavaObject)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to java-object.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static <T> T toVncJavaObject(VncVal val, Class<T> type) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to java-object.");
        }
        if (Types.isVncJavaObject(val, type)) {
            return (T)((VncJavaObject)val).getDelegate();
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to java-object of type %s.", Types.getType(val), type.getName()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public static VncProtocol toVncProtocol(VncVal val) {
        if (val == null) {
            throw new VncException("Cannot coerce a null value to protocol.");
        }
        if (Types.isVncProtocol(val)) {
            return (VncProtocol)val;
        }
        WithCallStack cs = new WithCallStack(Coerce.callframe(val));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Cannot coerce value of type %s to protocol.", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    private static CallFrame callframe(VncVal val) {
        return new CallFrame("coerce", val.getMeta());
    }
}

