/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;

public class TimeUtil {
    public static Date convertLocalDateToDate(LocalDate date) {
        return new Date(date.atTime(0, 0, 0).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public static Date convertLocalDateTimeToDate(LocalDateTime date) {
        return new Date(date.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public static Date convertZonedDateTimeToDate(ZonedDateTime date) {
        return new Date(date.toInstant().toEpochMilli());
    }

    public static LocalDate convertDateToLocalDate(Date date) {
        long millis = date.getTime();
        return Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDate convertLocalDateTimeToLocalDate(LocalDateTime date) {
        return date.toLocalDate();
    }

    public static LocalDate convertZonedDateTimeToLocalDate(ZonedDateTime date) {
        return date.toLocalDate();
    }

    public static LocalDateTime convertDateToLocalDateTime(Date date) {
        long millis = date.getTime();
        return Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalDateTime convertLocalDateTimeToLocalDateTime(LocalDate date) {
        return date.atTime(0, 0, 0);
    }

    public static LocalDateTime convertZonedDateTimeToLocalDateTime(ZonedDateTime date) {
        return date.toLocalDateTime();
    }
}

