/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.concurrent;

import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.util.concurrent.ManagedExecutor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;

public class ManagedCachedThreadPoolExecutor
extends ManagedExecutor {
    private int maximumThreadPoolSize;

    public ManagedCachedThreadPoolExecutor(String threadPoolName, int maxPoolSize) {
        super(threadPoolName);
        this.maximumThreadPoolSize = maxPoolSize;
    }

    @Override
    public ThreadPoolExecutor getExecutor() {
        return (ThreadPoolExecutor)super.getExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ThreadPoolExecutor createExecutorService() {
        ManagedCachedThreadPoolExecutor managedCachedThreadPoolExecutor = this;
        synchronized (managedCachedThreadPoolExecutor) {
            ThreadPoolExecutor es = (ThreadPoolExecutor)Executors.newCachedThreadPool(this.createThreadFactory());
            es.setMaximumPoolSize(this.maximumThreadPoolSize);
            return es;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumThreadPoolSize(int maximumPoolSize) {
        ManagedCachedThreadPoolExecutor managedCachedThreadPoolExecutor = this;
        synchronized (managedCachedThreadPoolExecutor) {
            if (super.exists()) {
                this.maximumThreadPoolSize = Math.max(1, maximumPoolSize);
                this.getExecutor().setMaximumPoolSize(this.maximumThreadPoolSize);
            }
        }
    }

    public int getCoreThreadPoolSize() {
        return this.getExecutor().getCorePoolSize();
    }

    public int getMaximumThreadPoolSize() {
        return this.maximumThreadPoolSize;
    }

    public int getLargestThreadPoolSize() {
        return this.getExecutor().getLargestPoolSize();
    }

    public int getActiveThreadCount() {
        return this.getExecutor().getActiveCount();
    }

    public int getThreadPoolSize() {
        return this.getExecutor().getPoolSize();
    }

    public long getScheduledTaskCount() {
        return this.getExecutor().getTaskCount();
    }

    public long getCompletedTaskCount() {
        return this.getExecutor().getCompletedTaskCount();
    }

    public VncMap info() {
        return VncOrderedMap.of(new VncKeyword("core-pool-size"), new VncLong(this.getCoreThreadPoolSize()), new VncKeyword("maximum-pool-size"), new VncLong(this.getMaximumThreadPoolSize()), new VncKeyword("current-pool-size"), new VncLong(this.getThreadPoolSize()), new VncKeyword("largest-pool-size"), new VncLong(this.getLargestThreadPoolSize()), new VncKeyword("active-thread-count"), new VncLong(this.getActiveThreadCount()), new VncKeyword("scheduled-task-count"), new VncLong(this.getScheduledTaskCount()), new VncKeyword("completed-task-count"), new VncLong(this.getCompletedTaskCount()));
    }
}

