/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.markdown.block;

import com.github.jlangch.venice.impl.reader.LineReader;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.markdown.block.TextBlock;
import com.github.jlangch.venice.impl.util.markdown.chunk.LineBreakChunk;
import com.github.jlangch.venice.impl.util.markdown.chunk.RawChunk;
import java.util.ArrayList;

public class TextBlockParser {
    private final LineReader reader;

    public TextBlockParser(LineReader reader) {
        this.reader = reader;
    }

    public TextBlock parse() {
        TextBlock block = new TextBlock();
        if (this.reader.eof()) {
            return block;
        }
        ArrayList<String> lines = new ArrayList<String>();
        while (!this.reader.eof()) {
            String line = this.reader.peek();
            this.reader.consume();
            if (StringUtil.isBlank(line)) break;
            lines.add(line);
        }
        this.addLine(block, String.join((CharSequence)" ", lines));
        block.parseChunks();
        return block;
    }

    public static boolean isTextBlockStart(String line) {
        return true;
    }

    private void addLine(TextBlock block, String line) {
        if (line.contains("\u00b6")) {
            String[] chunks = line.split("\u00b6");
            for (int ii = 0; ii < chunks.length; ++ii) {
                if (ii > 0) {
                    block.add(new LineBreakChunk());
                }
                block.add(new RawChunk(chunks[ii]));
            }
            if (line.endsWith("\u00b6")) {
                block.add(new LineBreakChunk());
            }
        } else {
            block.add(new RawChunk(line));
        }
    }
}

