/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.impl.util.io.CharsetUtil;
import com.github.jlangch.venice.javainterop.IInterceptor;
import com.github.jlangch.venice.javainterop.ILoadPaths;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.stream.Collectors;

public class ModuleFunctions {
    public static VncFunction loadResource = new VncFunction("load-resource", (VncVal)VncFunction.meta().arglists("(load-resource file & options)").doc("Loads a resource from the given load-paths. Returns a string, a bytebuffer or nil if the file does not exist. \n\nOptions: \n\n| :binary b   | e.g :binary true, defaults to true |\n| :encoding e | e.g :encoding :utf-8, defaults to :utf-8 |\n\nSee the `load-paths` doc for a description of the *load path* feature.").examples("(do                                                 \n  ;; With load-paths: [/users/foo/images]           \n  ;;        -> loads: /users/foo/images/coffee.png  \n  (load-resource \"coffee.png\")  ; relative        \n)", "(do                                                            \n  ;; With load-paths: [/users/foo/images]                      \n  ;;        -> loads: /users/foo/images/coffee.png             \n  (load-resource \"/users/foo/images/coffee.png\")  ; absolute \n)", "(do                                                                 \n  ;; With load-paths: [/users/foo/images]                           \n  ;;        -> loads: /users/foo/images/small/coffee.png            \n  (load-resource \"small/coffee.png\")  ; relative in sub directory \n)", "(do                                                              \n  ;; With load-paths: [/users/foo/images.zip]                    \n  ;;        -> loads: /users/foo/images.zip!small/coffee.png     \n  (load-resource \"small/coffee.png\")  ; in ZIP                 \n)").seeAlso("load-paths", "load-file").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            String file = ModuleFunctions.name(args.first());
            try {
                VncHashMap options = VncHashMap.ofAll(args.rest());
                boolean binary = VncBoolean.isTrue(options.get(new VncKeyword("binary"), VncBoolean.True));
                Charset charset = CharsetUtil.charset(options.get(new VncKeyword("encoding")));
                IInterceptor interceptor = ThreadContext.getInterceptor();
                if (binary) {
                    ByteBuffer data = interceptor.getLoadPaths().loadBinaryResource(new File(file));
                    if (data == null) {
                        throw new VncException("Failed to load the resource file '" + file + "'!");
                    }
                    return new VncByteBuffer(data);
                }
                String data = interceptor.getLoadPaths().loadTextResource(new File(file), charset);
                if (data == null) {
                    throw new VncException("Failed to load the resource file '" + file + "'!");
                }
                return new VncString(data);
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException("Failed to load the resource '" + file + "'", ex);
            }
        }

        @Override
        public boolean isRedefinable() {
            return false;
        }
    };
    public static VncFunction loadPaths = new VncFunction("load-paths", (VncVal)VncFunction.meta().arglists("(load-paths)").doc("Returns the list of the defined load paths. A load path is either a ZIP file, or a directory. \n\nThe functions `load-file` and `load-resource` try sequentially every load path to read the file. If a load path is a directory the file is read from that directory. If a load path is a ZIP file the file is read from within that ZIP.\n\nExamples:").seeAlso("load-paths-unrestricted?", "load-file", "load-resource").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            this.sandboxFunctionCallValidation();
            IInterceptor interceptor = ThreadContext.getInterceptor();
            ILoadPaths paths = interceptor.getLoadPaths();
            return VncList.ofColl(paths.getPaths().stream().map(f -> new VncJavaObject(f)).collect(Collectors.toList()));
        }

        @Override
        public boolean isRedefinable() {
            return false;
        }
    };
    public static VncFunction loadPathsUnrestricted_Q = new VncFunction("load-paths-unrestricted?", (VncVal)VncFunction.meta().arglists("(load-paths-unrestricted?)").doc("Returns true if the load paths are unrestricted.").seeAlso("load-paths", "load-file", "load-resource").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            this.sandboxFunctionCallValidation();
            IInterceptor interceptor = ThreadContext.getInterceptor();
            ILoadPaths paths = interceptor.getLoadPaths();
            return VncBoolean.of(paths.isUnlimitedAccess());
        }

        @Override
        public boolean isRedefinable() {
            return false;
        }
    };
    public static Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(loadResource).add(loadPaths).add(loadPathsUnrestricted_Q).toMap();

    private static String name(VncVal val) {
        if (Types.isVncString(val)) {
            return ((VncString)val).getValue();
        }
        if (Types.isVncKeyword(val)) {
            return ((VncKeyword)val).getValue();
        }
        if (Types.isVncSymbol(val)) {
            return ((VncSymbol)val).getName();
        }
        return null;
    }
}

