/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.specialforms;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.IVeniceInterpreter;
import com.github.jlangch.venice.impl.ModuleLoader;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.namespaces.Namespace;
import com.github.jlangch.venice.impl.namespaces.Namespaces;
import com.github.jlangch.venice.impl.specialforms.util.SpecialFormsContext;
import com.github.jlangch.venice.impl.specialforms.util.SpecialFormsUtil;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncSpecialForm;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;

public class SpecialForms_LoadCodeMacros {
    public static VncSpecialForm load_string = new VncSpecialForm("load-string", (VncVal)VncSpecialForm.meta().arglists("(load-string s)").doc("Sequentially read and evaluate the set of forms contained in the string.").examples("(do                             \n  (load-string \"(def x 1)\")   \n  (+ x 2))                      ").seeAlso("load-file", "load-classpath-file", "loaded-modules").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            SpecialFormsUtil.specialFormCallValidation("load-string");
            ArityExceptions.assertArity("load-string", ArityExceptions.FnType.SpecialForm, args, 1);
            1 var5_5 = this;
            synchronized (var5_5) {
                VncVal vncVal;
                Namespace currNS = Namespaces.getCurrentNamespace();
                try {
                    VncVal ast;
                    VncString s = Coerce.toVncString(args.first());
                    vncVal = ast = SpecialForms_LoadCodeMacros.loadCode(s.getValue(), "string", ctx.getInterpreter(), env);
                }
                catch (Throwable throwable) {
                    Namespaces.setCurrentNamespace(currNS);
                    throw throwable;
                }
                Namespaces.setCurrentNamespace(currNS);
                return vncVal;
            }
        }
    };
    public static VncSpecialForm load_module = new VncSpecialForm("load-module", (VncVal)VncSpecialForm.meta().arglists("(load-module m)", "(load-module m force)", "(load-module m nsalias)", "(load-module m force nsalias)").doc("Loads a Venice predefined extension module.\n\nReturns a tuple with the module's name and the keyword `:loaded` if the module has been successfully loaded or `:already-loaded` if the module has been already loaded. Throws an exception on any loading error.\n\nWith 'force' set to `false` (the default) the module is only loaded once and interpreted once. Subsequent load attempts will be skipped. With 'force' set to `true` it is always loaded and interpreted.\n\nLoaded modules are cached by Venice and subsequent loads are just skipped. To enforce a reload call the module load with the force flag set to true: `(load-module :hexdump true)`\n\nAn optional namespace alias can passed:\n`(load-module :hexdump ['hexdump :as 'h])`").examples("(load-module :trace) ", ";; loading the :trace modul and define a ns alias 't for namespace \n;; 'trace used in the module                                       \n(load-module :trace ['trace :as 't])                               ", ";; reloading a module          \n(do                            \n  (load-module :trace)         \n  ; reload the module          \n  (ns-remove 'trace)           \n  (load-module :trace true))   ", ";; namespace aliases                       \n(do                                        \n  (load-module :hexdump ['hexdump :as 'h]) \n  (h/dump (range 32 64)))                  ").seeAlso("load-file", "load-classpath-file", "load-string", "loaded-modules").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            SpecialFormsUtil.specialFormCallValidation("load-module");
            ArityExceptions.assertArity("load-module", ArityExceptions.FnType.SpecialForm, args, 1, 2, 3);
            2 var5_5 = this;
            synchronized (var5_5) {
                Namespace currNS = Namespaces.getCurrentNamespace();
                try {
                    boolean load;
                    VncKeyword moduleName = Coerce.toVncKeyword(args.first());
                    Options options = SpecialForms_LoadCodeMacros.parseOptions(args, "load-module");
                    VncBoolean force = options.force;
                    VncVector alias = options.alias;
                    VncSet loadedModules = SpecialForms_LoadCodeMacros.getLoadedModules(env);
                    boolean bl = load = VncBoolean.isTrue(force) || !loadedModules.contains(moduleName);
                    if (load) {
                        IInterceptor interceptor = ThreadContext.getInterceptor();
                        interceptor.validateLoadModule(moduleName.getValue());
                        VncString code = new VncString(ModuleLoader.loadModule(moduleName.getValue()));
                        VncVal ast = SpecialForms_LoadCodeMacros.loadCode(code.getValue(), moduleName.getValue(), ctx.getInterpreter(), env);
                        loadedModules.add(moduleName);
                    }
                    if (alias != null) {
                        SpecialForms_LoadCodeMacros.validateNsAlias(String.format("load-module '%s'", moduleName.getValue()), alias);
                        VncSymbol aliasName = SpecialForms_LoadCodeMacros.unquoteSymbol(alias.third());
                        VncSymbol nsName = SpecialForms_LoadCodeMacros.unquoteSymbol(alias.first());
                        currNS.addAlias(aliasName.getName(), nsName.getName());
                    }
                    VncVector vncVector = VncVector.empty().addAtEnd(moduleName).addAtEnd(new VncKeyword(load ? "loaded" : "already-loaded"));
                    return vncVector;
                }
                catch (VncException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new VncException("Failed to load the Venice module '" + args.first() + "'", ex);
                }
                finally {
                    Namespaces.setCurrentNamespace(currNS);
                }
            }
        }
    };
    public static VncSpecialForm load_file = new VncSpecialForm("load-file", (VncVal)VncSpecialForm.meta().arglists("(load-file f)", "(load-file f force)", "(load-file f nsalias)", "(load-file f force nsalias)").doc("Sequentially read and evaluate the set of forms contained in the file.\n\nIf the file is found on one of the defined load paths it is read and the forms it contains are evaluated. If the file is not found an exception is raised.\n\nReturns a tuple with the file's name and the keyword `:loaded` if the file has been successfully loaded or `:already-loaded` if the file has been already loaded. Throws an exception on any loading error.\n\nWith 'force' set to `false` (the default) the file is only loaded once and interpreted once. Subsequent load attempts will be skipped. With 'force' set to `true` it is always loaded and interpreted.\n\nThe function is restricted to load files with the extension '.venice'. If the file extension is missing '.venice' will be implicitely added.\n\nAn optional namespace alias can passed:\n`(load-file \"coffee.venice\" ['coffee :as 'c])`\n\nSee the `load-paths` doc for a description of the *load path* feature.").examples(";; With load-paths: [/users/foo/scripts]                              \n;;        -> loads: /users/foo/scripts/coffee.venice                  \n(load-file \"coffee\")                                                ", ";; With load-paths: [/users/foo/scripts]                              \n;;        -> loads: /users/foo/scripts/coffee.venice                  \n(load-file \"coffee.venice\")                                         ", ";; With load-paths: [/users/foo/scripts]                              \n;;        -> loads: /users/foo/scripts/beverages/coffee.venice        \n(load-file \"beverages/coffee\")                                      ", ";; With load-paths: [/users/foo/resources.zip]                        \n;;        -> loads: /users/foo/resources.zip!beverages/coffee.venice  \n(load-file \"beverages/coffee\")                                      ").seeAlso("load-classpath-file", "load-string", "load-module", "load-paths").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            SpecialFormsUtil.specialFormCallValidation("load-file");
            ArityExceptions.assertArity("load-file", ArityExceptions.FnType.SpecialForm, args, 1, 2, 3);
            3 var5_5 = this;
            synchronized (var5_5) {
                Namespace currNS = Namespaces.getCurrentNamespace();
                try {
                    boolean load;
                    VncString fileName = SpecialForms_LoadCodeMacros.getVeniceFile(env, args.first(), "load-file");
                    Options options = SpecialForms_LoadCodeMacros.parseOptions(args, "load-file");
                    VncBoolean force = options.force;
                    VncVector alias = options.alias;
                    VncSet loadedFunction = SpecialForms_LoadCodeMacros.getLoadedFunctions(env);
                    boolean bl = load = VncBoolean.isTrue(force) || !loadedFunction.contains(fileName);
                    if (load) {
                        String data = ModuleLoader.loadExternalVeniceFile(fileName.getValue());
                        if (data == null) {
                            throw new VncException("Failed to load Venice file");
                        }
                        VncString code = new VncString(data);
                        VncVal ast = SpecialForms_LoadCodeMacros.loadCode(code.getValue(), fileName.getValue(), ctx.getInterpreter(), env);
                        loadedFunction.add(fileName);
                    }
                    if (alias != null) {
                        SpecialForms_LoadCodeMacros.validateNsAlias(String.format("load-file '%s'", fileName.getValue()), alias);
                        VncSymbol aliasName = SpecialForms_LoadCodeMacros.unquoteSymbol(alias.third());
                        VncSymbol nsName = SpecialForms_LoadCodeMacros.unquoteSymbol(alias.first());
                        currNS.addAlias(aliasName.getName(), nsName.getName());
                    }
                    VncVector vncVector = VncVector.empty().addAtEnd(fileName).addAtEnd(new VncKeyword(load ? "loaded" : "already-loaded"));
                    return vncVector;
                }
                catch (VncException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new VncException("Failed to load the Venice file '" + args.first() + "'", ex);
                }
                finally {
                    Namespaces.setCurrentNamespace(currNS);
                }
            }
        }
    };
    public static VncSpecialForm load_classpath_file = new VncSpecialForm("load-classpath-file", (VncVal)VncSpecialForm.meta().arglists("(load-classpath-file f)", "(load-classpath-file f force)", "(load-classpath-file f nsalias)", "(load-classpath-file f force nsalias)").doc("Sequentially read and evaluate the set of forms contained in the classpath file. The function is restricted to classpath files with the extension '.venice'.\n\nReturns a tuple with the file's name and the keyword `:loaded` if the file has been successfully loaded or `:already-loaded` if the file has been already loaded. Throws an exception on any loading error.\n\nWith 'force' set to `false` (the default) the file is only loaded once and interpreted once. Subsequent load attempts will be skipped. With 'force' set to `true` it is always loaded and interpreted.\n\nLoaded files are cached by Venice and subsequent loads are just skipped. To enforce a reload call the file load with the force flag set to true:\n`(load-classpath-file \"com/github/jlangch/venice/test.venice\" true)`\n\nAn optional namespace alias can passed:\n`(load-classpath-file \"com/github/jlangch/venice/test.venice\" ['test :as 't])`").examples("(do                                                                              \n  (load-classpath-file \"com/github/jlangch/venice/test.venice\")                \n  (test/test-fn \"hello\"))                                                      ", "(do                                                                              \n  (load-classpath-file \"com/github/jlangch/venice/test.venice\")                \n  (test/test-fn \"hello\")                                                       \n  ; reload the classpath file                                                    \n  (ns-remove 'test)                                                              \n  (load-classpath-file \"com/github/jlangch/venice/test.venice\" true)           \n  (test/test-fn \"hello\"))                                                      ", ";; namespace aliases                                                             \n(do                                                                              \n  (load-classpath-file \"com/github/jlangch/venice/test.venice\" ['test :as 't]) \n  (t/test-fn \"hello\"))                                                         ").seeAlso("load-file", "load-string", "load-module").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            SpecialFormsUtil.specialFormCallValidation("load-classpath-file");
            ArityExceptions.assertArity("load-classpath-file", ArityExceptions.FnType.SpecialForm, args, 1, 2, 3);
            Namespace currNS = Namespaces.getCurrentNamespace();
            try {
                4 var6_6 = this;
                synchronized (var6_6) {
                    try {
                        boolean load;
                        VncString fileName = SpecialForms_LoadCodeMacros.getVeniceFile(env, args.first(), "load-classpath-file");
                        Options options = SpecialForms_LoadCodeMacros.parseOptions(args, "load-classpath-file");
                        VncBoolean force = options.force;
                        VncVector alias = options.alias;
                        VncSet loadedFunction = SpecialForms_LoadCodeMacros.getLoadedFunctions(env);
                        boolean bl = load = VncBoolean.isTrue(force) || !loadedFunction.contains(fileName);
                        if (load) {
                            String res = ModuleLoader.loadClasspathVeniceFile(fileName.getValue());
                            if (res == null) {
                                throw new VncException("Failed to load Venice classpath file");
                            }
                            VncString code = new VncString(res);
                            VncVal ast = SpecialForms_LoadCodeMacros.loadCode(code.getValue(), fileName.getValue(), ctx.getInterpreter(), env);
                            loadedFunction.add(fileName);
                        }
                        if (alias != null) {
                            SpecialForms_LoadCodeMacros.validateNsAlias(String.format("load-classpath-file '%s'", fileName.getValue()), alias);
                            VncSymbol aliasName = SpecialForms_LoadCodeMacros.unquoteSymbol(alias.third());
                            VncSymbol nsName = SpecialForms_LoadCodeMacros.unquoteSymbol(alias.first());
                            currNS.addAlias(aliasName.getName(), nsName.getName());
                        }
                        VncVector vncVector = VncVector.empty().addAtEnd(fileName).addAtEnd(new VncKeyword(load ? "loaded" : "already-loaded"));
                        return vncVector;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (VncException ex) {
                            throw ex;
                        }
                        catch (Exception ex) {
                            throw new VncException("Failed to load the Venice classpath file '" + args.first() + "'", ex);
                        }
                    }
                }
            }
            finally {
                Namespaces.setCurrentNamespace(currNS);
            }
        }
    };
    public static Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(load_string).add(load_module).add(load_file).add(load_classpath_file).toMap();

    private static void validateNsAlias(String caller, VncVector alias_) {
        boolean ok;
        boolean bl = ok = !(alias_.size() != 3 || !Types.isVncSymbol(alias_.first()) && !SpecialForms_LoadCodeMacros.isQuotedSymbol(alias_.first()) || !Types.isVncKeyword(alias_.second()) || !"as".equals(Coerce.toVncKeyword(alias_.second()).getValue()) || !Types.isVncSymbol(alias_.third()) && !SpecialForms_LoadCodeMacros.isQuotedSymbol(alias_.third()));
        if (!ok) {
            throw new VncException(String.format("Invalid ns alias definition '%s' for %s!", Printer.pr_str(alias_, true), caller));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Options parseOptions(VncList args, String fnName) {
        VncBoolean force = VncBoolean.False;
        VncVector alias = null;
        if (args.size() == 1) return new Options(force, alias);
        if (args.size() == 2) {
            if (Types.isVncBoolean(args.second())) {
                force = Coerce.toVncBoolean(args.second());
                return new Options(force, alias);
            } else {
                if (!Types.isVncVector(args.second())) throw new VncException(String.format("Function '%s' does not allow %s as 2nd arg! Expected a force flag or a ns alias.", fnName, Types.getType(args.second())));
                alias = Coerce.toVncVector(args.second());
            }
            return new Options(force, alias);
        } else {
            if (!Types.isVncBoolean(args.second())) {
                throw new VncException(String.format("Function '%s' does not allow %s as 2nd arg! Expected a force flag.", fnName, Types.getType(args.second())));
            }
            force = Coerce.toVncBoolean(args.second());
            if (!Types.isVncVector(args.third())) throw new VncException(String.format("Function '%s' does not allow %s as 3rd arg! Expected a ns alias.", fnName, Types.getType(args.third())));
            alias = Coerce.toVncVector(args.third());
        }
        return new Options(force, alias);
    }

    private static VncSet getLoadedModules(Env env) {
        return Coerce.toVncSet(env.getGlobalOrNull(new VncSymbol("*loaded-modules*")));
    }

    private static VncSet getLoadedFunctions(Env env) {
        return Coerce.toVncSet(env.getGlobalOrNull(new VncSymbol("*loaded-files*")));
    }

    private static VncString getVeniceFile(Env env, VncVal arg, String fnName) {
        if (Types.isVncSymbol(arg)) {
            VncVal v = env.get((VncSymbol)arg);
            return SpecialForms_LoadCodeMacros.getVeniceFile(v, fnName);
        }
        return SpecialForms_LoadCodeMacros.getVeniceFile(arg, fnName);
    }

    private static VncString getVeniceFile(VncVal arg, String fnName) {
        if (Types.isVncString(arg)) {
            return SpecialForms_LoadCodeMacros.addVeniceFileExte((VncString)arg);
        }
        if (Types.isVncJavaObject(arg, File.class)) {
            return SpecialForms_LoadCodeMacros.addVeniceFileExte(new VncString(Coerce.toVncJavaObject(arg, File.class).getPath()));
        }
        if (Types.isVncJavaObject(arg, Path.class)) {
            return SpecialForms_LoadCodeMacros.addVeniceFileExte(new VncString(Coerce.toVncJavaObject(arg, Path.class).toFile().getPath()));
        }
        throw new VncException(String.format("Function '%s' does not allow %s as 1st arg! Expected a string or file.", fnName, Types.getType(arg)));
    }

    private static VncString addVeniceFileExte(VncString f) {
        String s = f.getValue();
        return s.endsWith(".venice") ? f : new VncString(s + ".venice");
    }

    private static boolean isQuotedSymbol(VncVal v) {
        VncSequence seq;
        if (Types.isVncSequence(v) && (seq = (VncSequence)v).size() == 2) {
            VncVal v1 = seq.first();
            VncVal v2 = seq.second();
            return Types.isVncSymbol(v1) && "quote".equals(((VncSymbol)v1).getValue()) && Types.isVncSymbol(v2);
        }
        return false;
    }

    private static VncSymbol unquoteSymbol(VncVal v) {
        if (Types.isVncSymbol(v)) {
            return (VncSymbol)v;
        }
        if (SpecialForms_LoadCodeMacros.isQuotedSymbol(v)) {
            VncSequence seq = (VncSequence)v;
            return (VncSymbol)seq.second();
        }
        throw new VncException("Invalid namespace alias.");
    }

    private static VncVal loadCode(String code, String name, IVeniceInterpreter venice, Env env) {
        VncVal ast = venice.READ("(do " + code + ")", name);
        if (venice.isMacroExpandOnLoad()) {
            ast = venice.MACROEXPAND(ast, env);
        }
        ast = venice.EVAL(ast, env);
        return ast;
    }

    private static class Options {
        final VncBoolean force;
        final VncVector alias;

        public Options(VncBoolean force, VncVector alias) {
            this.force = force;
            this.alias = alias;
        }
    }
}

