/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.util.concurrent.ConcurrentHashMap;

public class VncMultiFunction
extends VncFunction {
    public static final String TYPE = ":core/multi-function";
    private static final long serialVersionUID = -1848883965231344442L;
    private static final VncKeyword DEFAULT_METHOD = new VncKeyword(":default");
    private static final VncVector keywordDiscriminatorFnParams = VncVector.of(new VncSymbol("x"));
    private final IVncFunction discriminatorFn;
    private final ConcurrentHashMap<VncVal, VncFunction> functions = new ConcurrentHashMap();

    public VncMultiFunction(String name, IVncFunction discriminatorFn) {
        super(name);
        if (discriminatorFn == null) {
            throw new VncException("A discriminator function must not be null");
        }
        this.discriminatorFn = discriminatorFn;
    }

    @Override
    public VncMultiFunction withMeta(VncVal meta) {
        super.withMeta(meta);
        return this;
    }

    @Override
    public VncKeyword getType() {
        return new VncKeyword(TYPE, MetaUtil.typeMeta(new VncKeyword(":core/function"), new VncKeyword(":core/val")));
    }

    public VncMultiFunction addFn(VncVal dispatchVal, VncFunction fn) {
        if (dispatchVal == null) {
            throw new VncException("A dispatch value must not be null");
        }
        if (fn == null) {
            throw new VncException("A multifunction method must not be null");
        }
        this.functions.put(dispatchVal, fn);
        return this;
    }

    public VncMultiFunction removeFn(VncVal dispatchVal) {
        if (dispatchVal == null) {
            throw new VncException("A dispatch value must not be null");
        }
        this.functions.remove(dispatchVal);
        return this;
    }

    @Override
    public VncVector getParams() {
        return this.discriminatorFn instanceof VncFunction ? ((VncFunction)this.discriminatorFn).getParams() : keywordDiscriminatorFnParams;
    }

    @Override
    public VncVal apply(VncList args) {
        return this.getFunctionForArgs(args).apply(args);
    }

    @Override
    public boolean isNative() {
        return false;
    }

    @Override
    public VncFunction getFunctionForArgs(VncList args) {
        VncKeyword type;
        VncVal fn_;
        VncVal dispatchVal = this.discriminatorFn.apply(args);
        VncFunction fn = this.functions.get(dispatchVal);
        if (fn != null) {
            return fn;
        }
        if (this.isTypeKeyword(dispatchVal) && (fn_ = ((VncList)((VncList)MetaUtil.getSupertypes((type = (VncKeyword)dispatchVal).getMeta()).map(t -> this.functions.get(t))).filter(f -> f != null)).first()) != Constants.Nil) {
            return (VncFunction)fn_;
        }
        VncFunction defaultFn = this.functions.get(DEFAULT_METHOD);
        if (defaultFn != null) {
            return defaultFn;
        }
        throw new VncException(String.format("No matching '%s' multi-function method defined for dispatch value %s", this.getQualifiedName(), Printer.pr_str(dispatchVal, true)));
    }

    @Override
    public VncFunction getFunctionForArity(int arity) {
        throw new VncException(String.format("No supported for multi-function methods (%s)", this.getQualifiedName()));
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.MULTI_FUNCTION;
    }

    @Override
    public String toString() {
        return "multi-fn " + this.getQualifiedName();
    }

    private boolean isTypeKeyword(VncVal val) {
        return val instanceof VncKeyword && MetaUtil.isType(val.getMeta());
    }
}

