/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.loadpath;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.util.loadpath.LoadPath;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class DirectoryLoadPath
extends LoadPath {
    private final File dir;

    public DirectoryLoadPath(File dir) {
        this.dir = this.canonical(dir);
    }

    @Override
    public File path() {
        return this.dir;
    }

    @Override
    public boolean isOnPath(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        try {
            File f = this.realFile(file);
            return this.isFileWithinDirectory(f);
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to check if the file '%s' is on the load path", file.getPath()), ex);
        }
    }

    @Override
    public ByteBuffer load(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        try {
            File f = this.realFile(file);
            if (f.isFile()) {
                return this.isFileWithinDirectory(f) ? ByteBuffer.wrap(Files.readAllBytes(f.toPath())) : null;
            }
            return null;
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to load file '%s'", file.getPath()), ex);
        }
    }

    @Override
    public InputStream getInputStream(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        try {
            File f = this.realFile(file);
            if (f.isFile()) {
                return this.isFileWithinDirectory(f) ? Files.newInputStream(f.toPath(), new OpenOption[0]) : null;
            }
            return null;
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to get InputStream for file '%s'", file.getPath()), ex);
        }
    }

    @Override
    public BufferedReader getBufferedReader(File file, Charset charset) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        try {
            File f = this.realFile(file);
            if (f.isFile()) {
                return this.isFileWithinDirectory(f) ? Files.newBufferedReader(f.toPath(), charset) : null;
            }
            return null;
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to get BufferedReader for file '%s'", file.getPath()), ex);
        }
    }

    @Override
    public OutputStream getOutputStream(File file, OpenOption ... options) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        try {
            File f = this.realFile(file);
            return this.isFileWithinDirectory(f) ? Files.newOutputStream(f.toPath(), options) : null;
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to get OutputStream for file '%s'", file.getPath()), ex);
        }
    }

    @Override
    public boolean isRegularFileOnLoadPath(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        return this.isOnPath(file) && file.isFile();
    }

    @Override
    public boolean isDirectoryOnLoadPath(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        return this.isOnPath(file) && file.isDirectory();
    }

    public String toString() {
        return this.dir.getPath();
    }

    private File realFile(File file) {
        return file.isAbsolute() ? file : new File(this.dir, file.getPath());
    }

    private boolean isFileWithinDirectory(File file) {
        return this.canonical(file).toPath().startsWith(this.dir.toPath());
    }
}

