/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.loadpath;

import com.github.jlangch.venice.impl.util.loadpath.LoadPath;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class FileLoadPath
extends LoadPath {
    private final File lpFile;

    public FileLoadPath(File file) {
        this.lpFile = this.canonical(file);
    }

    @Override
    public File path() {
        return this.lpFile;
    }

    @Override
    public boolean isOnPath(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        File f = this.canonical(file);
        if (this.lpFile.equals(f)) {
            return true;
        }
        return file.getParent() == null && this.lpFile.getName().equals(file.getName());
    }

    @Override
    public ByteBuffer load(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        File f = this.canonical(file);
        if (this.lpFile.equals(f) && f.isFile()) {
            try {
                return ByteBuffer.wrap(Files.readAllBytes(f.toPath()));
            }
            catch (IOException ex) {
                return null;
            }
        }
        if (file.getParent() == null && this.lpFile.getName().equals(file.getName())) {
            try {
                return ByteBuffer.wrap(Files.readAllBytes(this.lpFile.toPath()));
            }
            catch (IOException ex) {
                return null;
            }
        }
        return null;
    }

    @Override
    public InputStream getInputStream(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        File f = this.canonical(file);
        if (this.lpFile.equals(f) && f.isFile()) {
            try {
                return Files.newInputStream(f.toPath(), new OpenOption[0]);
            }
            catch (IOException ex) {
                return null;
            }
        }
        if (file.getParent() == null && this.lpFile.getName().equals(file.getName())) {
            try {
                return Files.newInputStream(this.lpFile.toPath(), new OpenOption[0]);
            }
            catch (IOException ex) {
                return null;
            }
        }
        return null;
    }

    @Override
    public BufferedReader getBufferedReader(File file, Charset charset) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        File f = this.canonical(file);
        if (this.lpFile.equals(f) && f.isFile()) {
            try {
                return Files.newBufferedReader(f.toPath(), charset);
            }
            catch (IOException ex) {
                return null;
            }
        }
        if (file.getParent() == null && this.lpFile.getName().equals(file.getName())) {
            try {
                return Files.newBufferedReader(this.lpFile.toPath(), charset);
            }
            catch (IOException ex) {
                return null;
            }
        }
        return null;
    }

    @Override
    public OutputStream getOutputStream(File file, OpenOption ... options) {
        return null;
    }

    @Override
    public boolean isRegularFileOnLoadPath(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        return this.isOnPath(file) && file.isFile();
    }

    @Override
    public boolean isDirectoryOnLoadPath(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        return false;
    }

    public String toString() {
        return this.lpFile.getPath();
    }
}

