/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.loadpath;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.util.io.zip.ZipFileSystemUtil;
import com.github.jlangch.venice.impl.util.io.zip.Zipper;
import com.github.jlangch.venice.impl.util.loadpath.LoadPath;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipLoadPath
extends LoadPath {
    private final File zip;
    private final Set<String> entries = new HashSet<String>();

    public ZipLoadPath(File zip) {
        this.zip = this.canonical(zip);
        this.entries.addAll(ZipLoadPath.list(zip));
    }

    @Override
    public File path() {
        return this.zip;
    }

    @Override
    public boolean isOnPath(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        return file.isAbsolute() ? false : this.entries.contains(file.getPath());
    }

    @Override
    public ByteBuffer load(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        if (file.isAbsolute()) {
            return null;
        }
        if (this.entries.contains(file.getPath())) {
            try {
                return ZipFileSystemUtil.loadBinaryFileFromZip(this.zip, file);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    @Override
    public InputStream getInputStream(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        if (file.isAbsolute()) {
            return null;
        }
        if (this.entries.contains(file.getPath())) {
            try {
                return ZipFileSystemUtil.getInputStreamFromZip(this.zip, file);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    @Override
    public BufferedReader getBufferedReader(File file, Charset charset) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        if (file.isAbsolute()) {
            return null;
        }
        if (this.entries.contains(file.getPath())) {
            try {
                return ZipFileSystemUtil.getBufferedReaderFromZip(this.zip, file, charset);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    @Override
    public OutputStream getOutputStream(File file, OpenOption ... options) {
        return null;
    }

    @Override
    public boolean isRegularFileOnLoadPath(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        return this.isOnPath(file);
    }

    @Override
    public boolean isDirectoryOnLoadPath(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null");
        }
        return false;
    }

    public String toString() {
        List<String> list = new ArrayList<String>(this.entries);
        Collections.sort(list);
        list = list.subList(0, Math.min(6, list.size()));
        return String.join((CharSequence)"\n", list);
    }

    public static boolean isZipFile(File file) {
        if (file.getName().endsWith(".zip")) {
            try {
                return Zipper.isZipFile(ZipLoadPath.readFirstNBytes(file, 4));
            }
            catch (Exception ex) {
                throw new VncException(String.format("The file '%s' is not a valid load path. It is not a zip file even though the file extension is '.zip'!", file.getPath()));
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> list(File zip) {
        try (ZipFile zf = new ZipFile(zip, 1);){
            List<String> list = zf.stream().map(ZipEntry::getName).collect(Collectors.toList());
            return list;
        }
        catch (IOException ex) {
            throw new VncException(String.format("Failed list the zip file's '%s' entries!", zip.getPath()));
        }
    }

    private static byte[] readFirstNBytes(File file, int n) throws Exception {
        try (FileInputStream is = new FileInputStream(file);){
            byte[] buffer = new byte[n];
            if (is.read(buffer) == buffer.length) {
                byte[] byArray = buffer;
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
    }
}

