/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.docgen.cheatsheet;

import com.github.jlangch.venice.impl.docgen.cheatsheet.CrossRef;
import com.github.jlangch.venice.impl.docgen.cheatsheet.ExampleOutput;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DocItem {
    private final String name;
    private final String altName;
    private final String id;
    private final List<String> signatures;
    private final String description;
    private final String descriptionXmlStyled;
    private final List<ExampleOutput> examples;
    private final List<CrossRef> crossRefs;

    public DocItem(String name, List<String> signatures, String description, String descriptionXmlStyled, List<ExampleOutput> examples, List<CrossRef> crossRefs, String id) {
        this.name = name;
        this.altName = name;
        this.signatures = signatures;
        this.description = description;
        this.descriptionXmlStyled = descriptionXmlStyled;
        this.examples = examples;
        this.id = id;
        this.crossRefs = new ArrayList<CrossRef>();
        if (crossRefs != null) {
            this.crossRefs.addAll(crossRefs);
        }
    }

    public DocItem(String name, String id) {
        this(name, null, null, null, null, null, id);
    }

    public String getName() {
        return this.name;
    }

    public String getAltName() {
        return this.altName;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getSignatures() {
        return this.signatures;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionXmlStyled() {
        return this.descriptionXmlStyled;
    }

    public List<String> getExamples() {
        return this.examples.stream().map(o -> o.render()).map(s -> StringUtil.trimToNull(s)).filter(s -> s != null).collect(Collectors.toList());
    }

    public List<String> getExamplesXmlStyled() {
        return this.examples.stream().map(o -> o.renderXmlStyled()).map(s -> StringUtil.trimToNull(s)).filter(s -> s != null).collect(Collectors.toList());
    }

    public List<CrossRef> getCrossRefs() {
        return this.crossRefs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocItem other = (DocItem)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

