/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.javainterop.IInterceptor;
import com.github.jlangch.venice.javainterop.ILoadPaths;
import java.util.Map;
import java.util.stream.Collectors;

public class LoadPathFunctions {
    public static VncFunction loadPaths = new VncFunction("load-paths", (VncVal)VncFunction.meta().arglists("(load-paths)").doc("Returns the list of the defined load paths. A load path is either a ZIP file, or a directory. \n\nThe functions `load-file` and I/O functions try sequentially every load path to read the file. If a load path is a directory the file is read from that directory. If a load path is a ZIP file the file is read from within that ZIP.\n\nExamples:").seeAlso("load-paths-unrestricted?", "load-file").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            this.sandboxFunctionCallValidation();
            IInterceptor interceptor = ThreadContext.getInterceptor();
            ILoadPaths paths = interceptor.getLoadPaths();
            return VncList.ofColl(paths.getPaths().stream().map(f -> new VncJavaObject(f)).collect(Collectors.toList()));
        }

        @Override
        public boolean isRedefinable() {
            return false;
        }
    };
    public static VncFunction loadPathsUnrestricted_Q = new VncFunction("load-paths-unrestricted?", (VncVal)VncFunction.meta().arglists("(load-paths-unrestricted?)").doc("Returns true if the load paths are unrestricted.").seeAlso("load-paths", "load-file").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            this.sandboxFunctionCallValidation();
            IInterceptor interceptor = ThreadContext.getInterceptor();
            ILoadPaths paths = interceptor.getLoadPaths();
            return VncBoolean.of(paths.isUnlimitedAccess());
        }

        @Override
        public boolean isRedefinable() {
            return false;
        }
    };
    public static Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(loadPaths).add(loadPathsUnrestricted_Q).toMap();
}

