/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegexFunctions {
    public static VncFunction pattern = new VncFunction("regex/pattern", (VncVal)VncFunction.meta().arglists("(regex/pattern s)").doc("Returns an instance of `java.util.regex.Pattern`.\n\nPatterns are immutable and are safe for use by multiple concurrent threads! \n\nAlternatively the reader macro for regex patterns can be used to define a pattern: `#\"[0-9+]\"`\n\nJavaDoc: [Pattern](https://docs.oracle.com/javase/8/docs/api/java/util/regex/Pattern.html)").examples("(regex/pattern \"[0-9]+\")").seeAlso("regex/matcher", "regex/matches", "regex/find", "regex/find-all").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            try {
                return new VncJavaObject(Pattern.compile(Coerce.toVncString(args.first()).getValue()));
            }
            catch (PatternSyntaxException ex) {
                throw new VncException("Illegal regex pattern: " + ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction matcher = new VncFunction("regex/matcher", (VncVal)VncFunction.meta().arglists("(regex/matcher pattern str)").doc("Returns an instance of `java.util.regex.Matcher`.\u00b6The pattern can be either a string or a pattern created by `(regex/pattern s)`.\n\nMatchers are mutable and are not safe for use by multiple concurrent threads! \n\nJavaDoc: [Pattern](https://docs.oracle.com/javase/8/docs/api/java/util/regex/Pattern.html)").examples("(regex/matcher \"[0-9]+\" \"100\")", "(let [p (regex/pattern \"[0-9]+\")] \n   (regex/matcher p \"100\"))").seeAlso("regex/pattern", "regex/matches?", "regex/find?", "regex/reset", "regex/matches", "regex/find", "regex/find-all").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncVal pattern = args.first();
            Pattern p = Types.isVncString(pattern) ? Pattern.compile(((VncString)pattern).getValue()) : (Pattern)Coerce.toVncJavaObject(args.first()).getDelegate();
            String s = Coerce.toVncString(args.second()).getValue();
            return new VncJavaObject(p.matcher(s));
        }
    };
    public static VncFunction matches_Q = new VncFunction("regex/matches?", (VncVal)VncFunction.meta().arglists("(regex/matches? matcher)", "(regex/matches? matcher str)").doc("Attempts to match the entire region against the pattern. If the match succeeds then more information can be obtained via the regex/group function").examples("(let [m (regex/matcher \"[0-9]+\" \"100\")]         \n  (regex/matches? m))                               ", "(let [m (regex/matcher \"[0-9]+\" \"value: 100\")]  \n  (regex/matches? m))                               ", "(let [m (regex/matcher \"[0-9]+\" \"\")]                     \n  (filter #(regex/matches? m %) [\"100\" \"1a1\" \"200\"]))  ").seeAlso("regex/matcher", "regex/matches").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            if (args.size() == 1) {
                Matcher m = (Matcher)Coerce.toVncJavaObject(args.first()).getDelegate();
                return VncBoolean.of(m.matches());
            }
            Matcher m = (Matcher)Coerce.toVncJavaObject(args.first()).getDelegate();
            String s = Coerce.toVncString(args.second()).getValue();
            return VncBoolean.of(m.reset(s).matches());
        }
    };
    public static VncFunction matches = new VncFunction("regex/matches", (VncVal)VncFunction.meta().arglists("(regex/matches pattern str)").doc("Returns the matches, if any, for the matcher with the pattern of a string, using `java.util.regex.Matcher.matches()`.\u00b6If the matcher's pattern matches the entire region sequence returns a list with the entire region sequence and the matched groups otherwise returns an empty list. \n\nReturns matching info as meta data on the region and the groups. \n\nRegion meta data: \n\n| :start       | start pos of the overall group        |\n| :end         | end pos of the overall group          |\n| :group-count | the number of matched elements groups |\n\nGroup meta data: \n\n| :start | start pos of the element group |\n| :end   | end pos of the element group   |\n\nJavaDoc: [Pattern](https://docs.oracle.com/javase/8/docs/api/java/util/regex/Pattern.html)").examples(";; Entire region sequence matched \n(regex/matches \"hello, (.*)\" \"hello, world\")", ";; Entire region sequence not matched \n(regex/matches \"HEllo, (.*)\" \"hello, world\")", ";; Matching multiple groups\n(regex/matches \"([0-9]+)-([0-9]+)-([0-9]+)-([0-9]+)\" \"672-345-456-212\")", ";; Matching multiple groups\n(let [p (regex/pattern \"([0-9]+)-([0-9]+)\")]\n  (regex/matches p \"672-345\"))", ";; Access matcher's region meta info \n(let [pattern \"([0-9]+)-([0-9]+)-([0-9]+)-([0-9]+)\" \n      matches (regex/matches pattern \"672-345-456-212\")] \n   (println \"meta info:\" (pr-str (meta matches))) \n   (println \"matches:  \" (pr-str matches)))", ";; Access matcher's region meta info and the meta info of each group \n(let [pattern \"([0-9]+)-([0-9]+)-([0-9]+)-([0-9]+)\" \n      matches (regex/matches pattern \"672-345-456-212\")] \n  (println \"region info:   \" (pr-str (meta matches))) \n  (println \"group count:   \" (count matches) \"(region included)\") \n  (println \"group matches: \" (pr-str (nth matches 0)) (meta (nth matches 0))) \n  (println \"               \" (pr-str (nth matches 1)) (meta (nth matches 1))) \n  (println \"               \" (pr-str (nth matches 2)) (meta (nth matches 2))) \n  (println \"               \" (pr-str (nth matches 3)) (meta (nth matches 3))) \n  (println \"               \" (pr-str (nth matches 4)) (meta (nth matches 4))))").seeAlso("regex/pattern").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncVal pattern = args.first();
            Pattern p = Types.isVncString(pattern) ? Pattern.compile(((VncString)pattern).getValue()) : (Pattern)Coerce.toVncJavaObject(args.first()).getDelegate();
            String s = Coerce.toVncString(args.second()).getValue();
            Matcher m = p.matcher(s);
            if (m.matches()) {
                ArrayList<VncConstant> groups = new ArrayList<VncConstant>();
                VncHashMap metaGroup = VncHashMap.of(new VncKeyword("start"), new VncLong(m.start()), new VncKeyword("end"), new VncLong(m.end()), new VncKeyword("group-count"), new VncLong(m.groupCount()));
                for (int ii = 0; ii <= m.groupCount(); ++ii) {
                    VncHashMap metaItem = VncHashMap.of(new VncKeyword("start"), new VncLong(m.start(ii)), new VncKeyword("end"), new VncLong(m.end(ii)));
                    String group = m.group(ii);
                    groups.add((VncConstant)(group == null ? Constants.Nil : new VncString(group, (VncVal)metaItem)));
                }
                return VncList.ofList(groups, metaGroup);
            }
            return VncList.empty();
        }
    };
    public static VncFunction find_Q = new VncFunction("regex/find?", (VncVal)VncFunction.meta().arglists("(regex/find? matcher)").doc("Attempts to find the next subsequence that matches the pattern. If the match succeeds then more information can be obtained via the `regex/group` function").examples("(let [m (regex/matcher \"[0-9]+\" \"100\")] \n  (regex/find? m))", "(let [m (regex/matcher \"[0-9]+\" \"xxx: 100\")] \n  (regex/find? m))", "(let [m (regex/matcher \"[0-9]+\" \"xxx: 100 200\")] \n  (when (regex/find? m) \n    (println (regex/group m 0))) \n  (when (regex/find? m) \n    (println (regex/group m 0))) \n  (when (regex/find? m) \n    (println (regex/group m 0))))").seeAlso("regex/group", "regex/matches?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Matcher m = (Matcher)Coerce.toVncJavaObject(args.first()).getDelegate();
            return VncBoolean.of(m.find());
        }
    };
    public static VncFunction find = new VncFunction("regex/find", (VncVal)VncFunction.meta().arglists("(regex/find matcher)").doc("Returns the next regex match or nil if there is no further match. \n\nTo get the positional data for the matched group use `(regex/find+ matcher)`.").examples("(let [m (regex/matcher \"[0-9]+\" \"672-345-456-3212\")]  \n  (println (regex/find m))  \n  (println (regex/find m))  \n  (println (regex/find m))  \n  (println (regex/find m))  \n  (println (regex/find m)))").seeAlso("regex/find-all", "regex/find+", "regex/matcher").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Matcher m = (Matcher)Coerce.toVncJavaObject(args.first()).getDelegate();
            if (m.find()) {
                return new VncString(m.group());
            }
            return Constants.Nil;
        }
    };
    public static VncFunction find_plus = new VncFunction("regex/find+", (VncVal)VncFunction.meta().arglists("(regex/find+ matcher)").doc("Returns the next regex match and returns the group with its positional data.").examples("(let [m (regex/matcher \"[0-9]+\" \"672-345-456-3212\")]  \n   (println (regex/find+ m))  \n   (println (regex/find+ m))  \n   (println (regex/find+ m))  \n   (println (regex/find+ m))  \n   (println (regex/find+ m))) \n").seeAlso("regex/find-all+", "regex/find", "regex/matcher").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Matcher m = (Matcher)Coerce.toVncJavaObject(args.first()).getDelegate();
            if (m.find()) {
                return VncHashMap.of(new VncKeyword("start"), new VncLong(m.start()), new VncKeyword("end"), new VncLong(m.end()), new VncKeyword("group"), new VncString(m.group()));
            }
            return Constants.Nil;
        }
    };
    public static VncFunction find_all = new VncFunction("regex/find-all", (VncVal)VncFunction.meta().arglists("(regex/find-all matcher)").doc("Returns all regex matches.\n\nTo get the positional data for the matched groups use 'regex/find-all+'.").examples("(->> (regex/matcher \"\\\\d+\" \"672-345-456-3212\") \n     (regex/find-all))                                 ", "(->> (regex/matcher \"([^\\\"]\\\\S*|\\\".+?\\\")\\\\s*\" \"1 2 \\\"3 4\\\" 5\") \n     (regex/find-all))                                 ").seeAlso("regex/find", "regex/find-all+", "regex/matcher").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Matcher m = (Matcher)Coerce.toVncJavaObject(args.first()).getDelegate();
            ArrayList<VncString> matches = new ArrayList<VncString>();
            while (m.find()) {
                matches.add(new VncString(m.group()));
            }
            return VncList.ofList(matches);
        }
    };
    public static VncFunction find_all_plus = new VncFunction("regex/find-all+", (VncVal)VncFunction.meta().arglists("(regex/find-all+ matcher)").doc("Returns the all regex matches and returns the groups with its positional data").examples("(let [m (regex/matcher \"[0-9]+\" \"672-345-456-3212\")]  \n  (regex/find-all+ m))  \n").seeAlso("regex/find+", "regex/find-all", "regex/matcher").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Matcher m = (Matcher)Coerce.toVncJavaObject(args.first()).getDelegate();
            ArrayList<VncHashMap> groups = new ArrayList<VncHashMap>();
            while (m.find()) {
                groups.add(VncHashMap.of(new VncKeyword("start"), new VncLong(m.start()), new VncKeyword("end"), new VncLong(m.end()), new VncKeyword("group"), new VncString(m.group())));
            }
            return VncList.ofList(groups);
        }
    };
    public static VncFunction reset = new VncFunction("regex/reset", (VncVal)VncFunction.meta().arglists("(regex/reset matcher str)").doc("Resets the matcher with a new string").examples("(do  \n  (let [m (regex/matcher \"[0-9]+\" \"100\")]  \n    (println (regex/find m))                   \n    (let [m (regex/reset m \"200\")]           \n      (println (regex/find m)))))").seeAlso("regex/matcher").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            Matcher m = (Matcher)Coerce.toVncJavaObject(args.first()).getDelegate();
            String s = Coerce.toVncString(args.second()).getValue();
            return new VncJavaObject(m.reset(s));
        }
    };
    public static VncFunction group = new VncFunction("regex/group", (VncVal)VncFunction.meta().arglists("(regex/group matcher group)").doc("Returns the input subsequence captured by the given group during the previous match operation.").examples("(let [p (regex/pattern \"([0-9]+)(.*)\")      \n      m (regex/matcher p \"100abc\")]         \n   (if (regex/matches? m)                     \n      [(regex/group m 1) (regex/group m 2)]   \n      []))                                      ").seeAlso("regex/matcher", "regex/matches?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            Matcher m = (Matcher)Coerce.toVncJavaObject(args.first()).getDelegate();
            int g = Coerce.toVncLong(args.second()).getValue().intValue();
            if (g >= 0 && g <= m.groupCount()) {
                String group = m.group(g);
                return group == null ? Constants.Nil : new VncString(group);
            }
            return Constants.Nil;
        }
    };
    public static VncFunction count = new VncFunction("regex/count", (VncVal)VncFunction.meta().arglists("(regex/count matcher)").doc("Returns the matcher's group count.").examples("(let [p (regex/pattern \"([0-9]+)(.*)\")  \n      m (regex/matcher p \"100abc\")]     \n   (regex/count m))  ").seeAlso("regex/matcher").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Matcher m = (Matcher)Coerce.toVncJavaObject(args.first()).getDelegate();
            return new VncLong(m.groupCount());
        }
    };
    public static Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(pattern).add(matcher).add(find).add(find_all).add(find_plus).add(find_all_plus).add(reset).add(find_Q).add(matches).add(matches_Q).add(group).add(count).toMap();
}

