/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.specialforms;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.namespaces.Namespaces;
import com.github.jlangch.venice.impl.specialforms.util.SpecialFormsContext;
import com.github.jlangch.venice.impl.specialforms.util.SpecialFormsUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncSpecialForm;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class SpecialForms_NamespaceFunctions {
    public static VncSpecialForm ns_new = new VncSpecialForm("ns", (VncVal)VncSpecialForm.meta().arglists("(ns sym)").doc("Opens a namespace.").examples("(do                               \n  (ns xxx)                        \n  (def foo 1)                     \n  (ns yyy)                        \n  (def foo 5)                     \n  (println xxx/foo foo yyy/foo))    ").seeAlso("*ns*", "ns-unmap", "ns-remove", "ns-list", "ns-alias", "namespace", "var-ns").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            VncSymbol ns;
            SpecialFormsUtil.specialFormCallValidation("ns");
            ArityExceptions.assertArity("ns", ArityExceptions.FnType.SpecialForm, args, 1);
            VncVal name = args.first();
            VncSymbol vncSymbol = ns = Types.isVncSymbol(name) ? (VncSymbol)name : (VncSymbol)CoreFunctions.symbol.apply(VncList.of(ctx.getEvaluator().evaluate(name, env, false)));
            if (ns.hasNamespace() && !"core".equals(ns.getNamespace())) {
                throw new VncException(String.format("A namespace '%s' must not have itself a namespace! However you can use '%s'.", ns.getQualifiedName(), ns.getNamespace() + "." + ns.getSimpleName()));
            }
            VncSymbol ns_ = new VncSymbol(ns.getSimpleName());
            if (Namespaces.isSystemNS(ns_.getSimpleName()) && ctx.getSealedSystemNS().get()) {
                throw new VncException("Namespace '" + ns_.getName() + "' cannot be reopened!");
            }
            Namespaces.setCurrentNamespace(ctx.getNsRegistry().computeIfAbsent(ns_));
            return ns_;
        }
    };
    public static VncSpecialForm ns_unmap = new VncSpecialForm("ns-unmap", (VncVal)VncSpecialForm.meta().arglists("(ns-unmap ns sym)").doc("Removes the mappings for the symbol from the namespace.").examples("(do                    \n  (ns foo)             \n  (def x 1)            \n  (ns-unmap 'foo 'x)   \n  (ns-unmap *ns* 'x))   ").seeAlso("ns", "*ns*", "ns-remove", "ns-list", "namespace", "var-ns").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            SpecialFormsUtil.specialFormCallValidation("ns-unmap");
            ArityExceptions.assertArity("ns-unmap", ArityExceptions.FnType.SpecialForm, args, 2);
            VncSymbol ns = Coerce.toVncSymbol(ctx.getEvaluator().evaluate(args.first(), env, false));
            if (Namespaces.isSystemNS(ns.getName()) && ctx.getSealedSystemNS().get()) {
                throw new VncException("Cannot remove a symbol from namespace '" + ns.getName() + "'!");
            }
            VncSymbol sym = Coerce.toVncSymbol(ctx.getEvaluator().evaluate(args.second(), env, false));
            env.removeGlobalSymbol(sym.withNamespace(ns));
            return Constants.Nil;
        }
    };
    public static VncSpecialForm ns_remove = new VncSpecialForm("ns-remove", (VncVal)VncSpecialForm.meta().arglists("(ns-remove ns)").doc("Removes the mappings for all symbols from the namespace.").examples("(do                                     \n  (ns foo)                              \n  (def x 1)                             \n  (ns bar)                              \n  (def y 1)                             \n  (ns-remove 'foo)                      \n  (println \"ns foo:\" (ns-list 'foo))  \n  (println \"ns bar:\" (ns-list 'bar)))   ").seeAlso("ns", "ns-unmap", "ns-list", "namespace", "var-ns").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            SpecialFormsUtil.specialFormCallValidation("ns-remove");
            ArityExceptions.assertArity("ns-remove", ArityExceptions.FnType.SpecialForm, args, 1);
            VncSymbol ns = Coerce.toVncSymbol(ctx.getEvaluator().evaluate(args.first(), env, false));
            VncSymbol nsCurr = Namespaces.getCurrentNS();
            if (Namespaces.isSystemNS(ns.getName()) && ctx.getSealedSystemNS().get()) {
                throw new VncException("Namespace '" + ns.getName() + "' cannot be removed!");
            }
            if (ns.equals(nsCurr)) {
                throw new VncException("The current samespace '" + nsCurr.getName() + "' cannot be removed!");
            }
            env.removeGlobalSymbolsByNS(ns);
            ctx.getNsRegistry().remove(ns);
            return Constants.Nil;
        }
    };
    public static VncSpecialForm ns_list = new VncSpecialForm("ns-list", (VncVal)VncSpecialForm.meta().arglists("(ns-list)", "(ns-list ns)").doc("Without arg lists the loaded namespaces, else lists all the symbols in the specified namespace ns.").examples("(ns-list 'regex)", "(ns-list)").seeAlso("ns", "*ns*", "ns-unmap", "ns-remove", "namespace", "var-ns").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            SpecialFormsUtil.specialFormCallValidation("ns-list");
            ArityExceptions.assertArity("ns-list", ArityExceptions.FnType.SpecialForm, args, 0, 1);
            if (args.isEmpty()) {
                return VncList.ofList(env.getAllGlobalSymbols().keySet().stream().filter(s -> s.hasNamespace()).map(s -> s.getNamespace()).distinct().sorted().map(s -> new VncString((String)s)).collect(Collectors.toList()));
            }
            VncSymbol ns = Coerce.toVncSymbol(ctx.getEvaluator().evaluate(args.first(), env, false));
            String nsCore = Namespaces.NS_CORE.getName();
            String nsName = nsCore.equals(ns.getName()) ? null : ns.getName();
            return VncList.ofList(env.getAllGlobalSymbols().keySet().stream().filter(s -> Objects.equals(nsName, s.getNamespace())).sorted().collect(Collectors.toList()));
        }
    };
    public static Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(ns_new).add(ns_list).add(ns_remove).add(ns_unmap).toMap();
}

